// device/vr/public/mojom/isolated_xr_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_H_
#define DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/isolated_xr_service.mojom-features.h"  // IWYU pragma: export
#include "device/vr/public/mojom/isolated_xr_service.mojom-shared.h"  // IWYU pragma: export
#include "device/vr/public/mojom/isolated_xr_service.mojom-forward.h"  // IWYU pragma: export
#include "device/vr/public/mojom/test/browser_test_interfaces.mojom-forward.h"
#include "device/vr/public/mojom/vr_service.mojom.h"
#include "device/vr/public/mojom/xr_device.mojom-forward.h"
#include "device/vr/public/mojom/xr_session.mojom.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "services/viz/public/mojom/gpu.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"



constexpr ::sandbox::mojom::Sandbox kXrSandbox = ::sandbox::mojom::Sandbox::kUtility;


namespace device::mojom {

class XRSessionControllerProxy;

template <typename ImplRefTraits>
class XRSessionControllerStub;

class XRSessionControllerRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRSessionController
    : public XRSessionControllerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRSessionController";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRSessionControllerInterfaceBase;
  using Proxy_ = XRSessionControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRSessionControllerStub<ImplRefTraits>;

  using RequestValidator_ = XRSessionControllerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetFrameDataRestrictedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetFrameDataRestricted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRSessionController() = default;

  virtual void SetFrameDataRestricted(bool restricted) = 0;
};

class XRRuntimeEventListenerProxy;

template <typename ImplRefTraits>
class XRRuntimeEventListenerStub;

class XRRuntimeEventListenerRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeEventListener
    : public XRRuntimeEventListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRRuntimeEventListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRRuntimeEventListenerInterfaceBase;
  using Proxy_ = XRRuntimeEventListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRRuntimeEventListenerStub<ImplRefTraits>;

  using RequestValidator_ = XRRuntimeEventListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnVisibilityStateChangedMinVersion = 0,
    kOnExitPresentMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnVisibilityStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnExitPresent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRRuntimeEventListener() = default;

  virtual void OnVisibilityStateChanged(::device::mojom::XRVisibilityState visibility_state) = 0;

  virtual void OnExitPresent() = 0;
};

class XRRuntimeProxy;

template <typename ImplRefTraits>
class XRRuntimeStub;

class XRRuntimeRequestValidator;
class XRRuntimeResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntime
    : public XRRuntimeInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRRuntime";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRRuntimeInterfaceBase;
  using Proxy_ = XRRuntimeProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRRuntimeStub<ImplRefTraits>;

  using RequestValidator_ = XRRuntimeRequestValidator;
  using ResponseValidator_ = XRRuntimeResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestSessionMinVersion = 0,
    kShutdownSessionMinVersion = 0,
    kListenToDeviceChangesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShutdownSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ListenToDeviceChanges_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRRuntime() = default;

  using RequestSessionCallback = base::OnceCallback<void(XRRuntimeSessionResultPtr)>;
  using RequestSessionMojoCallback = base::OnceCallback<void(XRRuntimeSessionResultPtr)>;

  virtual void RequestSession(XRRuntimeSessionOptionsPtr options, RequestSessionCallback callback) = 0;

  using ShutdownSessionCallback = base::OnceCallback<void()>;
  using ShutdownSessionMojoCallback = base::OnceCallback<void()>;

  virtual void ShutdownSession(ShutdownSessionCallback callback) = 0;

  virtual void ListenToDeviceChanges(::mojo::PendingAssociatedRemote<XRRuntimeEventListener> listener) = 0;
};

class ImmersiveOverlayProxy;

template <typename ImplRefTraits>
class ImmersiveOverlayStub;

class ImmersiveOverlayRequestValidator;
class ImmersiveOverlayResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) ImmersiveOverlay
    : public ImmersiveOverlayInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.ImmersiveOverlay";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ImmersiveOverlayInterfaceBase;
  using Proxy_ = ImmersiveOverlayProxy;

  template <typename ImplRefTraits>
  using Stub_ = ImmersiveOverlayStub<ImplRefTraits>;

  using RequestValidator_ = ImmersiveOverlayRequestValidator;
  using ResponseValidator_ = ImmersiveOverlayResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestNextOverlayPoseMinVersion = 0,
    kSubmitOverlayTextureMinVersion = 0,
    kSetOverlayAndWebXRVisibilityMinVersion = 0,
    kRequestNotificationOnWebXrSubmittedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestNextOverlayPose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitOverlayTexture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOverlayAndWebXRVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestNotificationOnWebXrSubmitted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ImmersiveOverlay() = default;

  using RequestNextOverlayPoseCallback = base::OnceCallback<void(::device::mojom::XRRenderInfoPtr)>;
  using RequestNextOverlayPoseMojoCallback = base::OnceCallback<void(::device::mojom::XRRenderInfoPtr)>;

  virtual void RequestNextOverlayPose(RequestNextOverlayPoseCallback callback) = 0;

  using SubmitOverlayTextureCallback = base::OnceCallback<void(bool)>;
  using SubmitOverlayTextureMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SubmitOverlayTexture(int16_t frame_id, ::gfx::GpuMemoryBufferHandle texture, const ::gpu::SyncToken& sync_token, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, SubmitOverlayTextureCallback callback) = 0;

  virtual void SetOverlayAndWebXRVisibility(bool overlay_visible, bool webxr_visible) = 0;

  using RequestNotificationOnWebXrSubmittedCallback = base::OnceCallback<void()>;
  using RequestNotificationOnWebXrSubmittedMojoCallback = base::OnceCallback<void()>;

  virtual void RequestNotificationOnWebXrSubmitted(RequestNotificationOnWebXrSubmittedCallback callback) = 0;
};

class IsolatedXRRuntimeProviderClientProxy;

template <typename ImplRefTraits>
class IsolatedXRRuntimeProviderClientStub;

class IsolatedXRRuntimeProviderClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderClient
    : public IsolatedXRRuntimeProviderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.IsolatedXRRuntimeProviderClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IsolatedXRRuntimeProviderClientInterfaceBase;
  using Proxy_ = IsolatedXRRuntimeProviderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = IsolatedXRRuntimeProviderClientStub<ImplRefTraits>;

  using RequestValidator_ = IsolatedXRRuntimeProviderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceAddedMinVersion = 0,
    kOnDeviceRemovedMinVersion = 0,
    kOnDevicesEnumeratedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDeviceAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDeviceRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDevicesEnumerated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IsolatedXRRuntimeProviderClient() = default;

  virtual void OnDeviceAdded(::mojo::PendingRemote<XRRuntime> runtime, XRDeviceDataPtr device_data, ::device::mojom::XRDeviceId device_id) = 0;

  virtual void OnDeviceRemoved(::device::mojom::XRDeviceId device_index) = 0;

  virtual void OnDevicesEnumerated() = 0;
};

class IsolatedXRRuntimeProviderProxy;

template <typename ImplRefTraits>
class IsolatedXRRuntimeProviderStub;

class IsolatedXRRuntimeProviderRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProvider
    : public IsolatedXRRuntimeProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.IsolatedXRRuntimeProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IsolatedXRRuntimeProviderInterfaceBase;
  using Proxy_ = IsolatedXRRuntimeProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = IsolatedXRRuntimeProviderStub<ImplRefTraits>;

  using RequestValidator_ = IsolatedXRRuntimeProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequestDevicesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IsolatedXRRuntimeProvider() = default;

  virtual void RequestDevices(::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> client) = 0;
};

class XRDeviceServiceProxy;

template <typename ImplRefTraits>
class XRDeviceServiceStub;

class XRDeviceServiceRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceService
    : public XRDeviceServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRDeviceService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kUtility;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRDeviceServiceInterfaceBase;
  using Proxy_ = XRDeviceServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRDeviceServiceStub<ImplRefTraits>;

  using RequestValidator_ = XRDeviceServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindRuntimeProviderMinVersion = 0,
    kBindTestHookMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindRuntimeProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindTestHook_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRDeviceService() = default;

  virtual void BindRuntimeProvider(::mojo::PendingReceiver<IsolatedXRRuntimeProvider> receiver, ::mojo::PendingRemote<XRDeviceServiceHost> host) = 0;

  virtual void BindTestHook(::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> receiver) = 0;
};

class XRDeviceServiceHostProxy;

template <typename ImplRefTraits>
class XRDeviceServiceHostStub;

class XRDeviceServiceHostRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceHost
    : public XRDeviceServiceHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRDeviceServiceHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRDeviceServiceHostInterfaceBase;
  using Proxy_ = XRDeviceServiceHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRDeviceServiceHostStub<ImplRefTraits>;

  using RequestValidator_ = XRDeviceServiceHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindGpuMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindGpu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRDeviceServiceHost() = default;

  virtual void BindGpu(::mojo::PendingReceiver<::viz::mojom::Gpu> receiver) = 0;
};



class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRSessionControllerProxy
    : public XRSessionController {
 public:
  using InterfaceType = XRSessionController;

  explicit XRSessionControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetFrameDataRestricted(bool restricted) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeEventListenerProxy
    : public XRRuntimeEventListener {
 public:
  using InterfaceType = XRRuntimeEventListener;

  explicit XRRuntimeEventListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnVisibilityStateChanged(::device::mojom::XRVisibilityState visibility_state) final;
  
  void OnExitPresent() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeProxy
    : public XRRuntime {
 public:
  using InterfaceType = XRRuntime;

  explicit XRRuntimeProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestSession(XRRuntimeSessionOptionsPtr options, RequestSessionCallback callback) final;
  
  void ShutdownSession(ShutdownSessionCallback callback) final;
  
  void ListenToDeviceChanges(::mojo::PendingAssociatedRemote<XRRuntimeEventListener> listener) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) ImmersiveOverlayProxy
    : public ImmersiveOverlay {
 public:
  using InterfaceType = ImmersiveOverlay;

  explicit ImmersiveOverlayProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestNextOverlayPose(RequestNextOverlayPoseCallback callback) final;
  
  void SubmitOverlayTexture(int16_t frame_id, ::gfx::GpuMemoryBufferHandle texture, const ::gpu::SyncToken& sync_token, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, SubmitOverlayTextureCallback callback) final;
  
  void SetOverlayAndWebXRVisibility(bool overlay_visible, bool webxr_visible) final;
  
  void RequestNotificationOnWebXrSubmitted(RequestNotificationOnWebXrSubmittedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderClientProxy
    : public IsolatedXRRuntimeProviderClient {
 public:
  using InterfaceType = IsolatedXRRuntimeProviderClient;

  explicit IsolatedXRRuntimeProviderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceAdded(::mojo::PendingRemote<XRRuntime> runtime, XRDeviceDataPtr device_data, ::device::mojom::XRDeviceId device_id) final;
  
  void OnDeviceRemoved(::device::mojom::XRDeviceId device_index) final;
  
  void OnDevicesEnumerated() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderProxy
    : public IsolatedXRRuntimeProvider {
 public:
  using InterfaceType = IsolatedXRRuntimeProvider;

  explicit IsolatedXRRuntimeProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestDevices(::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceProxy
    : public XRDeviceService {
 public:
  using InterfaceType = XRDeviceService;

  explicit XRDeviceServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindRuntimeProvider(::mojo::PendingReceiver<IsolatedXRRuntimeProvider> receiver, ::mojo::PendingRemote<XRDeviceServiceHost> host) final;
  
  void BindTestHook(::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceHostProxy
    : public XRDeviceServiceHost {
 public:
  using InterfaceType = XRDeviceServiceHost;

  explicit XRDeviceServiceHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindGpu(::mojo::PendingReceiver<::viz::mojom::Gpu> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRSessionControllerStubDispatch {
 public:
  static bool Accept(XRSessionController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRSessionController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRSessionController>>
class XRSessionControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRSessionControllerStub() = default;
  ~XRSessionControllerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeEventListenerStubDispatch {
 public:
  static bool Accept(XRRuntimeEventListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRRuntimeEventListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRRuntimeEventListener>>
class XRRuntimeEventListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRRuntimeEventListenerStub() = default;
  ~XRRuntimeEventListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRRuntimeEventListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRRuntimeEventListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeStubDispatch {
 public:
  static bool Accept(XRRuntime* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRRuntime* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRRuntime>>
class XRRuntimeStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRRuntimeStub() = default;
  ~XRRuntimeStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRRuntimeStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRRuntimeStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) ImmersiveOverlayStubDispatch {
 public:
  static bool Accept(ImmersiveOverlay* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ImmersiveOverlay* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ImmersiveOverlay>>
class ImmersiveOverlayStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ImmersiveOverlayStub() = default;
  ~ImmersiveOverlayStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImmersiveOverlayStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImmersiveOverlayStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderClientStubDispatch {
 public:
  static bool Accept(IsolatedXRRuntimeProviderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IsolatedXRRuntimeProviderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IsolatedXRRuntimeProviderClient>>
class IsolatedXRRuntimeProviderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IsolatedXRRuntimeProviderClientStub() = default;
  ~IsolatedXRRuntimeProviderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IsolatedXRRuntimeProviderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IsolatedXRRuntimeProviderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderStubDispatch {
 public:
  static bool Accept(IsolatedXRRuntimeProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IsolatedXRRuntimeProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IsolatedXRRuntimeProvider>>
class IsolatedXRRuntimeProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IsolatedXRRuntimeProviderStub() = default;
  ~IsolatedXRRuntimeProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IsolatedXRRuntimeProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IsolatedXRRuntimeProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceStubDispatch {
 public:
  static bool Accept(XRDeviceService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRDeviceService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRDeviceService>>
class XRDeviceServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRDeviceServiceStub() = default;
  ~XRDeviceServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRDeviceServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRDeviceServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceHostStubDispatch {
 public:
  static bool Accept(XRDeviceServiceHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRDeviceServiceHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRDeviceServiceHost>>
class XRDeviceServiceHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRDeviceServiceHostStub() = default;
  ~XRDeviceServiceHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRDeviceServiceHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRDeviceServiceHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRSessionControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeEventListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) ImmersiveOverlayRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) IsolatedXRRuntimeProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceServiceHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) ImmersiveOverlayResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeSessionOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRRuntimeSessionOptions, T>::value>;
  using DataView = XRRuntimeSessionOptionsDataView;
  using Data_ = internal::XRRuntimeSessionOptions_Data;

  template <typename... Args>
  static XRRuntimeSessionOptionsPtr New(Args&&... args) {
    return XRRuntimeSessionOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRRuntimeSessionOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRRuntimeSessionOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRRuntimeSessionOptions>::Convert(*this);
  }


  XRRuntimeSessionOptions();

  XRRuntimeSessionOptions(
      ::device::mojom::XRSessionMode mode,
      std::vector<::device::mojom::XRSessionFeature> required_features,
      std::vector<::device::mojom::XRSessionFeature> optional_features,
      int32_t render_process_id,
      int32_t render_frame_id,
      std::vector<::device::mojom::XRTrackedImagePtr> tracked_images,
      ::device::mojom::XRDepthOptionsPtr depth_options,
      uint64_t trace_id);

XRRuntimeSessionOptions(const XRRuntimeSessionOptions&) = delete;
XRRuntimeSessionOptions& operator=(const XRRuntimeSessionOptions&) = delete;

  ~XRRuntimeSessionOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRRuntimeSessionOptionsPtr>
  XRRuntimeSessionOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRRuntimeSessionOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRRuntimeSessionOptions_UnserializedMessageContext<
            UserType, XRRuntimeSessionOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRRuntimeSessionOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRRuntimeSessionOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRRuntimeSessionOptions_UnserializedMessageContext<
            UserType, XRRuntimeSessionOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRRuntimeSessionOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::mojom::XRSessionMode mode;
  
  std::vector<::device::mojom::XRSessionFeature> required_features;
  
  std::vector<::device::mojom::XRSessionFeature> optional_features;
  
  int32_t render_process_id;
  
  int32_t render_frame_id;
  
  std::vector<::device::mojom::XRTrackedImagePtr> tracked_images;
  
  ::device::mojom::XRDepthOptionsPtr depth_options;
  
  uint64_t trace_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRRuntimeSessionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRRuntimeSessionResult, T>::value>;
  using DataView = XRRuntimeSessionResultDataView;
  using Data_ = internal::XRRuntimeSessionResult_Data;

  template <typename... Args>
  static XRRuntimeSessionResultPtr New(Args&&... args) {
    return XRRuntimeSessionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRRuntimeSessionResultPtr From(const U& u) {
    return mojo::TypeConverter<XRRuntimeSessionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRRuntimeSessionResult>::Convert(*this);
  }


  XRRuntimeSessionResult();

  XRRuntimeSessionResult(
      ::mojo::PendingRemote<XRSessionController> controller,
      ::device::mojom::XRSessionPtr session,
      const std::optional<::viz::FrameSinkId>& frame_sink_id,
      ::mojo::PendingRemote<ImmersiveOverlay> overlay);

XRRuntimeSessionResult(const XRRuntimeSessionResult&) = delete;
XRRuntimeSessionResult& operator=(const XRRuntimeSessionResult&) = delete;

  ~XRRuntimeSessionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRRuntimeSessionResultPtr>
  XRRuntimeSessionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRRuntimeSessionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRRuntimeSessionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRRuntimeSessionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRRuntimeSessionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRRuntimeSessionResult_UnserializedMessageContext<
            UserType, XRRuntimeSessionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRRuntimeSessionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRRuntimeSessionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRRuntimeSessionResult_UnserializedMessageContext<
            UserType, XRRuntimeSessionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRRuntimeSessionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<XRSessionController> controller;
  
  ::device::mojom::XRSessionPtr session;
  
  std::optional<::viz::FrameSinkId> frame_sink_id;
  
  ::mojo::PendingRemote<ImmersiveOverlay> overlay;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRRuntimeSessionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRRuntimeSessionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRRuntimeSessionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRRuntimeSessionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) XRDeviceData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDeviceData, T>::value>;
  using DataView = XRDeviceDataDataView;
  using Data_ = internal::XRDeviceData_Data;

  template <typename... Args>
  static XRDeviceDataPtr New(Args&&... args) {
    return XRDeviceDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDeviceDataPtr From(const U& u) {
    return mojo::TypeConverter<XRDeviceDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDeviceData>::Convert(*this);
  }


  XRDeviceData();

  XRDeviceData(
      std::vector<::device::mojom::XRSessionFeature> supported_features,
      bool is_ar_blend_mode_supported);


  ~XRDeviceData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDeviceDataPtr>
  XRDeviceDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDeviceData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDeviceData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDeviceData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDeviceData_UnserializedMessageContext<
            UserType, XRDeviceData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRDeviceData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRDeviceData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDeviceData_UnserializedMessageContext<
            UserType, XRDeviceData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDeviceData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::device::mojom::XRSessionFeature> supported_features;
  
  bool is_ar_blend_mode_supported;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDeviceData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
XRRuntimeSessionOptionsPtr XRRuntimeSessionOptions::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(required_features),
      mojo::Clone(optional_features),
      mojo::Clone(render_process_id),
      mojo::Clone(render_frame_id),
      mojo::Clone(tracked_images),
      mojo::Clone(depth_options),
      mojo::Clone(trace_id)
  );
}

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>*>
bool XRRuntimeSessionOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->required_features, other_struct.required_features))
    return false;
  if (!mojo::Equals(this->optional_features, other_struct.optional_features))
    return false;
  if (!mojo::Equals(this->render_process_id, other_struct.render_process_id))
    return false;
  if (!mojo::Equals(this->render_frame_id, other_struct.render_frame_id))
    return false;
  if (!mojo::Equals(this->tracked_images, other_struct.tracked_images))
    return false;
  if (!mojo::Equals(this->depth_options, other_struct.depth_options))
    return false;
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  return true;
}

template <typename T, XRRuntimeSessionOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.required_features < rhs.required_features)
    return true;
  if (rhs.required_features < lhs.required_features)
    return false;
  if (lhs.optional_features < rhs.optional_features)
    return true;
  if (rhs.optional_features < lhs.optional_features)
    return false;
  if (lhs.render_process_id < rhs.render_process_id)
    return true;
  if (rhs.render_process_id < lhs.render_process_id)
    return false;
  if (lhs.render_frame_id < rhs.render_frame_id)
    return true;
  if (rhs.render_frame_id < lhs.render_frame_id)
    return false;
  if (lhs.tracked_images < rhs.tracked_images)
    return true;
  if (rhs.tracked_images < lhs.tracked_images)
    return false;
  if (lhs.depth_options < rhs.depth_options)
    return true;
  if (rhs.depth_options < lhs.depth_options)
    return false;
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  return false;
}
template <typename StructPtrType>
XRRuntimeSessionResultPtr XRRuntimeSessionResult::Clone() const {
  return New(
      mojo::Clone(controller),
      mojo::Clone(session),
      mojo::Clone(frame_sink_id),
      mojo::Clone(overlay)
  );
}

template <typename T, XRRuntimeSessionResult::EnableIfSame<T>*>
bool XRRuntimeSessionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->controller, other_struct.controller))
    return false;
  if (!mojo::Equals(this->session, other_struct.session))
    return false;
  if (!mojo::Equals(this->frame_sink_id, other_struct.frame_sink_id))
    return false;
  if (!mojo::Equals(this->overlay, other_struct.overlay))
    return false;
  return true;
}

template <typename T, XRRuntimeSessionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.controller < rhs.controller)
    return true;
  if (rhs.controller < lhs.controller)
    return false;
  if (lhs.session < rhs.session)
    return true;
  if (rhs.session < lhs.session)
    return false;
  if (lhs.frame_sink_id < rhs.frame_sink_id)
    return true;
  if (rhs.frame_sink_id < lhs.frame_sink_id)
    return false;
  if (lhs.overlay < rhs.overlay)
    return true;
  if (rhs.overlay < lhs.overlay)
    return false;
  return false;
}
template <typename StructPtrType>
XRDeviceDataPtr XRDeviceData::Clone() const {
  return New(
      mojo::Clone(supported_features),
      mojo::Clone(is_ar_blend_mode_supported)
  );
}

template <typename T, XRDeviceData::EnableIfSame<T>*>
bool XRDeviceData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supported_features, other_struct.supported_features))
    return false;
  if (!mojo::Equals(this->is_ar_blend_mode_supported, other_struct.is_ar_blend_mode_supported))
    return false;
  return true;
}

template <typename T, XRDeviceData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supported_features < rhs.supported_features)
    return true;
  if (rhs.supported_features < lhs.supported_features)
    return false;
  if (lhs.is_ar_blend_mode_supported < rhs.is_ar_blend_mode_supported)
    return true;
  if (rhs.is_ar_blend_mode_supported < lhs.is_ar_blend_mode_supported)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRRuntimeSessionOptions::DataView,
                                         ::device::mojom::XRRuntimeSessionOptionsPtr> {
  static bool IsNull(const ::device::mojom::XRRuntimeSessionOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRRuntimeSessionOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRRuntimeSessionOptions::mode) mode(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->mode;
  }

  static const decltype(::device::mojom::XRRuntimeSessionOptions::required_features)& required_features(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->required_features;
  }

  static const decltype(::device::mojom::XRRuntimeSessionOptions::optional_features)& optional_features(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->optional_features;
  }

  static decltype(::device::mojom::XRRuntimeSessionOptions::render_process_id) render_process_id(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->render_process_id;
  }

  static decltype(::device::mojom::XRRuntimeSessionOptions::render_frame_id) render_frame_id(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->render_frame_id;
  }

  static  decltype(::device::mojom::XRRuntimeSessionOptions::tracked_images)& tracked_images(
       ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->tracked_images;
  }

  static const decltype(::device::mojom::XRRuntimeSessionOptions::depth_options)& depth_options(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->depth_options;
  }

  static decltype(::device::mojom::XRRuntimeSessionOptions::trace_id) trace_id(
      const ::device::mojom::XRRuntimeSessionOptionsPtr& input) {
    return input->trace_id;
  }

  static bool Read(::device::mojom::XRRuntimeSessionOptions::DataView input, ::device::mojom::XRRuntimeSessionOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRRuntimeSessionResult::DataView,
                                         ::device::mojom::XRRuntimeSessionResultPtr> {
  static bool IsNull(const ::device::mojom::XRRuntimeSessionResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRRuntimeSessionResultPtr* output) { output->reset(); }

  static  decltype(::device::mojom::XRRuntimeSessionResult::controller)& controller(
       ::device::mojom::XRRuntimeSessionResultPtr& input) {
    return input->controller;
  }

  static  decltype(::device::mojom::XRRuntimeSessionResult::session)& session(
       ::device::mojom::XRRuntimeSessionResultPtr& input) {
    return input->session;
  }

  static const decltype(::device::mojom::XRRuntimeSessionResult::frame_sink_id)& frame_sink_id(
      const ::device::mojom::XRRuntimeSessionResultPtr& input) {
    return input->frame_sink_id;
  }

  static  decltype(::device::mojom::XRRuntimeSessionResult::overlay)& overlay(
       ::device::mojom::XRRuntimeSessionResultPtr& input) {
    return input->overlay;
  }

  static bool Read(::device::mojom::XRRuntimeSessionResult::DataView input, ::device::mojom::XRRuntimeSessionResultPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_ISOLATED_XR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRDeviceData::DataView,
                                         ::device::mojom::XRDeviceDataPtr> {
  static bool IsNull(const ::device::mojom::XRDeviceDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRDeviceDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRDeviceData::supported_features)& supported_features(
      const ::device::mojom::XRDeviceDataPtr& input) {
    return input->supported_features;
  }

  static decltype(::device::mojom::XRDeviceData::is_ar_blend_mode_supported) is_ar_blend_mode_supported(
      const ::device::mojom::XRDeviceDataPtr& input) {
    return input->is_ar_blend_mode_supported;
  }

  static bool Read(::device::mojom::XRDeviceData::DataView input, ::device::mojom::XRDeviceDataPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_H_