// device/vr/public/mojom/isolated_xr_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_SEND_VALIDATION_H_
#define DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "device/vr/public/mojom/isolated_xr_service.mojom-shared-internal.h"
#include "device/vr/public/mojom/test/browser_test_interfaces.mojom-shared.h"
#include "device/vr/public/mojom/vr_service.mojom-shared.h"
#include "device/vr/public/mojom/xr_device.mojom-shared.h"
#include "device/vr/public/mojom/xr_session.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/gpu.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"

#include "device/vr/public/mojom/isolated_xr_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRRuntimeSessionOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRuntimeSessionOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRRuntimeSessionOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::XRSessionMode>(
        Traits::mode(input),
        &fragment->mode);

      decltype(Traits::required_features(input)) in_required_features = Traits::required_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->required_features)::BaseType>
          required_features_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& required_features_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>, send_validation>(
        in_required_features,
        required_features_fragment,
        &required_features_validate_params);

      fragment->required_features.Set(
          required_features_fragment.is_null() ? nullptr : required_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->required_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null required_features in XRRuntimeSessionOptions struct");

      decltype(Traits::optional_features(input)) in_optional_features = Traits::optional_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->optional_features)::BaseType>
          optional_features_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& optional_features_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>, send_validation>(
        in_optional_features,
        optional_features_fragment,
        &optional_features_validate_params);

      fragment->optional_features.Set(
          optional_features_fragment.is_null() ? nullptr : optional_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->optional_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null optional_features in XRRuntimeSessionOptions struct");

      fragment->render_process_id = Traits::render_process_id(input);

      fragment->render_frame_id = Traits::render_frame_id(input);

      decltype(Traits::tracked_images(input)) in_tracked_images = Traits::tracked_images(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tracked_images)::BaseType>
          tracked_images_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& tracked_images_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>, send_validation>(
        in_tracked_images,
        tracked_images_fragment,
        &tracked_images_validate_params);

      fragment->tracked_images.Set(
          tracked_images_fragment.is_null() ? nullptr : tracked_images_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tracked_images.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tracked_images in XRRuntimeSessionOptions struct");

      decltype(Traits::depth_options(input)) in_depth_options = Traits::depth_options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->depth_options)::BaseType> depth_options_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRDepthOptionsDataView, send_validation>(
        in_depth_options,
        depth_options_fragment);

      fragment->depth_options.Set(
          depth_options_fragment.is_null() ? nullptr : depth_options_fragment.data());

      fragment->trace_id = Traits::trace_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRRuntimeSessionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRuntimeSessionResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRRuntimeSessionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::controller(input)) in_controller = Traits::controller(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionControllerInterfaceBase>>(
        in_controller,
        &fragment->controller,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->controller)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid controller in XRRuntimeSessionResult struct");

      decltype(Traits::session(input)) in_session = Traits::session(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session)::BaseType> session_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRSessionDataView, send_validation>(
        in_session,
        session_fragment);

      fragment->session.Set(
          session_fragment.is_null() ? nullptr : session_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->session.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session in XRRuntimeSessionResult struct");

      decltype(Traits::frame_sink_id(input)) in_frame_sink_id = Traits::frame_sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_sink_id)::BaseType> frame_sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView, send_validation>(
        in_frame_sink_id,
        frame_sink_id_fragment);

      fragment->frame_sink_id.Set(
          frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

      decltype(Traits::overlay(input)) in_overlay = Traits::overlay(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::ImmersiveOverlayInterfaceBase>>(
        in_overlay,
        &fragment->overlay,
        &fragment.message());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRDeviceDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDeviceDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDeviceData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::supported_features(input)) in_supported_features = Traits::supported_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_features)::BaseType>
          supported_features_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_features_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>, send_validation>(
        in_supported_features,
        supported_features_fragment,
        &supported_features_validate_params);

      fragment->supported_features.Set(
          supported_features_fragment.is_null() ? nullptr : supported_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_features in XRDeviceData struct");

      fragment->is_ar_blend_mode_supported = Traits::is_ar_blend_mode_supported(input);
  }
};

}  // namespace mojo::internal

#endif  // DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_SEND_VALIDATION_H_