// device/vr/public/mojom/browser_test_interfaces.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_DATA_VIEW_H_
#define DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "device/vr/public/mojom/browser_test_interfaces.mojom-shared-internal.h"
#include "device/vr/public/mojom/openxr_interaction_profile_type.mojom-shared.h"
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"


namespace device_test::mojom {
class ColorDataView;

class ViewDataDataView;

class PoseFrameDataDataView;

class ProjectionRawDataView;

class DeviceConfigDataView;

class ControllerAxisDataDataView;

class ControllerFrameDataDataView;

class EventDataDataView;



}  // device_test::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device_test::mojom::ColorDataView> {
  using Data = ::device_test::mojom::internal::Color_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::ViewDataDataView> {
  using Data = ::device_test::mojom::internal::ViewData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::PoseFrameDataDataView> {
  using Data = ::device_test::mojom::internal::PoseFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::ProjectionRawDataView> {
  using Data = ::device_test::mojom::internal::ProjectionRaw_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::DeviceConfigDataView> {
  using Data = ::device_test::mojom::internal::DeviceConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::ControllerAxisDataDataView> {
  using Data = ::device_test::mojom::internal::ControllerAxisData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::ControllerFrameDataDataView> {
  using Data = ::device_test::mojom::internal::ControllerFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::EventDataDataView> {
  using Data = ::device_test::mojom::internal::EventData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device_test::mojom {


enum class Eye : int32_t {
  
  LEFT = 1,
  
  RIGHT = 2,
  
  NONE = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, Eye value);
inline bool IsKnownEnumValue(Eye value) {
  return internal::Eye_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrackedDeviceClass : int32_t {
  
  kTrackedDeviceInvalid = 0,
  
  kTrackedDeviceHmd = 1,
  
  kTrackedDeviceController = 2,
  
  kTrackedDeviceGenericTracker = 3,
  
  kTrackedDeviceTrackingReference = 4,
  
  kTrackedDeviceDisplayRedirect = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, TrackedDeviceClass value);
inline bool IsKnownEnumValue(TrackedDeviceClass value) {
  return internal::TrackedDeviceClass_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ControllerRole : int32_t {
  
  kControllerRoleInvalid = 0,
  
  kControllerRoleLeft = 1,
  
  kControllerRoleRight = 2,
  
  kControllerRoleVoice = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, ControllerRole value);
inline bool IsKnownEnumValue(ControllerRole value) {
  return internal::ControllerRole_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EventType : int32_t {
  
  kSessionLost = 0,
  
  kVisibilityVisibleBlurred = 1,
  
  kInstanceLost = 2,
  
  kInteractionProfileChanged = 3,
  
  kNoEvent = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, EventType value);
inline bool IsKnownEnumValue(EventType value) {
  return internal::EventType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class XRTestHookInterfaceBase {};

using XRTestHookPtrDataView =
    mojo::InterfacePtrDataView<XRTestHookInterfaceBase>;
using XRTestHookRequestDataView =
    mojo::InterfaceRequestDataView<XRTestHookInterfaceBase>;
using XRTestHookAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRTestHookInterfaceBase>;
using XRTestHookAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRTestHookInterfaceBase>;
class XRServiceTestHookInterfaceBase {};

using XRServiceTestHookPtrDataView =
    mojo::InterfacePtrDataView<XRServiceTestHookInterfaceBase>;
using XRServiceTestHookRequestDataView =
    mojo::InterfaceRequestDataView<XRServiceTestHookInterfaceBase>;
using XRServiceTestHookAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRServiceTestHookInterfaceBase>;
using XRServiceTestHookAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRServiceTestHookInterfaceBase>;


class ColorDataView {
 public:
  ColorDataView() = default;

  ColorDataView(
      internal::Color_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t r() const {
    return data_->r;
  }
  uint8_t g() const {
    return data_->g;
  }
  uint8_t b() const {
    return data_->b;
  }
  uint8_t a() const {
    return data_->a;
  }
 private:
  internal::Color_Data* data_ = nullptr;
};


class ViewDataDataView {
 public:
  ViewDataDataView() = default;

  ViewDataDataView(
      internal::ViewData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetColorDataView(
      ColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) {
    
    auto* pointer = data_->color.Get();
    return mojo::internal::Deserialize<::device_test::mojom::ColorDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEye(UserType* output) const {
    auto data_value = data_->eye;
    return mojo::internal::Deserialize<::device_test::mojom::Eye>(
        data_value, output);
  }
  Eye eye() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device_test::mojom::Eye>(data_->eye));
  }
  inline void GetViewportDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewport(UserType* output) {
    
    auto* pointer = data_->viewport.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
 private:
  internal::ViewData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PoseFrameDataDataView {
 public:
  PoseFrameDataDataView() = default;

  PoseFrameDataDataView(
      internal::PoseFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceToOriginDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceToOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `device_to_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeviceToOrigin` instead "
    "of `ReadDeviceToOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->device_to_origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
 private:
  internal::PoseFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProjectionRawDataView {
 public:
  ProjectionRawDataView() = default;

  ProjectionRawDataView(
      internal::ProjectionRaw_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float left() const {
    return data_->left;
  }
  float right() const {
    return data_->right;
  }
  float top() const {
    return data_->top;
  }
  float bottom() const {
    return data_->bottom;
  }
 private:
  internal::ProjectionRaw_Data* data_ = nullptr;
};


class DeviceConfigDataView {
 public:
  DeviceConfigDataView() = default;

  DeviceConfigDataView(
      internal::DeviceConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float interpupillary_distance() const {
    return data_->interpupillary_distance;
  }
  inline void GetProjectionLeftDataView(
      ProjectionRawDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProjectionLeft(UserType* output) {
    
    auto* pointer = data_->projection_left.Get();
    return mojo::internal::Deserialize<::device_test::mojom::ProjectionRawDataView>(
        pointer, output, message_);
  }
  inline void GetProjectionRightDataView(
      ProjectionRawDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProjectionRight(UserType* output) {
    
    auto* pointer = data_->projection_right.Get();
    return mojo::internal::Deserialize<::device_test::mojom::ProjectionRawDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ControllerAxisDataDataView {
 public:
  ControllerAxisDataDataView() = default;

  ControllerAxisDataDataView(
      internal::ControllerAxisData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float x() const {
    return data_->x;
  }
  float y() const {
    return data_->y;
  }
  uint8_t axis_type() const {
    return data_->axis_type;
  }
 private:
  internal::ControllerAxisData_Data* data_ = nullptr;
};


class ControllerFrameDataDataView {
 public:
  ControllerFrameDataDataView() = default;

  ControllerFrameDataDataView(
      internal::ControllerFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t packet_number() const {
    return data_->packet_number;
  }
  uint64_t buttons_pressed() const {
    return data_->buttons_pressed;
  }
  uint64_t buttons_touched() const {
    return data_->buttons_touched;
  }
  uint64_t supported_buttons() const {
    return data_->supported_buttons;
  }
  inline void GetAxisDataDataView(
      mojo::ArrayDataView<ControllerAxisDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAxisData(UserType* output) {
    
    auto* pointer = data_->axis_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device_test::mojom::ControllerAxisDataDataView>>(
        pointer, output, message_);
  }
  inline void GetPoseDataDataView(
      PoseFrameDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoseData(UserType* output) {
    
    auto* pointer = data_->pose_data.Get();
    return mojo::internal::Deserialize<::device_test::mojom::PoseFrameDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRole(UserType* output) const {
    auto data_value = data_->role;
    return mojo::internal::Deserialize<::device_test::mojom::ControllerRole>(
        data_value, output);
  }
  ControllerRole role() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device_test::mojom::ControllerRole>(data_->role));
  }
  inline void GetHandDataDataView(
      ::device::mojom::XRHandTrackingDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHandData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRHandTrackingDataDataView, UserType>(),
    "Attempting to read the optional `hand_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHandData` instead "
    "of `ReadHandData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hand_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRHandTrackingDataDataView>(
        pointer, output, message_);
  }
  bool is_valid() const {
    return data_->is_valid;
  }
 private:
  internal::ControllerFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EventDataDataView {
 public:
  EventDataDataView() = default;

  EventDataDataView(
      internal::EventData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::device_test::mojom::EventType>(
        data_value, output);
  }
  EventType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device_test::mojom::EventType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInteractionProfile(UserType* output) const {
    auto data_value = data_->interaction_profile;
    return mojo::internal::Deserialize<::device::mojom::OpenXrInteractionProfileType>(
        data_value, output);
  }
  ::device::mojom::OpenXrInteractionProfileType interaction_profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::OpenXrInteractionProfileType>(data_->interaction_profile));
  }
 private:
  internal::EventData_Data* data_ = nullptr;
};


}  // device_test::mojom

#endif  // DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_DATA_VIEW_H_