// device/gamepad/public/mojom/gamepad.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_H_
#define DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/gamepad/public/mojom/gamepad.mojom-features.h"  // IWYU pragma: export
#include "device/gamepad/public/mojom/gamepad.mojom-shared.h"  // IWYU pragma: export
#include "device/gamepad/public/mojom/gamepad.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "device/gamepad/public/cpp/gamepad_mojom_traits.h"
#include "base/component_export.h"




namespace device::mojom {

class GamepadObserverProxy;

template <typename ImplRefTraits>
class GamepadObserverStub;

class GamepadObserverRequestValidator;


class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadObserver
    : public GamepadObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.GamepadObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GamepadObserverInterfaceBase;
  using Proxy_ = GamepadObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = GamepadObserverStub<ImplRefTraits>;

  using RequestValidator_ = GamepadObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGamepadConnectedMinVersion = 0,
    kGamepadDisconnectedMinVersion = 0,
    kGamepadRawInputChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GamepadConnected_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GamepadDisconnected_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GamepadRawInputChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GamepadObserver() = default;

  virtual void GamepadConnected(uint32_t index, const ::device::Gamepad& gamepad) = 0;

  virtual void GamepadDisconnected(uint32_t index, const ::device::Gamepad& gamepad) = 0;

  virtual void GamepadRawInputChanged(uint32_t index, const ::device::Gamepad& gamepad) = 0;
};

class GamepadMonitorProxy;

template <typename ImplRefTraits>
class GamepadMonitorStub;

class GamepadMonitorRequestValidator;
class GamepadMonitorResponseValidator;


class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadMonitor
    : public GamepadMonitorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.GamepadMonitor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GamepadMonitorInterfaceBase;
  using Proxy_ = GamepadMonitorProxy;

  template <typename ImplRefTraits>
  using Stub_ = GamepadMonitorStub<ImplRefTraits>;

  using RequestValidator_ = GamepadMonitorRequestValidator;
  using ResponseValidator_ = GamepadMonitorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGamepadStartPollingMinVersion = 0,
    kGamepadStopPollingMinVersion = 0,
    kSetObserverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GamepadStartPolling_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GamepadStopPolling_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GamepadMonitor() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GamepadStartPolling(::base::ReadOnlySharedMemoryRegion* out_memory_region);
  using GamepadStartPollingCallback = base::OnceCallback<void(::base::ReadOnlySharedMemoryRegion)>;
  using GamepadStartPollingMojoCallback = base::OnceCallback<void(::base::ReadOnlySharedMemoryRegion)>;

  virtual void GamepadStartPolling(GamepadStartPollingCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GamepadStopPolling();
  using GamepadStopPollingCallback = base::OnceCallback<void()>;
  using GamepadStopPollingMojoCallback = base::OnceCallback<void()>;

  virtual void GamepadStopPolling(GamepadStopPollingCallback callback) = 0;

  virtual void SetObserver(::mojo::PendingRemote<GamepadObserver> gamepad_observer) = 0;
};

class GamepadHapticsManagerProxy;

template <typename ImplRefTraits>
class GamepadHapticsManagerStub;

class GamepadHapticsManagerRequestValidator;
class GamepadHapticsManagerResponseValidator;


class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadHapticsManager
    : public GamepadHapticsManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.GamepadHapticsManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GamepadHapticsManagerInterfaceBase;
  using Proxy_ = GamepadHapticsManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = GamepadHapticsManagerStub<ImplRefTraits>;

  using RequestValidator_ = GamepadHapticsManagerRequestValidator;
  using ResponseValidator_ = GamepadHapticsManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPlayVibrationEffectOnceMinVersion = 0,
    kResetVibrationActuatorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PlayVibrationEffectOnce_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetVibrationActuator_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GamepadHapticsManager() = default;

  using PlayVibrationEffectOnceCallback = base::OnceCallback<void(GamepadHapticsResult)>;
  using PlayVibrationEffectOnceMojoCallback = base::OnceCallback<void(GamepadHapticsResult)>;

  virtual void PlayVibrationEffectOnce(uint32_t pad_index, GamepadHapticEffectType type, GamepadEffectParametersPtr params, PlayVibrationEffectOnceCallback callback) = 0;

  using ResetVibrationActuatorCallback = base::OnceCallback<void(GamepadHapticsResult)>;
  using ResetVibrationActuatorMojoCallback = base::OnceCallback<void(GamepadHapticsResult)>;

  virtual void ResetVibrationActuator(uint32_t pad_index, ResetVibrationActuatorCallback callback) = 0;
};



class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadObserverProxy
    : public GamepadObserver {
 public:
  using InterfaceType = GamepadObserver;

  explicit GamepadObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GamepadConnected(uint32_t index, const ::device::Gamepad& gamepad) final;
  
  void GamepadDisconnected(uint32_t index, const ::device::Gamepad& gamepad) final;
  
  void GamepadRawInputChanged(uint32_t index, const ::device::Gamepad& gamepad) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadMonitorProxy
    : public GamepadMonitor {
 public:
  using InterfaceType = GamepadMonitor;

  explicit GamepadMonitorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GamepadStartPolling(::base::ReadOnlySharedMemoryRegion* out_memory_region) final;
  
  void GamepadStartPolling(GamepadStartPollingCallback callback) final;
  
  bool GamepadStopPolling() final;
  
  void GamepadStopPolling(GamepadStopPollingCallback callback) final;
  
  void SetObserver(::mojo::PendingRemote<GamepadObserver> gamepad_observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadHapticsManagerProxy
    : public GamepadHapticsManager {
 public:
  using InterfaceType = GamepadHapticsManager;

  explicit GamepadHapticsManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PlayVibrationEffectOnce(uint32_t pad_index, GamepadHapticEffectType type, GamepadEffectParametersPtr params, PlayVibrationEffectOnceCallback callback) final;
  
  void ResetVibrationActuator(uint32_t pad_index, ResetVibrationActuatorCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadObserverStubDispatch {
 public:
  static bool Accept(GamepadObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GamepadObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GamepadObserver>>
class GamepadObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GamepadObserverStub() = default;
  ~GamepadObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GamepadObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GamepadObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadMonitorStubDispatch {
 public:
  static bool Accept(GamepadMonitor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GamepadMonitor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GamepadMonitor>>
class GamepadMonitorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GamepadMonitorStub() = default;
  ~GamepadMonitorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GamepadMonitorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GamepadMonitorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadHapticsManagerStubDispatch {
 public:
  static bool Accept(GamepadHapticsManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GamepadHapticsManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GamepadHapticsManager>>
class GamepadHapticsManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GamepadHapticsManagerStub() = default;
  ~GamepadHapticsManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GamepadHapticsManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GamepadHapticsManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadMonitorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadHapticsManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadMonitorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadHapticsManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadQuaternion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GamepadQuaternion, T>::value>;
  using DataView = GamepadQuaternionDataView;
  using Data_ = internal::GamepadQuaternion_Data;

  template <typename... Args>
  static GamepadQuaternionPtr New(Args&&... args) {
    return GamepadQuaternionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GamepadQuaternionPtr From(const U& u) {
    return mojo::TypeConverter<GamepadQuaternionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GamepadQuaternion>::Convert(*this);
  }


  GamepadQuaternion();

  GamepadQuaternion(
      float x,
      float y,
      float z,
      float w);


  ~GamepadQuaternion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GamepadQuaternionPtr>
  GamepadQuaternionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GamepadQuaternion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GamepadQuaternion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GamepadQuaternion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadQuaternion::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadQuaternion::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GamepadQuaternion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GamepadQuaternion_UnserializedMessageContext<
            UserType, GamepadQuaternion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GamepadQuaternion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GamepadQuaternion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GamepadQuaternion_UnserializedMessageContext<
            UserType, GamepadQuaternion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GamepadQuaternion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float y;
  
  float z;
  
  float w;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GamepadQuaternion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GamepadQuaternion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GamepadQuaternion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GamepadQuaternion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadVector {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GamepadVector, T>::value>;
  using DataView = GamepadVectorDataView;
  using Data_ = internal::GamepadVector_Data;

  template <typename... Args>
  static GamepadVectorPtr New(Args&&... args) {
    return GamepadVectorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GamepadVectorPtr From(const U& u) {
    return mojo::TypeConverter<GamepadVectorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GamepadVector>::Convert(*this);
  }


  GamepadVector();

  GamepadVector(
      float x,
      float y,
      float z);


  ~GamepadVector();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GamepadVectorPtr>
  GamepadVectorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GamepadVector::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GamepadVector::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GamepadVector::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadVector::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadVector::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GamepadVector::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GamepadVector_UnserializedMessageContext<
            UserType, GamepadVector::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GamepadVector::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GamepadVector::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GamepadVector_UnserializedMessageContext<
            UserType, GamepadVector::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GamepadVector::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float y;
  
  float z;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GamepadVector::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GamepadVector::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GamepadVector::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GamepadVector::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadButton {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GamepadButton, T>::value>;
  using DataView = GamepadButtonDataView;
  using Data_ = internal::GamepadButton_Data;

  template <typename... Args>
  static GamepadButtonPtr New(Args&&... args) {
    return GamepadButtonPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GamepadButtonPtr From(const U& u) {
    return mojo::TypeConverter<GamepadButtonPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GamepadButton>::Convert(*this);
  }


  GamepadButton();

  GamepadButton(
      bool pressed,
      bool touched,
      double value);


  ~GamepadButton();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GamepadButtonPtr>
  GamepadButtonPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GamepadButton::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GamepadButton::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GamepadButton::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadButton::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadButton::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GamepadButton::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GamepadButton_UnserializedMessageContext<
            UserType, GamepadButton::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GamepadButton::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GamepadButton::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GamepadButton_UnserializedMessageContext<
            UserType, GamepadButton::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GamepadButton::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool pressed;
  
  bool touched;
  
  double value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GamepadButton::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GamepadButton::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GamepadButton::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GamepadButton::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadHapticActuator {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GamepadHapticActuator, T>::value>;
  using DataView = GamepadHapticActuatorDataView;
  using Data_ = internal::GamepadHapticActuator_Data;

  template <typename... Args>
  static GamepadHapticActuatorPtr New(Args&&... args) {
    return GamepadHapticActuatorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GamepadHapticActuatorPtr From(const U& u) {
    return mojo::TypeConverter<GamepadHapticActuatorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GamepadHapticActuator>::Convert(*this);
  }


  GamepadHapticActuator();

  explicit GamepadHapticActuator(
      ::device::GamepadHapticActuatorType type);


  ~GamepadHapticActuator();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GamepadHapticActuatorPtr>
  GamepadHapticActuatorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GamepadHapticActuator::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GamepadHapticActuator::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GamepadHapticActuator::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadHapticActuator::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadHapticActuator::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GamepadHapticActuator::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GamepadHapticActuator_UnserializedMessageContext<
            UserType, GamepadHapticActuator::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GamepadHapticActuator::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GamepadHapticActuator::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GamepadHapticActuator_UnserializedMessageContext<
            UserType, GamepadHapticActuator::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GamepadHapticActuator::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::GamepadHapticActuatorType type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GamepadHapticActuator::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GamepadHapticActuator::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GamepadHapticActuator::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GamepadHapticActuator::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadTouch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GamepadTouch, T>::value>;
  using DataView = GamepadTouchDataView;
  using Data_ = internal::GamepadTouch_Data;

  template <typename... Args>
  static GamepadTouchPtr New(Args&&... args) {
    return GamepadTouchPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GamepadTouchPtr From(const U& u) {
    return mojo::TypeConverter<GamepadTouchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GamepadTouch>::Convert(*this);
  }


  GamepadTouch();

  GamepadTouch(
      uint32_t touch_id,
      uint8_t surface_id,
      double x,
      double y,
      uint32_t surface_height,
      uint32_t surface_width,
      bool has_surface_dimensions);


  ~GamepadTouch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GamepadTouchPtr>
  GamepadTouchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GamepadTouch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GamepadTouch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GamepadTouch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadTouch::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadTouch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GamepadTouch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GamepadTouch_UnserializedMessageContext<
            UserType, GamepadTouch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GamepadTouch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GamepadTouch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GamepadTouch_UnserializedMessageContext<
            UserType, GamepadTouch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GamepadTouch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t touch_id;
  
  uint8_t surface_id;
  
  double x;
  
  double y;
  
  uint32_t surface_height;
  
  uint32_t surface_width;
  
  bool has_surface_dimensions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GamepadTouch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GamepadTouch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GamepadTouch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GamepadTouch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadPose {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GamepadPose, T>::value>;
  using DataView = GamepadPoseDataView;
  using Data_ = internal::GamepadPose_Data;

  template <typename... Args>
  static GamepadPosePtr New(Args&&... args) {
    return GamepadPosePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GamepadPosePtr From(const U& u) {
    return mojo::TypeConverter<GamepadPosePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GamepadPose>::Convert(*this);
  }


  GamepadPose();

  GamepadPose(
      const ::device::GamepadQuaternion& orientation,
      const ::device::GamepadVector& position,
      const ::device::GamepadVector& angular_velocity,
      const ::device::GamepadVector& linear_velocity,
      const ::device::GamepadVector& angular_acceleration,
      const ::device::GamepadVector& linear_acceleration);


  ~GamepadPose();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GamepadPosePtr>
  GamepadPosePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GamepadPose::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GamepadPose::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GamepadPose::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadPose::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadPose::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GamepadPose::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GamepadPose_UnserializedMessageContext<
            UserType, GamepadPose::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GamepadPose::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GamepadPose::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GamepadPose_UnserializedMessageContext<
            UserType, GamepadPose::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GamepadPose::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::GamepadQuaternion orientation;
  
  ::device::GamepadVector position;
  
  ::device::GamepadVector angular_velocity;
  
  ::device::GamepadVector linear_velocity;
  
  ::device::GamepadVector angular_acceleration;
  
  ::device::GamepadVector linear_acceleration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GamepadPose::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GamepadPose::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GamepadPose::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GamepadPose::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(GAMEPAD_MOJOM) Gamepad {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Gamepad, T>::value>;
  using DataView = GamepadDataView;
  using Data_ = internal::Gamepad_Data;

  template <typename... Args>
  static GamepadPtr New(Args&&... args) {
    return GamepadPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GamepadPtr From(const U& u) {
    return mojo::TypeConverter<GamepadPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Gamepad>::Convert(*this);
  }


  Gamepad();

  Gamepad(
      bool connected,
      std::vector<uint16_t> id,
      int64_t timestamp,
      std::vector<double> axes,
      std::vector<::device::GamepadButton> buttons,
      const ::device::GamepadHapticActuator& vibration_actuator,
      ::device::GamepadMapping mapping,
      const ::device::GamepadPose& pose,
      ::device::GamepadHand hand,
      std::vector<::device::GamepadTouch> touch_events,
      uint32_t display_id);


  ~Gamepad();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GamepadPtr>
  GamepadPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Gamepad::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Gamepad::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Gamepad::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gamepad::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gamepad::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Gamepad::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Gamepad_UnserializedMessageContext<
            UserType, Gamepad::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Gamepad::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Gamepad::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Gamepad_UnserializedMessageContext<
            UserType, Gamepad::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Gamepad::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool connected;
  
  std::vector<uint16_t> id;
  
  int64_t timestamp;
  
  std::vector<double> axes;
  
  std::vector<::device::GamepadButton> buttons;
  
  ::device::GamepadHapticActuator vibration_actuator;
  
  ::device::GamepadMapping mapping;
  
  ::device::GamepadPose pose;
  
  ::device::GamepadHand hand;
  
  std::vector<::device::GamepadTouch> touch_events;
  
  uint32_t display_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Gamepad::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Gamepad::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Gamepad::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Gamepad::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadEffectParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GamepadEffectParameters, T>::value>;
  using DataView = GamepadEffectParametersDataView;
  using Data_ = internal::GamepadEffectParameters_Data;

  template <typename... Args>
  static GamepadEffectParametersPtr New(Args&&... args) {
    return GamepadEffectParametersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GamepadEffectParametersPtr From(const U& u) {
    return mojo::TypeConverter<GamepadEffectParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GamepadEffectParameters>::Convert(*this);
  }


  GamepadEffectParameters();

  GamepadEffectParameters(
      double duration,
      double start_delay,
      double strong_magnitude,
      double weak_magnitude,
      double left_trigger,
      double right_trigger);


  ~GamepadEffectParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GamepadEffectParametersPtr>
  GamepadEffectParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GamepadEffectParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GamepadEffectParameters::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GamepadEffectParameters::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadEffectParameters::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GamepadEffectParameters::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GamepadEffectParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GamepadEffectParameters_UnserializedMessageContext<
            UserType, GamepadEffectParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GamepadEffectParameters::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GamepadEffectParameters::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GamepadEffectParameters_UnserializedMessageContext<
            UserType, GamepadEffectParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GamepadEffectParameters::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double duration;
  
  double start_delay;
  
  double strong_magnitude;
  
  double weak_magnitude;
  
  double left_trigger;
  
  double right_trigger;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GamepadEffectParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GamepadEffectParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GamepadEffectParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GamepadEffectParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GamepadQuaternionPtr GamepadQuaternion::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(z),
      mojo::Clone(w)
  );
}

template <typename T, GamepadQuaternion::EnableIfSame<T>*>
bool GamepadQuaternion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->z, other_struct.z))
    return false;
  if (!mojo::Equals(this->w, other_struct.w))
    return false;
  return true;
}

template <typename T, GamepadQuaternion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.z < rhs.z)
    return true;
  if (rhs.z < lhs.z)
    return false;
  if (lhs.w < rhs.w)
    return true;
  if (rhs.w < lhs.w)
    return false;
  return false;
}
template <typename StructPtrType>
GamepadVectorPtr GamepadVector::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(z)
  );
}

template <typename T, GamepadVector::EnableIfSame<T>*>
bool GamepadVector::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->z, other_struct.z))
    return false;
  return true;
}

template <typename T, GamepadVector::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.z < rhs.z)
    return true;
  if (rhs.z < lhs.z)
    return false;
  return false;
}
template <typename StructPtrType>
GamepadButtonPtr GamepadButton::Clone() const {
  return New(
      mojo::Clone(pressed),
      mojo::Clone(touched),
      mojo::Clone(value)
  );
}

template <typename T, GamepadButton::EnableIfSame<T>*>
bool GamepadButton::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pressed, other_struct.pressed))
    return false;
  if (!mojo::Equals(this->touched, other_struct.touched))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, GamepadButton::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pressed < rhs.pressed)
    return true;
  if (rhs.pressed < lhs.pressed)
    return false;
  if (lhs.touched < rhs.touched)
    return true;
  if (rhs.touched < lhs.touched)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
GamepadTouchPtr GamepadTouch::Clone() const {
  return New(
      mojo::Clone(touch_id),
      mojo::Clone(surface_id),
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(surface_height),
      mojo::Clone(surface_width),
      mojo::Clone(has_surface_dimensions)
  );
}

template <typename T, GamepadTouch::EnableIfSame<T>*>
bool GamepadTouch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->touch_id, other_struct.touch_id))
    return false;
  if (!mojo::Equals(this->surface_id, other_struct.surface_id))
    return false;
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->surface_height, other_struct.surface_height))
    return false;
  if (!mojo::Equals(this->surface_width, other_struct.surface_width))
    return false;
  if (!mojo::Equals(this->has_surface_dimensions, other_struct.has_surface_dimensions))
    return false;
  return true;
}

template <typename T, GamepadTouch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.touch_id < rhs.touch_id)
    return true;
  if (rhs.touch_id < lhs.touch_id)
    return false;
  if (lhs.surface_id < rhs.surface_id)
    return true;
  if (rhs.surface_id < lhs.surface_id)
    return false;
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.surface_height < rhs.surface_height)
    return true;
  if (rhs.surface_height < lhs.surface_height)
    return false;
  if (lhs.surface_width < rhs.surface_width)
    return true;
  if (rhs.surface_width < lhs.surface_width)
    return false;
  if (lhs.has_surface_dimensions < rhs.has_surface_dimensions)
    return true;
  if (rhs.has_surface_dimensions < lhs.has_surface_dimensions)
    return false;
  return false;
}
template <typename StructPtrType>
GamepadPosePtr GamepadPose::Clone() const {
  return New(
      mojo::Clone(orientation),
      mojo::Clone(position),
      mojo::Clone(angular_velocity),
      mojo::Clone(linear_velocity),
      mojo::Clone(angular_acceleration),
      mojo::Clone(linear_acceleration)
  );
}

template <typename T, GamepadPose::EnableIfSame<T>*>
bool GamepadPose::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->angular_velocity, other_struct.angular_velocity))
    return false;
  if (!mojo::Equals(this->linear_velocity, other_struct.linear_velocity))
    return false;
  if (!mojo::Equals(this->angular_acceleration, other_struct.angular_acceleration))
    return false;
  if (!mojo::Equals(this->linear_acceleration, other_struct.linear_acceleration))
    return false;
  return true;
}

template <typename T, GamepadPose::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.orientation < rhs.orientation)
    return true;
  if (rhs.orientation < lhs.orientation)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  if (lhs.angular_velocity < rhs.angular_velocity)
    return true;
  if (rhs.angular_velocity < lhs.angular_velocity)
    return false;
  if (lhs.linear_velocity < rhs.linear_velocity)
    return true;
  if (rhs.linear_velocity < lhs.linear_velocity)
    return false;
  if (lhs.angular_acceleration < rhs.angular_acceleration)
    return true;
  if (rhs.angular_acceleration < lhs.angular_acceleration)
    return false;
  if (lhs.linear_acceleration < rhs.linear_acceleration)
    return true;
  if (rhs.linear_acceleration < lhs.linear_acceleration)
    return false;
  return false;
}
template <typename StructPtrType>
GamepadHapticActuatorPtr GamepadHapticActuator::Clone() const {
  return New(
      mojo::Clone(type)
  );
}

template <typename T, GamepadHapticActuator::EnableIfSame<T>*>
bool GamepadHapticActuator::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, GamepadHapticActuator::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}
template <typename StructPtrType>
GamepadPtr Gamepad::Clone() const {
  return New(
      mojo::Clone(connected),
      mojo::Clone(id),
      mojo::Clone(timestamp),
      mojo::Clone(axes),
      mojo::Clone(buttons),
      mojo::Clone(vibration_actuator),
      mojo::Clone(mapping),
      mojo::Clone(pose),
      mojo::Clone(hand),
      mojo::Clone(touch_events),
      mojo::Clone(display_id)
  );
}

template <typename T, Gamepad::EnableIfSame<T>*>
bool Gamepad::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->connected, other_struct.connected))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->axes, other_struct.axes))
    return false;
  if (!mojo::Equals(this->buttons, other_struct.buttons))
    return false;
  if (!mojo::Equals(this->vibration_actuator, other_struct.vibration_actuator))
    return false;
  if (!mojo::Equals(this->mapping, other_struct.mapping))
    return false;
  if (!mojo::Equals(this->pose, other_struct.pose))
    return false;
  if (!mojo::Equals(this->hand, other_struct.hand))
    return false;
  if (!mojo::Equals(this->touch_events, other_struct.touch_events))
    return false;
  if (!mojo::Equals(this->display_id, other_struct.display_id))
    return false;
  return true;
}

template <typename T, Gamepad::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.connected < rhs.connected)
    return true;
  if (rhs.connected < lhs.connected)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.axes < rhs.axes)
    return true;
  if (rhs.axes < lhs.axes)
    return false;
  if (lhs.buttons < rhs.buttons)
    return true;
  if (rhs.buttons < lhs.buttons)
    return false;
  if (lhs.vibration_actuator < rhs.vibration_actuator)
    return true;
  if (rhs.vibration_actuator < lhs.vibration_actuator)
    return false;
  if (lhs.mapping < rhs.mapping)
    return true;
  if (rhs.mapping < lhs.mapping)
    return false;
  if (lhs.pose < rhs.pose)
    return true;
  if (rhs.pose < lhs.pose)
    return false;
  if (lhs.hand < rhs.hand)
    return true;
  if (rhs.hand < lhs.hand)
    return false;
  if (lhs.touch_events < rhs.touch_events)
    return true;
  if (rhs.touch_events < lhs.touch_events)
    return false;
  if (lhs.display_id < rhs.display_id)
    return true;
  if (rhs.display_id < lhs.display_id)
    return false;
  return false;
}
template <typename StructPtrType>
GamepadEffectParametersPtr GamepadEffectParameters::Clone() const {
  return New(
      mojo::Clone(duration),
      mojo::Clone(start_delay),
      mojo::Clone(strong_magnitude),
      mojo::Clone(weak_magnitude),
      mojo::Clone(left_trigger),
      mojo::Clone(right_trigger)
  );
}

template <typename T, GamepadEffectParameters::EnableIfSame<T>*>
bool GamepadEffectParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->start_delay, other_struct.start_delay))
    return false;
  if (!mojo::Equals(this->strong_magnitude, other_struct.strong_magnitude))
    return false;
  if (!mojo::Equals(this->weak_magnitude, other_struct.weak_magnitude))
    return false;
  if (!mojo::Equals(this->left_trigger, other_struct.left_trigger))
    return false;
  if (!mojo::Equals(this->right_trigger, other_struct.right_trigger))
    return false;
  return true;
}

template <typename T, GamepadEffectParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.start_delay < rhs.start_delay)
    return true;
  if (rhs.start_delay < lhs.start_delay)
    return false;
  if (lhs.strong_magnitude < rhs.strong_magnitude)
    return true;
  if (rhs.strong_magnitude < lhs.strong_magnitude)
    return false;
  if (lhs.weak_magnitude < rhs.weak_magnitude)
    return true;
  if (rhs.weak_magnitude < lhs.weak_magnitude)
    return false;
  if (lhs.left_trigger < rhs.left_trigger)
    return true;
  if (rhs.left_trigger < lhs.left_trigger)
    return false;
  if (lhs.right_trigger < rhs.right_trigger)
    return true;
  if (rhs.right_trigger < lhs.right_trigger)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM) StructTraits<::device::mojom::GamepadQuaternion::DataView,
                                         ::device::mojom::GamepadQuaternionPtr> {
  static bool IsNull(const ::device::mojom::GamepadQuaternionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::GamepadQuaternionPtr* output) { output->reset(); }

  static decltype(::device::mojom::GamepadQuaternion::x) x(
      const ::device::mojom::GamepadQuaternionPtr& input) {
    return input->x;
  }

  static decltype(::device::mojom::GamepadQuaternion::y) y(
      const ::device::mojom::GamepadQuaternionPtr& input) {
    return input->y;
  }

  static decltype(::device::mojom::GamepadQuaternion::z) z(
      const ::device::mojom::GamepadQuaternionPtr& input) {
    return input->z;
  }

  static decltype(::device::mojom::GamepadQuaternion::w) w(
      const ::device::mojom::GamepadQuaternionPtr& input) {
    return input->w;
  }

  static bool Read(::device::mojom::GamepadQuaternion::DataView input, ::device::mojom::GamepadQuaternionPtr* output);
};


template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM) StructTraits<::device::mojom::GamepadVector::DataView,
                                         ::device::mojom::GamepadVectorPtr> {
  static bool IsNull(const ::device::mojom::GamepadVectorPtr& input) { return !input; }
  static void SetToNull(::device::mojom::GamepadVectorPtr* output) { output->reset(); }

  static decltype(::device::mojom::GamepadVector::x) x(
      const ::device::mojom::GamepadVectorPtr& input) {
    return input->x;
  }

  static decltype(::device::mojom::GamepadVector::y) y(
      const ::device::mojom::GamepadVectorPtr& input) {
    return input->y;
  }

  static decltype(::device::mojom::GamepadVector::z) z(
      const ::device::mojom::GamepadVectorPtr& input) {
    return input->z;
  }

  static bool Read(::device::mojom::GamepadVector::DataView input, ::device::mojom::GamepadVectorPtr* output);
};


template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM) StructTraits<::device::mojom::GamepadButton::DataView,
                                         ::device::mojom::GamepadButtonPtr> {
  static bool IsNull(const ::device::mojom::GamepadButtonPtr& input) { return !input; }
  static void SetToNull(::device::mojom::GamepadButtonPtr* output) { output->reset(); }

  static decltype(::device::mojom::GamepadButton::pressed) pressed(
      const ::device::mojom::GamepadButtonPtr& input) {
    return input->pressed;
  }

  static decltype(::device::mojom::GamepadButton::touched) touched(
      const ::device::mojom::GamepadButtonPtr& input) {
    return input->touched;
  }

  static decltype(::device::mojom::GamepadButton::value) value(
      const ::device::mojom::GamepadButtonPtr& input) {
    return input->value;
  }

  static bool Read(::device::mojom::GamepadButton::DataView input, ::device::mojom::GamepadButtonPtr* output);
};


template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM) StructTraits<::device::mojom::GamepadTouch::DataView,
                                         ::device::mojom::GamepadTouchPtr> {
  static bool IsNull(const ::device::mojom::GamepadTouchPtr& input) { return !input; }
  static void SetToNull(::device::mojom::GamepadTouchPtr* output) { output->reset(); }

  static decltype(::device::mojom::GamepadTouch::touch_id) touch_id(
      const ::device::mojom::GamepadTouchPtr& input) {
    return input->touch_id;
  }

  static decltype(::device::mojom::GamepadTouch::surface_id) surface_id(
      const ::device::mojom::GamepadTouchPtr& input) {
    return input->surface_id;
  }

  static decltype(::device::mojom::GamepadTouch::x) x(
      const ::device::mojom::GamepadTouchPtr& input) {
    return input->x;
  }

  static decltype(::device::mojom::GamepadTouch::y) y(
      const ::device::mojom::GamepadTouchPtr& input) {
    return input->y;
  }

  static decltype(::device::mojom::GamepadTouch::surface_height) surface_height(
      const ::device::mojom::GamepadTouchPtr& input) {
    return input->surface_height;
  }

  static decltype(::device::mojom::GamepadTouch::surface_width) surface_width(
      const ::device::mojom::GamepadTouchPtr& input) {
    return input->surface_width;
  }

  static decltype(::device::mojom::GamepadTouch::has_surface_dimensions) has_surface_dimensions(
      const ::device::mojom::GamepadTouchPtr& input) {
    return input->has_surface_dimensions;
  }

  static bool Read(::device::mojom::GamepadTouch::DataView input, ::device::mojom::GamepadTouchPtr* output);
};


template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM) StructTraits<::device::mojom::GamepadPose::DataView,
                                         ::device::mojom::GamepadPosePtr> {
  static bool IsNull(const ::device::mojom::GamepadPosePtr& input) { return !input; }
  static void SetToNull(::device::mojom::GamepadPosePtr* output) { output->reset(); }

  static const decltype(::device::mojom::GamepadPose::orientation)& orientation(
      const ::device::mojom::GamepadPosePtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::GamepadPose::position)& position(
      const ::device::mojom::GamepadPosePtr& input) {
    return input->position;
  }

  static const decltype(::device::mojom::GamepadPose::angular_velocity)& angular_velocity(
      const ::device::mojom::GamepadPosePtr& input) {
    return input->angular_velocity;
  }

  static const decltype(::device::mojom::GamepadPose::linear_velocity)& linear_velocity(
      const ::device::mojom::GamepadPosePtr& input) {
    return input->linear_velocity;
  }

  static const decltype(::device::mojom::GamepadPose::angular_acceleration)& angular_acceleration(
      const ::device::mojom::GamepadPosePtr& input) {
    return input->angular_acceleration;
  }

  static const decltype(::device::mojom::GamepadPose::linear_acceleration)& linear_acceleration(
      const ::device::mojom::GamepadPosePtr& input) {
    return input->linear_acceleration;
  }

  static bool Read(::device::mojom::GamepadPose::DataView input, ::device::mojom::GamepadPosePtr* output);
};


template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM) StructTraits<::device::mojom::GamepadHapticActuator::DataView,
                                         ::device::mojom::GamepadHapticActuatorPtr> {
  static bool IsNull(const ::device::mojom::GamepadHapticActuatorPtr& input) { return !input; }
  static void SetToNull(::device::mojom::GamepadHapticActuatorPtr* output) { output->reset(); }

  static decltype(::device::mojom::GamepadHapticActuator::type) type(
      const ::device::mojom::GamepadHapticActuatorPtr& input) {
    return input->type;
  }

  static bool Read(::device::mojom::GamepadHapticActuator::DataView input, ::device::mojom::GamepadHapticActuatorPtr* output);
};


template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM) StructTraits<::device::mojom::Gamepad::DataView,
                                         ::device::mojom::GamepadPtr> {
  static bool IsNull(const ::device::mojom::GamepadPtr& input) { return !input; }
  static void SetToNull(::device::mojom::GamepadPtr* output) { output->reset(); }

  static decltype(::device::mojom::Gamepad::connected) connected(
      const ::device::mojom::GamepadPtr& input) {
    return input->connected;
  }

  static const decltype(::device::mojom::Gamepad::id)& id(
      const ::device::mojom::GamepadPtr& input) {
    return input->id;
  }

  static decltype(::device::mojom::Gamepad::timestamp) timestamp(
      const ::device::mojom::GamepadPtr& input) {
    return input->timestamp;
  }

  static const decltype(::device::mojom::Gamepad::axes)& axes(
      const ::device::mojom::GamepadPtr& input) {
    return input->axes;
  }

  static const decltype(::device::mojom::Gamepad::buttons)& buttons(
      const ::device::mojom::GamepadPtr& input) {
    return input->buttons;
  }

  static const decltype(::device::mojom::Gamepad::vibration_actuator)& vibration_actuator(
      const ::device::mojom::GamepadPtr& input) {
    return input->vibration_actuator;
  }

  static decltype(::device::mojom::Gamepad::mapping) mapping(
      const ::device::mojom::GamepadPtr& input) {
    return input->mapping;
  }

  static const decltype(::device::mojom::Gamepad::pose)& pose(
      const ::device::mojom::GamepadPtr& input) {
    return input->pose;
  }

  static decltype(::device::mojom::Gamepad::hand) hand(
      const ::device::mojom::GamepadPtr& input) {
    return input->hand;
  }

  static const decltype(::device::mojom::Gamepad::touch_events)& touch_events(
      const ::device::mojom::GamepadPtr& input) {
    return input->touch_events;
  }

  static decltype(::device::mojom::Gamepad::display_id) display_id(
      const ::device::mojom::GamepadPtr& input) {
    return input->display_id;
  }

  static bool Read(::device::mojom::Gamepad::DataView input, ::device::mojom::GamepadPtr* output);
};


template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM) StructTraits<::device::mojom::GamepadEffectParameters::DataView,
                                         ::device::mojom::GamepadEffectParametersPtr> {
  static bool IsNull(const ::device::mojom::GamepadEffectParametersPtr& input) { return !input; }
  static void SetToNull(::device::mojom::GamepadEffectParametersPtr* output) { output->reset(); }

  static decltype(::device::mojom::GamepadEffectParameters::duration) duration(
      const ::device::mojom::GamepadEffectParametersPtr& input) {
    return input->duration;
  }

  static decltype(::device::mojom::GamepadEffectParameters::start_delay) start_delay(
      const ::device::mojom::GamepadEffectParametersPtr& input) {
    return input->start_delay;
  }

  static decltype(::device::mojom::GamepadEffectParameters::strong_magnitude) strong_magnitude(
      const ::device::mojom::GamepadEffectParametersPtr& input) {
    return input->strong_magnitude;
  }

  static decltype(::device::mojom::GamepadEffectParameters::weak_magnitude) weak_magnitude(
      const ::device::mojom::GamepadEffectParametersPtr& input) {
    return input->weak_magnitude;
  }

  static decltype(::device::mojom::GamepadEffectParameters::left_trigger) left_trigger(
      const ::device::mojom::GamepadEffectParametersPtr& input) {
    return input->left_trigger;
  }

  static decltype(::device::mojom::GamepadEffectParameters::right_trigger) right_trigger(
      const ::device::mojom::GamepadEffectParametersPtr& input) {
    return input->right_trigger;
  }

  static bool Read(::device::mojom::GamepadEffectParameters::DataView input, ::device::mojom::GamepadEffectParametersPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_H_