// device/gamepad/public/mojom/gamepad.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_SHARED_H_
#define DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/gamepad/public/mojom/gamepad.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "device/gamepad/public/mojom/gamepad.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::device::mojom::GamepadMapping>
    : public mojo::internal::EnumHashImpl<::device::mojom::GamepadMapping> {};

template <>
struct hash<::device::mojom::GamepadHand>
    : public mojo::internal::EnumHashImpl<::device::mojom::GamepadHand> {};

template <>
struct hash<::device::mojom::GamepadHapticActuatorType>
    : public mojo::internal::EnumHashImpl<::device::mojom::GamepadHapticActuatorType> {};

template <>
struct hash<::device::mojom::GamepadHapticEffectType>
    : public mojo::internal::EnumHashImpl<::device::mojom::GamepadHapticEffectType> {};

template <>
struct hash<::device::mojom::GamepadHapticsResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::GamepadHapticsResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadMapping, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::GamepadMapping, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::GamepadMapping>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadHand, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::GamepadHand, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::GamepadHand>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadHapticActuatorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::GamepadHapticActuatorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::GamepadHapticActuatorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadHapticEffectType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::GamepadHapticEffectType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::GamepadHapticEffectType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadHapticsResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::GamepadHapticsResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::GamepadHapticsResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadQuaternionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadQuaternionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadQuaternion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->x = Traits::x(input);

    fragment->y = Traits::y(input);

    fragment->z = Traits::z(input);

    fragment->w = Traits::w(input);
  }

  static bool Deserialize(::device::mojom::internal::GamepadQuaternion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GamepadQuaternionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadVectorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadVectorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadVector_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->x = Traits::x(input);

    fragment->y = Traits::y(input);

    fragment->z = Traits::z(input);
  }

  static bool Deserialize(::device::mojom::internal::GamepadVector_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GamepadVectorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadButtonDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadButtonDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadButton_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->pressed = Traits::pressed(input);

    fragment->touched = Traits::touched(input);

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::device::mojom::internal::GamepadButton_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GamepadButtonDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadTouchDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadTouchDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadTouch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->touch_id = Traits::touch_id(input);

    fragment->surface_id = Traits::surface_id(input);

    fragment->x = Traits::x(input);

    fragment->y = Traits::y(input);

    fragment->surface_height = Traits::surface_height(input);

    fragment->surface_width = Traits::surface_width(input);

    fragment->has_surface_dimensions = Traits::has_surface_dimensions(input);
  }

  static bool Deserialize(::device::mojom::internal::GamepadTouch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GamepadTouchDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadPoseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadPoseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadPose_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::orientation(input)) in_orientation = Traits::orientation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->orientation)::BaseType> orientation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::GamepadQuaternionDataView>(
      in_orientation,
      orientation_fragment);

    fragment->orientation.Set(
        orientation_fragment.is_null() ? nullptr : orientation_fragment.data());

    decltype(Traits::position(input)) in_position = Traits::position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position)::BaseType> position_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::GamepadVectorDataView>(
      in_position,
      position_fragment);

    fragment->position.Set(
        position_fragment.is_null() ? nullptr : position_fragment.data());

    decltype(Traits::angular_velocity(input)) in_angular_velocity = Traits::angular_velocity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->angular_velocity)::BaseType> angular_velocity_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::GamepadVectorDataView>(
      in_angular_velocity,
      angular_velocity_fragment);

    fragment->angular_velocity.Set(
        angular_velocity_fragment.is_null() ? nullptr : angular_velocity_fragment.data());

    decltype(Traits::linear_velocity(input)) in_linear_velocity = Traits::linear_velocity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->linear_velocity)::BaseType> linear_velocity_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::GamepadVectorDataView>(
      in_linear_velocity,
      linear_velocity_fragment);

    fragment->linear_velocity.Set(
        linear_velocity_fragment.is_null() ? nullptr : linear_velocity_fragment.data());

    decltype(Traits::angular_acceleration(input)) in_angular_acceleration = Traits::angular_acceleration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->angular_acceleration)::BaseType> angular_acceleration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::GamepadVectorDataView>(
      in_angular_acceleration,
      angular_acceleration_fragment);

    fragment->angular_acceleration.Set(
        angular_acceleration_fragment.is_null() ? nullptr : angular_acceleration_fragment.data());

    decltype(Traits::linear_acceleration(input)) in_linear_acceleration = Traits::linear_acceleration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->linear_acceleration)::BaseType> linear_acceleration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::GamepadVectorDataView>(
      in_linear_acceleration,
      linear_acceleration_fragment);

    fragment->linear_acceleration.Set(
        linear_acceleration_fragment.is_null() ? nullptr : linear_acceleration_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::GamepadPose_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GamepadPoseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadHapticActuatorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadHapticActuatorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadHapticActuator_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device::mojom::GamepadHapticActuatorType>(
      Traits::type(input),
      &fragment->type);
  }

  static bool Deserialize(::device::mojom::internal::GamepadHapticActuator_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GamepadHapticActuatorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::Gamepad_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->connected = Traits::connected(input);

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType>
        id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
      in_id,
      id_fragment,
      &id_validate_params);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in Gamepad struct");

    fragment->timestamp = Traits::timestamp(input);

    decltype(Traits::axes(input)) in_axes = Traits::axes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->axes)::BaseType>
        axes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<double>>(
      in_axes,
      axes_fragment,
      &axes_validate_params);

    fragment->axes.Set(
        axes_fragment.is_null() ? nullptr : axes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->axes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null axes in Gamepad struct");

    decltype(Traits::buttons(input)) in_buttons = Traits::buttons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buttons)::BaseType>
        buttons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& buttons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::GamepadButtonDataView>>(
      in_buttons,
      buttons_fragment,
      &buttons_validate_params);

    fragment->buttons.Set(
        buttons_fragment.is_null() ? nullptr : buttons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->buttons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buttons in Gamepad struct");

    decltype(Traits::vibration_actuator(input)) in_vibration_actuator = Traits::vibration_actuator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vibration_actuator)::BaseType> vibration_actuator_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::GamepadHapticActuatorDataView>(
      in_vibration_actuator,
      vibration_actuator_fragment);

    fragment->vibration_actuator.Set(
        vibration_actuator_fragment.is_null() ? nullptr : vibration_actuator_fragment.data());

    
    mojo::internal::Serialize<::device::mojom::GamepadMapping>(
      Traits::mapping(input),
      &fragment->mapping);

    decltype(Traits::pose(input)) in_pose = Traits::pose(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pose)::BaseType> pose_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::GamepadPoseDataView>(
      in_pose,
      pose_fragment);

    fragment->pose.Set(
        pose_fragment.is_null() ? nullptr : pose_fragment.data());

    
    mojo::internal::Serialize<::device::mojom::GamepadHand>(
      Traits::hand(input),
      &fragment->hand);

    decltype(Traits::touch_events(input)) in_touch_events = Traits::touch_events(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->touch_events)::BaseType>
        touch_events_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& touch_events_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::GamepadTouchDataView>>(
      in_touch_events,
      touch_events_fragment,
      &touch_events_validate_params);

    fragment->touch_events.Set(
        touch_events_fragment.is_null() ? nullptr : touch_events_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->touch_events.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null touch_events in Gamepad struct");

    fragment->display_id = Traits::display_id(input);
  }

  static bool Deserialize(::device::mojom::internal::Gamepad_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GamepadDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GamepadEffectParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GamepadEffectParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GamepadEffectParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->duration = Traits::duration(input);

    fragment->start_delay = Traits::start_delay(input);

    fragment->strong_magnitude = Traits::strong_magnitude(input);

    fragment->weak_magnitude = Traits::weak_magnitude(input);

    fragment->left_trigger = Traits::left_trigger(input);

    fragment->right_trigger = Traits::right_trigger(input);
  }

  static bool Deserialize(::device::mojom::internal::GamepadEffectParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GamepadEffectParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {









inline void GamepadPoseDataView::GetOrientationDataView(
    GamepadQuaternionDataView* output) {
  auto pointer = data_->orientation.Get();
  *output = GamepadQuaternionDataView(pointer, message_);
}
inline void GamepadPoseDataView::GetPositionDataView(
    GamepadVectorDataView* output) {
  auto pointer = data_->position.Get();
  *output = GamepadVectorDataView(pointer, message_);
}
inline void GamepadPoseDataView::GetAngularVelocityDataView(
    GamepadVectorDataView* output) {
  auto pointer = data_->angular_velocity.Get();
  *output = GamepadVectorDataView(pointer, message_);
}
inline void GamepadPoseDataView::GetLinearVelocityDataView(
    GamepadVectorDataView* output) {
  auto pointer = data_->linear_velocity.Get();
  *output = GamepadVectorDataView(pointer, message_);
}
inline void GamepadPoseDataView::GetAngularAccelerationDataView(
    GamepadVectorDataView* output) {
  auto pointer = data_->angular_acceleration.Get();
  *output = GamepadVectorDataView(pointer, message_);
}
inline void GamepadPoseDataView::GetLinearAccelerationDataView(
    GamepadVectorDataView* output) {
  auto pointer = data_->linear_acceleration.Get();
  *output = GamepadVectorDataView(pointer, message_);
}




inline void GamepadDataView::GetIdDataView(
    mojo::ArrayDataView<uint16_t>* output) {
  auto pointer = data_->id.Get();
  *output = mojo::ArrayDataView<uint16_t>(pointer, message_);
}
inline void GamepadDataView::GetAxesDataView(
    mojo::ArrayDataView<double>* output) {
  auto pointer = data_->axes.Get();
  *output = mojo::ArrayDataView<double>(pointer, message_);
}
inline void GamepadDataView::GetButtonsDataView(
    mojo::ArrayDataView<GamepadButtonDataView>* output) {
  auto pointer = data_->buttons.Get();
  *output = mojo::ArrayDataView<GamepadButtonDataView>(pointer, message_);
}
inline void GamepadDataView::GetVibrationActuatorDataView(
    GamepadHapticActuatorDataView* output) {
  auto pointer = data_->vibration_actuator.Get();
  *output = GamepadHapticActuatorDataView(pointer, message_);
}
inline void GamepadDataView::GetPoseDataView(
    GamepadPoseDataView* output) {
  auto pointer = data_->pose.Get();
  *output = GamepadPoseDataView(pointer, message_);
}
inline void GamepadDataView::GetTouchEventsDataView(
    mojo::ArrayDataView<GamepadTouchDataView>* output) {
  auto pointer = data_->touch_events.Get();
  *output = mojo::ArrayDataView<GamepadTouchDataView>(pointer, message_);
}





}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) TraceFormatTraits<::device::mojom::GamepadMapping> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::GamepadMapping value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) TraceFormatTraits<::device::mojom::GamepadHand> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::GamepadHand value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) TraceFormatTraits<::device::mojom::GamepadHapticActuatorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::GamepadHapticActuatorType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) TraceFormatTraits<::device::mojom::GamepadHapticEffectType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::GamepadHapticEffectType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(GAMEPAD_MOJOM_SHARED) TraceFormatTraits<::device::mojom::GamepadHapticsResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::GamepadHapticsResult value);
};

} // namespace perfetto

#endif  // DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_SHARED_H_