// device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_GATT_CHARACTERISTIC_PERMISSIONS_MOJOM_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_GATT_CHARACTERISTIC_PERMISSIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom-features.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom-shared.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "device/bluetooth/public/mojom/gatt_characteristic_mojom_traits.h"
#include "device/bluetooth/public/mojom/gatt_service_mojom_traits.h"
#include "device/bluetooth/public/mojom/uuid_mojom_traits.h"




namespace bluetooth::mojom {








class  GattCharacteristicPermissions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GattCharacteristicPermissions, T>::value>;
  using DataView = GattCharacteristicPermissionsDataView;
  using Data_ = internal::GattCharacteristicPermissions_Data;

  template <typename... Args>
  static GattCharacteristicPermissionsPtr New(Args&&... args) {
    return GattCharacteristicPermissionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GattCharacteristicPermissionsPtr From(const U& u) {
    return mojo::TypeConverter<GattCharacteristicPermissionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GattCharacteristicPermissions>::Convert(*this);
  }


  GattCharacteristicPermissions();

  GattCharacteristicPermissions(
      bool read,
      bool write,
      bool read_encrypted,
      bool write_encrypted,
      bool read_encrypted_authenticated,
      bool write_encrypted_authenticated);


  ~GattCharacteristicPermissions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GattCharacteristicPermissionsPtr>
  GattCharacteristicPermissionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GattCharacteristicPermissions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GattCharacteristicPermissions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GattCharacteristicPermissions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GattCharacteristicPermissions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GattCharacteristicPermissions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GattCharacteristicPermissions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GattCharacteristicPermissions_UnserializedMessageContext<
            UserType, GattCharacteristicPermissions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GattCharacteristicPermissions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GattCharacteristicPermissions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GattCharacteristicPermissions_UnserializedMessageContext<
            UserType, GattCharacteristicPermissions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GattCharacteristicPermissions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool read;
  
  bool write;
  
  bool read_encrypted;
  
  bool write_encrypted;
  
  bool read_encrypted_authenticated;
  
  bool write_encrypted_authenticated;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GattCharacteristicPermissions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GattCharacteristicPermissions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GattCharacteristicPermissions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GattCharacteristicPermissions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GattCharacteristicPermissionsPtr GattCharacteristicPermissions::Clone() const {
  return New(
      mojo::Clone(read),
      mojo::Clone(write),
      mojo::Clone(read_encrypted),
      mojo::Clone(write_encrypted),
      mojo::Clone(read_encrypted_authenticated),
      mojo::Clone(write_encrypted_authenticated)
  );
}

template <typename T, GattCharacteristicPermissions::EnableIfSame<T>*>
bool GattCharacteristicPermissions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->read, other_struct.read))
    return false;
  if (!mojo::Equals(this->write, other_struct.write))
    return false;
  if (!mojo::Equals(this->read_encrypted, other_struct.read_encrypted))
    return false;
  if (!mojo::Equals(this->write_encrypted, other_struct.write_encrypted))
    return false;
  if (!mojo::Equals(this->read_encrypted_authenticated, other_struct.read_encrypted_authenticated))
    return false;
  if (!mojo::Equals(this->write_encrypted_authenticated, other_struct.write_encrypted_authenticated))
    return false;
  return true;
}

template <typename T, GattCharacteristicPermissions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.read < rhs.read)
    return true;
  if (rhs.read < lhs.read)
    return false;
  if (lhs.write < rhs.write)
    return true;
  if (rhs.write < lhs.write)
    return false;
  if (lhs.read_encrypted < rhs.read_encrypted)
    return true;
  if (rhs.read_encrypted < lhs.read_encrypted)
    return false;
  if (lhs.write_encrypted < rhs.write_encrypted)
    return true;
  if (rhs.write_encrypted < lhs.write_encrypted)
    return false;
  if (lhs.read_encrypted_authenticated < rhs.read_encrypted_authenticated)
    return true;
  if (rhs.read_encrypted_authenticated < lhs.read_encrypted_authenticated)
    return false;
  if (lhs.write_encrypted_authenticated < rhs.write_encrypted_authenticated)
    return true;
  if (rhs.write_encrypted_authenticated < lhs.write_encrypted_authenticated)
    return false;
  return false;
}


}  // bluetooth::mojom

namespace mojo {


template <>
struct  StructTraits<::bluetooth::mojom::GattCharacteristicPermissions::DataView,
                                         ::bluetooth::mojom::GattCharacteristicPermissionsPtr> {
  static bool IsNull(const ::bluetooth::mojom::GattCharacteristicPermissionsPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::GattCharacteristicPermissionsPtr* output) { output->reset(); }

  static decltype(::bluetooth::mojom::GattCharacteristicPermissions::read) read(
      const ::bluetooth::mojom::GattCharacteristicPermissionsPtr& input) {
    return input->read;
  }

  static decltype(::bluetooth::mojom::GattCharacteristicPermissions::write) write(
      const ::bluetooth::mojom::GattCharacteristicPermissionsPtr& input) {
    return input->write;
  }

  static decltype(::bluetooth::mojom::GattCharacteristicPermissions::read_encrypted) read_encrypted(
      const ::bluetooth::mojom::GattCharacteristicPermissionsPtr& input) {
    return input->read_encrypted;
  }

  static decltype(::bluetooth::mojom::GattCharacteristicPermissions::write_encrypted) write_encrypted(
      const ::bluetooth::mojom::GattCharacteristicPermissionsPtr& input) {
    return input->write_encrypted;
  }

  static decltype(::bluetooth::mojom::GattCharacteristicPermissions::read_encrypted_authenticated) read_encrypted_authenticated(
      const ::bluetooth::mojom::GattCharacteristicPermissionsPtr& input) {
    return input->read_encrypted_authenticated;
  }

  static decltype(::bluetooth::mojom::GattCharacteristicPermissions::write_encrypted_authenticated) write_encrypted_authenticated(
      const ::bluetooth::mojom::GattCharacteristicPermissionsPtr& input) {
    return input->write_encrypted_authenticated;
  }

  static bool Read(::bluetooth::mojom::GattCharacteristicPermissions::DataView input, ::bluetooth::mojom::GattCharacteristicPermissionsPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_GATT_CHARACTERISTIC_PERMISSIONS_MOJOM_H_