// device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_SHARED_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-data-view.h"




namespace std {

template <>
struct hash<::bluetooth::mojom::CentralState>
    : public mojo::internal::EnumHashImpl<::bluetooth::mojom::CentralState> {};

template <>
struct hash<::bluetooth::mojom::WriteType>
    : public mojo::internal::EnumHashImpl<::bluetooth::mojom::WriteType> {};

template <>
struct hash<::bluetooth::mojom::GATTOperationType>
    : public mojo::internal::EnumHashImpl<::bluetooth::mojom::GATTOperationType> {};

template <>
struct hash<::bluetooth::mojom::CharacteristicOperationType>
    : public mojo::internal::EnumHashImpl<::bluetooth::mojom::CharacteristicOperationType> {};

template <>
struct hash<::bluetooth::mojom::DescriptorOperationType>
    : public mojo::internal::EnumHashImpl<::bluetooth::mojom::DescriptorOperationType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::CentralState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::bluetooth::mojom::CentralState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::bluetooth::mojom::CentralState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::WriteType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::bluetooth::mojom::WriteType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::bluetooth::mojom::WriteType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::GATTOperationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::bluetooth::mojom::GATTOperationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::bluetooth::mojom::GATTOperationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::CharacteristicOperationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::bluetooth::mojom::CharacteristicOperationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::bluetooth::mojom::CharacteristicOperationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::DescriptorOperationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::bluetooth::mojom::DescriptorOperationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::bluetooth::mojom::DescriptorOperationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::AppearanceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::AppearanceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::Appearance_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->has_value = Traits::has_value(input);

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::bluetooth::mojom::internal::Appearance_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::AppearanceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::PowerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::PowerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::Power_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->has_value = Traits::has_value(input);

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::bluetooth::mojom::internal::Power_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::PowerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::ServiceDataMapDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::ServiceDataMapDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::ServiceDataMap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::service_data(input)) in_service_data = Traits::service_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_data)::BaseType>
        service_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& service_data_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>>(
      in_service_data,
      service_data_fragment,
      &service_data_validate_params);

    fragment->service_data.Set(
        service_data_fragment.is_null() ? nullptr : service_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->service_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null service_data in ServiceDataMap struct");
  }

  static bool Deserialize(::bluetooth::mojom::internal::ServiceDataMap_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::ServiceDataMapDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::ScanRecordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::ScanRecordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::ScanRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    decltype(Traits::uuids(input)) in_uuids = Traits::uuids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuids)::BaseType>
        uuids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& uuids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
      in_uuids,
      uuids_fragment,
      &uuids_validate_params);

    fragment->uuids.Set(
        uuids_fragment.is_null() ? nullptr : uuids_fragment.data());

    decltype(Traits::appearance(input)) in_appearance = Traits::appearance(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->appearance)::BaseType> appearance_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::AppearanceDataView>(
      in_appearance,
      appearance_fragment);

    fragment->appearance.Set(
        appearance_fragment.is_null() ? nullptr : appearance_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->appearance.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null appearance in ScanRecord struct");

    decltype(Traits::tx_power(input)) in_tx_power = Traits::tx_power(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tx_power)::BaseType> tx_power_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::PowerDataView>(
      in_tx_power,
      tx_power_fragment);

    fragment->tx_power.Set(
        tx_power_fragment.is_null() ? nullptr : tx_power_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tx_power.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tx_power in ScanRecord struct");

    decltype(Traits::manufacturer_data(input)) in_manufacturer_data = Traits::manufacturer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manufacturer_data)::BaseType>
        manufacturer_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>>(
      in_manufacturer_data,
      manufacturer_data_fragment,
      &manufacturer_data_validate_params);

    fragment->manufacturer_data.Set(
        manufacturer_data_fragment.is_null() ? nullptr : manufacturer_data_fragment.data());

    decltype(Traits::service_data(input)) in_service_data = Traits::service_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_data)::BaseType> service_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::ServiceDataMapDataView>(
      in_service_data,
      service_data_fragment);

    fragment->service_data.Set(
        service_data_fragment.is_null() ? nullptr : service_data_fragment.data());
  }

  static bool Deserialize(::bluetooth::mojom::internal::ScanRecord_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::ScanRecordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::ScanResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::ScanResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::ScanResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::device_address(input)) in_device_address = Traits::device_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_address)::BaseType> device_address_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_address,
      device_address_fragment);

    fragment->device_address.Set(
        device_address_fragment.is_null() ? nullptr : device_address_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_address.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_address in ScanResult struct");

    fragment->rssi = Traits::rssi(input);

    decltype(Traits::scan_record(input)) in_scan_record = Traits::scan_record(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scan_record)::BaseType> scan_record_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::ScanRecordDataView>(
      in_scan_record,
      scan_record_fragment);

    fragment->scan_record.Set(
        scan_record_fragment.is_null() ? nullptr : scan_record_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scan_record.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scan_record in ScanResult struct");
  }

  static bool Deserialize(::bluetooth::mojom::internal::ScanResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::ScanResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::CharacteristicPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::CharacteristicPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::CharacteristicProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->broadcast = Traits::broadcast(input);

    fragment->read = Traits::read(input);

    fragment->write_without_response = Traits::write_without_response(input);

    fragment->write = Traits::write(input);

    fragment->notify = Traits::notify(input);

    fragment->indicate = Traits::indicate(input);

    fragment->authenticated_signed_writes = Traits::authenticated_signed_writes(input);

    fragment->extended_properties = Traits::extended_properties(input);
  }

  static bool Deserialize(::bluetooth::mojom::internal::CharacteristicProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::CharacteristicPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace bluetooth::mojom {





inline void ServiceDataMapDataView::GetServiceDataDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->service_data.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>(pointer, message_);
}


inline void ScanRecordDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ScanRecordDataView::GetUuidsDataView(
    mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output) {
  auto pointer = data_->uuids.Get();
  *output = mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>(pointer, message_);
}
inline void ScanRecordDataView::GetAppearanceDataView(
    AppearanceDataView* output) {
  auto pointer = data_->appearance.Get();
  *output = AppearanceDataView(pointer, message_);
}
inline void ScanRecordDataView::GetTxPowerDataView(
    PowerDataView* output) {
  auto pointer = data_->tx_power.Get();
  *output = PowerDataView(pointer, message_);
}
inline void ScanRecordDataView::GetManufacturerDataDataView(
    mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->manufacturer_data.Get();
  *output = mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void ScanRecordDataView::GetServiceDataDataView(
    ServiceDataMapDataView* output) {
  auto pointer = data_->service_data.Get();
  *output = ServiceDataMapDataView(pointer, message_);
}


inline void ScanResultDataView::GetDeviceAddressDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_address.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ScanResultDataView::GetScanRecordDataView(
    ScanRecordDataView* output) {
  auto pointer = data_->scan_record.Get();
  *output = ScanRecordDataView(pointer, message_);
}





}  // bluetooth::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::bluetooth::mojom::CentralState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::bluetooth::mojom::CentralState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::bluetooth::mojom::WriteType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::bluetooth::mojom::WriteType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::bluetooth::mojom::GATTOperationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::bluetooth::mojom::GATTOperationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::bluetooth::mojom::CharacteristicOperationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::bluetooth::mojom::CharacteristicOperationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::bluetooth::mojom::DescriptorOperationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::bluetooth::mojom::DescriptorOperationType value);
};

} // namespace perfetto

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_SHARED_H_