// device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_DATA_VIEW_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"


namespace bluetooth::mojom {
class AppearanceDataView;

class PowerDataView;

class ServiceDataMapDataView;

class ScanRecordDataView;

class ScanResultDataView;

class CharacteristicPropertiesDataView;



}  // bluetooth::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::bluetooth::mojom::AppearanceDataView> {
  using Data = ::bluetooth::mojom::internal::Appearance_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::PowerDataView> {
  using Data = ::bluetooth::mojom::internal::Power_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::ServiceDataMapDataView> {
  using Data = ::bluetooth::mojom::internal::ServiceDataMap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::ScanRecordDataView> {
  using Data = ::bluetooth::mojom::internal::ScanRecord_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::ScanResultDataView> {
  using Data = ::bluetooth::mojom::internal::ScanResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::CharacteristicPropertiesDataView> {
  using Data = ::bluetooth::mojom::internal::CharacteristicProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace bluetooth::mojom {


enum class CentralState : int32_t {
  
  ABSENT = 0,
  
  POWERED_ON = 1,
  
  POWERED_OFF = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CentralState value);
inline bool IsKnownEnumValue(CentralState value) {
  return internal::CentralState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WriteType : int32_t {
  
  kNone = 0,
  
  kWriteDefaultDeprecated = 1,
  
  kWriteWithResponse = 2,
  
  kWriteWithoutResponse = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, WriteType value);
inline bool IsKnownEnumValue(WriteType value) {
  return internal::WriteType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GATTOperationType : int32_t {
  
  kConnect = 0,
  
  kDiscovery = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, GATTOperationType value);
inline bool IsKnownEnumValue(GATTOperationType value) {
  return internal::GATTOperationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CharacteristicOperationType : int32_t {
  
  kRead = 0,
  
  kWrite = 1,
  
  kSubscribeToNotifications = 2,
  
  kUnsubscribeFromNotifications = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, CharacteristicOperationType value);
inline bool IsKnownEnumValue(CharacteristicOperationType value) {
  return internal::CharacteristicOperationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DescriptorOperationType : int32_t {
  
  kRead = 0,
  
  kWrite = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, DescriptorOperationType value);
inline bool IsKnownEnumValue(DescriptorOperationType value) {
  return internal::DescriptorOperationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FakeBluetoothInterfaceBase {};

using FakeBluetoothPtrDataView =
    mojo::InterfacePtrDataView<FakeBluetoothInterfaceBase>;
using FakeBluetoothRequestDataView =
    mojo::InterfaceRequestDataView<FakeBluetoothInterfaceBase>;
using FakeBluetoothAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FakeBluetoothInterfaceBase>;
using FakeBluetoothAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FakeBluetoothInterfaceBase>;
class FakeCentralInterfaceBase {};

using FakeCentralPtrDataView =
    mojo::InterfacePtrDataView<FakeCentralInterfaceBase>;
using FakeCentralRequestDataView =
    mojo::InterfaceRequestDataView<FakeCentralInterfaceBase>;
using FakeCentralAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FakeCentralInterfaceBase>;
using FakeCentralAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FakeCentralInterfaceBase>;
class FakeCentralClientInterfaceBase {};

using FakeCentralClientPtrDataView =
    mojo::InterfacePtrDataView<FakeCentralClientInterfaceBase>;
using FakeCentralClientRequestDataView =
    mojo::InterfaceRequestDataView<FakeCentralClientInterfaceBase>;
using FakeCentralClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FakeCentralClientInterfaceBase>;
using FakeCentralClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FakeCentralClientInterfaceBase>;


class AppearanceDataView {
 public:
  AppearanceDataView() = default;

  AppearanceDataView(
      internal::Appearance_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_value() const {
    return data_->has_value;
  }
  int8_t value() const {
    return data_->value;
  }
 private:
  internal::Appearance_Data* data_ = nullptr;
};


class PowerDataView {
 public:
  PowerDataView() = default;

  PowerDataView(
      internal::Power_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_value() const {
    return data_->has_value;
  }
  int8_t value() const {
    return data_->value;
  }
 private:
  internal::Power_Data* data_ = nullptr;
};


class ServiceDataMapDataView {
 public:
  ServiceDataMapDataView() = default;

  ServiceDataMapDataView(
      internal::ServiceDataMap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServiceDataDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceData(UserType* output) {
    
    auto* pointer = data_->service_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::ServiceDataMap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScanRecordDataView {
 public:
  ScanRecordDataView() = default;

  ScanRecordDataView(
      internal::ScanRecord_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidsDataView(
      mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuids(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>, UserType>(),
    "Attempting to read the optional `uuids` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUuids` instead "
    "of `ReadUuids if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->uuids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        pointer, output, message_);
  }
  inline void GetAppearanceDataView(
      AppearanceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppearance(UserType* output) {
    
    auto* pointer = data_->appearance.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::AppearanceDataView>(
        pointer, output, message_);
  }
  inline void GetTxPowerDataView(
      PowerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTxPower(UserType* output) {
    
    auto* pointer = data_->tx_power.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::PowerDataView>(
        pointer, output, message_);
  }
  inline void GetManufacturerDataDataView(
      mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManufacturerData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>, UserType>(),
    "Attempting to read the optional `manufacturer_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadManufacturerData` instead "
    "of `ReadManufacturerData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->manufacturer_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetServiceDataDataView(
      ServiceDataMapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::bluetooth::mojom::ServiceDataMapDataView, UserType>(),
    "Attempting to read the optional `service_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceData` instead "
    "of `ReadServiceData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_data.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::ServiceDataMapDataView>(
        pointer, output, message_);
  }
 private:
  internal::ScanRecord_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScanResultDataView {
 public:
  ScanResultDataView() = default;

  ScanResultDataView(
      internal::ScanResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceAddressDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceAddress(UserType* output) {
    
    auto* pointer = data_->device_address.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int8_t rssi() const {
    return data_->rssi;
  }
  inline void GetScanRecordDataView(
      ScanRecordDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScanRecord(UserType* output) {
    
    auto* pointer = data_->scan_record.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::ScanRecordDataView>(
        pointer, output, message_);
  }
 private:
  internal::ScanResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CharacteristicPropertiesDataView {
 public:
  CharacteristicPropertiesDataView() = default;

  CharacteristicPropertiesDataView(
      internal::CharacteristicProperties_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool broadcast() const {
    return data_->broadcast;
  }
  bool read() const {
    return data_->read;
  }
  bool write_without_response() const {
    return data_->write_without_response;
  }
  bool write() const {
    return data_->write;
  }
  bool notify() const {
    return data_->notify;
  }
  bool indicate() const {
    return data_->indicate;
  }
  bool authenticated_signed_writes() const {
    return data_->authenticated_signed_writes;
  }
  bool extended_properties() const {
    return data_->extended_properties;
  }
 private:
  internal::CharacteristicProperties_Data* data_ = nullptr;
};


}  // bluetooth::mojom

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_DATA_VIEW_H_