// device/bluetooth/public/mojom/device.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/bluetooth/public/mojom/device.mojom-features.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/device.mojom-shared.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/device.mojom-forward.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/uuid.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace bluetooth::mojom {

class DeviceProxy;

template <typename ImplRefTraits>
class DeviceStub;

class DeviceRequestValidator;
class DeviceResponseValidator;


class Device
    : public DeviceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.Device";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceInterfaceBase;
  using Proxy_ = DeviceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceStub<ImplRefTraits>;

  using RequestValidator_ = DeviceRequestValidator;
  using ResponseValidator_ = DeviceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDisconnectMinVersion = 0,
    kGetInfoMinVersion = 0,
    kGetServicesMinVersion = 0,
    kGetCharacteristicsMinVersion = 0,
    kReadValueForCharacteristicMinVersion = 0,
    kWriteValueForCharacteristicMinVersion = 0,
    kGetDescriptorsMinVersion = 0,
    kReadValueForDescriptorMinVersion = 0,
    kWriteValueForDescriptorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Disconnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetServices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCharacteristics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadValueForCharacteristic_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteValueForCharacteristic_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDescriptors_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadValueForDescriptor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteValueForDescriptor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Device() = default;

  virtual void Disconnect() = 0;

  using GetInfoCallback = base::OnceCallback<void(DeviceInfoPtr)>;
  using GetInfoMojoCallback = base::OnceCallback<void(DeviceInfoPtr)>;

  virtual void GetInfo(GetInfoCallback callback) = 0;

  using GetServicesCallback = base::OnceCallback<void(std::vector<ServiceInfoPtr>)>;
  using GetServicesMojoCallback = base::OnceCallback<void(std::vector<ServiceInfoPtr>)>;

  virtual void GetServices(GetServicesCallback callback) = 0;

  using GetCharacteristicsCallback = base::OnceCallback<void(std::optional<std::vector<CharacteristicInfoPtr>>)>;
  using GetCharacteristicsMojoCallback = base::OnceCallback<void(std::optional<std::vector<CharacteristicInfoPtr>>)>;

  virtual void GetCharacteristics(const std::string& service_id, GetCharacteristicsCallback callback) = 0;

  using ReadValueForCharacteristicCallback = base::OnceCallback<void(GattResult, const std::optional<std::vector<uint8_t>>&)>;
  using ReadValueForCharacteristicMojoCallback = base::OnceCallback<void(GattResult, const std::optional<std::vector<uint8_t>>&)>;

  virtual void ReadValueForCharacteristic(const std::string& service_id, const std::string& characteristic_id, ReadValueForCharacteristicCallback callback) = 0;

  using WriteValueForCharacteristicCallback = base::OnceCallback<void(GattResult)>;
  using WriteValueForCharacteristicMojoCallback = base::OnceCallback<void(GattResult)>;

  virtual void WriteValueForCharacteristic(const std::string& service_id, const std::string& characteristic_id, const std::vector<uint8_t>& value, WriteValueForCharacteristicCallback callback) = 0;

  using GetDescriptorsCallback = base::OnceCallback<void(std::optional<std::vector<DescriptorInfoPtr>>)>;
  using GetDescriptorsMojoCallback = base::OnceCallback<void(std::optional<std::vector<DescriptorInfoPtr>>)>;

  virtual void GetDescriptors(const std::string& service_id, const std::string& characteristic_id, GetDescriptorsCallback callback) = 0;

  using ReadValueForDescriptorCallback = base::OnceCallback<void(GattResult, const std::optional<std::vector<uint8_t>>&)>;
  using ReadValueForDescriptorMojoCallback = base::OnceCallback<void(GattResult, const std::optional<std::vector<uint8_t>>&)>;

  virtual void ReadValueForDescriptor(const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, ReadValueForDescriptorCallback callback) = 0;

  using WriteValueForDescriptorCallback = base::OnceCallback<void(GattResult)>;
  using WriteValueForDescriptorMojoCallback = base::OnceCallback<void(GattResult)>;

  virtual void WriteValueForDescriptor(const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, const std::vector<uint8_t>& value, WriteValueForDescriptorCallback callback) = 0;
};



class  DeviceProxy
    : public Device {
 public:
  using InterfaceType = Device;

  explicit DeviceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Disconnect() final;
  
  void GetInfo(GetInfoCallback callback) final;
  
  void GetServices(GetServicesCallback callback) final;
  
  void GetCharacteristics(const std::string& service_id, GetCharacteristicsCallback callback) final;
  
  void ReadValueForCharacteristic(const std::string& service_id, const std::string& characteristic_id, ReadValueForCharacteristicCallback callback) final;
  
  void WriteValueForCharacteristic(const std::string& service_id, const std::string& characteristic_id, const std::vector<uint8_t>& value, WriteValueForCharacteristicCallback callback) final;
  
  void GetDescriptors(const std::string& service_id, const std::string& characteristic_id, GetDescriptorsCallback callback) final;
  
  void ReadValueForDescriptor(const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, ReadValueForDescriptorCallback callback) final;
  
  void WriteValueForDescriptor(const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, const std::vector<uint8_t>& value, WriteValueForDescriptorCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DeviceStubDispatch {
 public:
  static bool Accept(Device* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Device* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Device>>
class DeviceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceStub() = default;
  ~DeviceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeviceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DeviceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  RSSIWrapper {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RSSIWrapper, T>::value>;
  using DataView = RSSIWrapperDataView;
  using Data_ = internal::RSSIWrapper_Data;

  template <typename... Args>
  static RSSIWrapperPtr New(Args&&... args) {
    return RSSIWrapperPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RSSIWrapperPtr From(const U& u) {
    return mojo::TypeConverter<RSSIWrapperPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RSSIWrapper>::Convert(*this);
  }


  RSSIWrapper();

  explicit RSSIWrapper(
      int8_t value);


  ~RSSIWrapper();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RSSIWrapperPtr>
  RSSIWrapperPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RSSIWrapper::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RSSIWrapper::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RSSIWrapper::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RSSIWrapper::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RSSIWrapper::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RSSIWrapper::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RSSIWrapper_UnserializedMessageContext<
            UserType, RSSIWrapper::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RSSIWrapper::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RSSIWrapper::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RSSIWrapper_UnserializedMessageContext<
            UserType, RSSIWrapper::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RSSIWrapper::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int8_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RSSIWrapper::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RSSIWrapper::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RSSIWrapper::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RSSIWrapper::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class  DeviceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceInfo, T>::value>;
  using DataView = DeviceInfoDataView;
  using Data_ = internal::DeviceInfo_Data;

  template <typename... Args>
  static DeviceInfoPtr New(Args&&... args) {
    return DeviceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceInfoPtr From(const U& u) {
    return mojo::TypeConverter<DeviceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceInfo>::Convert(*this);
  }


  DeviceInfo();

  DeviceInfo(
      const std::optional<std::string>& name,
      const std::string& name_for_display,
      const std::string& address,
      bool is_gatt_connected,
      RSSIWrapperPtr rssi,
      std::vector<::device::BluetoothUUID> service_uuids,
      const base::flat_map<uint16_t, std::vector<uint8_t>>& manufacturer_data_map,
      const base::flat_map<::device::BluetoothUUID, std::vector<uint8_t>>& service_data_map);

DeviceInfo(const DeviceInfo&) = delete;
DeviceInfo& operator=(const DeviceInfo&) = delete;

  ~DeviceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceInfoPtr>
  DeviceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceInfo_UnserializedMessageContext<
            UserType, DeviceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceInfo_UnserializedMessageContext<
            UserType, DeviceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> name;
  
  std::string name_for_display;
  
  std::string address;
  
  bool is_gatt_connected;
  
  RSSIWrapperPtr rssi;
  
  std::vector<::device::BluetoothUUID> service_uuids;
  
  base::flat_map<uint16_t, std::vector<uint8_t>> manufacturer_data_map;
  
  base::flat_map<::device::BluetoothUUID, std::vector<uint8_t>> service_data_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ServiceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceInfo, T>::value>;
  using DataView = ServiceInfoDataView;
  using Data_ = internal::ServiceInfo_Data;

  template <typename... Args>
  static ServiceInfoPtr New(Args&&... args) {
    return ServiceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceInfoPtr From(const U& u) {
    return mojo::TypeConverter<ServiceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceInfo>::Convert(*this);
  }


  ServiceInfo();

  ServiceInfo(
      const std::string& id,
      const ::device::BluetoothUUID& uuid,
      bool is_primary);


  ~ServiceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceInfoPtr>
  ServiceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceInfo_UnserializedMessageContext<
            UserType, ServiceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceInfo_UnserializedMessageContext<
            UserType, ServiceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  ::device::BluetoothUUID uuid;
  
  bool is_primary;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CharacteristicInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CharacteristicInfo, T>::value>;
  using DataView = CharacteristicInfoDataView;
  using Data_ = internal::CharacteristicInfo_Data;

  template <typename... Args>
  static CharacteristicInfoPtr New(Args&&... args) {
    return CharacteristicInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CharacteristicInfoPtr From(const U& u) {
    return mojo::TypeConverter<CharacteristicInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CharacteristicInfo>::Convert(*this);
  }


  CharacteristicInfo();

  CharacteristicInfo(
      const std::string& id,
      const ::device::BluetoothUUID& uuid,
      uint32_t properties,
      uint32_t permissions,
      std::vector<uint8_t> last_known_value);


  ~CharacteristicInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CharacteristicInfoPtr>
  CharacteristicInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CharacteristicInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CharacteristicInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CharacteristicInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CharacteristicInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CharacteristicInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CharacteristicInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CharacteristicInfo_UnserializedMessageContext<
            UserType, CharacteristicInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CharacteristicInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CharacteristicInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CharacteristicInfo_UnserializedMessageContext<
            UserType, CharacteristicInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CharacteristicInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  ::device::BluetoothUUID uuid;
  
  uint32_t properties;
  
  uint32_t permissions;
  
  std::vector<uint8_t> last_known_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CharacteristicInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CharacteristicInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CharacteristicInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CharacteristicInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DescriptorInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DescriptorInfo, T>::value>;
  using DataView = DescriptorInfoDataView;
  using Data_ = internal::DescriptorInfo_Data;

  template <typename... Args>
  static DescriptorInfoPtr New(Args&&... args) {
    return DescriptorInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DescriptorInfoPtr From(const U& u) {
    return mojo::TypeConverter<DescriptorInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DescriptorInfo>::Convert(*this);
  }


  DescriptorInfo();

  DescriptorInfo(
      const std::string& id,
      const ::device::BluetoothUUID& uuid,
      std::vector<uint8_t> last_known_value);


  ~DescriptorInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DescriptorInfoPtr>
  DescriptorInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DescriptorInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DescriptorInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DescriptorInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DescriptorInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DescriptorInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DescriptorInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DescriptorInfo_UnserializedMessageContext<
            UserType, DescriptorInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DescriptorInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DescriptorInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DescriptorInfo_UnserializedMessageContext<
            UserType, DescriptorInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DescriptorInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  ::device::BluetoothUUID uuid;
  
  std::vector<uint8_t> last_known_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DescriptorInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DescriptorInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DescriptorInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DescriptorInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RSSIWrapperPtr RSSIWrapper::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, RSSIWrapper::EnableIfSame<T>*>
bool RSSIWrapper::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, RSSIWrapper::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceInfoPtr DeviceInfo::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(name_for_display),
      mojo::Clone(address),
      mojo::Clone(is_gatt_connected),
      mojo::Clone(rssi),
      mojo::Clone(service_uuids),
      mojo::Clone(manufacturer_data_map),
      mojo::Clone(service_data_map)
  );
}

template <typename T, DeviceInfo::EnableIfSame<T>*>
bool DeviceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->name_for_display, other_struct.name_for_display))
    return false;
  if (!mojo::Equals(this->address, other_struct.address))
    return false;
  if (!mojo::Equals(this->is_gatt_connected, other_struct.is_gatt_connected))
    return false;
  if (!mojo::Equals(this->rssi, other_struct.rssi))
    return false;
  if (!mojo::Equals(this->service_uuids, other_struct.service_uuids))
    return false;
  if (!mojo::Equals(this->manufacturer_data_map, other_struct.manufacturer_data_map))
    return false;
  if (!mojo::Equals(this->service_data_map, other_struct.service_data_map))
    return false;
  return true;
}

template <typename T, DeviceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.name_for_display < rhs.name_for_display)
    return true;
  if (rhs.name_for_display < lhs.name_for_display)
    return false;
  if (lhs.address < rhs.address)
    return true;
  if (rhs.address < lhs.address)
    return false;
  if (lhs.is_gatt_connected < rhs.is_gatt_connected)
    return true;
  if (rhs.is_gatt_connected < lhs.is_gatt_connected)
    return false;
  if (lhs.rssi < rhs.rssi)
    return true;
  if (rhs.rssi < lhs.rssi)
    return false;
  if (lhs.service_uuids < rhs.service_uuids)
    return true;
  if (rhs.service_uuids < lhs.service_uuids)
    return false;
  if (lhs.manufacturer_data_map < rhs.manufacturer_data_map)
    return true;
  if (rhs.manufacturer_data_map < lhs.manufacturer_data_map)
    return false;
  if (lhs.service_data_map < rhs.service_data_map)
    return true;
  if (rhs.service_data_map < lhs.service_data_map)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceInfoPtr ServiceInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(uuid),
      mojo::Clone(is_primary)
  );
}

template <typename T, ServiceInfo::EnableIfSame<T>*>
bool ServiceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->is_primary, other_struct.is_primary))
    return false;
  return true;
}

template <typename T, ServiceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.is_primary < rhs.is_primary)
    return true;
  if (rhs.is_primary < lhs.is_primary)
    return false;
  return false;
}
template <typename StructPtrType>
CharacteristicInfoPtr CharacteristicInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(uuid),
      mojo::Clone(properties),
      mojo::Clone(permissions),
      mojo::Clone(last_known_value)
  );
}

template <typename T, CharacteristicInfo::EnableIfSame<T>*>
bool CharacteristicInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->properties, other_struct.properties))
    return false;
  if (!mojo::Equals(this->permissions, other_struct.permissions))
    return false;
  if (!mojo::Equals(this->last_known_value, other_struct.last_known_value))
    return false;
  return true;
}

template <typename T, CharacteristicInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.properties < rhs.properties)
    return true;
  if (rhs.properties < lhs.properties)
    return false;
  if (lhs.permissions < rhs.permissions)
    return true;
  if (rhs.permissions < lhs.permissions)
    return false;
  if (lhs.last_known_value < rhs.last_known_value)
    return true;
  if (rhs.last_known_value < lhs.last_known_value)
    return false;
  return false;
}
template <typename StructPtrType>
DescriptorInfoPtr DescriptorInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(uuid),
      mojo::Clone(last_known_value)
  );
}

template <typename T, DescriptorInfo::EnableIfSame<T>*>
bool DescriptorInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->last_known_value, other_struct.last_known_value))
    return false;
  return true;
}

template <typename T, DescriptorInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.last_known_value < rhs.last_known_value)
    return true;
  if (rhs.last_known_value < lhs.last_known_value)
    return false;
  return false;
}


}  // bluetooth::mojom

namespace mojo {


template <>
struct  StructTraits<::bluetooth::mojom::RSSIWrapper::DataView,
                                         ::bluetooth::mojom::RSSIWrapperPtr> {
  static bool IsNull(const ::bluetooth::mojom::RSSIWrapperPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::RSSIWrapperPtr* output) { output->reset(); }

  static decltype(::bluetooth::mojom::RSSIWrapper::value) value(
      const ::bluetooth::mojom::RSSIWrapperPtr& input) {
    return input->value;
  }

  static bool Read(::bluetooth::mojom::RSSIWrapper::DataView input, ::bluetooth::mojom::RSSIWrapperPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::DeviceInfo::DataView,
                                         ::bluetooth::mojom::DeviceInfoPtr> {
  static bool IsNull(const ::bluetooth::mojom::DeviceInfoPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::DeviceInfoPtr* output) { output->reset(); }

  static const decltype(::bluetooth::mojom::DeviceInfo::name)& name(
      const ::bluetooth::mojom::DeviceInfoPtr& input) {
    return input->name;
  }

  static const decltype(::bluetooth::mojom::DeviceInfo::name_for_display)& name_for_display(
      const ::bluetooth::mojom::DeviceInfoPtr& input) {
    return input->name_for_display;
  }

  static const decltype(::bluetooth::mojom::DeviceInfo::address)& address(
      const ::bluetooth::mojom::DeviceInfoPtr& input) {
    return input->address;
  }

  static decltype(::bluetooth::mojom::DeviceInfo::is_gatt_connected) is_gatt_connected(
      const ::bluetooth::mojom::DeviceInfoPtr& input) {
    return input->is_gatt_connected;
  }

  static const decltype(::bluetooth::mojom::DeviceInfo::rssi)& rssi(
      const ::bluetooth::mojom::DeviceInfoPtr& input) {
    return input->rssi;
  }

  static const decltype(::bluetooth::mojom::DeviceInfo::service_uuids)& service_uuids(
      const ::bluetooth::mojom::DeviceInfoPtr& input) {
    return input->service_uuids;
  }

  static const decltype(::bluetooth::mojom::DeviceInfo::manufacturer_data_map)& manufacturer_data_map(
      const ::bluetooth::mojom::DeviceInfoPtr& input) {
    return input->manufacturer_data_map;
  }

  static const decltype(::bluetooth::mojom::DeviceInfo::service_data_map)& service_data_map(
      const ::bluetooth::mojom::DeviceInfoPtr& input) {
    return input->service_data_map;
  }

  static bool Read(::bluetooth::mojom::DeviceInfo::DataView input, ::bluetooth::mojom::DeviceInfoPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::ServiceInfo::DataView,
                                         ::bluetooth::mojom::ServiceInfoPtr> {
  static bool IsNull(const ::bluetooth::mojom::ServiceInfoPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::ServiceInfoPtr* output) { output->reset(); }

  static const decltype(::bluetooth::mojom::ServiceInfo::id)& id(
      const ::bluetooth::mojom::ServiceInfoPtr& input) {
    return input->id;
  }

  static const decltype(::bluetooth::mojom::ServiceInfo::uuid)& uuid(
      const ::bluetooth::mojom::ServiceInfoPtr& input) {
    return input->uuid;
  }

  static decltype(::bluetooth::mojom::ServiceInfo::is_primary) is_primary(
      const ::bluetooth::mojom::ServiceInfoPtr& input) {
    return input->is_primary;
  }

  static bool Read(::bluetooth::mojom::ServiceInfo::DataView input, ::bluetooth::mojom::ServiceInfoPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::CharacteristicInfo::DataView,
                                         ::bluetooth::mojom::CharacteristicInfoPtr> {
  static bool IsNull(const ::bluetooth::mojom::CharacteristicInfoPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::CharacteristicInfoPtr* output) { output->reset(); }

  static const decltype(::bluetooth::mojom::CharacteristicInfo::id)& id(
      const ::bluetooth::mojom::CharacteristicInfoPtr& input) {
    return input->id;
  }

  static const decltype(::bluetooth::mojom::CharacteristicInfo::uuid)& uuid(
      const ::bluetooth::mojom::CharacteristicInfoPtr& input) {
    return input->uuid;
  }

  static decltype(::bluetooth::mojom::CharacteristicInfo::properties) properties(
      const ::bluetooth::mojom::CharacteristicInfoPtr& input) {
    return input->properties;
  }

  static decltype(::bluetooth::mojom::CharacteristicInfo::permissions) permissions(
      const ::bluetooth::mojom::CharacteristicInfoPtr& input) {
    return input->permissions;
  }

  static const decltype(::bluetooth::mojom::CharacteristicInfo::last_known_value)& last_known_value(
      const ::bluetooth::mojom::CharacteristicInfoPtr& input) {
    return input->last_known_value;
  }

  static bool Read(::bluetooth::mojom::CharacteristicInfo::DataView input, ::bluetooth::mojom::CharacteristicInfoPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::DescriptorInfo::DataView,
                                         ::bluetooth::mojom::DescriptorInfoPtr> {
  static bool IsNull(const ::bluetooth::mojom::DescriptorInfoPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::DescriptorInfoPtr* output) { output->reset(); }

  static const decltype(::bluetooth::mojom::DescriptorInfo::id)& id(
      const ::bluetooth::mojom::DescriptorInfoPtr& input) {
    return input->id;
  }

  static const decltype(::bluetooth::mojom::DescriptorInfo::uuid)& uuid(
      const ::bluetooth::mojom::DescriptorInfoPtr& input) {
    return input->uuid;
  }

  static const decltype(::bluetooth::mojom::DescriptorInfo::last_known_value)& last_known_value(
      const ::bluetooth::mojom::DescriptorInfoPtr& input) {
    return input->last_known_value;
  }

  static bool Read(::bluetooth::mojom::DescriptorInfo::DataView input, ::bluetooth::mojom::DescriptorInfoPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_H_