// device/bluetooth/public/mojom/device.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/bluetooth/public/mojom/device.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/bluetooth/public/mojom/device.mojom-params-data.h"
#include "device/bluetooth/public/mojom/device.mojom-shared-message-ids.h"

#include "device/bluetooth/public/mojom/device.mojom-import-headers.h"
#include "device/bluetooth/public/mojom/device.mojom-test-utils.h"


namespace bluetooth::mojom {
RSSIWrapper::RSSIWrapper()
    : value() {}

RSSIWrapper::RSSIWrapper(
    int8_t value_in)
    : value(std::move(value_in)) {}

RSSIWrapper::~RSSIWrapper() = default;
size_t RSSIWrapper::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void RSSIWrapper::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RSSIWrapper::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeviceInfo::DeviceInfo()
    : name(),
      name_for_display(),
      address(),
      is_gatt_connected(),
      rssi(),
      service_uuids(),
      manufacturer_data_map(),
      service_data_map() {}

DeviceInfo::DeviceInfo(
    const std::optional<std::string>& name_in,
    const std::string& name_for_display_in,
    const std::string& address_in,
    bool is_gatt_connected_in,
    RSSIWrapperPtr rssi_in,
    std::vector<::device::BluetoothUUID> service_uuids_in,
    const base::flat_map<uint16_t, std::vector<uint8_t>>& manufacturer_data_map_in,
    const base::flat_map<::device::BluetoothUUID, std::vector<uint8_t>>& service_data_map_in)
    : name(std::move(name_in)),
      name_for_display(std::move(name_for_display_in)),
      address(std::move(address_in)),
      is_gatt_connected(std::move(is_gatt_connected_in)),
      rssi(std::move(rssi_in)),
      service_uuids(std::move(service_uuids_in)),
      manufacturer_data_map(std::move(manufacturer_data_map_in)),
      service_data_map(std::move(service_data_map_in)) {}

DeviceInfo::~DeviceInfo() = default;

void DeviceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name_for_display"), this->name_for_display,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "address"), this->address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_gatt_connected"), this->is_gatt_connected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rssi"), this->rssi,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RSSIWrapperPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_uuids"), this->service_uuids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::device::BluetoothUUID>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manufacturer_data_map"), this->manufacturer_data_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint16_t, std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_data_map"), this->service_data_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::device::BluetoothUUID, std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceInfo::ServiceInfo()
    : id(),
      uuid(),
      is_primary() {}

ServiceInfo::ServiceInfo(
    const std::string& id_in,
    const ::device::BluetoothUUID& uuid_in,
    bool is_primary_in)
    : id(std::move(id_in)),
      uuid(std::move(uuid_in)),
      is_primary(std::move(is_primary_in)) {}

ServiceInfo::~ServiceInfo() = default;

void ServiceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::BluetoothUUID&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_primary"), this->is_primary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CharacteristicInfo::CharacteristicInfo()
    : id(),
      uuid(),
      properties(),
      permissions(),
      last_known_value() {}

CharacteristicInfo::CharacteristicInfo(
    const std::string& id_in,
    const ::device::BluetoothUUID& uuid_in,
    uint32_t properties_in,
    uint32_t permissions_in,
    std::vector<uint8_t> last_known_value_in)
    : id(std::move(id_in)),
      uuid(std::move(uuid_in)),
      properties(std::move(properties_in)),
      permissions(std::move(permissions_in)),
      last_known_value(std::move(last_known_value_in)) {}

CharacteristicInfo::~CharacteristicInfo() = default;

void CharacteristicInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::BluetoothUUID&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "properties"), this->properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permissions"), this->permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_known_value"), this->last_known_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CharacteristicInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DescriptorInfo::DescriptorInfo()
    : id(),
      uuid(),
      last_known_value() {}

DescriptorInfo::DescriptorInfo(
    const std::string& id_in,
    const ::device::BluetoothUUID& uuid_in,
    std::vector<uint8_t> last_known_value_in)
    : id(std::move(id_in)),
      uuid(std::move(uuid_in)),
      last_known_value(std::move(last_known_value_in)) {}

DescriptorInfo::~DescriptorInfo() = default;

void DescriptorInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::BluetoothUUID&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_known_value"), this->last_known_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DescriptorInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

Device::IPCStableHashFunction Device::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Device>(message.name())) {
    case messages::Device::kDisconnect: {
      return &Device::Disconnect_Sym::IPCStableHash;
    }
    case messages::Device::kGetInfo: {
      return &Device::GetInfo_Sym::IPCStableHash;
    }
    case messages::Device::kGetServices: {
      return &Device::GetServices_Sym::IPCStableHash;
    }
    case messages::Device::kGetCharacteristics: {
      return &Device::GetCharacteristics_Sym::IPCStableHash;
    }
    case messages::Device::kReadValueForCharacteristic: {
      return &Device::ReadValueForCharacteristic_Sym::IPCStableHash;
    }
    case messages::Device::kWriteValueForCharacteristic: {
      return &Device::WriteValueForCharacteristic_Sym::IPCStableHash;
    }
    case messages::Device::kGetDescriptors: {
      return &Device::GetDescriptors_Sym::IPCStableHash;
    }
    case messages::Device::kReadValueForDescriptor: {
      return &Device::ReadValueForDescriptor_Sym::IPCStableHash;
    }
    case messages::Device::kWriteValueForDescriptor: {
      return &Device::WriteValueForDescriptor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Device::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Device>(message.name())) {
      case messages::Device::kDisconnect:
            return "Receive bluetooth::mojom::Device::Disconnect";
      case messages::Device::kGetInfo:
            return "Receive bluetooth::mojom::Device::GetInfo";
      case messages::Device::kGetServices:
            return "Receive bluetooth::mojom::Device::GetServices";
      case messages::Device::kGetCharacteristics:
            return "Receive bluetooth::mojom::Device::GetCharacteristics";
      case messages::Device::kReadValueForCharacteristic:
            return "Receive bluetooth::mojom::Device::ReadValueForCharacteristic";
      case messages::Device::kWriteValueForCharacteristic:
            return "Receive bluetooth::mojom::Device::WriteValueForCharacteristic";
      case messages::Device::kGetDescriptors:
            return "Receive bluetooth::mojom::Device::GetDescriptors";
      case messages::Device::kReadValueForDescriptor:
            return "Receive bluetooth::mojom::Device::ReadValueForDescriptor";
      case messages::Device::kWriteValueForDescriptor:
            return "Receive bluetooth::mojom::Device::WriteValueForDescriptor";
    }
  } else {
    switch (static_cast<messages::Device>(message.name())) {
      case messages::Device::kDisconnect:
            return "Receive reply bluetooth::mojom::Device::Disconnect";
      case messages::Device::kGetInfo:
            return "Receive reply bluetooth::mojom::Device::GetInfo";
      case messages::Device::kGetServices:
            return "Receive reply bluetooth::mojom::Device::GetServices";
      case messages::Device::kGetCharacteristics:
            return "Receive reply bluetooth::mojom::Device::GetCharacteristics";
      case messages::Device::kReadValueForCharacteristic:
            return "Receive reply bluetooth::mojom::Device::ReadValueForCharacteristic";
      case messages::Device::kWriteValueForCharacteristic:
            return "Receive reply bluetooth::mojom::Device::WriteValueForCharacteristic";
      case messages::Device::kGetDescriptors:
            return "Receive reply bluetooth::mojom::Device::GetDescriptors";
      case messages::Device::kReadValueForDescriptor:
            return "Receive reply bluetooth::mojom::Device::ReadValueForDescriptor";
      case messages::Device::kWriteValueForDescriptor:
            return "Receive reply bluetooth::mojom::Device::WriteValueForDescriptor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Device::Disconnect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x82b521ef;  // IPCStableHash for bluetooth::mojom::Device::Disconnect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Device::GetInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9526db6;  // IPCStableHash for bluetooth::mojom::Device::GetInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Device::GetServices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11fe6826;  // IPCStableHash for bluetooth::mojom::Device::GetServices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Device::GetCharacteristics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad7e330b;  // IPCStableHash for bluetooth::mojom::Device::GetCharacteristics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Device::ReadValueForCharacteristic_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7578d789;  // IPCStableHash for bluetooth::mojom::Device::ReadValueForCharacteristic
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Device::WriteValueForCharacteristic_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd97e0bb6;  // IPCStableHash for bluetooth::mojom::Device::WriteValueForCharacteristic
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Device::GetDescriptors_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76ecd517;  // IPCStableHash for bluetooth::mojom::Device::GetDescriptors
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Device::ReadValueForDescriptor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x052839b5;  // IPCStableHash for bluetooth::mojom::Device::ReadValueForDescriptor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Device::WriteValueForDescriptor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb15222f8;  // IPCStableHash for bluetooth::mojom::Device::WriteValueForDescriptor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Device_GetInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_GetInfo_ForwardToCallback(
      Device::GetInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  Device_GetInfo_ForwardToCallback(const Device_GetInfo_ForwardToCallback&) = delete;
  Device_GetInfo_ForwardToCallback& operator=(const Device_GetInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Device::GetInfoCallback callback_;
};

class Device_GetServices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_GetServices_ForwardToCallback(
      Device::GetServicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  Device_GetServices_ForwardToCallback(const Device_GetServices_ForwardToCallback&) = delete;
  Device_GetServices_ForwardToCallback& operator=(const Device_GetServices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Device::GetServicesCallback callback_;
};

class Device_GetCharacteristics_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_GetCharacteristics_ForwardToCallback(
      Device::GetCharacteristicsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Device_GetCharacteristics_ForwardToCallback(const Device_GetCharacteristics_ForwardToCallback&) = delete;
  Device_GetCharacteristics_ForwardToCallback& operator=(const Device_GetCharacteristics_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Device::GetCharacteristicsCallback callback_;
};

class Device_ReadValueForCharacteristic_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_ReadValueForCharacteristic_ForwardToCallback(
      Device::ReadValueForCharacteristicCallback callback
      ) : callback_(std::move(callback)) {
  }

  Device_ReadValueForCharacteristic_ForwardToCallback(const Device_ReadValueForCharacteristic_ForwardToCallback&) = delete;
  Device_ReadValueForCharacteristic_ForwardToCallback& operator=(const Device_ReadValueForCharacteristic_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Device::ReadValueForCharacteristicCallback callback_;
};

class Device_WriteValueForCharacteristic_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_WriteValueForCharacteristic_ForwardToCallback(
      Device::WriteValueForCharacteristicCallback callback
      ) : callback_(std::move(callback)) {
  }

  Device_WriteValueForCharacteristic_ForwardToCallback(const Device_WriteValueForCharacteristic_ForwardToCallback&) = delete;
  Device_WriteValueForCharacteristic_ForwardToCallback& operator=(const Device_WriteValueForCharacteristic_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Device::WriteValueForCharacteristicCallback callback_;
};

class Device_GetDescriptors_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_GetDescriptors_ForwardToCallback(
      Device::GetDescriptorsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Device_GetDescriptors_ForwardToCallback(const Device_GetDescriptors_ForwardToCallback&) = delete;
  Device_GetDescriptors_ForwardToCallback& operator=(const Device_GetDescriptors_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Device::GetDescriptorsCallback callback_;
};

class Device_ReadValueForDescriptor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_ReadValueForDescriptor_ForwardToCallback(
      Device::ReadValueForDescriptorCallback callback
      ) : callback_(std::move(callback)) {
  }

  Device_ReadValueForDescriptor_ForwardToCallback(const Device_ReadValueForDescriptor_ForwardToCallback&) = delete;
  Device_ReadValueForDescriptor_ForwardToCallback& operator=(const Device_ReadValueForDescriptor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Device::ReadValueForDescriptorCallback callback_;
};

class Device_WriteValueForDescriptor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_WriteValueForDescriptor_ForwardToCallback(
      Device::WriteValueForDescriptorCallback callback
      ) : callback_(std::move(callback)) {
  }

  Device_WriteValueForDescriptor_ForwardToCallback(const Device_WriteValueForDescriptor_ForwardToCallback&) = delete;
  Device_WriteValueForDescriptor_ForwardToCallback& operator=(const Device_WriteValueForDescriptor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Device::WriteValueForDescriptorCallback callback_;
};

DeviceProxy::DeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceProxy::Disconnect(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::Device::Disconnect");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_Disconnect_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("Disconnect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceProxy::GetInfo(
    GetInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::Device::GetInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kGetInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_GetInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_GetInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceProxy::GetServices(
    GetServicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::Device::GetServices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kGetServices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_GetServices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetServices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_GetServices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceProxy::GetCharacteristics(
    const std::string& in_service_id, GetCharacteristicsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Device::GetCharacteristics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kGetCharacteristics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_GetCharacteristics_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Device.GetCharacteristics request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetCharacteristics");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_GetCharacteristics_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceProxy::ReadValueForCharacteristic(
    const std::string& in_service_id, const std::string& in_characteristic_id, ReadValueForCharacteristicCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Device::ReadValueForCharacteristic", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kReadValueForCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_ReadValueForCharacteristic_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Device.ReadValueForCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in Device.ReadValueForCharacteristic request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("ReadValueForCharacteristic");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_ReadValueForCharacteristic_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceProxy::WriteValueForCharacteristic(
    const std::string& in_service_id, const std::string& in_characteristic_id, const std::vector<uint8_t>& in_value, WriteValueForCharacteristicCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Device::WriteValueForCharacteristic", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kWriteValueForCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_WriteValueForCharacteristic_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Device.WriteValueForCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in Device.WriteValueForCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in Device.WriteValueForCharacteristic request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("WriteValueForCharacteristic");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_WriteValueForCharacteristic_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceProxy::GetDescriptors(
    const std::string& in_service_id, const std::string& in_characteristic_id, GetDescriptorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Device::GetDescriptors", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kGetDescriptors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_GetDescriptors_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Device.GetDescriptors request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in Device.GetDescriptors request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetDescriptors");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_GetDescriptors_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceProxy::ReadValueForDescriptor(
    const std::string& in_service_id, const std::string& in_characteristic_id, const std::string& in_descriptor_id, ReadValueForDescriptorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Device::ReadValueForDescriptor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_id"), in_descriptor_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kReadValueForDescriptor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_ReadValueForDescriptor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Device.ReadValueForDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in Device.ReadValueForDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_id)::BaseType> descriptor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_id,
    descriptor_id_fragment);

  params->descriptor_id.Set(
      descriptor_id_fragment.is_null() ? nullptr : descriptor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_id in Device.ReadValueForDescriptor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("ReadValueForDescriptor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_ReadValueForDescriptor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceProxy::WriteValueForDescriptor(
    const std::string& in_service_id, const std::string& in_characteristic_id, const std::string& in_descriptor_id, const std::vector<uint8_t>& in_value, WriteValueForDescriptorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::Device::WriteValueForDescriptor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_id"), in_descriptor_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kWriteValueForDescriptor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_WriteValueForDescriptor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in Device.WriteValueForDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in Device.WriteValueForDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_id)::BaseType> descriptor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_id,
    descriptor_id_fragment);

  params->descriptor_id.Set(
      descriptor_id_fragment.is_null() ? nullptr : descriptor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_id in Device.WriteValueForDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in Device.WriteValueForDescriptor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("WriteValueForDescriptor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_WriteValueForDescriptor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Device_GetInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Device::GetInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Device_GetInfo_ProxyToResponder> proxy(
        new Device_GetInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Device_GetInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_GetInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Device_GetInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Device::GetInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceInfoPtr in_info);
};

bool Device_GetInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Device_GetInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_GetInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Device.1
  bool success = true;
  DeviceInfoPtr p_info{};
  Device_GetInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void Device_GetInfo_ProxyToResponder::Run(
    DeviceInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Device::GetInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type DeviceInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kGetInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_GetInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::DeviceInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Device_GetServices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Device::GetServicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Device_GetServices_ProxyToResponder> proxy(
        new Device_GetServices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Device_GetServices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_GetServices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Device_GetServices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Device::GetServicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ServiceInfoPtr> in_services);
};

bool Device_GetServices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Device_GetServices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_GetServices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Device.2
  bool success = true;
  std::vector<ServiceInfoPtr> p_services{};
  Device_GetServices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadServices(&p_services))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_services));
  }
  return true;
}

void Device_GetServices_ProxyToResponder::Run(
    std::vector<ServiceInfoPtr> in_services) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Device::GetServices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("services"), in_services,
                        "<value of type std::vector<ServiceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kGetServices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_GetServices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->services)::BaseType>
      services_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& services_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::ServiceInfoDataView>>(
    in_services,
    services_fragment,
    &services_validate_params);

  params->services.Set(
      services_fragment.is_null() ? nullptr : services_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->services.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null services in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetServices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Device_GetCharacteristics_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Device::GetCharacteristicsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Device_GetCharacteristics_ProxyToResponder> proxy(
        new Device_GetCharacteristics_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Device_GetCharacteristics_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_GetCharacteristics_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Device_GetCharacteristics_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Device::GetCharacteristicsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<std::vector<CharacteristicInfoPtr>> in_characteristics);
};

bool Device_GetCharacteristics_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Device_GetCharacteristics_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_GetCharacteristics_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Device.3
  bool success = true;
  std::optional<std::vector<CharacteristicInfoPtr>> p_characteristics{};
  Device_GetCharacteristics_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCharacteristics(&p_characteristics))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_characteristics));
  }
  return true;
}

void Device_GetCharacteristics_ProxyToResponder::Run(
    std::optional<std::vector<CharacteristicInfoPtr>> in_characteristics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Device::GetCharacteristics", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristics"), in_characteristics,
                        "<value of type std::optional<std::vector<CharacteristicInfoPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kGetCharacteristics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_GetCharacteristics_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristics)::BaseType>
      characteristics_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& characteristics_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::CharacteristicInfoDataView>>(
    in_characteristics,
    characteristics_fragment,
    &characteristics_validate_params);

  params->characteristics.Set(
      characteristics_fragment.is_null() ? nullptr : characteristics_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetCharacteristics");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Device_ReadValueForCharacteristic_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Device::ReadValueForCharacteristicCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Device_ReadValueForCharacteristic_ProxyToResponder> proxy(
        new Device_ReadValueForCharacteristic_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Device_ReadValueForCharacteristic_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_ReadValueForCharacteristic_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Device_ReadValueForCharacteristic_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Device::ReadValueForCharacteristicCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GattResult in_result, const std::optional<std::vector<uint8_t>>& in_value);
};

bool Device_ReadValueForCharacteristic_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Device_ReadValueForCharacteristic_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_ReadValueForCharacteristic_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Device.4
  bool success = true;
  GattResult p_result{};
  std::optional<std::vector<uint8_t>> p_value{};
  Device_ReadValueForCharacteristic_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_value));
  }
  return true;
}

void Device_ReadValueForCharacteristic_ProxyToResponder::Run(
    GattResult in_result, const std::optional<std::vector<uint8_t>>& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Device::ReadValueForCharacteristic", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GattResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kReadValueForCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_ReadValueForCharacteristic_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::GattResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("ReadValueForCharacteristic");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Device_WriteValueForCharacteristic_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Device::WriteValueForCharacteristicCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Device_WriteValueForCharacteristic_ProxyToResponder> proxy(
        new Device_WriteValueForCharacteristic_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Device_WriteValueForCharacteristic_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_WriteValueForCharacteristic_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Device_WriteValueForCharacteristic_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Device::WriteValueForCharacteristicCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GattResult in_result);
};

bool Device_WriteValueForCharacteristic_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Device_WriteValueForCharacteristic_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_WriteValueForCharacteristic_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Device.5
  bool success = true;
  GattResult p_result{};
  Device_WriteValueForCharacteristic_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Device_WriteValueForCharacteristic_ProxyToResponder::Run(
    GattResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Device::WriteValueForCharacteristic", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GattResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kWriteValueForCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_WriteValueForCharacteristic_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::GattResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("WriteValueForCharacteristic");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Device_GetDescriptors_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Device::GetDescriptorsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Device_GetDescriptors_ProxyToResponder> proxy(
        new Device_GetDescriptors_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Device_GetDescriptors_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_GetDescriptors_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Device_GetDescriptors_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Device::GetDescriptorsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<std::vector<DescriptorInfoPtr>> in_descriptors);
};

bool Device_GetDescriptors_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Device_GetDescriptors_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_GetDescriptors_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Device.6
  bool success = true;
  std::optional<std::vector<DescriptorInfoPtr>> p_descriptors{};
  Device_GetDescriptors_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDescriptors(&p_descriptors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_descriptors));
  }
  return true;
}

void Device_GetDescriptors_ProxyToResponder::Run(
    std::optional<std::vector<DescriptorInfoPtr>> in_descriptors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Device::GetDescriptors", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptors"), in_descriptors,
                        "<value of type std::optional<std::vector<DescriptorInfoPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kGetDescriptors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_GetDescriptors_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->descriptors)::BaseType>
      descriptors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& descriptors_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::DescriptorInfoDataView>>(
    in_descriptors,
    descriptors_fragment,
    &descriptors_validate_params);

  params->descriptors.Set(
      descriptors_fragment.is_null() ? nullptr : descriptors_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetDescriptors");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Device_ReadValueForDescriptor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Device::ReadValueForDescriptorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Device_ReadValueForDescriptor_ProxyToResponder> proxy(
        new Device_ReadValueForDescriptor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Device_ReadValueForDescriptor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_ReadValueForDescriptor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Device_ReadValueForDescriptor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Device::ReadValueForDescriptorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GattResult in_result, const std::optional<std::vector<uint8_t>>& in_value);
};

bool Device_ReadValueForDescriptor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Device_ReadValueForDescriptor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_ReadValueForDescriptor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Device.7
  bool success = true;
  GattResult p_result{};
  std::optional<std::vector<uint8_t>> p_value{};
  Device_ReadValueForDescriptor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_value));
  }
  return true;
}

void Device_ReadValueForDescriptor_ProxyToResponder::Run(
    GattResult in_result, const std::optional<std::vector<uint8_t>>& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Device::ReadValueForDescriptor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GattResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kReadValueForDescriptor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_ReadValueForDescriptor_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::GattResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("ReadValueForDescriptor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Device_WriteValueForDescriptor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Device::WriteValueForDescriptorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Device_WriteValueForDescriptor_ProxyToResponder> proxy(
        new Device_WriteValueForDescriptor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Device_WriteValueForDescriptor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_WriteValueForDescriptor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Device_WriteValueForDescriptor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Device::WriteValueForDescriptorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GattResult in_result);
};

bool Device_WriteValueForDescriptor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Device_WriteValueForDescriptor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_WriteValueForDescriptor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Device.8
  bool success = true;
  GattResult p_result{};
  Device_WriteValueForDescriptor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Device_WriteValueForDescriptor_ProxyToResponder::Run(
    GattResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::Device::WriteValueForDescriptor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GattResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Device::kWriteValueForDescriptor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::Device_WriteValueForDescriptor_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::GattResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("WriteValueForDescriptor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DeviceStubDispatch::Accept(
    Device* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Device>(message->header()->name)) {
    case messages::Device::kDisconnect: {
      DCHECK(message->is_serialized());
      internal::Device_Disconnect_Params_Data* params =
          reinterpret_cast<internal::Device_Disconnect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Device.0
      bool success = true;
      Device_Disconnect_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Disconnect(        );
      return true;
    }
    case messages::Device::kGetInfo: {
      break;
    }
    case messages::Device::kGetServices: {
      break;
    }
    case messages::Device::kGetCharacteristics: {
      break;
    }
    case messages::Device::kReadValueForCharacteristic: {
      break;
    }
    case messages::Device::kWriteValueForCharacteristic: {
      break;
    }
    case messages::Device::kGetDescriptors: {
      break;
    }
    case messages::Device::kReadValueForDescriptor: {
      break;
    }
    case messages::Device::kWriteValueForDescriptor: {
      break;
    }
  }
  return false;
}

// static
bool DeviceStubDispatch::AcceptWithResponder(
    Device* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Device>(message->header()->name)) {
    case messages::Device::kDisconnect: {
      break;
    }
    case messages::Device::kGetInfo: {
      internal::Device_GetInfo_Params_Data* params =
          reinterpret_cast<
              internal::Device_GetInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Device.1
      bool success = true;
      Device_GetInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 1, false);
        return false;
      }
      auto callback =
          Device_GetInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInfo(std::move(callback));
      return true;
    }
    case messages::Device::kGetServices: {
      internal::Device_GetServices_Params_Data* params =
          reinterpret_cast<
              internal::Device_GetServices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Device.2
      bool success = true;
      Device_GetServices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 2, false);
        return false;
      }
      auto callback =
          Device_GetServices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetServices(std::move(callback));
      return true;
    }
    case messages::Device::kGetCharacteristics: {
      internal::Device_GetCharacteristics_Params_Data* params =
          reinterpret_cast<
              internal::Device_GetCharacteristics_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Device.3
      bool success = true;
      std::string p_service_id{};
      Device_GetCharacteristics_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 3, false);
        return false;
      }
      auto callback =
          Device_GetCharacteristics_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCharacteristics(        
        std::move(p_service_id), std::move(callback));
      return true;
    }
    case messages::Device::kReadValueForCharacteristic: {
      internal::Device_ReadValueForCharacteristic_Params_Data* params =
          reinterpret_cast<
              internal::Device_ReadValueForCharacteristic_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Device.4
      bool success = true;
      std::string p_service_id{};
      std::string p_characteristic_id{};
      Device_ReadValueForCharacteristic_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 4, false);
        return false;
      }
      auto callback =
          Device_ReadValueForCharacteristic_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadValueForCharacteristic(        
        std::move(p_service_id), 
        std::move(p_characteristic_id), std::move(callback));
      return true;
    }
    case messages::Device::kWriteValueForCharacteristic: {
      internal::Device_WriteValueForCharacteristic_Params_Data* params =
          reinterpret_cast<
              internal::Device_WriteValueForCharacteristic_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Device.5
      bool success = true;
      std::string p_service_id{};
      std::string p_characteristic_id{};
      std::vector<uint8_t> p_value{};
      Device_WriteValueForCharacteristic_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 5, false);
        return false;
      }
      auto callback =
          Device_WriteValueForCharacteristic_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteValueForCharacteristic(        
        std::move(p_service_id), 
        std::move(p_characteristic_id), 
        std::move(p_value), std::move(callback));
      return true;
    }
    case messages::Device::kGetDescriptors: {
      internal::Device_GetDescriptors_Params_Data* params =
          reinterpret_cast<
              internal::Device_GetDescriptors_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Device.6
      bool success = true;
      std::string p_service_id{};
      std::string p_characteristic_id{};
      Device_GetDescriptors_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 6, false);
        return false;
      }
      auto callback =
          Device_GetDescriptors_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDescriptors(        
        std::move(p_service_id), 
        std::move(p_characteristic_id), std::move(callback));
      return true;
    }
    case messages::Device::kReadValueForDescriptor: {
      internal::Device_ReadValueForDescriptor_Params_Data* params =
          reinterpret_cast<
              internal::Device_ReadValueForDescriptor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Device.7
      bool success = true;
      std::string p_service_id{};
      std::string p_characteristic_id{};
      std::string p_descriptor_id{};
      Device_ReadValueForDescriptor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadDescriptorId(&p_descriptor_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 7, false);
        return false;
      }
      auto callback =
          Device_ReadValueForDescriptor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadValueForDescriptor(        
        std::move(p_service_id), 
        std::move(p_characteristic_id), 
        std::move(p_descriptor_id), std::move(callback));
      return true;
    }
    case messages::Device::kWriteValueForDescriptor: {
      internal::Device_WriteValueForDescriptor_Params_Data* params =
          reinterpret_cast<
              internal::Device_WriteValueForDescriptor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Device.8
      bool success = true;
      std::string p_service_id{};
      std::string p_characteristic_id{};
      std::string p_descriptor_id{};
      std::vector<uint8_t> p_value{};
      Device_WriteValueForDescriptor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadDescriptorId(&p_descriptor_id))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 8, false);
        return false;
      }
      auto callback =
          Device_WriteValueForDescriptor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteValueForDescriptor(        
        std::move(p_service_id), 
        std::move(p_characteristic_id), 
        std::move(p_descriptor_id), 
        std::move(p_value), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDeviceValidationInfo[] = {
    { &internal::Device_Disconnect_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Device_GetInfo_Params_Data::Validate,
     &internal::Device_GetInfo_ResponseParams_Data::Validate},
    { &internal::Device_GetServices_Params_Data::Validate,
     &internal::Device_GetServices_ResponseParams_Data::Validate},
    { &internal::Device_GetCharacteristics_Params_Data::Validate,
     &internal::Device_GetCharacteristics_ResponseParams_Data::Validate},
    { &internal::Device_ReadValueForCharacteristic_Params_Data::Validate,
     &internal::Device_ReadValueForCharacteristic_ResponseParams_Data::Validate},
    { &internal::Device_WriteValueForCharacteristic_Params_Data::Validate,
     &internal::Device_WriteValueForCharacteristic_ResponseParams_Data::Validate},
    { &internal::Device_GetDescriptors_Params_Data::Validate,
     &internal::Device_GetDescriptors_ResponseParams_Data::Validate},
    { &internal::Device_ReadValueForDescriptor_Params_Data::Validate,
     &internal::Device_ReadValueForDescriptor_ResponseParams_Data::Validate},
    { &internal::Device_WriteValueForDescriptor_Params_Data::Validate,
     &internal::Device_WriteValueForDescriptor_ResponseParams_Data::Validate},
};

bool DeviceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::Device::Name_,
    kDeviceValidationInfo);
}

bool DeviceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::Device::Name_,
    kDeviceValidationInfo);
}


}  // bluetooth::mojom


namespace mojo {


// static
bool StructTraits<::bluetooth::mojom::RSSIWrapper::DataView, ::bluetooth::mojom::RSSIWrapperPtr>::Read(
    ::bluetooth::mojom::RSSIWrapper::DataView input,
    ::bluetooth::mojom::RSSIWrapperPtr* output) {
  bool success = true;
  ::bluetooth::mojom::RSSIWrapperPtr result(::bluetooth::mojom::RSSIWrapper::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::DeviceInfo::DataView, ::bluetooth::mojom::DeviceInfoPtr>::Read(
    ::bluetooth::mojom::DeviceInfo::DataView input,
    ::bluetooth::mojom::DeviceInfoPtr* output) {
  bool success = true;
  ::bluetooth::mojom::DeviceInfoPtr result(::bluetooth::mojom::DeviceInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadNameForDisplay(&result->name_for_display))
        success = false;
      if (success && !input.ReadAddress(&result->address))
        success = false;
      if (success)
        result->is_gatt_connected = input.is_gatt_connected();
      if (success && !input.ReadRssi(&result->rssi))
        success = false;
      if (success && !input.ReadServiceUuids(&result->service_uuids))
        success = false;
      if (success && !input.ReadManufacturerDataMap(&result->manufacturer_data_map))
        success = false;
      if (success && !input.ReadServiceDataMap(&result->service_data_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::ServiceInfo::DataView, ::bluetooth::mojom::ServiceInfoPtr>::Read(
    ::bluetooth::mojom::ServiceInfo::DataView input,
    ::bluetooth::mojom::ServiceInfoPtr* output) {
  bool success = true;
  ::bluetooth::mojom::ServiceInfoPtr result(::bluetooth::mojom::ServiceInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success)
        result->is_primary = input.is_primary();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::CharacteristicInfo::DataView, ::bluetooth::mojom::CharacteristicInfoPtr>::Read(
    ::bluetooth::mojom::CharacteristicInfo::DataView input,
    ::bluetooth::mojom::CharacteristicInfoPtr* output) {
  bool success = true;
  ::bluetooth::mojom::CharacteristicInfoPtr result(::bluetooth::mojom::CharacteristicInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success)
        result->properties = input.properties();
      if (success)
        result->permissions = input.permissions();
      if (success && !input.ReadLastKnownValue(&result->last_known_value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::DescriptorInfo::DataView, ::bluetooth::mojom::DescriptorInfoPtr>::Read(
    ::bluetooth::mojom::DescriptorInfo::DataView input,
    ::bluetooth::mojom::DescriptorInfoPtr* output) {
  bool success = true;
  ::bluetooth::mojom::DescriptorInfoPtr result(::bluetooth::mojom::DescriptorInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success && !input.ReadLastKnownValue(&result->last_known_value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace bluetooth::mojom {


void DeviceInterceptorForTesting::Disconnect() {
  GetForwardingInterface()->Disconnect();
}
void DeviceInterceptorForTesting::GetInfo(GetInfoCallback callback) {
  GetForwardingInterface()->GetInfo(std::move(callback));
}
void DeviceInterceptorForTesting::GetServices(GetServicesCallback callback) {
  GetForwardingInterface()->GetServices(std::move(callback));
}
void DeviceInterceptorForTesting::GetCharacteristics(const std::string& service_id, GetCharacteristicsCallback callback) {
  GetForwardingInterface()->GetCharacteristics(
    std::move(service_id)
    , std::move(callback));
}
void DeviceInterceptorForTesting::ReadValueForCharacteristic(const std::string& service_id, const std::string& characteristic_id, ReadValueForCharacteristicCallback callback) {
  GetForwardingInterface()->ReadValueForCharacteristic(
    std::move(service_id)
    , 
    std::move(characteristic_id)
    , std::move(callback));
}
void DeviceInterceptorForTesting::WriteValueForCharacteristic(const std::string& service_id, const std::string& characteristic_id, const std::vector<uint8_t>& value, WriteValueForCharacteristicCallback callback) {
  GetForwardingInterface()->WriteValueForCharacteristic(
    std::move(service_id)
    , 
    std::move(characteristic_id)
    , 
    std::move(value)
    , std::move(callback));
}
void DeviceInterceptorForTesting::GetDescriptors(const std::string& service_id, const std::string& characteristic_id, GetDescriptorsCallback callback) {
  GetForwardingInterface()->GetDescriptors(
    std::move(service_id)
    , 
    std::move(characteristic_id)
    , std::move(callback));
}
void DeviceInterceptorForTesting::ReadValueForDescriptor(const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, ReadValueForDescriptorCallback callback) {
  GetForwardingInterface()->ReadValueForDescriptor(
    std::move(service_id)
    , 
    std::move(characteristic_id)
    , 
    std::move(descriptor_id)
    , std::move(callback));
}
void DeviceInterceptorForTesting::WriteValueForDescriptor(const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, const std::vector<uint8_t>& value, WriteValueForDescriptorCallback callback) {
  GetForwardingInterface()->WriteValueForDescriptor(
    std::move(service_id)
    , 
    std::move(characteristic_id)
    , 
    std::move(descriptor_id)
    , 
    std::move(value)
    , std::move(callback));
}
DeviceAsyncWaiter::DeviceAsyncWaiter(
    Device* proxy) : proxy_(proxy) {}

DeviceAsyncWaiter::~DeviceAsyncWaiter() = default;


void DeviceAsyncWaiter::GetInfo(
    DeviceInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->GetInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             DeviceInfoPtr* out_info
,
             DeviceInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

DeviceInfoPtr DeviceAsyncWaiter::GetInfo(
    ) {
  DeviceInfoPtr async_wait_result;
  GetInfo(&async_wait_result);
  return async_wait_result;
}

void DeviceAsyncWaiter::GetServices(
    std::vector<ServiceInfoPtr>* out_services) {
  base::RunLoop loop;
  proxy_->GetServices(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ServiceInfoPtr>* out_services
,
             std::vector<ServiceInfoPtr> services) {*out_services = std::move(services);
            loop->Quit();
          },
          &loop,
          out_services));
  loop.Run();
}

std::vector<ServiceInfoPtr> DeviceAsyncWaiter::GetServices(
    ) {
  std::vector<ServiceInfoPtr> async_wait_result;
  GetServices(&async_wait_result);
  return async_wait_result;
}

void DeviceAsyncWaiter::GetCharacteristics(
    const std::string& service_id, std::optional<std::vector<CharacteristicInfoPtr>>* out_characteristics) {
  base::RunLoop loop;
  proxy_->GetCharacteristics(
      std::move(service_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::vector<CharacteristicInfoPtr>>* out_characteristics
,
             std::optional<std::vector<CharacteristicInfoPtr>> characteristics) {*out_characteristics = std::move(characteristics);
            loop->Quit();
          },
          &loop,
          out_characteristics));
  loop.Run();
}

std::optional<std::vector<CharacteristicInfoPtr>> DeviceAsyncWaiter::GetCharacteristics(
    const std::string& service_id) {
  std::optional<std::vector<CharacteristicInfoPtr>> async_wait_result;
  GetCharacteristics(std::move(service_id),&async_wait_result);
  return async_wait_result;
}

void DeviceAsyncWaiter::ReadValueForCharacteristic(
    const std::string& service_id, const std::string& characteristic_id, GattResult* out_result, std::optional<std::vector<uint8_t>>* out_value) {
  base::RunLoop loop;
  proxy_->ReadValueForCharacteristic(
      std::move(service_id),
      std::move(characteristic_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             GattResult* out_result
,
             std::optional<std::vector<uint8_t>>* out_value
,
             GattResult result,
             const std::optional<std::vector<uint8_t>>& value) {*out_result = std::move(result);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_result,
          out_value));
  loop.Run();
}



void DeviceAsyncWaiter::WriteValueForCharacteristic(
    const std::string& service_id, const std::string& characteristic_id, const std::vector<uint8_t>& value, GattResult* out_result) {
  base::RunLoop loop;
  proxy_->WriteValueForCharacteristic(
      std::move(service_id),
      std::move(characteristic_id),
      std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop,
             GattResult* out_result
,
             GattResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GattResult DeviceAsyncWaiter::WriteValueForCharacteristic(
    const std::string& service_id, const std::string& characteristic_id, const std::vector<uint8_t>& value) {
  GattResult async_wait_result;
  WriteValueForCharacteristic(std::move(service_id),std::move(characteristic_id),std::move(value),&async_wait_result);
  return async_wait_result;
}

void DeviceAsyncWaiter::GetDescriptors(
    const std::string& service_id, const std::string& characteristic_id, std::optional<std::vector<DescriptorInfoPtr>>* out_descriptors) {
  base::RunLoop loop;
  proxy_->GetDescriptors(
      std::move(service_id),
      std::move(characteristic_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::vector<DescriptorInfoPtr>>* out_descriptors
,
             std::optional<std::vector<DescriptorInfoPtr>> descriptors) {*out_descriptors = std::move(descriptors);
            loop->Quit();
          },
          &loop,
          out_descriptors));
  loop.Run();
}

std::optional<std::vector<DescriptorInfoPtr>> DeviceAsyncWaiter::GetDescriptors(
    const std::string& service_id, const std::string& characteristic_id) {
  std::optional<std::vector<DescriptorInfoPtr>> async_wait_result;
  GetDescriptors(std::move(service_id),std::move(characteristic_id),&async_wait_result);
  return async_wait_result;
}

void DeviceAsyncWaiter::ReadValueForDescriptor(
    const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, GattResult* out_result, std::optional<std::vector<uint8_t>>* out_value) {
  base::RunLoop loop;
  proxy_->ReadValueForDescriptor(
      std::move(service_id),
      std::move(characteristic_id),
      std::move(descriptor_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             GattResult* out_result
,
             std::optional<std::vector<uint8_t>>* out_value
,
             GattResult result,
             const std::optional<std::vector<uint8_t>>& value) {*out_result = std::move(result);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_result,
          out_value));
  loop.Run();
}



void DeviceAsyncWaiter::WriteValueForDescriptor(
    const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, const std::vector<uint8_t>& value, GattResult* out_result) {
  base::RunLoop loop;
  proxy_->WriteValueForDescriptor(
      std::move(service_id),
      std::move(characteristic_id),
      std::move(descriptor_id),
      std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop,
             GattResult* out_result
,
             GattResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GattResult DeviceAsyncWaiter::WriteValueForDescriptor(
    const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, const std::vector<uint8_t>& value) {
  GattResult async_wait_result;
  WriteValueForDescriptor(std::move(service_id),std::move(characteristic_id),std::move(descriptor_id),std::move(value),&async_wait_result);
  return async_wait_result;
}






}  // bluetooth::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif