// device/bluetooth/public/mojom/device.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_DATA_VIEW_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "device/bluetooth/public/mojom/device.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"


namespace bluetooth::mojom {
class RSSIWrapperDataView;

class DeviceInfoDataView;

class ServiceInfoDataView;

class CharacteristicInfoDataView;

class DescriptorInfoDataView;



}  // bluetooth::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::bluetooth::mojom::RSSIWrapperDataView> {
  using Data = ::bluetooth::mojom::internal::RSSIWrapper_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::DeviceInfoDataView> {
  using Data = ::bluetooth::mojom::internal::DeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::ServiceInfoDataView> {
  using Data = ::bluetooth::mojom::internal::ServiceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::CharacteristicInfoDataView> {
  using Data = ::bluetooth::mojom::internal::CharacteristicInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::DescriptorInfoDataView> {
  using Data = ::bluetooth::mojom::internal::DescriptorInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace bluetooth::mojom {


enum class Property : int32_t {
  
  NONE = 0,
  
  BROADCAST = 1,
  
  READ = 2,
  
  WRITE_WITHOUT_RESPONSE = 4,
  
  WRITE = 8,
  
  NOTIFY = 16,
  
  INDICATE = 32,
  
  AUTHENTICATED_SIGNED_WRITES = 64,
  
  EXTENDED_PROPERTIES = 128,
  
  RELIABLE_WRITE = 256,
  
  WRITABLE_AUXILIARIES = 512,
  
  READ_ENCRYPTED = 1024,
  
  WRITE_ENCRYPTED = 2048,
  
  READ_ENCRYPTED_AUTHENTICATED = 4096,
  
  WRITE_ENCRYPTED_AUTHENTICATED = 8192,
  kMinValue = 0,
  kMaxValue = 8192,
};

 std::ostream& operator<<(std::ostream& os, Property value);
inline bool IsKnownEnumValue(Property value) {
  return internal::Property_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GattResult : int32_t {
  
  SUCCESS = 0,
  
  UNKNOWN = 1,
  
  FAILED = 2,
  
  IN_PROGRESS = 3,
  
  INVALID_LENGTH = 4,
  
  NOT_PERMITTED = 5,
  
  NOT_AUTHORIZED = 6,
  
  NOT_PAIRED = 7,
  
  NOT_SUPPORTED = 8,
  
  SERVICE_NOT_FOUND = 9,
  
  CHARACTERISTIC_NOT_FOUND = 10,
  
  DESCRIPTOR_NOT_FOUND = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

 std::ostream& operator<<(std::ostream& os, GattResult value);
inline bool IsKnownEnumValue(GattResult value) {
  return internal::GattResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DeviceInterfaceBase {};

using DevicePtrDataView =
    mojo::InterfacePtrDataView<DeviceInterfaceBase>;
using DeviceRequestDataView =
    mojo::InterfaceRequestDataView<DeviceInterfaceBase>;
using DeviceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceInterfaceBase>;
using DeviceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceInterfaceBase>;


class RSSIWrapperDataView {
 public:
  RSSIWrapperDataView() = default;

  RSSIWrapperDataView(
      internal::RSSIWrapper_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int8_t value() const {
    return data_->value;
  }
 private:
  internal::RSSIWrapper_Data* data_ = nullptr;
};


class DeviceInfoDataView {
 public:
  DeviceInfoDataView() = default;

  DeviceInfoDataView(
      internal::DeviceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameForDisplayDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNameForDisplay(UserType* output) {
    
    auto* pointer = data_->name_for_display.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAddressDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddress(UserType* output) {
    
    auto* pointer = data_->address.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_gatt_connected() const {
    return data_->is_gatt_connected;
  }
  inline void GetRssiDataView(
      RSSIWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRssi(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::bluetooth::mojom::RSSIWrapperDataView, UserType>(),
    "Attempting to read the optional `rssi` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRssi` instead "
    "of `ReadRssi if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->rssi.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::RSSIWrapperDataView>(
        pointer, output, message_);
  }
  inline void GetServiceUuidsDataView(
      mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceUuids(UserType* output) {
    
    auto* pointer = data_->service_uuids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        pointer, output, message_);
  }
  inline void GetManufacturerDataMapDataView(
      mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManufacturerDataMap(UserType* output) {
    
    auto* pointer = data_->manufacturer_data_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetServiceDataMapDataView(
      mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceDataMap(UserType* output) {
    
    auto* pointer = data_->service_data_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::DeviceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceInfoDataView {
 public:
  ServiceInfoDataView() = default;

  ServiceInfoDataView(
      internal::ServiceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  bool is_primary() const {
    return data_->is_primary;
  }
 private:
  internal::ServiceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CharacteristicInfoDataView {
 public:
  CharacteristicInfoDataView() = default;

  CharacteristicInfoDataView(
      internal::CharacteristicInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  uint32_t properties() const {
    return data_->properties;
  }
  uint32_t permissions() const {
    return data_->permissions;
  }
  inline void GetLastKnownValueDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastKnownValue(UserType* output) {
    
    auto* pointer = data_->last_known_value.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::CharacteristicInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DescriptorInfoDataView {
 public:
  DescriptorInfoDataView() = default;

  DescriptorInfoDataView(
      internal::DescriptorInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  inline void GetLastKnownValueDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastKnownValue(UserType* output) {
    
    auto* pointer = data_->last_known_value.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::DescriptorInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // bluetooth::mojom

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_DATA_VIEW_H_