// device/bluetooth/public/mojom/adapter.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/bluetooth/public/mojom/adapter.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/bluetooth/public/mojom/adapter.mojom-params-data.h"
namespace bluetooth {
namespace mojom {

NOINLINE static const char* ConnectResultToStringHelper(ConnectResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ConnectResult::SUCCESS:
      return "SUCCESS";
    case ConnectResult::AUTH_CANCELED:
      return "AUTH_CANCELED";
    case ConnectResult::AUTH_FAILED:
      return "AUTH_FAILED";
    case ConnectResult::AUTH_REJECTED:
      return "AUTH_REJECTED";
    case ConnectResult::AUTH_TIMEOUT:
      return "AUTH_TIMEOUT";
    case ConnectResult::FAILED:
      return "FAILED";
    case ConnectResult::INPROGRESS:
      return "INPROGRESS";
    case ConnectResult::UNKNOWN:
      return "UNKNOWN";
    case ConnectResult::UNSUPPORTED_DEVICE:
      return "UNSUPPORTED_DEVICE";
    case ConnectResult::DEVICE_NO_LONGER_IN_RANGE:
      return "DEVICE_NO_LONGER_IN_RANGE";
    case ConnectResult::NOT_READY:
      return "NOT_READY";
    case ConnectResult::ALREADY_CONNECTED:
      return "ALREADY_CONNECTED";
    case ConnectResult::ALREADY_EXISTS:
      return "ALREADY_EXISTS";
    case ConnectResult::NOT_CONNECTED:
      return "NOT_CONNECTED";
    case ConnectResult::DOES_NOT_EXIST:
      return "DOES_NOT_EXIST";
    case ConnectResult::INVALID_ARGS:
      return "INVALID_ARGS";
    case ConnectResult::NON_AUTH_TIMEOUT:
      return "NON_AUTH_TIMEOUT";
    case ConnectResult::NO_MEMORY:
      return "NO_MEMORY";
    case ConnectResult::JNI_ENVIRONMENT:
      return "JNI_ENVIRONMENT";
    case ConnectResult::JNI_THREAD_ATTACH:
      return "JNI_THREAD_ATTACH";
    case ConnectResult::WAKELOCK:
      return "WAKELOCK";
    case ConnectResult::UNEXPECTED_STATE:
      return "UNEXPECTED_STATE";
    case ConnectResult::SOCKET:
      return "SOCKET";
    default:
      return nullptr;
  }
}

std::string ConnectResultToString(ConnectResult value) {
  const char *str = ConnectResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ConnectResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ConnectResult value) {
  return os << ConnectResultToString(value);
}

namespace internal {
// static
bool LocalCharacteristicReadResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const LocalCharacteristicReadResult_Data* object = static_cast<const LocalCharacteristicReadResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case LocalCharacteristicReadResult_Tag::kErrorCode: {


      if (!::bluetooth::mojom::internal::GattServiceErrorCode_Data
            ::Validate(object->data.f_error_code, validation_context))
        return false;
      return true;
    }
    case LocalCharacteristicReadResult_Tag::kData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_data, validation_context,
                                             &data_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in LocalCharacteristicReadResult");
      return false;
    }
  }
}


// static
bool ConnectToServiceResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConnectToServiceResult_Data* object =
      static_cast<const ConnectToServiceResult_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receive_stream, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receive_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->send_stream, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->send_stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ConnectToServiceResult_Data::ConnectToServiceResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AcceptConnectionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AcceptConnectionResult_Data* object =
      static_cast<const AcceptConnectionResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receive_stream, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receive_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->send_stream, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->send_stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AcceptConnectionResult_Data::AcceptConnectionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdapterInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdapterInfo_Data* object =
      static_cast<const AdapterInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->system_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& system_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->system_name, validation_context,
                                         &system_name_validate_params)) {
    return false;
  }

  return true;
}

AdapterInfo_Data::AdapterInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Advertisement_Unregister_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Advertisement_Unregister_Params_Data* object =
      static_cast<const Advertisement_Unregister_Params_Data*>(data);

  return true;
}

Advertisement_Unregister_Params_Data::Advertisement_Unregister_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Advertisement_Unregister_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Advertisement_Unregister_ResponseParams_Data* object =
      static_cast<const Advertisement_Unregister_ResponseParams_Data*>(data);

  return true;
}

Advertisement_Unregister_ResponseParams_Data::Advertisement_Unregister_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DiscoverySession_IsActive_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DiscoverySession_IsActive_Params_Data* object =
      static_cast<const DiscoverySession_IsActive_Params_Data*>(data);

  return true;
}

DiscoverySession_IsActive_Params_Data::DiscoverySession_IsActive_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DiscoverySession_IsActive_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DiscoverySession_IsActive_ResponseParams_Data* object =
      static_cast<const DiscoverySession_IsActive_ResponseParams_Data*>(data);

  return true;
}

DiscoverySession_IsActive_ResponseParams_Data::DiscoverySession_IsActive_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DiscoverySession_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DiscoverySession_Stop_Params_Data* object =
      static_cast<const DiscoverySession_Stop_Params_Data*>(data);

  return true;
}

DiscoverySession_Stop_Params_Data::DiscoverySession_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DiscoverySession_Stop_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DiscoverySession_Stop_ResponseParams_Data* object =
      static_cast<const DiscoverySession_Stop_ResponseParams_Data*>(data);

  return true;
}

DiscoverySession_Stop_ResponseParams_Data::DiscoverySession_Stop_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Socket_Disconnect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Socket_Disconnect_Params_Data* object =
      static_cast<const Socket_Disconnect_Params_Data*>(data);

  return true;
}

Socket_Disconnect_Params_Data::Socket_Disconnect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Socket_Disconnect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Socket_Disconnect_ResponseParams_Data* object =
      static_cast<const Socket_Disconnect_ResponseParams_Data*>(data);

  return true;
}

Socket_Disconnect_ResponseParams_Data::Socket_Disconnect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServerSocket_Accept_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServerSocket_Accept_Params_Data* object =
      static_cast<const ServerSocket_Accept_Params_Data*>(data);

  return true;
}

ServerSocket_Accept_Params_Data::ServerSocket_Accept_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServerSocket_Accept_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServerSocket_Accept_ResponseParams_Data* object =
      static_cast<const ServerSocket_Accept_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ServerSocket_Accept_ResponseParams_Data::ServerSocket_Accept_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServerSocket_Disconnect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServerSocket_Disconnect_Params_Data* object =
      static_cast<const ServerSocket_Disconnect_Params_Data*>(data);

  return true;
}

ServerSocket_Disconnect_Params_Data::ServerSocket_Disconnect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServerSocket_Disconnect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServerSocket_Disconnect_ResponseParams_Data* object =
      static_cast<const ServerSocket_Disconnect_ResponseParams_Data*>(data);

  return true;
}

ServerSocket_Disconnect_ResponseParams_Data::ServerSocket_Disconnect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GattService_CreateCharacteristic_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GattService_CreateCharacteristic_Params_Data* object =
      static_cast<const GattService_CreateCharacteristic_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->characteristic_uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permissions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  return true;
}

GattService_CreateCharacteristic_Params_Data::GattService_CreateCharacteristic_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GattService_CreateCharacteristic_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GattService_CreateCharacteristic_ResponseParams_Data* object =
      static_cast<const GattService_CreateCharacteristic_ResponseParams_Data*>(data);

  return true;
}

GattService_CreateCharacteristic_ResponseParams_Data::GattService_CreateCharacteristic_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GattService_Register_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GattService_Register_Params_Data* object =
      static_cast<const GattService_Register_Params_Data*>(data);

  return true;
}

GattService_Register_Params_Data::GattService_Register_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GattService_Register_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GattService_Register_ResponseParams_Data* object =
      static_cast<const GattService_Register_ResponseParams_Data*>(data);


  if (!::bluetooth::mojom::internal::GattServiceErrorCode_Data
        ::Validate(object->error_code_$value, validation_context))
    return false;

  return true;
}

GattService_Register_ResponseParams_Data::GattService_Register_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GattServiceObserver_OnLocalCharacteristicRead_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GattServiceObserver_OnLocalCharacteristicRead_Params_Data* object =
      static_cast<const GattServiceObserver_OnLocalCharacteristicRead_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_device, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_device, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->characteristic_uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_uuid, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_uuid, validation_context))
    return false;

  return true;
}

GattServiceObserver_OnLocalCharacteristicRead_Params_Data::GattServiceObserver_OnLocalCharacteristicRead_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data* object =
      static_cast<const GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->read_result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->read_result, validation_context))
    return false;

  return true;
}

GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data::GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_ConnectToDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_ConnectToDevice_Params_Data* object =
      static_cast<const Adapter_ConnectToDevice_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  return true;
}

Adapter_ConnectToDevice_Params_Data::Adapter_ConnectToDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_ConnectToDevice_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_ConnectToDevice_ResponseParams_Data* object =
      static_cast<const Adapter_ConnectToDevice_ResponseParams_Data*>(data);


  if (!::bluetooth::mojom::internal::ConnectResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->device,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Adapter_ConnectToDevice_ResponseParams_Data::Adapter_ConnectToDevice_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_GetDevices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_GetDevices_Params_Data* object =
      static_cast<const Adapter_GetDevices_Params_Data*>(data);

  return true;
}

Adapter_GetDevices_Params_Data::Adapter_GetDevices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_GetDevices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_GetDevices_ResponseParams_Data* object =
      static_cast<const Adapter_GetDevices_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

Adapter_GetDevices_ResponseParams_Data::Adapter_GetDevices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_GetInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_GetInfo_Params_Data* object =
      static_cast<const Adapter_GetInfo_Params_Data*>(data);

  return true;
}

Adapter_GetInfo_Params_Data::Adapter_GetInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_GetInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_GetInfo_ResponseParams_Data* object =
      static_cast<const Adapter_GetInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

Adapter_GetInfo_ResponseParams_Data::Adapter_GetInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_AddObserver_Params_Data* object =
      static_cast<const Adapter_AddObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Adapter_AddObserver_Params_Data::Adapter_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_AddObserver_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_AddObserver_ResponseParams_Data* object =
      static_cast<const Adapter_AddObserver_ResponseParams_Data*>(data);

  return true;
}

Adapter_AddObserver_ResponseParams_Data::Adapter_AddObserver_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_RegisterAdvertisement_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_RegisterAdvertisement_Params_Data* object =
      static_cast<const Adapter_RegisterAdvertisement_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_data, validation_context,
                                         &service_data_validate_params)) {
    return false;
  }

  return true;
}

Adapter_RegisterAdvertisement_Params_Data::Adapter_RegisterAdvertisement_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_RegisterAdvertisement_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_RegisterAdvertisement_ResponseParams_Data* object =
      static_cast<const Adapter_RegisterAdvertisement_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->advertisement,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Adapter_RegisterAdvertisement_ResponseParams_Data::Adapter_RegisterAdvertisement_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_SetDiscoverable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_SetDiscoverable_Params_Data* object =
      static_cast<const Adapter_SetDiscoverable_Params_Data*>(data);

  return true;
}

Adapter_SetDiscoverable_Params_Data::Adapter_SetDiscoverable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_SetDiscoverable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_SetDiscoverable_ResponseParams_Data* object =
      static_cast<const Adapter_SetDiscoverable_ResponseParams_Data*>(data);

  return true;
}

Adapter_SetDiscoverable_ResponseParams_Data::Adapter_SetDiscoverable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_SetName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_SetName_Params_Data* object =
      static_cast<const Adapter_SetName_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

Adapter_SetName_Params_Data::Adapter_SetName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_SetName_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_SetName_ResponseParams_Data* object =
      static_cast<const Adapter_SetName_ResponseParams_Data*>(data);

  return true;
}

Adapter_SetName_ResponseParams_Data::Adapter_SetName_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_StartDiscoverySession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_StartDiscoverySession_Params_Data* object =
      static_cast<const Adapter_StartDiscoverySession_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_name, validation_context,
                                         &client_name_validate_params)) {
    return false;
  }

  return true;
}

Adapter_StartDiscoverySession_Params_Data::Adapter_StartDiscoverySession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_StartDiscoverySession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_StartDiscoverySession_ResponseParams_Data* object =
      static_cast<const Adapter_StartDiscoverySession_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Adapter_StartDiscoverySession_ResponseParams_Data::Adapter_StartDiscoverySession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_ConnectToServiceInsecurely_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_ConnectToServiceInsecurely_Params_Data* object =
      static_cast<const Adapter_ConnectToServiceInsecurely_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& address_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_uuid, validation_context))
    return false;

  return true;
}

Adapter_ConnectToServiceInsecurely_Params_Data::Adapter_ConnectToServiceInsecurely_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_ConnectToServiceInsecurely_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_ConnectToServiceInsecurely_ResponseParams_Data* object =
      static_cast<const Adapter_ConnectToServiceInsecurely_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

Adapter_ConnectToServiceInsecurely_ResponseParams_Data::Adapter_ConnectToServiceInsecurely_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_CreateRfcommServiceInsecurely_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_CreateRfcommServiceInsecurely_Params_Data* object =
      static_cast<const Adapter_CreateRfcommServiceInsecurely_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_name, validation_context,
                                         &service_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_uuid, validation_context))
    return false;

  return true;
}

Adapter_CreateRfcommServiceInsecurely_Params_Data::Adapter_CreateRfcommServiceInsecurely_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data* object =
      static_cast<const Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->server_socket,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data::Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_CreateLocalGattService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_CreateLocalGattService_Params_Data* object =
      static_cast<const Adapter_CreateLocalGattService_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Adapter_CreateLocalGattService_Params_Data::Adapter_CreateLocalGattService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_CreateLocalGattService_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_CreateLocalGattService_ResponseParams_Data* object =
      static_cast<const Adapter_CreateLocalGattService_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->gatt_service, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->gatt_service,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Adapter_CreateLocalGattService_ResponseParams_Data::Adapter_CreateLocalGattService_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_IsLeScatternetDualRoleSupported_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_IsLeScatternetDualRoleSupported_Params_Data* object =
      static_cast<const Adapter_IsLeScatternetDualRoleSupported_Params_Data*>(data);

  return true;
}

Adapter_IsLeScatternetDualRoleSupported_Params_Data::Adapter_IsLeScatternetDualRoleSupported_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data* object =
      static_cast<const Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data*>(data);

  return true;
}

Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data::Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdapterObserver_PresentChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdapterObserver_PresentChanged_Params_Data* object =
      static_cast<const AdapterObserver_PresentChanged_Params_Data*>(data);

  return true;
}

AdapterObserver_PresentChanged_Params_Data::AdapterObserver_PresentChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdapterObserver_PoweredChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdapterObserver_PoweredChanged_Params_Data* object =
      static_cast<const AdapterObserver_PoweredChanged_Params_Data*>(data);

  return true;
}

AdapterObserver_PoweredChanged_Params_Data::AdapterObserver_PoweredChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdapterObserver_DiscoverableChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdapterObserver_DiscoverableChanged_Params_Data* object =
      static_cast<const AdapterObserver_DiscoverableChanged_Params_Data*>(data);

  return true;
}

AdapterObserver_DiscoverableChanged_Params_Data::AdapterObserver_DiscoverableChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdapterObserver_DiscoveringChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdapterObserver_DiscoveringChanged_Params_Data* object =
      static_cast<const AdapterObserver_DiscoveringChanged_Params_Data*>(data);

  return true;
}

AdapterObserver_DiscoveringChanged_Params_Data::AdapterObserver_DiscoveringChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdapterObserver_DeviceAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdapterObserver_DeviceAdded_Params_Data* object =
      static_cast<const AdapterObserver_DeviceAdded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device, validation_context))
    return false;

  return true;
}

AdapterObserver_DeviceAdded_Params_Data::AdapterObserver_DeviceAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdapterObserver_DeviceChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdapterObserver_DeviceChanged_Params_Data* object =
      static_cast<const AdapterObserver_DeviceChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device, validation_context))
    return false;

  return true;
}

AdapterObserver_DeviceChanged_Params_Data::AdapterObserver_DeviceChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdapterObserver_DeviceRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdapterObserver_DeviceRemoved_Params_Data* object =
      static_cast<const AdapterObserver_DeviceRemoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device, validation_context))
    return false;

  return true;
}

AdapterObserver_DeviceRemoved_Params_Data::AdapterObserver_DeviceRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace bluetooth

namespace perfetto {

// static
void TraceFormatTraits<::bluetooth::mojom::ConnectResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::bluetooth::mojom::ConnectResult value) {
  return std::move(context).WriteString(::bluetooth::mojom::ConnectResultToString(value));
}

} // namespace perfetto