// content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_TRUSTED_SIGNALS_CACHE_MOJOM_PARAMS_DATA_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_TRUSTED_SIGNALS_CACHE_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace auction_worklet::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TrustedSignalsCacheClient_OnSuccess_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t compression_scheme;
  uint8_t pad0_[4];
  ::mojo_base::mojom::internal::BigBuffer_Data compression_group_data;

 private:
  friend class mojo::internal::MessageFragment<TrustedSignalsCacheClient_OnSuccess_Params_Data>;

  TrustedSignalsCacheClient_OnSuccess_Params_Data();
  ~TrustedSignalsCacheClient_OnSuccess_Params_Data() = delete;
};
static_assert(sizeof(TrustedSignalsCacheClient_OnSuccess_Params_Data) == 32,
              "Bad sizeof(TrustedSignalsCacheClient_OnSuccess_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TrustedSignalsCacheClient_OnError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> error_message;

 private:
  friend class mojo::internal::MessageFragment<TrustedSignalsCacheClient_OnError_Params_Data>;

  TrustedSignalsCacheClient_OnError_Params_Data();
  ~TrustedSignalsCacheClient_OnError_Params_Data() = delete;
};
static_assert(sizeof(TrustedSignalsCacheClient_OnError_Params_Data) == 16,
              "Bad sizeof(TrustedSignalsCacheClient_OnError_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TrustedSignalsCache_GetTrustedSignals_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> compression_group_token;
  mojo::internal::Interface_Data client;

 private:
  friend class mojo::internal::MessageFragment<TrustedSignalsCache_GetTrustedSignals_Params_Data>;

  TrustedSignalsCache_GetTrustedSignals_Params_Data();
  ~TrustedSignalsCache_GetTrustedSignals_Params_Data() = delete;
};
static_assert(sizeof(TrustedSignalsCache_GetTrustedSignals_Params_Data) == 24,
              "Bad sizeof(TrustedSignalsCache_GetTrustedSignals_Params_Data)");

}  // namespace internal


class TrustedSignalsCacheClient_OnSuccess_ParamsDataView {
 public:
  TrustedSignalsCacheClient_OnSuccess_ParamsDataView() = default;

  TrustedSignalsCacheClient_OnSuccess_ParamsDataView(
      internal::TrustedSignalsCacheClient_OnSuccess_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCompressionScheme(UserType* output) const {
    auto data_value = data_->compression_scheme;
    return mojo::internal::Deserialize<::auction_worklet::mojom::TrustedSignalsCompressionScheme>(
        data_value, output);
  }
  TrustedSignalsCompressionScheme compression_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::TrustedSignalsCompressionScheme>(data_->compression_scheme));
  }
  inline void GetCompressionGroupDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCompressionGroupData(UserType* output) {
    
    auto* pointer = !data_->compression_group_data.is_null() ? &data_->compression_group_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::TrustedSignalsCacheClient_OnSuccess_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustedSignalsCacheClient_OnError_ParamsDataView {
 public:
  TrustedSignalsCacheClient_OnError_ParamsDataView() = default;

  TrustedSignalsCacheClient_OnError_ParamsDataView(
      internal::TrustedSignalsCacheClient_OnError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TrustedSignalsCacheClient_OnError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustedSignalsCache_GetTrustedSignals_ParamsDataView {
 public:
  TrustedSignalsCache_GetTrustedSignals_ParamsDataView() = default;

  TrustedSignalsCache_GetTrustedSignals_ParamsDataView(
      internal::TrustedSignalsCache_GetTrustedSignals_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCompressionGroupTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCompressionGroupToken(UserType* output) {
    
    auto* pointer = data_->compression_group_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::auction_worklet::mojom::TrustedSignalsCacheClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::TrustedSignalsCache_GetTrustedSignals_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void TrustedSignalsCacheClient_OnSuccess_ParamsDataView::GetCompressionGroupDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->compression_group_data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void TrustedSignalsCacheClient_OnError_ParamsDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TrustedSignalsCache_GetTrustedSignals_ParamsDataView::GetCompressionGroupTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->compression_group_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // auction_worklet::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_TRUSTED_SIGNALS_CACHE_MOJOM_PARAMS_DATA_H_