// content/services/auction_worklet/public/mojom/seller_worklet.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_DATA_VIEW_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared-internal.h"
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/reject_reason.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace auction_worklet::mojom {
class ComponentAuctionModifiedBidParamsDataView;

class ComponentAuctionReportResultParamsDataView;

class ScoreAdDependencyLatenciesDataView;

class SellerTimingMetricsDataView;

class CreativeInfoWithoutOwnerDataView;

class ComponentAuctionOtherSellerDataView;


}  // auction_worklet::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::auction_worklet::mojom::ComponentAuctionModifiedBidParamsDataView> {
  using Data = ::auction_worklet::mojom::internal::ComponentAuctionModifiedBidParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::ComponentAuctionReportResultParamsDataView> {
  using Data = ::auction_worklet::mojom::internal::ComponentAuctionReportResultParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::ScoreAdDependencyLatenciesDataView> {
  using Data = ::auction_worklet::mojom::internal::ScoreAdDependencyLatencies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::SellerTimingMetricsDataView> {
  using Data = ::auction_worklet::mojom::internal::SellerTimingMetrics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::CreativeInfoWithoutOwnerDataView> {
  using Data = ::auction_worklet::mojom::internal::CreativeInfoWithoutOwner_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::ComponentAuctionOtherSellerDataView> {
  using Data = ::auction_worklet::mojom::internal::ComponentAuctionOtherSeller_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace auction_worklet::mojom {
// Interface base classes. They are used for type safety check.
class ScoreAdClientInterfaceBase {};

using ScoreAdClientPtrDataView =
    mojo::InterfacePtrDataView<ScoreAdClientInterfaceBase>;
using ScoreAdClientRequestDataView =
    mojo::InterfaceRequestDataView<ScoreAdClientInterfaceBase>;
using ScoreAdClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ScoreAdClientInterfaceBase>;
using ScoreAdClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ScoreAdClientInterfaceBase>;
class SellerWorkletInterfaceBase {};

using SellerWorkletPtrDataView =
    mojo::InterfacePtrDataView<SellerWorkletInterfaceBase>;
using SellerWorkletRequestDataView =
    mojo::InterfaceRequestDataView<SellerWorkletInterfaceBase>;
using SellerWorkletAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SellerWorkletInterfaceBase>;
using SellerWorkletAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SellerWorkletInterfaceBase>;


class ComponentAuctionModifiedBidParamsDataView {
 public:
  ComponentAuctionModifiedBidParamsDataView() = default;

  ComponentAuctionModifiedBidParamsDataView(
      internal::ComponentAuctionModifiedBidParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAd(UserType* output) {
    
    auto* pointer = data_->ad.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<double> bid() const {

    return data_->bid_$flag
        ? std::make_optional(data_->bid_$value)
        : std::nullopt;
  }
  inline void GetBidCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBidCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `bid_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBidCurrency` instead "
    "of `ReadBidCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bid_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
 private:
  internal::ComponentAuctionModifiedBidParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ComponentAuctionReportResultParamsDataView {
 public:
  ComponentAuctionReportResultParamsDataView() = default;

  ComponentAuctionReportResultParamsDataView(
      internal::ComponentAuctionReportResultParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopLevelSellerSignalsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelSellerSignals(UserType* output) {
    
    auto* pointer = data_->top_level_seller_signals.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<double> modified_bid() const {

    return data_->modified_bid_$flag
        ? std::make_optional(data_->modified_bid_$value)
        : std::nullopt;
  }
 private:
  internal::ComponentAuctionReportResultParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScoreAdDependencyLatenciesDataView {
 public:
  ScoreAdDependencyLatenciesDataView() = default;

  ScoreAdDependencyLatenciesDataView(
      internal::ScoreAdDependencyLatencies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeReadyLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodeReadyLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `code_ready_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCodeReadyLatency` instead "
    "of `ReadCodeReadyLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->code_ready_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerSignalsLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerSignalsLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_signals_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerSignalsLatency` instead "
    "of `ReadDirectFromSellerSignalsLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_signals_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedScoringSignalsLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedScoringSignalsLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `trusted_scoring_signals_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedScoringSignalsLatency` instead "
    "of `ReadTrustedScoringSignalsLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_scoring_signals_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDepsWaitStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepsWaitStartTime(UserType* output) {
    
    auto* pointer = data_->deps_wait_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetScoreAdStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScoreAdStartTime(UserType* output) {
    
    auto* pointer = data_->score_ad_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetScoreAdFinishTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScoreAdFinishTime(UserType* output) {
    
    auto* pointer = data_->score_ad_finish_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::ScoreAdDependencyLatencies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SellerTimingMetricsDataView {
 public:
  SellerTimingMetricsDataView() = default;

  SellerTimingMetricsDataView(
      internal::SellerTimingMetrics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetJsFetchLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJsFetchLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `js_fetch_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadJsFetchLatency` instead "
    "of `ReadJsFetchLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->js_fetch_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetScriptLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptLatency(UserType* output) {
    
    auto* pointer = data_->script_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool script_timed_out() const {
    return data_->script_timed_out;
  }
 private:
  internal::SellerTimingMetrics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreativeInfoWithoutOwnerDataView {
 public:
  CreativeInfoWithoutOwnerDataView() = default;

  CreativeInfoWithoutOwnerDataView(
      internal::CreativeInfoWithoutOwner_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAdDescriptorDataView(
      ::blink::mojom::AdDescriptorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdDescriptor(UserType* output) {
    
    auto* pointer = data_->ad_descriptor.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdDescriptorDataView>(
        pointer, output, message_);
  }
  inline void GetCreativeScanningMetadataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreativeScanningMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `creative_scanning_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCreativeScanningMetadata` instead "
    "of `ReadCreativeScanningMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->creative_scanning_metadata.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreativeInfoWithoutOwner_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ComponentAuctionOtherSellerDataView {
 public:
  using Tag = internal::ComponentAuctionOtherSeller_Data::ComponentAuctionOtherSeller_Tag;

  ComponentAuctionOtherSellerDataView() = default;

  ComponentAuctionOtherSellerDataView(
      internal::ComponentAuctionOtherSeller_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_top_level_seller() const { return data_->tag == Tag::kTopLevelSeller; }
  inline void GetTopLevelSellerDataView(
      ::url::mojom::OriginDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelSeller(UserType* output) const {
    
    CHECK(is_top_level_seller());
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        data_->data.f_top_level_seller.Get(), output, message_);
  }
  bool is_component_seller() const { return data_->tag == Tag::kComponentSeller; }
  inline void GetComponentSellerDataView(
      ::url::mojom::OriginDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadComponentSeller(UserType* output) const {
    
    CHECK(is_component_seller());
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        data_->data.f_component_seller.Get(), output, message_);
  }

 private:
  internal::ComponentAuctionOtherSeller_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // auction_worklet::mojom

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_DATA_VIEW_H_