// content/services/auction_worklet/public/mojom/private_aggregation_request.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-features.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/int128.mojom.h"
#include "third_party/blink/public/mojom/aggregation_service/aggregatable_report.mojom.h"
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom.h"
#include <string>
#include <vector>




#include "content/common/content_export.h"




namespace auction_worklet::mojom {







class CONTENT_EXPORT SignalValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignalValue, T>::value>;
  using DataView = SignalValueDataView;
  using Data_ = internal::SignalValue_Data;

  template <typename... Args>
  static SignalValuePtr New(Args&&... args) {
    return SignalValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignalValuePtr From(const U& u) {
    return mojo::TypeConverter<SignalValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignalValue>::Convert(*this);
  }


  SignalValue();

  SignalValue(
      BaseValue base_value,
      double scale,
      int32_t offset);


  ~SignalValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignalValuePtr>
  SignalValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignalValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SignalValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SignalValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignalValue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignalValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignalValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignalValue_UnserializedMessageContext<
            UserType, SignalValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SignalValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SignalValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignalValue_UnserializedMessageContext<
            UserType, SignalValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignalValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BaseValue base_value;
  
  double scale;
  
  int32_t offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignalValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignalValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignalValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignalValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class CONTENT_EXPORT ForEventSignalBucket {
 public:
  using DataView = ForEventSignalBucketDataView;
  using Data_ = internal::ForEventSignalBucket_Data;
  using Tag = Data_::ForEventSignalBucket_Tag;

  template <typename... Args>
  static ForEventSignalBucketPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |id_bucket|.
  static ForEventSignalBucketPtr NewIdBucket(
      const ::absl::uint128& value);
  // Construct an instance holding |signal_bucket|.
  static ForEventSignalBucketPtr NewSignalBucket(
      SignalBucketPtr value);

  template <typename U>
  static ForEventSignalBucketPtr From(const U& u) {
    return mojo::TypeConverter<ForEventSignalBucketPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ForEventSignalBucket>::Convert(*this);
  }
  ~ForEventSignalBucket();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ForEventSignalBucket(const ForEventSignalBucket& other) = delete;
  ForEventSignalBucket& operator=(const ForEventSignalBucket& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ForEventSignalBucketPtr>
  ForEventSignalBucketPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ForEventSignalBucket>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ForEventSignalBucket>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_id_bucket() const { return tag_ == Tag::kIdBucket; }
  const ::absl::uint128& get_id_bucket() const {
    CHECK(tag_ == Tag::kIdBucket);
    return data_.id_bucket;
  }
  ::absl::uint128& get_id_bucket() {
    CHECK(tag_ == Tag::kIdBucket);
    return data_.id_bucket;
  }
  void set_id_bucket(const ::absl::uint128& id_bucket);

  bool is_signal_bucket() const { return tag_ == Tag::kSignalBucket; }
  const SignalBucketPtr& get_signal_bucket() const {
    CHECK(tag_ == Tag::kSignalBucket);
    return data_.signal_bucket;
  }
  SignalBucketPtr& get_signal_bucket() {
    CHECK(tag_ == Tag::kSignalBucket);
    return data_.signal_bucket;
  }
  void set_signal_bucket(SignalBucketPtr signal_bucket);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ForEventSignalBucket::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ForEventSignalBucket::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kIdBucket)>,
        const ::absl::uint128& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSignalBucket)>,
        SignalBucketPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::absl::uint128 id_bucket;
    SignalBucketPtr signal_bucket;
  };

  ForEventSignalBucket(
      std::in_place_index_t<static_cast<size_t>(Tag::kIdBucket)>,
      const ::absl::uint128& value);
  ForEventSignalBucket(
      std::in_place_index_t<static_cast<size_t>(Tag::kSignalBucket)>,
      SignalBucketPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class CONTENT_EXPORT ForEventSignalValue {
 public:
  using DataView = ForEventSignalValueDataView;
  using Data_ = internal::ForEventSignalValue_Data;
  using Tag = Data_::ForEventSignalValue_Tag;

  template <typename... Args>
  static ForEventSignalValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |int_value|.
  static ForEventSignalValuePtr NewIntValue(
      int32_t value);
  // Construct an instance holding |signal_value|.
  static ForEventSignalValuePtr NewSignalValue(
      SignalValuePtr value);

  template <typename U>
  static ForEventSignalValuePtr From(const U& u) {
    return mojo::TypeConverter<ForEventSignalValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ForEventSignalValue>::Convert(*this);
  }
  ~ForEventSignalValue();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ForEventSignalValue(const ForEventSignalValue& other) = delete;
  ForEventSignalValue& operator=(const ForEventSignalValue& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ForEventSignalValuePtr>
  ForEventSignalValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ForEventSignalValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ForEventSignalValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_int_value() const { return tag_ == Tag::kIntValue; }
  int32_t get_int_value() const {
    CHECK(tag_ == Tag::kIntValue);
    return data_.int_value;
  }
  void set_int_value(int32_t int_value);

  bool is_signal_value() const { return tag_ == Tag::kSignalValue; }
  const SignalValuePtr& get_signal_value() const {
    CHECK(tag_ == Tag::kSignalValue);
    return data_.signal_value;
  }
  SignalValuePtr& get_signal_value() {
    CHECK(tag_ == Tag::kSignalValue);
    return data_.signal_value;
  }
  void set_signal_value(SignalValuePtr signal_value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ForEventSignalValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ForEventSignalValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
        int32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSignalValue)>,
        SignalValuePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    int32_t int_value;
    SignalValuePtr signal_value;
  };

  ForEventSignalValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
      int32_t value);
  ForEventSignalValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kSignalValue)>,
      SignalValuePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class CONTENT_EXPORT EventType {
 public:
  using DataView = EventTypeDataView;
  using Data_ = internal::EventType_Data;
  using Tag = Data_::EventType_Tag;

  template <typename... Args>
  static EventTypePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |reserved_non_error|.
  static EventTypePtr NewReservedNonError(
      ReservedNonErrorEventType value);
  // Construct an instance holding |reserved_error|.
  static EventTypePtr NewReservedError(
      ReservedErrorEventType value);
  // Construct an instance holding |non_reserved|.
  static EventTypePtr NewNonReserved(
      const std::string& value);

  template <typename U>
  static EventTypePtr From(const U& u) {
    return mojo::TypeConverter<EventTypePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EventType>::Convert(*this);
  }
  ~EventType();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  EventType(const EventType& other) = delete;
  EventType& operator=(const EventType& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = EventTypePtr>
  EventTypePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, EventType>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, EventType>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_reserved_non_error() const { return tag_ == Tag::kReservedNonError; }
  ReservedNonErrorEventType get_reserved_non_error() const {
    CHECK(tag_ == Tag::kReservedNonError);
    return data_.reserved_non_error;
  }
  void set_reserved_non_error(ReservedNonErrorEventType reserved_non_error);

  bool is_reserved_error() const { return tag_ == Tag::kReservedError; }
  ReservedErrorEventType get_reserved_error() const {
    CHECK(tag_ == Tag::kReservedError);
    return data_.reserved_error;
  }
  void set_reserved_error(ReservedErrorEventType reserved_error);

  bool is_non_reserved() const { return tag_ == Tag::kNonReserved; }
  const std::string& get_non_reserved() const {
    CHECK(tag_ == Tag::kNonReserved);
    return data_.non_reserved;
  }
  std::string& get_non_reserved() {
    CHECK(tag_ == Tag::kNonReserved);
    return data_.non_reserved;
  }
  void set_non_reserved(const std::string& non_reserved);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EventType::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<EventType::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReservedNonError)>,
        ReservedNonErrorEventType value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReservedError)>,
        ReservedErrorEventType value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNonReserved)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ReservedNonErrorEventType reserved_non_error;
    ReservedErrorEventType reserved_error;
    std::string non_reserved;
  };

  EventType(
      std::in_place_index_t<static_cast<size_t>(Tag::kReservedNonError)>,
      ReservedNonErrorEventType value);
  EventType(
      std::in_place_index_t<static_cast<size_t>(Tag::kReservedError)>,
      ReservedErrorEventType value);
  EventType(
      std::in_place_index_t<static_cast<size_t>(Tag::kNonReserved)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class CONTENT_EXPORT AggregatableReportContribution {
 public:
  using DataView = AggregatableReportContributionDataView;
  using Data_ = internal::AggregatableReportContribution_Data;
  using Tag = Data_::AggregatableReportContribution_Tag;

  template <typename... Args>
  static AggregatableReportContributionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |histogram_contribution|.
  static AggregatableReportContributionPtr NewHistogramContribution(
      ::blink::mojom::AggregatableReportHistogramContributionPtr value);
  // Construct an instance holding |for_event_contribution|.
  static AggregatableReportContributionPtr NewForEventContribution(
      AggregatableReportForEventContributionPtr value);

  template <typename U>
  static AggregatableReportContributionPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableReportContributionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableReportContribution>::Convert(*this);
  }
  ~AggregatableReportContribution();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AggregatableReportContribution(const AggregatableReportContribution& other) = delete;
  AggregatableReportContribution& operator=(const AggregatableReportContribution& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AggregatableReportContributionPtr>
  AggregatableReportContributionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AggregatableReportContribution>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AggregatableReportContribution>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_histogram_contribution() const { return tag_ == Tag::kHistogramContribution; }
  const ::blink::mojom::AggregatableReportHistogramContributionPtr& get_histogram_contribution() const {
    CHECK(tag_ == Tag::kHistogramContribution);
    return data_.histogram_contribution;
  }
  ::blink::mojom::AggregatableReportHistogramContributionPtr& get_histogram_contribution() {
    CHECK(tag_ == Tag::kHistogramContribution);
    return data_.histogram_contribution;
  }
  void set_histogram_contribution(::blink::mojom::AggregatableReportHistogramContributionPtr histogram_contribution);

  bool is_for_event_contribution() const { return tag_ == Tag::kForEventContribution; }
  const AggregatableReportForEventContributionPtr& get_for_event_contribution() const {
    CHECK(tag_ == Tag::kForEventContribution);
    return data_.for_event_contribution;
  }
  AggregatableReportForEventContributionPtr& get_for_event_contribution() {
    CHECK(tag_ == Tag::kForEventContribution);
    return data_.for_event_contribution;
  }
  void set_for_event_contribution(AggregatableReportForEventContributionPtr for_event_contribution);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableReportContribution::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AggregatableReportContribution::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kHistogramContribution)>,
        ::blink::mojom::AggregatableReportHistogramContributionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kForEventContribution)>,
        AggregatableReportForEventContributionPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::mojom::AggregatableReportHistogramContributionPtr histogram_contribution;
    AggregatableReportForEventContributionPtr for_event_contribution;
  };

  AggregatableReportContribution(
      std::in_place_index_t<static_cast<size_t>(Tag::kHistogramContribution)>,
      ::blink::mojom::AggregatableReportHistogramContributionPtr value);
  AggregatableReportContribution(
      std::in_place_index_t<static_cast<size_t>(Tag::kForEventContribution)>,
      AggregatableReportForEventContributionPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class CONTENT_EXPORT BucketOffset {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BucketOffset, T>::value>;
  using DataView = BucketOffsetDataView;
  using Data_ = internal::BucketOffset_Data;

  template <typename... Args>
  static BucketOffsetPtr New(Args&&... args) {
    return BucketOffsetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BucketOffsetPtr From(const U& u) {
    return mojo::TypeConverter<BucketOffsetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BucketOffset>::Convert(*this);
  }


  BucketOffset();

  BucketOffset(
      const ::absl::uint128& value,
      bool is_negative);


  ~BucketOffset();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BucketOffsetPtr>
  BucketOffsetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BucketOffset::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BucketOffset::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BucketOffset::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BucketOffset::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BucketOffset::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BucketOffset::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BucketOffset_UnserializedMessageContext<
            UserType, BucketOffset::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BucketOffset::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BucketOffset::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BucketOffset_UnserializedMessageContext<
            UserType, BucketOffset::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BucketOffset::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::absl::uint128 value;
  
  bool is_negative;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BucketOffset::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BucketOffset::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BucketOffset::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BucketOffset::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT SignalBucket {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignalBucket, T>::value>;
  using DataView = SignalBucketDataView;
  using Data_ = internal::SignalBucket_Data;

  template <typename... Args>
  static SignalBucketPtr New(Args&&... args) {
    return SignalBucketPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignalBucketPtr From(const U& u) {
    return mojo::TypeConverter<SignalBucketPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignalBucket>::Convert(*this);
  }


  SignalBucket();

  SignalBucket(
      BaseValue base_value,
      double scale,
      BucketOffsetPtr offset);

SignalBucket(const SignalBucket&) = delete;
SignalBucket& operator=(const SignalBucket&) = delete;

  ~SignalBucket();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignalBucketPtr>
  SignalBucketPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignalBucket::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SignalBucket::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SignalBucket::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignalBucket::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignalBucket::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignalBucket::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignalBucket_UnserializedMessageContext<
            UserType, SignalBucket::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SignalBucket::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SignalBucket::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignalBucket_UnserializedMessageContext<
            UserType, SignalBucket::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignalBucket::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BaseValue base_value;
  
  double scale;
  
  BucketOffsetPtr offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignalBucket::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignalBucket::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignalBucket::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignalBucket::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class CONTENT_EXPORT AggregatableReportForEventContribution {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatableReportForEventContribution, T>::value>;
  using DataView = AggregatableReportForEventContributionDataView;
  using Data_ = internal::AggregatableReportForEventContribution_Data;

  template <typename... Args>
  static AggregatableReportForEventContributionPtr New(Args&&... args) {
    return AggregatableReportForEventContributionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatableReportForEventContributionPtr From(const U& u) {
    return mojo::TypeConverter<AggregatableReportForEventContributionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatableReportForEventContribution>::Convert(*this);
  }


  AggregatableReportForEventContribution();

  AggregatableReportForEventContribution(
      ForEventSignalBucketPtr bucket,
      ForEventSignalValuePtr value,
      std::optional<uint64_t> filtering_id,
      EventTypePtr event_type);

AggregatableReportForEventContribution(const AggregatableReportForEventContribution&) = delete;
AggregatableReportForEventContribution& operator=(const AggregatableReportForEventContribution&) = delete;

  ~AggregatableReportForEventContribution();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatableReportForEventContributionPtr>
  AggregatableReportForEventContributionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatableReportForEventContribution::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatableReportForEventContribution::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatableReportForEventContribution::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableReportForEventContribution::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatableReportForEventContribution::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatableReportForEventContribution::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatableReportForEventContribution_UnserializedMessageContext<
            UserType, AggregatableReportForEventContribution::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatableReportForEventContribution::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatableReportForEventContribution::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatableReportForEventContribution_UnserializedMessageContext<
            UserType, AggregatableReportForEventContribution::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatableReportForEventContribution::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ForEventSignalBucketPtr bucket;
  
  ForEventSignalValuePtr value;
  
  std::optional<uint64_t> filtering_id;
  
  EventTypePtr event_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatableReportForEventContribution::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatableReportForEventContribution::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatableReportForEventContribution::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatableReportForEventContribution::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT PrivateAggregationRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrivateAggregationRequest, T>::value>;
  using DataView = PrivateAggregationRequestDataView;
  using Data_ = internal::PrivateAggregationRequest_Data;

  template <typename... Args>
  static PrivateAggregationRequestPtr New(Args&&... args) {
    return PrivateAggregationRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrivateAggregationRequestPtr From(const U& u) {
    return mojo::TypeConverter<PrivateAggregationRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrivateAggregationRequest>::Convert(*this);
  }


  PrivateAggregationRequest();

  PrivateAggregationRequest(
      AggregatableReportContributionPtr contribution,
      ::blink::mojom::DebugModeDetailsPtr debug_mode_details);

PrivateAggregationRequest(const PrivateAggregationRequest&) = delete;
PrivateAggregationRequest& operator=(const PrivateAggregationRequest&) = delete;

  ~PrivateAggregationRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrivateAggregationRequestPtr>
  PrivateAggregationRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrivateAggregationRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrivateAggregationRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrivateAggregationRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivateAggregationRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivateAggregationRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrivateAggregationRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrivateAggregationRequest_UnserializedMessageContext<
            UserType, PrivateAggregationRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrivateAggregationRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrivateAggregationRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrivateAggregationRequest_UnserializedMessageContext<
            UserType, PrivateAggregationRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrivateAggregationRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AggregatableReportContributionPtr contribution;
  
  ::blink::mojom::DebugModeDetailsPtr debug_mode_details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrivateAggregationRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrivateAggregationRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrivateAggregationRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrivateAggregationRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT FinalizedPrivateAggregationRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FinalizedPrivateAggregationRequest, T>::value>;
  using DataView = FinalizedPrivateAggregationRequestDataView;
  using Data_ = internal::FinalizedPrivateAggregationRequest_Data;

  template <typename... Args>
  static FinalizedPrivateAggregationRequestPtr New(Args&&... args) {
    return FinalizedPrivateAggregationRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FinalizedPrivateAggregationRequestPtr From(const U& u) {
    return mojo::TypeConverter<FinalizedPrivateAggregationRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FinalizedPrivateAggregationRequest>::Convert(*this);
  }


  FinalizedPrivateAggregationRequest();

  FinalizedPrivateAggregationRequest(
      ::blink::mojom::AggregatableReportHistogramContributionPtr contribution,
      ::blink::mojom::DebugModeDetailsPtr debug_mode_details,
      std::optional<::blink::mojom::PrivateAggregationErrorEvent> error_event);

FinalizedPrivateAggregationRequest(const FinalizedPrivateAggregationRequest&) = delete;
FinalizedPrivateAggregationRequest& operator=(const FinalizedPrivateAggregationRequest&) = delete;

  ~FinalizedPrivateAggregationRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FinalizedPrivateAggregationRequestPtr>
  FinalizedPrivateAggregationRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FinalizedPrivateAggregationRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FinalizedPrivateAggregationRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FinalizedPrivateAggregationRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FinalizedPrivateAggregationRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FinalizedPrivateAggregationRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FinalizedPrivateAggregationRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FinalizedPrivateAggregationRequest_UnserializedMessageContext<
            UserType, FinalizedPrivateAggregationRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FinalizedPrivateAggregationRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FinalizedPrivateAggregationRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FinalizedPrivateAggregationRequest_UnserializedMessageContext<
            UserType, FinalizedPrivateAggregationRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FinalizedPrivateAggregationRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::AggregatableReportHistogramContributionPtr contribution;
  
  ::blink::mojom::DebugModeDetailsPtr debug_mode_details;
  
  std::optional<::blink::mojom::PrivateAggregationErrorEvent> error_event;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FinalizedPrivateAggregationRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FinalizedPrivateAggregationRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FinalizedPrivateAggregationRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FinalizedPrivateAggregationRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ForEventSignalBucketPtr ForEventSignalBucket::Clone() const {
  switch (tag_) {
    case Tag::kIdBucket:
      return NewIdBucket(
          mojo::Clone(data_.id_bucket));
    case Tag::kSignalBucket:
      return NewSignalBucket(
          mojo::Clone(data_.signal_bucket));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ForEventSignalBucket>::value>::type*>
bool ForEventSignalBucket::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kIdBucket:
      return mojo::Equals(data_.id_bucket, other.data_.id_bucket);
    case Tag::kSignalBucket:
      return mojo::Equals(data_.signal_bucket, other.data_.signal_bucket);
  }

  return false;
}
template <typename UnionPtrType>
ForEventSignalValuePtr ForEventSignalValue::Clone() const {
  switch (tag_) {
    case Tag::kIntValue:
      return NewIntValue(
          mojo::Clone(data_.int_value));
    case Tag::kSignalValue:
      return NewSignalValue(
          mojo::Clone(data_.signal_value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ForEventSignalValue>::value>::type*>
bool ForEventSignalValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kIntValue:
      return mojo::Equals(data_.int_value, other.data_.int_value);
    case Tag::kSignalValue:
      return mojo::Equals(data_.signal_value, other.data_.signal_value);
  }

  return false;
}
template <typename UnionPtrType>
EventTypePtr EventType::Clone() const {
  switch (tag_) {
    case Tag::kReservedNonError:
      return NewReservedNonError(
          mojo::Clone(data_.reserved_non_error));
    case Tag::kReservedError:
      return NewReservedError(
          mojo::Clone(data_.reserved_error));
    case Tag::kNonReserved:
      return NewNonReserved(
          mojo::Clone(data_.non_reserved));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, EventType>::value>::type*>
bool EventType::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kReservedNonError:
      return mojo::Equals(data_.reserved_non_error, other.data_.reserved_non_error);
    case Tag::kReservedError:
      return mojo::Equals(data_.reserved_error, other.data_.reserved_error);
    case Tag::kNonReserved:
      return mojo::Equals(data_.non_reserved, other.data_.non_reserved);
  }

  return false;
}
template <typename UnionPtrType>
AggregatableReportContributionPtr AggregatableReportContribution::Clone() const {
  switch (tag_) {
    case Tag::kHistogramContribution:
      return NewHistogramContribution(
          mojo::Clone(data_.histogram_contribution));
    case Tag::kForEventContribution:
      return NewForEventContribution(
          mojo::Clone(data_.for_event_contribution));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AggregatableReportContribution>::value>::type*>
bool AggregatableReportContribution::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kHistogramContribution:
      return mojo::Equals(data_.histogram_contribution, other.data_.histogram_contribution);
    case Tag::kForEventContribution:
      return mojo::Equals(data_.for_event_contribution, other.data_.for_event_contribution);
  }

  return false;
}
template <typename StructPtrType>
BucketOffsetPtr BucketOffset::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(is_negative)
  );
}

template <typename T, BucketOffset::EnableIfSame<T>*>
bool BucketOffset::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->is_negative, other_struct.is_negative))
    return false;
  return true;
}

template <typename T, BucketOffset::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.is_negative < rhs.is_negative)
    return true;
  if (rhs.is_negative < lhs.is_negative)
    return false;
  return false;
}
template <typename StructPtrType>
SignalBucketPtr SignalBucket::Clone() const {
  return New(
      mojo::Clone(base_value),
      mojo::Clone(scale),
      mojo::Clone(offset)
  );
}

template <typename T, SignalBucket::EnableIfSame<T>*>
bool SignalBucket::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->base_value, other_struct.base_value))
    return false;
  if (!mojo::Equals(this->scale, other_struct.scale))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  return true;
}

template <typename T, SignalBucket::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.base_value < rhs.base_value)
    return true;
  if (rhs.base_value < lhs.base_value)
    return false;
  if (lhs.scale < rhs.scale)
    return true;
  if (rhs.scale < lhs.scale)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  return false;
}
template <typename StructPtrType>
SignalValuePtr SignalValue::Clone() const {
  return New(
      mojo::Clone(base_value),
      mojo::Clone(scale),
      mojo::Clone(offset)
  );
}

template <typename T, SignalValue::EnableIfSame<T>*>
bool SignalValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->base_value, other_struct.base_value))
    return false;
  if (!mojo::Equals(this->scale, other_struct.scale))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  return true;
}

template <typename T, SignalValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.base_value < rhs.base_value)
    return true;
  if (rhs.base_value < lhs.base_value)
    return false;
  if (lhs.scale < rhs.scale)
    return true;
  if (rhs.scale < lhs.scale)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  return false;
}
template <typename StructPtrType>
AggregatableReportForEventContributionPtr AggregatableReportForEventContribution::Clone() const {
  return New(
      mojo::Clone(bucket),
      mojo::Clone(value),
      mojo::Clone(filtering_id),
      mojo::Clone(event_type)
  );
}

template <typename T, AggregatableReportForEventContribution::EnableIfSame<T>*>
bool AggregatableReportForEventContribution::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bucket, other_struct.bucket))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->filtering_id, other_struct.filtering_id))
    return false;
  if (!mojo::Equals(this->event_type, other_struct.event_type))
    return false;
  return true;
}

template <typename T, AggregatableReportForEventContribution::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bucket < rhs.bucket)
    return true;
  if (rhs.bucket < lhs.bucket)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.filtering_id < rhs.filtering_id)
    return true;
  if (rhs.filtering_id < lhs.filtering_id)
    return false;
  if (lhs.event_type < rhs.event_type)
    return true;
  if (rhs.event_type < lhs.event_type)
    return false;
  return false;
}
template <typename StructPtrType>
PrivateAggregationRequestPtr PrivateAggregationRequest::Clone() const {
  return New(
      mojo::Clone(contribution),
      mojo::Clone(debug_mode_details)
  );
}

template <typename T, PrivateAggregationRequest::EnableIfSame<T>*>
bool PrivateAggregationRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->contribution, other_struct.contribution))
    return false;
  if (!mojo::Equals(this->debug_mode_details, other_struct.debug_mode_details))
    return false;
  return true;
}

template <typename T, PrivateAggregationRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.contribution < rhs.contribution)
    return true;
  if (rhs.contribution < lhs.contribution)
    return false;
  if (lhs.debug_mode_details < rhs.debug_mode_details)
    return true;
  if (rhs.debug_mode_details < lhs.debug_mode_details)
    return false;
  return false;
}
template <typename StructPtrType>
FinalizedPrivateAggregationRequestPtr FinalizedPrivateAggregationRequest::Clone() const {
  return New(
      mojo::Clone(contribution),
      mojo::Clone(debug_mode_details),
      mojo::Clone(error_event)
  );
}

template <typename T, FinalizedPrivateAggregationRequest::EnableIfSame<T>*>
bool FinalizedPrivateAggregationRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->contribution, other_struct.contribution))
    return false;
  if (!mojo::Equals(this->debug_mode_details, other_struct.debug_mode_details))
    return false;
  if (!mojo::Equals(this->error_event, other_struct.error_event))
    return false;
  return true;
}

template <typename T, FinalizedPrivateAggregationRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.contribution < rhs.contribution)
    return true;
  if (rhs.contribution < lhs.contribution)
    return false;
  if (lhs.debug_mode_details < rhs.debug_mode_details)
    return true;
  if (rhs.debug_mode_details < lhs.debug_mode_details)
    return false;
  if (lhs.error_event < rhs.error_event)
    return true;
  if (rhs.error_event < lhs.error_event)
    return false;
  return false;
}


}  // auction_worklet::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::BucketOffset::DataView,
                                         ::auction_worklet::mojom::BucketOffsetPtr> {
  static bool IsNull(const ::auction_worklet::mojom::BucketOffsetPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::BucketOffsetPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::BucketOffset::value)& value(
      const ::auction_worklet::mojom::BucketOffsetPtr& input) {
    return input->value;
  }

  static decltype(::auction_worklet::mojom::BucketOffset::is_negative) is_negative(
      const ::auction_worklet::mojom::BucketOffsetPtr& input) {
    return input->is_negative;
  }

  static bool Read(::auction_worklet::mojom::BucketOffset::DataView input, ::auction_worklet::mojom::BucketOffsetPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::SignalBucket::DataView,
                                         ::auction_worklet::mojom::SignalBucketPtr> {
  static bool IsNull(const ::auction_worklet::mojom::SignalBucketPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::SignalBucketPtr* output) { output->reset(); }

  static decltype(::auction_worklet::mojom::SignalBucket::base_value) base_value(
      const ::auction_worklet::mojom::SignalBucketPtr& input) {
    return input->base_value;
  }

  static decltype(::auction_worklet::mojom::SignalBucket::scale) scale(
      const ::auction_worklet::mojom::SignalBucketPtr& input) {
    return input->scale;
  }

  static const decltype(::auction_worklet::mojom::SignalBucket::offset)& offset(
      const ::auction_worklet::mojom::SignalBucketPtr& input) {
    return input->offset;
  }

  static bool Read(::auction_worklet::mojom::SignalBucket::DataView input, ::auction_worklet::mojom::SignalBucketPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::SignalValue::DataView,
                                         ::auction_worklet::mojom::SignalValuePtr> {
  static bool IsNull(const ::auction_worklet::mojom::SignalValuePtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::SignalValuePtr* output) { output->reset(); }

  static decltype(::auction_worklet::mojom::SignalValue::base_value) base_value(
      const ::auction_worklet::mojom::SignalValuePtr& input) {
    return input->base_value;
  }

  static decltype(::auction_worklet::mojom::SignalValue::scale) scale(
      const ::auction_worklet::mojom::SignalValuePtr& input) {
    return input->scale;
  }

  static decltype(::auction_worklet::mojom::SignalValue::offset) offset(
      const ::auction_worklet::mojom::SignalValuePtr& input) {
    return input->offset;
  }

  static bool Read(::auction_worklet::mojom::SignalValue::DataView input, ::auction_worklet::mojom::SignalValuePtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::AggregatableReportForEventContribution::DataView,
                                         ::auction_worklet::mojom::AggregatableReportForEventContributionPtr> {
  static bool IsNull(const ::auction_worklet::mojom::AggregatableReportForEventContributionPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::AggregatableReportForEventContributionPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::AggregatableReportForEventContribution::bucket)& bucket(
      const ::auction_worklet::mojom::AggregatableReportForEventContributionPtr& input) {
    return input->bucket;
  }

  static const decltype(::auction_worklet::mojom::AggregatableReportForEventContribution::value)& value(
      const ::auction_worklet::mojom::AggregatableReportForEventContributionPtr& input) {
    return input->value;
  }

  static decltype(::auction_worklet::mojom::AggregatableReportForEventContribution::filtering_id) filtering_id(
      const ::auction_worklet::mojom::AggregatableReportForEventContributionPtr& input) {
    return input->filtering_id;
  }

  static const decltype(::auction_worklet::mojom::AggregatableReportForEventContribution::event_type)& event_type(
      const ::auction_worklet::mojom::AggregatableReportForEventContributionPtr& input) {
    return input->event_type;
  }

  static bool Read(::auction_worklet::mojom::AggregatableReportForEventContribution::DataView input, ::auction_worklet::mojom::AggregatableReportForEventContributionPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::PrivateAggregationRequest::DataView,
                                         ::auction_worklet::mojom::PrivateAggregationRequestPtr> {
  static bool IsNull(const ::auction_worklet::mojom::PrivateAggregationRequestPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::PrivateAggregationRequestPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::PrivateAggregationRequest::contribution)& contribution(
      const ::auction_worklet::mojom::PrivateAggregationRequestPtr& input) {
    return input->contribution;
  }

  static const decltype(::auction_worklet::mojom::PrivateAggregationRequest::debug_mode_details)& debug_mode_details(
      const ::auction_worklet::mojom::PrivateAggregationRequestPtr& input) {
    return input->debug_mode_details;
  }

  static bool Read(::auction_worklet::mojom::PrivateAggregationRequest::DataView input, ::auction_worklet::mojom::PrivateAggregationRequestPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::FinalizedPrivateAggregationRequest::DataView,
                                         ::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr> {
  static bool IsNull(const ::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::FinalizedPrivateAggregationRequest::contribution)& contribution(
      const ::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr& input) {
    return input->contribution;
  }

  static const decltype(::auction_worklet::mojom::FinalizedPrivateAggregationRequest::debug_mode_details)& debug_mode_details(
      const ::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr& input) {
    return input->debug_mode_details;
  }

  static decltype(::auction_worklet::mojom::FinalizedPrivateAggregationRequest::error_event) error_event(
      const ::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr& input) {
    return input->error_event;
  }

  static bool Read(::auction_worklet::mojom::FinalizedPrivateAggregationRequest::DataView input, ::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr* output);
};


template <>
struct CONTENT_EXPORT UnionTraits<::auction_worklet::mojom::ForEventSignalBucket::DataView,
                                        ::auction_worklet::mojom::ForEventSignalBucketPtr> {
  static bool IsNull(const ::auction_worklet::mojom::ForEventSignalBucketPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::ForEventSignalBucketPtr* output) { output->reset(); }

  static ::auction_worklet::mojom::ForEventSignalBucket::Tag GetTag(const ::auction_worklet::mojom::ForEventSignalBucketPtr& input) {
    return input->which();
  }

  static const ::absl::uint128& id_bucket(const ::auction_worklet::mojom::ForEventSignalBucketPtr& input) {
    return input->get_id_bucket();
  }

  static const ::auction_worklet::mojom::SignalBucketPtr& signal_bucket(const ::auction_worklet::mojom::ForEventSignalBucketPtr& input) {
    return input->get_signal_bucket();
  }

  static bool Read(::auction_worklet::mojom::ForEventSignalBucket::DataView input, ::auction_worklet::mojom::ForEventSignalBucketPtr* output);
};


template <>
struct CONTENT_EXPORT UnionTraits<::auction_worklet::mojom::ForEventSignalValue::DataView,
                                        ::auction_worklet::mojom::ForEventSignalValuePtr> {
  static bool IsNull(const ::auction_worklet::mojom::ForEventSignalValuePtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::ForEventSignalValuePtr* output) { output->reset(); }

  static ::auction_worklet::mojom::ForEventSignalValue::Tag GetTag(const ::auction_worklet::mojom::ForEventSignalValuePtr& input) {
    return input->which();
  }

  static  int32_t int_value(const ::auction_worklet::mojom::ForEventSignalValuePtr& input) {
    return input->get_int_value();
  }

  static const ::auction_worklet::mojom::SignalValuePtr& signal_value(const ::auction_worklet::mojom::ForEventSignalValuePtr& input) {
    return input->get_signal_value();
  }

  static bool Read(::auction_worklet::mojom::ForEventSignalValue::DataView input, ::auction_worklet::mojom::ForEventSignalValuePtr* output);
};


template <>
struct CONTENT_EXPORT UnionTraits<::auction_worklet::mojom::EventType::DataView,
                                        ::auction_worklet::mojom::EventTypePtr> {
  static bool IsNull(const ::auction_worklet::mojom::EventTypePtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::EventTypePtr* output) { output->reset(); }

  static ::auction_worklet::mojom::EventType::Tag GetTag(const ::auction_worklet::mojom::EventTypePtr& input) {
    return input->which();
  }

  static  ::auction_worklet::mojom::ReservedNonErrorEventType reserved_non_error(const ::auction_worklet::mojom::EventTypePtr& input) {
    return input->get_reserved_non_error();
  }

  static  ::auction_worklet::mojom::ReservedErrorEventType reserved_error(const ::auction_worklet::mojom::EventTypePtr& input) {
    return input->get_reserved_error();
  }

  static const std::string& non_reserved(const ::auction_worklet::mojom::EventTypePtr& input) {
    return input->get_non_reserved();
  }

  static bool Read(::auction_worklet::mojom::EventType::DataView input, ::auction_worklet::mojom::EventTypePtr* output);
};


template <>
struct CONTENT_EXPORT UnionTraits<::auction_worklet::mojom::AggregatableReportContribution::DataView,
                                        ::auction_worklet::mojom::AggregatableReportContributionPtr> {
  static bool IsNull(const ::auction_worklet::mojom::AggregatableReportContributionPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::AggregatableReportContributionPtr* output) { output->reset(); }

  static ::auction_worklet::mojom::AggregatableReportContribution::Tag GetTag(const ::auction_worklet::mojom::AggregatableReportContributionPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::AggregatableReportHistogramContributionPtr& histogram_contribution(const ::auction_worklet::mojom::AggregatableReportContributionPtr& input) {
    return input->get_histogram_contribution();
  }

  static const ::auction_worklet::mojom::AggregatableReportForEventContributionPtr& for_event_contribution(const ::auction_worklet::mojom::AggregatableReportContributionPtr& input) {
    return input->get_for_event_contribution();
  }

  static bool Read(::auction_worklet::mojom::AggregatableReportContribution::DataView input, ::auction_worklet::mojom::AggregatableReportContributionPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_H_