// content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_SHARED_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "third_party/blink/public/mojom/aggregation_service/aggregatable_report.mojom-shared.h"
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-shared.h"




#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::auction_worklet::mojom::BaseValue>
    : public mojo::internal::EnumHashImpl<::auction_worklet::mojom::BaseValue> {};

template <>
struct hash<::auction_worklet::mojom::ReservedNonErrorEventType>
    : public mojo::internal::EnumHashImpl<::auction_worklet::mojom::ReservedNonErrorEventType> {};

template <>
struct hash<::auction_worklet::mojom::ReservedErrorEventType>
    : public mojo::internal::EnumHashImpl<::auction_worklet::mojom::ReservedErrorEventType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::BaseValue, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::auction_worklet::mojom::BaseValue, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::BaseValue>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ReservedNonErrorEventType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::auction_worklet::mojom::ReservedNonErrorEventType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::ReservedNonErrorEventType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ReservedErrorEventType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::auction_worklet::mojom::ReservedErrorEventType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::ReservedErrorEventType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::BucketOffsetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BucketOffsetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BucketOffset_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in BucketOffset struct");

    fragment->is_negative = Traits::is_negative(input);
  }

  static bool Deserialize(::auction_worklet::mojom::internal::BucketOffset_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::BucketOffsetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::SignalBucketDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::SignalBucketDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::SignalBucket_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::auction_worklet::mojom::BaseValue>(
      Traits::base_value(input),
      &fragment->base_value);

    fragment->scale = Traits::scale(input);

    decltype(Traits::offset(input)) in_offset = Traits::offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offset)::BaseType> offset_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::auction_worklet::mojom::BucketOffsetDataView>(
      in_offset,
      offset_fragment);

    fragment->offset.Set(
        offset_fragment.is_null() ? nullptr : offset_fragment.data());
  }

  static bool Deserialize(::auction_worklet::mojom::internal::SignalBucket_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::SignalBucketDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::SignalValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::SignalValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::SignalValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::auction_worklet::mojom::BaseValue>(
      Traits::base_value(input),
      &fragment->base_value);

    fragment->scale = Traits::scale(input);

    fragment->offset = Traits::offset(input);
  }

  static bool Deserialize(::auction_worklet::mojom::internal::SignalValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::SignalValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::AggregatableReportForEventContributionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::AggregatableReportForEventContributionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::AggregatableReportForEventContribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bucket(input)) in_bucket = Traits::bucket(input);
    mojo::internal::MessageFragment<decltype(fragment->bucket)>
        bucket_fragment(fragment.message());
    bucket_fragment.Claim(&fragment->bucket);
    
    mojo::internal::Serialize<::auction_worklet::mojom::ForEventSignalBucketDataView>(
      in_bucket,
      bucket_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bucket.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket in AggregatableReportForEventContribution struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<decltype(fragment->value)>
        value_fragment(fragment.message());
    value_fragment.Claim(&fragment->value);
    
    mojo::internal::Serialize<::auction_worklet::mojom::ForEventSignalValueDataView>(
      in_value,
      value_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in AggregatableReportForEventContribution struct");
    fragment->filtering_id_$flag = Traits::filtering_id(input).has_value();
    if (Traits::filtering_id(input).has_value()) {
      fragment->filtering_id_$value = Traits::filtering_id(input).value();
    }

    decltype(Traits::event_type(input)) in_event_type = Traits::event_type(input);
    mojo::internal::MessageFragment<decltype(fragment->event_type)>
        event_type_fragment(fragment.message());
    event_type_fragment.Claim(&fragment->event_type);
    
    mojo::internal::Serialize<::auction_worklet::mojom::EventTypeDataView>(
      in_event_type,
      event_type_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->event_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_type in AggregatableReportForEventContribution struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::AggregatableReportForEventContribution_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::AggregatableReportForEventContributionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::PrivateAggregationRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::PrivateAggregationRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::PrivateAggregationRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::contribution(input)) in_contribution = Traits::contribution(input);
    mojo::internal::MessageFragment<decltype(fragment->contribution)>
        contribution_fragment(fragment.message());
    contribution_fragment.Claim(&fragment->contribution);
    
    mojo::internal::Serialize<::auction_worklet::mojom::AggregatableReportContributionDataView>(
      in_contribution,
      contribution_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->contribution.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contribution in PrivateAggregationRequest struct");

    decltype(Traits::debug_mode_details(input)) in_debug_mode_details = Traits::debug_mode_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_mode_details)::BaseType> debug_mode_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::DebugModeDetailsDataView>(
      in_debug_mode_details,
      debug_mode_details_fragment);

    fragment->debug_mode_details.Set(
        debug_mode_details_fragment.is_null() ? nullptr : debug_mode_details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->debug_mode_details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_mode_details in PrivateAggregationRequest struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::PrivateAggregationRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::PrivateAggregationRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::FinalizedPrivateAggregationRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::FinalizedPrivateAggregationRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::FinalizedPrivateAggregationRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::contribution(input)) in_contribution = Traits::contribution(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contribution)::BaseType> contribution_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AggregatableReportHistogramContributionDataView>(
      in_contribution,
      contribution_fragment);

    fragment->contribution.Set(
        contribution_fragment.is_null() ? nullptr : contribution_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->contribution.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contribution in FinalizedPrivateAggregationRequest struct");

    decltype(Traits::debug_mode_details(input)) in_debug_mode_details = Traits::debug_mode_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_mode_details)::BaseType> debug_mode_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::DebugModeDetailsDataView>(
      in_debug_mode_details,
      debug_mode_details_fragment);

    fragment->debug_mode_details.Set(
        debug_mode_details_fragment.is_null() ? nullptr : debug_mode_details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->debug_mode_details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_mode_details in FinalizedPrivateAggregationRequest struct");
    fragment->error_event_$flag = Traits::error_event(input).has_value();
    if (Traits::error_event(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::PrivateAggregationErrorEvent>(
        Traits::error_event(input).value(),
        &fragment->error_event_$value);
    } else {
      fragment->error_event_$value =
          static_cast<int32_t>(::blink::mojom::PrivateAggregationErrorEvent::kMinValue);
    }
  }

  static bool Deserialize(::auction_worklet::mojom::internal::FinalizedPrivateAggregationRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::FinalizedPrivateAggregationRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ForEventSignalBucketDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::auction_worklet::mojom::ForEventSignalBucketDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::auction_worklet::mojom::internal::ForEventSignalBucket_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::auction_worklet::mojom::ForEventSignalBucketDataView::Tag::kIdBucket: {
    decltype(Traits::id_bucket(input))
    in_id_bucket = Traits::id_bucket(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_id_bucket)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView>(
  in_id_bucket,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null id_bucket in ForEventSignalBucket union");
    fragment->data.f_id_bucket.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::auction_worklet::mojom::ForEventSignalBucketDataView::Tag::kSignalBucket: {
    decltype(Traits::signal_bucket(input))
    in_signal_bucket = Traits::signal_bucket(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_signal_bucket)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::auction_worklet::mojom::SignalBucketDataView>(
  in_signal_bucket,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null signal_bucket in ForEventSignalBucket union");
    fragment->data.f_signal_bucket.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::auction_worklet::mojom::internal::ForEventSignalBucket_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::ForEventSignalBucketDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ForEventSignalValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::auction_worklet::mojom::ForEventSignalValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::auction_worklet::mojom::internal::ForEventSignalValue_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::auction_worklet::mojom::ForEventSignalValueDataView::Tag::kIntValue: {
    decltype(Traits::int_value(input))
    in_int_value = Traits::int_value(input);
    fragment->data.f_int_value = in_int_value;
    break;
  }
  case ::auction_worklet::mojom::ForEventSignalValueDataView::Tag::kSignalValue: {
    decltype(Traits::signal_value(input))
    in_signal_value = Traits::signal_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_signal_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::auction_worklet::mojom::SignalValueDataView>(
  in_signal_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null signal_value in ForEventSignalValue union");
    fragment->data.f_signal_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::auction_worklet::mojom::internal::ForEventSignalValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::ForEventSignalValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::EventTypeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::auction_worklet::mojom::EventTypeDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::auction_worklet::mojom::internal::EventType_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::auction_worklet::mojom::EventTypeDataView::Tag::kReservedNonError: {
    decltype(Traits::reserved_non_error(input))
    in_reserved_non_error = Traits::reserved_non_error(input);
        
mojo::internal::Serialize<::auction_worklet::mojom::ReservedNonErrorEventType>(
  in_reserved_non_error,
  &fragment->data.f_reserved_non_error);
    break;
  }
  case ::auction_worklet::mojom::EventTypeDataView::Tag::kReservedError: {
    decltype(Traits::reserved_error(input))
    in_reserved_error = Traits::reserved_error(input);
        
mojo::internal::Serialize<::auction_worklet::mojom::ReservedErrorEventType>(
  in_reserved_error,
  &fragment->data.f_reserved_error);
    break;
  }
  case ::auction_worklet::mojom::EventTypeDataView::Tag::kNonReserved: {
    decltype(Traits::non_reserved(input))
    in_non_reserved = Traits::non_reserved(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_non_reserved)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_non_reserved,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null non_reserved in EventType union");
    fragment->data.f_non_reserved.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::auction_worklet::mojom::internal::EventType_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::EventTypeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::AggregatableReportContributionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::auction_worklet::mojom::AggregatableReportContributionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::auction_worklet::mojom::internal::AggregatableReportContribution_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::auction_worklet::mojom::AggregatableReportContributionDataView::Tag::kHistogramContribution: {
    decltype(Traits::histogram_contribution(input))
    in_histogram_contribution = Traits::histogram_contribution(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_histogram_contribution)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::AggregatableReportHistogramContributionDataView>(
  in_histogram_contribution,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null histogram_contribution in AggregatableReportContribution union");
    fragment->data.f_histogram_contribution.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::auction_worklet::mojom::AggregatableReportContributionDataView::Tag::kForEventContribution: {
    decltype(Traits::for_event_contribution(input))
    in_for_event_contribution = Traits::for_event_contribution(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_for_event_contribution)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::auction_worklet::mojom::AggregatableReportForEventContributionDataView>(
  in_for_event_contribution,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null for_event_contribution in AggregatableReportContribution union");
    fragment->data.f_for_event_contribution.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::auction_worklet::mojom::internal::AggregatableReportContribution_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::AggregatableReportContributionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace auction_worklet::mojom {

inline void BucketOffsetDataView::GetValueDataView(
    ::mojo_base::mojom::Uint128DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::Uint128DataView(pointer, message_);
}


inline void SignalBucketDataView::GetOffsetDataView(
    BucketOffsetDataView* output) {
  auto pointer = data_->offset.Get();
  *output = BucketOffsetDataView(pointer, message_);
}




inline void AggregatableReportForEventContributionDataView::GetBucketDataView(
    ForEventSignalBucketDataView* output) {
  auto pointer = &data_->bucket;
  *output = ForEventSignalBucketDataView(pointer, message_);
}
inline void AggregatableReportForEventContributionDataView::GetValueDataView(
    ForEventSignalValueDataView* output) {
  auto pointer = &data_->value;
  *output = ForEventSignalValueDataView(pointer, message_);
}
inline void AggregatableReportForEventContributionDataView::GetEventTypeDataView(
    EventTypeDataView* output) {
  auto pointer = &data_->event_type;
  *output = EventTypeDataView(pointer, message_);
}


inline void PrivateAggregationRequestDataView::GetContributionDataView(
    AggregatableReportContributionDataView* output) {
  auto pointer = &data_->contribution;
  *output = AggregatableReportContributionDataView(pointer, message_);
}
inline void PrivateAggregationRequestDataView::GetDebugModeDetailsDataView(
    ::blink::mojom::DebugModeDetailsDataView* output) {
  auto pointer = data_->debug_mode_details.Get();
  *output = ::blink::mojom::DebugModeDetailsDataView(pointer, message_);
}


inline void FinalizedPrivateAggregationRequestDataView::GetContributionDataView(
    ::blink::mojom::AggregatableReportHistogramContributionDataView* output) {
  auto pointer = data_->contribution.Get();
  *output = ::blink::mojom::AggregatableReportHistogramContributionDataView(pointer, message_);
}
inline void FinalizedPrivateAggregationRequestDataView::GetDebugModeDetailsDataView(
    ::blink::mojom::DebugModeDetailsDataView* output) {
  auto pointer = data_->debug_mode_details.Get();
  *output = ::blink::mojom::DebugModeDetailsDataView(pointer, message_);
}


inline void ForEventSignalBucketDataView::GetIdBucketDataView(
    ::mojo_base::mojom::Uint128DataView* output) const {
  CHECK(is_id_bucket());
  *output = ::mojo_base::mojom::Uint128DataView(data_->data.f_id_bucket.Get(), message_);
}
inline void ForEventSignalBucketDataView::GetSignalBucketDataView(
    SignalBucketDataView* output) const {
  CHECK(is_signal_bucket());
  *output = SignalBucketDataView(data_->data.f_signal_bucket.Get(), message_);
}

inline void ForEventSignalValueDataView::GetSignalValueDataView(
    SignalValueDataView* output) const {
  CHECK(is_signal_value());
  *output = SignalValueDataView(data_->data.f_signal_value.Get(), message_);
}

inline void EventTypeDataView::GetNonReservedDataView(
    mojo::StringDataView* output) const {
  CHECK(is_non_reserved());
  *output = mojo::StringDataView(data_->data.f_non_reserved.Get(), message_);
}

inline void AggregatableReportContributionDataView::GetHistogramContributionDataView(
    ::blink::mojom::AggregatableReportHistogramContributionDataView* output) const {
  CHECK(is_histogram_contribution());
  *output = ::blink::mojom::AggregatableReportHistogramContributionDataView(data_->data.f_histogram_contribution.Get(), message_);
}
inline void AggregatableReportContributionDataView::GetForEventContributionDataView(
    AggregatableReportForEventContributionDataView* output) const {
  CHECK(is_for_event_contribution());
  *output = AggregatableReportForEventContributionDataView(data_->data.f_for_event_contribution.Get(), message_);
}


}  // auction_worklet::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::auction_worklet::mojom::BaseValue> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::auction_worklet::mojom::BaseValue value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::auction_worklet::mojom::ReservedNonErrorEventType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::auction_worklet::mojom::ReservedNonErrorEventType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::auction_worklet::mojom::ReservedErrorEventType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::auction_worklet::mojom::ReservedErrorEventType value);
};

} // namespace perfetto

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_SHARED_H_