// content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_DATA_VIEW_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "third_party/blink/public/mojom/aggregation_service/aggregatable_report.mojom-shared.h"
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-shared.h"


namespace auction_worklet::mojom {
class BucketOffsetDataView;

class SignalBucketDataView;

class SignalValueDataView;

class AggregatableReportForEventContributionDataView;

class PrivateAggregationRequestDataView;

class FinalizedPrivateAggregationRequestDataView;

class ForEventSignalBucketDataView;
class ForEventSignalValueDataView;
class EventTypeDataView;
class AggregatableReportContributionDataView;


}  // auction_worklet::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BucketOffsetDataView> {
  using Data = ::auction_worklet::mojom::internal::BucketOffset_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::SignalBucketDataView> {
  using Data = ::auction_worklet::mojom::internal::SignalBucket_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::SignalValueDataView> {
  using Data = ::auction_worklet::mojom::internal::SignalValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::AggregatableReportForEventContributionDataView> {
  using Data = ::auction_worklet::mojom::internal::AggregatableReportForEventContribution_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::PrivateAggregationRequestDataView> {
  using Data = ::auction_worklet::mojom::internal::PrivateAggregationRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::FinalizedPrivateAggregationRequestDataView> {
  using Data = ::auction_worklet::mojom::internal::FinalizedPrivateAggregationRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::ForEventSignalBucketDataView> {
  using Data = ::auction_worklet::mojom::internal::ForEventSignalBucket_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::ForEventSignalValueDataView> {
  using Data = ::auction_worklet::mojom::internal::ForEventSignalValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::EventTypeDataView> {
  using Data = ::auction_worklet::mojom::internal::EventType_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::AggregatableReportContributionDataView> {
  using Data = ::auction_worklet::mojom::internal::AggregatableReportContribution_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace auction_worklet::mojom {


enum class BaseValue : int32_t {
  
  kWinningBid = 0,
  
  kHighestScoringOtherBid = 1,
  
  kScriptRunTime = 2,
  
  kSignalsFetchTime = 3,
  
  kBidRejectReason = 4,
  
  kParticipatingInterestGroupCount = 5,
  
  kAverageCodeFetchTime = 6,
  
  kPercentScriptsTimeout = 7,
  
  kPercentInterestGroupsCumulativeTimeout = 8,
  
  kCumulativeBuyerTime = 9,
  
  kRegularInterestGroupsUsed = 10,
  
  kPercentRegularInterestGroupQuotaUsed = 11,
  
  kNegativeInterestGroupsUsed = 12,
  
  kPercentNegativeInterestGroupQuotaUsed = 13,
  
  kInterestGroupStorageUsed = 14,
  
  kPercentInterestGroupStorageQuotaUsed = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, BaseValue value);
inline bool IsKnownEnumValue(BaseValue value) {
  return internal::BaseValue_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ReservedNonErrorEventType : int32_t {
  
  kReservedAlways = 0,
  
  kReservedWin = 1,
  
  kReservedLoss = 2,
  
  kReservedOnce = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ReservedNonErrorEventType value);
inline bool IsKnownEnumValue(ReservedNonErrorEventType value) {
  return internal::ReservedNonErrorEventType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ReservedErrorEventType : int32_t {
  
  kReportSuccess = 0,
  
  kTooManyContributions = 1,
  
  kEmptyReportDropped = 2,
  
  kPendingReportLimitReached = 3,
  
  kInsufficientBudget = 4,
  
  kUncaughtError = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ReservedErrorEventType value);
inline bool IsKnownEnumValue(ReservedErrorEventType value) {
  return internal::ReservedErrorEventType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class BucketOffsetDataView {
 public:
  BucketOffsetDataView() = default;

  BucketOffsetDataView(
      internal::BucketOffset_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  bool is_negative() const {
    return data_->is_negative;
  }
 private:
  internal::BucketOffset_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignalBucketDataView {
 public:
  SignalBucketDataView() = default;

  SignalBucketDataView(
      internal::SignalBucket_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadBaseValue(UserType* output) const {
    auto data_value = data_->base_value;
    return mojo::internal::Deserialize<::auction_worklet::mojom::BaseValue>(
        data_value, output);
  }
  BaseValue base_value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::BaseValue>(data_->base_value));
  }
  double scale() const {
    return data_->scale;
  }
  inline void GetOffsetDataView(
      BucketOffsetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffset(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::auction_worklet::mojom::BucketOffsetDataView, UserType>(),
    "Attempting to read the optional `offset` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOffset` instead "
    "of `ReadOffset if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->offset.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::BucketOffsetDataView>(
        pointer, output, message_);
  }
 private:
  internal::SignalBucket_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignalValueDataView {
 public:
  SignalValueDataView() = default;

  SignalValueDataView(
      internal::SignalValue_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadBaseValue(UserType* output) const {
    auto data_value = data_->base_value;
    return mojo::internal::Deserialize<::auction_worklet::mojom::BaseValue>(
        data_value, output);
  }
  BaseValue base_value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::BaseValue>(data_->base_value));
  }
  double scale() const {
    return data_->scale;
  }
  int32_t offset() const {
    return data_->offset;
  }
 private:
  internal::SignalValue_Data* data_ = nullptr;
};


class AggregatableReportForEventContributionDataView {
 public:
  AggregatableReportForEventContributionDataView() = default;

  AggregatableReportForEventContributionDataView(
      internal::AggregatableReportForEventContribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBucketDataView(
      ForEventSignalBucketDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBucket(UserType* output) {
    
    auto* pointer = !data_->bucket.is_null() ? &data_->bucket : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::ForEventSignalBucketDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      ForEventSignalValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::ForEventSignalValueDataView>(
        pointer, output, message_);
  }
  std::optional<uint64_t> filtering_id() const {

    return data_->filtering_id_$flag
        ? std::make_optional(data_->filtering_id_$value)
        : std::nullopt;
  }
  inline void GetEventTypeDataView(
      EventTypeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventType(UserType* output) {
    
    auto* pointer = !data_->event_type.is_null() ? &data_->event_type : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::EventTypeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AggregatableReportForEventContribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrivateAggregationRequestDataView {
 public:
  PrivateAggregationRequestDataView() = default;

  PrivateAggregationRequestDataView(
      internal::PrivateAggregationRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContributionDataView(
      AggregatableReportContributionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContribution(UserType* output) {
    
    auto* pointer = !data_->contribution.is_null() ? &data_->contribution : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::AggregatableReportContributionDataView>(
        pointer, output, message_);
  }
  inline void GetDebugModeDetailsDataView(
      ::blink::mojom::DebugModeDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugModeDetails(UserType* output) {
    
    auto* pointer = data_->debug_mode_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::DebugModeDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PrivateAggregationRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FinalizedPrivateAggregationRequestDataView {
 public:
  FinalizedPrivateAggregationRequestDataView() = default;

  FinalizedPrivateAggregationRequestDataView(
      internal::FinalizedPrivateAggregationRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContributionDataView(
      ::blink::mojom::AggregatableReportHistogramContributionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContribution(UserType* output) {
    
    auto* pointer = data_->contribution.Get();
    return mojo::internal::Deserialize<::blink::mojom::AggregatableReportHistogramContributionDataView>(
        pointer, output, message_);
  }
  inline void GetDebugModeDetailsDataView(
      ::blink::mojom::DebugModeDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugModeDetails(UserType* output) {
    
    auto* pointer = data_->debug_mode_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::DebugModeDetailsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorEvent(UserType* output) const {
    if (!data_->error_event_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::PrivateAggregationErrorEvent>(
        data_->error_event_$value, &output->emplace());
  }
  std::optional<::blink::mojom::PrivateAggregationErrorEvent> error_event() const {
    if (!data_->error_event_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PrivateAggregationErrorEvent>(data_->error_event_$value));
  }
 private:
  internal::FinalizedPrivateAggregationRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ForEventSignalBucketDataView {
 public:
  using Tag = internal::ForEventSignalBucket_Data::ForEventSignalBucket_Tag;

  ForEventSignalBucketDataView() = default;

  ForEventSignalBucketDataView(
      internal::ForEventSignalBucket_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_id_bucket() const { return data_->tag == Tag::kIdBucket; }
  inline void GetIdBucketDataView(
      ::mojo_base::mojom::Uint128DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadIdBucket(UserType* output) const {
    
    CHECK(is_id_bucket());
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        data_->data.f_id_bucket.Get(), output, message_);
  }
  bool is_signal_bucket() const { return data_->tag == Tag::kSignalBucket; }
  inline void GetSignalBucketDataView(
      SignalBucketDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSignalBucket(UserType* output) const {
    
    CHECK(is_signal_bucket());
    return mojo::internal::Deserialize<::auction_worklet::mojom::SignalBucketDataView>(
        data_->data.f_signal_bucket.Get(), output, message_);
  }

 private:
  internal::ForEventSignalBucket_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class ForEventSignalValueDataView {
 public:
  using Tag = internal::ForEventSignalValue_Data::ForEventSignalValue_Tag;

  ForEventSignalValueDataView() = default;

  ForEventSignalValueDataView(
      internal::ForEventSignalValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_int_value() const { return data_->tag == Tag::kIntValue; }
  int32_t int_value() const {
    CHECK(is_int_value());
    return data_->data.f_int_value;
  }
  bool is_signal_value() const { return data_->tag == Tag::kSignalValue; }
  inline void GetSignalValueDataView(
      SignalValueDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSignalValue(UserType* output) const {
    
    CHECK(is_signal_value());
    return mojo::internal::Deserialize<::auction_worklet::mojom::SignalValueDataView>(
        data_->data.f_signal_value.Get(), output, message_);
  }

 private:
  internal::ForEventSignalValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class EventTypeDataView {
 public:
  using Tag = internal::EventType_Data::EventType_Tag;

  EventTypeDataView() = default;

  EventTypeDataView(
      internal::EventType_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_reserved_non_error() const { return data_->tag == Tag::kReservedNonError; }
  template <typename UserType>
  [[nodiscard]] bool ReadReservedNonError(UserType* output) const {
    CHECK(is_reserved_non_error());
    return mojo::internal::Deserialize<::auction_worklet::mojom::ReservedNonErrorEventType>(
        data_->data.f_reserved_non_error, output);
  }
  ReservedNonErrorEventType reserved_non_error() const {
    CHECK(is_reserved_non_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::ReservedNonErrorEventType>(data_->data.f_reserved_non_error));
  }
  bool is_reserved_error() const { return data_->tag == Tag::kReservedError; }
  template <typename UserType>
  [[nodiscard]] bool ReadReservedError(UserType* output) const {
    CHECK(is_reserved_error());
    return mojo::internal::Deserialize<::auction_worklet::mojom::ReservedErrorEventType>(
        data_->data.f_reserved_error, output);
  }
  ReservedErrorEventType reserved_error() const {
    CHECK(is_reserved_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::ReservedErrorEventType>(data_->data.f_reserved_error));
  }
  bool is_non_reserved() const { return data_->tag == Tag::kNonReserved; }
  inline void GetNonReservedDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNonReserved(UserType* output) const {
    
    CHECK(is_non_reserved());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_non_reserved.Get(), output, message_);
  }

 private:
  internal::EventType_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AggregatableReportContributionDataView {
 public:
  using Tag = internal::AggregatableReportContribution_Data::AggregatableReportContribution_Tag;

  AggregatableReportContributionDataView() = default;

  AggregatableReportContributionDataView(
      internal::AggregatableReportContribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_histogram_contribution() const { return data_->tag == Tag::kHistogramContribution; }
  inline void GetHistogramContributionDataView(
      ::blink::mojom::AggregatableReportHistogramContributionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadHistogramContribution(UserType* output) const {
    
    CHECK(is_histogram_contribution());
    return mojo::internal::Deserialize<::blink::mojom::AggregatableReportHistogramContributionDataView>(
        data_->data.f_histogram_contribution.Get(), output, message_);
  }
  bool is_for_event_contribution() const { return data_->tag == Tag::kForEventContribution; }
  inline void GetForEventContributionDataView(
      AggregatableReportForEventContributionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadForEventContribution(UserType* output) const {
    
    CHECK(is_for_event_contribution());
    return mojo::internal::Deserialize<::auction_worklet::mojom::AggregatableReportForEventContributionDataView>(
        data_->data.f_for_event_contribution.Get(), output, message_);
  }

 private:
  internal::AggregatableReportContribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // auction_worklet::mojom

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_DATA_VIEW_H_