// content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_IN_PROGRESS_AUCTION_DOWNLOAD_MOJOM_SEND_VALIDATION_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_IN_PROGRESS_AUCTION_DOWNLOAD_MOJOM_SEND_VALIDATION_H_

#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::InProgressAuctionDownloadDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::InProgressAuctionDownloadDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::InProgressAuctionDownload_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in InProgressAuctionDownload struct");

      decltype(Traits::endpoints(input)) in_endpoints = Traits::endpoints(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->endpoints)::BaseType> endpoints_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::URLLoaderClientEndpointsDataView, send_validation>(
        in_endpoints,
        endpoints_fragment);

      fragment->endpoints.Set(
          endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->endpoints.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null endpoints in InProgressAuctionDownload struct");

      decltype(Traits::devtools_request_id(input)) in_devtools_request_id = Traits::devtools_request_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->devtools_request_id)::BaseType> devtools_request_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_devtools_request_id,
        devtools_request_id_fragment);

      fragment->devtools_request_id.Set(
          devtools_request_id_fragment.is_null() ? nullptr : devtools_request_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->devtools_request_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_request_id in InProgressAuctionDownload struct");
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_IN_PROGRESS_AUCTION_DOWNLOAD_MOJOM_SEND_VALIDATION_H_