// content/services/auction_worklet/public/mojom/bidder_worklet.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_SEND_VALIDATION_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_SEND_VALIDATION_H_

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared-internal.h"
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/reject_reason.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::auction_worklet::mojom::KAnonymityBidMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::auction_worklet::mojom::KAnonymityStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::auction_worklet::mojom::BidRole, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::auction_worklet::mojom::ReportingIdField, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::KAnonKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::KAnonKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::KAnonKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType> data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_data,
        data_fragment);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in KAnonKey struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::BidderWorkletNonSharedParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BidderWorkletNonSharedParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BidderWorkletNonSharedParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in BidderWorkletNonSharedParams struct");

      
      mojo::internal::Serialize<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(
        Traits::trusted_bidding_signals_slot_size_mode(input),
        &fragment->trusted_bidding_signals_slot_size_mode);

      fragment->enable_bidding_signals_prioritization = Traits::enable_bidding_signals_prioritization(input);

      decltype(Traits::priority_vector(input)) in_priority_vector = Traits::priority_vector(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->priority_vector)::BaseType>
          priority_vector_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& priority_vector_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, double>, send_validation>(
        in_priority_vector,
        priority_vector_fragment,
        &priority_vector_validate_params);

      fragment->priority_vector.Set(
          priority_vector_fragment.is_null() ? nullptr : priority_vector_fragment.data());

      
      mojo::internal::Serialize<::blink::mojom::InterestGroup_ExecutionMode>(
        Traits::execution_mode(input),
        &fragment->execution_mode);

      decltype(Traits::update_url(input)) in_update_url = Traits::update_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->update_url)::BaseType> update_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_update_url,
        update_url_fragment);

      fragment->update_url.Set(
          update_url_fragment.is_null() ? nullptr : update_url_fragment.data());

      decltype(Traits::trusted_bidding_signals_keys(input)) in_trusted_bidding_signals_keys = Traits::trusted_bidding_signals_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trusted_bidding_signals_keys)::BaseType>
          trusted_bidding_signals_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& trusted_bidding_signals_keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_trusted_bidding_signals_keys,
        trusted_bidding_signals_keys_fragment,
        &trusted_bidding_signals_keys_validate_params);

      fragment->trusted_bidding_signals_keys.Set(
          trusted_bidding_signals_keys_fragment.is_null() ? nullptr : trusted_bidding_signals_keys_fragment.data());

      fragment->max_trusted_bidding_signals_url_length = Traits::max_trusted_bidding_signals_url_length(input);

      decltype(Traits::user_bidding_signals(input)) in_user_bidding_signals = Traits::user_bidding_signals(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_bidding_signals)::BaseType> user_bidding_signals_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_user_bidding_signals,
        user_bidding_signals_fragment);

      fragment->user_bidding_signals.Set(
          user_bidding_signals_fragment.is_null() ? nullptr : user_bidding_signals_fragment.data());

      decltype(Traits::ads(input)) in_ads = Traits::ads(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ads)::BaseType>
          ads_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& ads_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, send_validation>(
        in_ads,
        ads_fragment,
        &ads_validate_params);

      fragment->ads.Set(
          ads_fragment.is_null() ? nullptr : ads_fragment.data());

      decltype(Traits::ad_components(input)) in_ad_components = Traits::ad_components(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ad_components)::BaseType>
          ad_components_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& ad_components_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, send_validation>(
        in_ad_components,
        ad_components_fragment,
        &ad_components_validate_params);

      fragment->ad_components.Set(
          ad_components_fragment.is_null() ? nullptr : ad_components_fragment.data());

      decltype(Traits::kanon_keys(input)) in_kanon_keys = Traits::kanon_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->kanon_keys)::BaseType>
          kanon_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& kanon_keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::KAnonKeyDataView>, send_validation>(
        in_kanon_keys,
        kanon_keys_fragment,
        &kanon_keys_validate_params);

      fragment->kanon_keys.Set(
          kanon_keys_fragment.is_null() ? nullptr : kanon_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->kanon_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null kanon_keys in BidderWorkletNonSharedParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::BidderWorkletBidDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BidderWorkletBidDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BidderWorkletBid_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::auction_worklet::mojom::BidRole>(
        Traits::bid_role(input),
        &fragment->bid_role);

      decltype(Traits::ad(input)) in_ad = Traits::ad(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ad)::BaseType> ad_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_ad,
        ad_fragment);

      fragment->ad.Set(
          ad_fragment.is_null() ? nullptr : ad_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ad.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ad in BidderWorkletBid struct");

      fragment->bid = Traits::bid(input);

      decltype(Traits::bid_currency(input)) in_bid_currency = Traits::bid_currency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bid_currency)::BaseType> bid_currency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView, send_validation>(
        in_bid_currency,
        bid_currency_fragment);

      fragment->bid_currency.Set(
          bid_currency_fragment.is_null() ? nullptr : bid_currency_fragment.data());
      fragment->ad_cost_$flag = Traits::ad_cost(input).has_value();
      if (Traits::ad_cost(input).has_value()) {
        fragment->ad_cost_$value = Traits::ad_cost(input).value();
      }

      decltype(Traits::ad_descriptor(input)) in_ad_descriptor = Traits::ad_descriptor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ad_descriptor)::BaseType> ad_descriptor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::AdDescriptorDataView, send_validation>(
        in_ad_descriptor,
        ad_descriptor_fragment);

      fragment->ad_descriptor.Set(
          ad_descriptor_fragment.is_null() ? nullptr : ad_descriptor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ad_descriptor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ad_descriptor in BidderWorkletBid struct");

      decltype(Traits::selected_buyer_and_seller_reporting_id(input)) in_selected_buyer_and_seller_reporting_id = Traits::selected_buyer_and_seller_reporting_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->selected_buyer_and_seller_reporting_id)::BaseType> selected_buyer_and_seller_reporting_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_selected_buyer_and_seller_reporting_id,
        selected_buyer_and_seller_reporting_id_fragment);

      fragment->selected_buyer_and_seller_reporting_id.Set(
          selected_buyer_and_seller_reporting_id_fragment.is_null() ? nullptr : selected_buyer_and_seller_reporting_id_fragment.data());

      decltype(Traits::ad_component_descriptors(input)) in_ad_component_descriptors = Traits::ad_component_descriptors(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ad_component_descriptors)::BaseType>
          ad_component_descriptors_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& ad_component_descriptors_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>, send_validation>(
        in_ad_component_descriptors,
        ad_component_descriptors_fragment,
        &ad_component_descriptors_validate_params);

      fragment->ad_component_descriptors.Set(
          ad_component_descriptors_fragment.is_null() ? nullptr : ad_component_descriptors_fragment.data());
      fragment->modeling_signals_$flag = Traits::modeling_signals(input).has_value();
      if (Traits::modeling_signals(input).has_value()) {
        fragment->modeling_signals_$value = Traits::modeling_signals(input).value();
      }

      decltype(Traits::aggregate_win_signals(input)) in_aggregate_win_signals = Traits::aggregate_win_signals(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregate_win_signals)::BaseType> aggregate_win_signals_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_aggregate_win_signals,
        aggregate_win_signals_fragment);

      fragment->aggregate_win_signals.Set(
          aggregate_win_signals_fragment.is_null() ? nullptr : aggregate_win_signals_fragment.data());

      decltype(Traits::bid_duration(input)) in_bid_duration = Traits::bid_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bid_duration)::BaseType> bid_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_bid_duration,
        bid_duration_fragment);

      fragment->bid_duration.Set(
          bid_duration_fragment.is_null() ? nullptr : bid_duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bid_duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bid_duration in BidderWorkletBid struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::PrioritySignalsDoubleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::PrioritySignalsDoubleDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::PrioritySignalsDouble_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->value = Traits::value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::GenerateBidDependencyLatenciesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::GenerateBidDependencyLatenciesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::GenerateBidDependencyLatencies_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::code_ready_latency(input)) in_code_ready_latency = Traits::code_ready_latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->code_ready_latency)::BaseType> code_ready_latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_code_ready_latency,
        code_ready_latency_fragment);

      fragment->code_ready_latency.Set(
          code_ready_latency_fragment.is_null() ? nullptr : code_ready_latency_fragment.data());

      decltype(Traits::config_promises_latency(input)) in_config_promises_latency = Traits::config_promises_latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->config_promises_latency)::BaseType> config_promises_latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_config_promises_latency,
        config_promises_latency_fragment);

      fragment->config_promises_latency.Set(
          config_promises_latency_fragment.is_null() ? nullptr : config_promises_latency_fragment.data());

      decltype(Traits::direct_from_seller_signals_latency(input)) in_direct_from_seller_signals_latency = Traits::direct_from_seller_signals_latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->direct_from_seller_signals_latency)::BaseType> direct_from_seller_signals_latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_direct_from_seller_signals_latency,
        direct_from_seller_signals_latency_fragment);

      fragment->direct_from_seller_signals_latency.Set(
          direct_from_seller_signals_latency_fragment.is_null() ? nullptr : direct_from_seller_signals_latency_fragment.data());

      decltype(Traits::trusted_bidding_signals_latency(input)) in_trusted_bidding_signals_latency = Traits::trusted_bidding_signals_latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trusted_bidding_signals_latency)::BaseType> trusted_bidding_signals_latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_trusted_bidding_signals_latency,
        trusted_bidding_signals_latency_fragment);

      fragment->trusted_bidding_signals_latency.Set(
          trusted_bidding_signals_latency_fragment.is_null() ? nullptr : trusted_bidding_signals_latency_fragment.data());

      decltype(Traits::deps_wait_start_time(input)) in_deps_wait_start_time = Traits::deps_wait_start_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->deps_wait_start_time)::BaseType> deps_wait_start_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_deps_wait_start_time,
        deps_wait_start_time_fragment);

      fragment->deps_wait_start_time.Set(
          deps_wait_start_time_fragment.is_null() ? nullptr : deps_wait_start_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->deps_wait_start_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null deps_wait_start_time in GenerateBidDependencyLatencies struct");

      decltype(Traits::generate_bid_start_time(input)) in_generate_bid_start_time = Traits::generate_bid_start_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->generate_bid_start_time)::BaseType> generate_bid_start_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_generate_bid_start_time,
        generate_bid_start_time_fragment);

      fragment->generate_bid_start_time.Set(
          generate_bid_start_time_fragment.is_null() ? nullptr : generate_bid_start_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->generate_bid_start_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null generate_bid_start_time in GenerateBidDependencyLatencies struct");

      decltype(Traits::generate_bid_finish_time(input)) in_generate_bid_finish_time = Traits::generate_bid_finish_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->generate_bid_finish_time)::BaseType> generate_bid_finish_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_generate_bid_finish_time,
        generate_bid_finish_time_fragment);

      fragment->generate_bid_finish_time.Set(
          generate_bid_finish_time_fragment.is_null() ? nullptr : generate_bid_finish_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->generate_bid_finish_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null generate_bid_finish_time in GenerateBidDependencyLatencies struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::BidderTimingMetricsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BidderTimingMetricsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BidderTimingMetrics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::js_fetch_latency(input)) in_js_fetch_latency = Traits::js_fetch_latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->js_fetch_latency)::BaseType> js_fetch_latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_js_fetch_latency,
        js_fetch_latency_fragment);

      fragment->js_fetch_latency.Set(
          js_fetch_latency_fragment.is_null() ? nullptr : js_fetch_latency_fragment.data());

      decltype(Traits::wasm_fetch_latency(input)) in_wasm_fetch_latency = Traits::wasm_fetch_latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->wasm_fetch_latency)::BaseType> wasm_fetch_latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_wasm_fetch_latency,
        wasm_fetch_latency_fragment);

      fragment->wasm_fetch_latency.Set(
          wasm_fetch_latency_fragment.is_null() ? nullptr : wasm_fetch_latency_fragment.data());

      decltype(Traits::script_latency(input)) in_script_latency = Traits::script_latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->script_latency)::BaseType> script_latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_script_latency,
        script_latency_fragment);

      fragment->script_latency.Set(
          script_latency_fragment.is_null() ? nullptr : script_latency_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->script_latency.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_latency in BidderTimingMetrics struct");

      fragment->script_timed_out = Traits::script_timed_out(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::PrivateModelTrainingRequestDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::PrivateModelTrainingRequestDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::PrivateModelTrainingRequestData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::payload(input)) in_payload = Traits::payload(input);
      mojo::internal::MessageFragment<decltype(fragment->payload)>
          payload_fragment(fragment.message());
      payload_fragment.Claim(&fragment->payload);
      
      mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView, send_validation>(
        in_payload,
        payload_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->payload.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null payload in PrivateModelTrainingRequestData struct");

      fragment->payload_length = Traits::payload_length(input);

      decltype(Traits::aggregation_coordinator_origin(input)) in_aggregation_coordinator_origin = Traits::aggregation_coordinator_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregation_coordinator_origin)::BaseType> aggregation_coordinator_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_aggregation_coordinator_origin,
        aggregation_coordinator_origin_fragment);

      fragment->aggregation_coordinator_origin.Set(
          aggregation_coordinator_origin_fragment.is_null() ? nullptr : aggregation_coordinator_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregation_coordinator_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregation_coordinator_origin in PrivateModelTrainingRequestData struct");

      decltype(Traits::destination(input)) in_destination = Traits::destination(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->destination)::BaseType> destination_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_destination,
        destination_fragment);

      fragment->destination.Set(
          destination_fragment.is_null() ? nullptr : destination_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->destination.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null destination in PrivateModelTrainingRequestData struct");
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_SEND_VALIDATION_H_