// content/services/auction_worklet/public/mojom/bidder_worklet.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_DATA_VIEW_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared-internal.h"
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/reject_reason.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace auction_worklet::mojom {
class KAnonKeyDataView;

class BidderWorkletNonSharedParamsDataView;

class BidderWorkletBidDataView;

class PrioritySignalsDoubleDataView;

class GenerateBidDependencyLatenciesDataView;

class BidderTimingMetricsDataView;

class PrivateModelTrainingRequestDataDataView;



}  // auction_worklet::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::auction_worklet::mojom::KAnonKeyDataView> {
  using Data = ::auction_worklet::mojom::internal::KAnonKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BidderWorkletNonSharedParamsDataView> {
  using Data = ::auction_worklet::mojom::internal::BidderWorkletNonSharedParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BidderWorkletBidDataView> {
  using Data = ::auction_worklet::mojom::internal::BidderWorkletBid_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::PrioritySignalsDoubleDataView> {
  using Data = ::auction_worklet::mojom::internal::PrioritySignalsDouble_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::GenerateBidDependencyLatenciesDataView> {
  using Data = ::auction_worklet::mojom::internal::GenerateBidDependencyLatencies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BidderTimingMetricsDataView> {
  using Data = ::auction_worklet::mojom::internal::BidderTimingMetrics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::PrivateModelTrainingRequestDataDataView> {
  using Data = ::auction_worklet::mojom::internal::PrivateModelTrainingRequestData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace auction_worklet::mojom {


enum class KAnonymityBidMode : int32_t {
  
  kNone = 0,
  
  kSimulate = 1,
  
  kEnforce = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, KAnonymityBidMode value);
inline bool IsKnownEnumValue(KAnonymityBidMode value) {
  return internal::KAnonymityBidMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class KAnonymityStatus : int32_t {
  
  kUnknown = 0,
  
  kBelowThreshold = 1,
  
  kPassingNotEnforced = 2,
  
  kPassingAndEnforced = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, KAnonymityStatus value);
inline bool IsKnownEnumValue(KAnonymityStatus value) {
  return internal::KAnonymityStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BidRole : int32_t {
  
  kUnenforcedKAnon = 0,
  
  kEnforcedKAnon = 1,
  
  kBothKAnonModes = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, BidRole value);
inline bool IsKnownEnumValue(BidRole value) {
  return internal::BidRole_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ReportingIdField : int32_t {
  
  kNone = 0,
  
  kInterestGroupName = 1,
  
  kBuyerReportingId = 2,
  
  kBuyerAndSellerReportingId = 3,
  
  kSelectedBuyerAndSellerReportingId = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ReportingIdField value);
inline bool IsKnownEnumValue(ReportingIdField value) {
  return internal::ReportingIdField_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class GenerateBidClientInterfaceBase {};

using GenerateBidClientPtrDataView =
    mojo::InterfacePtrDataView<GenerateBidClientInterfaceBase>;
using GenerateBidClientRequestDataView =
    mojo::InterfaceRequestDataView<GenerateBidClientInterfaceBase>;
using GenerateBidClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GenerateBidClientInterfaceBase>;
using GenerateBidClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GenerateBidClientInterfaceBase>;
class GenerateBidFinalizerInterfaceBase {};

using GenerateBidFinalizerPtrDataView =
    mojo::InterfacePtrDataView<GenerateBidFinalizerInterfaceBase>;
using GenerateBidFinalizerRequestDataView =
    mojo::InterfaceRequestDataView<GenerateBidFinalizerInterfaceBase>;
using GenerateBidFinalizerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GenerateBidFinalizerInterfaceBase>;
using GenerateBidFinalizerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GenerateBidFinalizerInterfaceBase>;
class BidderWorkletInterfaceBase {};

using BidderWorkletPtrDataView =
    mojo::InterfacePtrDataView<BidderWorkletInterfaceBase>;
using BidderWorkletRequestDataView =
    mojo::InterfaceRequestDataView<BidderWorkletInterfaceBase>;
using BidderWorkletAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BidderWorkletInterfaceBase>;
using BidderWorkletAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BidderWorkletInterfaceBase>;


class KAnonKeyDataView {
 public:
  KAnonKeyDataView() = default;

  KAnonKeyDataView(
      internal::KAnonKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::KAnonKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderWorkletNonSharedParamsDataView {
 public:
  BidderWorkletNonSharedParamsDataView() = default;

  BidderWorkletNonSharedParamsDataView(
      internal::BidderWorkletNonSharedParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsSlotSizeMode(UserType* output) const {
    auto data_value = data_->trusted_bidding_signals_slot_size_mode;
    return mojo::internal::Deserialize<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(
        data_value, output);
  }
  ::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(data_->trusted_bidding_signals_slot_size_mode));
  }
  bool enable_bidding_signals_prioritization() const {
    return data_->enable_bidding_signals_prioritization;
  }
  inline void GetPriorityVectorDataView(
      mojo::MapDataView<mojo::StringDataView, double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPriorityVector(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, double>, UserType>(),
    "Attempting to read the optional `priority_vector` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPriorityVector` instead "
    "of `ReadPriorityVector if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->priority_vector.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, double>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadExecutionMode(UserType* output) const {
    auto data_value = data_->execution_mode;
    return mojo::internal::Deserialize<::blink::mojom::InterestGroup_ExecutionMode>(
        data_value, output);
  }
  ::blink::mojom::InterestGroup_ExecutionMode execution_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InterestGroup_ExecutionMode>(data_->execution_mode));
  }
  inline void GetUpdateUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `update_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUpdateUrl` instead "
    "of `ReadUpdateUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->update_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedBiddingSignalsKeysDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsKeys` instead "
    "of `ReadTrustedBiddingSignalsKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  int32_t max_trusted_bidding_signals_url_length() const {
    return data_->max_trusted_bidding_signals_url_length;
  }
  inline void GetUserBiddingSignalsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserBiddingSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `user_bidding_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserBiddingSignals` instead "
    "of `ReadUserBiddingSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_bidding_signals.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdsDataView(
      mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, UserType>(),
    "Attempting to read the optional `ads` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAds` instead "
    "of `ReadAds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ads.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        pointer, output, message_);
  }
  inline void GetAdComponentsDataView(
      mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdComponents(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, UserType>(),
    "Attempting to read the optional `ad_components` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdComponents` instead "
    "of `ReadAdComponents if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_components.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        pointer, output, message_);
  }
  inline void GetKanonKeysDataView(
      mojo::ArrayDataView<KAnonKeyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKanonKeys(UserType* output) {
    
    auto* pointer = data_->kanon_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::KAnonKeyDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BidderWorkletNonSharedParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderWorkletBidDataView {
 public:
  BidderWorkletBidDataView() = default;

  BidderWorkletBidDataView(
      internal::BidderWorkletBid_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadBidRole(UserType* output) const {
    auto data_value = data_->bid_role;
    return mojo::internal::Deserialize<::auction_worklet::mojom::BidRole>(
        data_value, output);
  }
  BidRole bid_role() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::BidRole>(data_->bid_role));
  }
  inline void GetAdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAd(UserType* output) {
    
    auto* pointer = data_->ad.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double bid() const {
    return data_->bid;
  }
  inline void GetBidCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBidCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `bid_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBidCurrency` instead "
    "of `ReadBidCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bid_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  std::optional<double> ad_cost() const {

    return data_->ad_cost_$flag
        ? std::make_optional(data_->ad_cost_$value)
        : std::nullopt;
  }
  inline void GetAdDescriptorDataView(
      ::blink::mojom::AdDescriptorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdDescriptor(UserType* output) {
    
    auto* pointer = data_->ad_descriptor.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdDescriptorDataView>(
        pointer, output, message_);
  }
  inline void GetSelectedBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `selected_buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSelectedBuyerAndSellerReportingId` instead "
    "of `ReadSelectedBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->selected_buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdComponentDescriptorsDataView(
      mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdComponentDescriptors(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>, UserType>(),
    "Attempting to read the optional `ad_component_descriptors` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdComponentDescriptors` instead "
    "of `ReadAdComponentDescriptors if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_component_descriptors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>>(
        pointer, output, message_);
  }
  std::optional<uint16_t> modeling_signals() const {

    return data_->modeling_signals_$flag
        ? std::make_optional(data_->modeling_signals_$value)
        : std::nullopt;
  }
  inline void GetAggregateWinSignalsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregateWinSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `aggregate_win_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregateWinSignals` instead "
    "of `ReadAggregateWinSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregate_win_signals.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBidDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBidDuration(UserType* output) {
    
    auto* pointer = data_->bid_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::BidderWorkletBid_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrioritySignalsDoubleDataView {
 public:
  PrioritySignalsDoubleDataView() = default;

  PrioritySignalsDoubleDataView(
      internal::PrioritySignalsDouble_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double value() const {
    return data_->value;
  }
 private:
  internal::PrioritySignalsDouble_Data* data_ = nullptr;
};


class GenerateBidDependencyLatenciesDataView {
 public:
  GenerateBidDependencyLatenciesDataView() = default;

  GenerateBidDependencyLatenciesDataView(
      internal::GenerateBidDependencyLatencies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeReadyLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodeReadyLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `code_ready_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCodeReadyLatency` instead "
    "of `ReadCodeReadyLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->code_ready_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetConfigPromisesLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfigPromisesLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `config_promises_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConfigPromisesLatency` instead "
    "of `ReadConfigPromisesLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->config_promises_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerSignalsLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerSignalsLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_signals_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerSignalsLatency` instead "
    "of `ReadDirectFromSellerSignalsLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_signals_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedBiddingSignalsLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsLatency` instead "
    "of `ReadTrustedBiddingSignalsLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDepsWaitStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepsWaitStartTime(UserType* output) {
    
    auto* pointer = data_->deps_wait_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetGenerateBidStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerateBidStartTime(UserType* output) {
    
    auto* pointer = data_->generate_bid_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetGenerateBidFinishTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerateBidFinishTime(UserType* output) {
    
    auto* pointer = data_->generate_bid_finish_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::GenerateBidDependencyLatencies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderTimingMetricsDataView {
 public:
  BidderTimingMetricsDataView() = default;

  BidderTimingMetricsDataView(
      internal::BidderTimingMetrics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetJsFetchLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJsFetchLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `js_fetch_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadJsFetchLatency` instead "
    "of `ReadJsFetchLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->js_fetch_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetWasmFetchLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWasmFetchLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `wasm_fetch_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWasmFetchLatency` instead "
    "of `ReadWasmFetchLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->wasm_fetch_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetScriptLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptLatency(UserType* output) {
    
    auto* pointer = data_->script_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool script_timed_out() const {
    return data_->script_timed_out;
  }
 private:
  internal::BidderTimingMetrics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrivateModelTrainingRequestDataDataView {
 public:
  PrivateModelTrainingRequestDataDataView() = default;

  PrivateModelTrainingRequestDataDataView(
      internal::PrivateModelTrainingRequestData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPayloadDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayload(UserType* output) {
    
    auto* pointer = !data_->payload.is_null() ? &data_->payload : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  uint32_t payload_length() const {
    return data_->payload_length;
  }
  inline void GetAggregationCoordinatorOriginDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinatorOrigin(UserType* output) {
    
    auto* pointer = data_->aggregation_coordinator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDestinationDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestination(UserType* output) {
    
    auto* pointer = data_->destination.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::PrivateModelTrainingRequestData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // auction_worklet::mojom

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_DATA_VIEW_H_