// content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_SEND_VALIDATION_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared-internal.h"
#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::BrowserSignalsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BrowserSignalsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BrowserSignals_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_frame_origin)::BaseType> top_frame_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_top_frame_origin,
        top_frame_origin_fragment);

      fragment->top_frame_origin.Set(
          top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->top_frame_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_frame_origin in BrowserSignals struct");

      decltype(Traits::seller(input)) in_seller = Traits::seller(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->seller)::BaseType> seller_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_seller,
        seller_fragment);

      fragment->seller.Set(
          seller_fragment.is_null() ? nullptr : seller_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->seller.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null seller in BrowserSignals struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::AuctionWorkletPermissionsPolicyState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->private_aggregation_allowed = Traits::private_aggregation_allowed(input);

      fragment->shared_storage_allowed = Traits::shared_storage_allowed(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::auction_worklet::mojom::TrustedSignalsPublicKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::TrustedSignalsPublicKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::TrustedSignalsPublicKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::key(input)) in_key = Traits::key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key)::BaseType> key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_key,
        key_fragment);

      fragment->key.Set(
          key_fragment.is_null() ? nullptr : key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in TrustedSignalsPublicKey struct");

      fragment->id = Traits::id(input);
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_SEND_VALIDATION_H_