// content/public/common/resource_usage_reporter.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_SEND_VALIDATION_H_
#define CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_SEND_VALIDATION_H_

#include "content/public/common/resource_usage_reporter.mojom-shared-internal.h"

#include "content/public/common/resource_usage_reporter.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::ResourceTypeStatDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::ResourceTypeStatDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::ResourceTypeStat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->count = Traits::count(input);

      fragment->size = Traits::size(input);

      fragment->live_size = Traits::live_size(input);

      fragment->decoded_size = Traits::decoded_size(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::ResourceTypeStatsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::ResourceTypeStatsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::ResourceTypeStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::images(input)) in_images = Traits::images(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->images)::BaseType> images_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView, send_validation>(
        in_images,
        images_fragment);

      fragment->images.Set(
          images_fragment.is_null() ? nullptr : images_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->images.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null images in ResourceTypeStats struct");

      decltype(Traits::css_style_sheets(input)) in_css_style_sheets = Traits::css_style_sheets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->css_style_sheets)::BaseType> css_style_sheets_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView, send_validation>(
        in_css_style_sheets,
        css_style_sheets_fragment);

      fragment->css_style_sheets.Set(
          css_style_sheets_fragment.is_null() ? nullptr : css_style_sheets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->css_style_sheets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null css_style_sheets in ResourceTypeStats struct");

      decltype(Traits::scripts(input)) in_scripts = Traits::scripts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scripts)::BaseType> scripts_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView, send_validation>(
        in_scripts,
        scripts_fragment);

      fragment->scripts.Set(
          scripts_fragment.is_null() ? nullptr : scripts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scripts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scripts in ResourceTypeStats struct");

      decltype(Traits::xsl_style_sheets(input)) in_xsl_style_sheets = Traits::xsl_style_sheets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->xsl_style_sheets)::BaseType> xsl_style_sheets_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView, send_validation>(
        in_xsl_style_sheets,
        xsl_style_sheets_fragment);

      fragment->xsl_style_sheets.Set(
          xsl_style_sheets_fragment.is_null() ? nullptr : xsl_style_sheets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->xsl_style_sheets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null xsl_style_sheets in ResourceTypeStats struct");

      decltype(Traits::fonts(input)) in_fonts = Traits::fonts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fonts)::BaseType> fonts_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView, send_validation>(
        in_fonts,
        fonts_fragment);

      fragment->fonts.Set(
          fonts_fragment.is_null() ? nullptr : fonts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fonts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fonts in ResourceTypeStats struct");

      decltype(Traits::other(input)) in_other = Traits::other(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->other)::BaseType> other_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView, send_validation>(
        in_other,
        other_fragment);

      fragment->other.Set(
          other_fragment.is_null() ? nullptr : other_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->other.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null other in ResourceTypeStats struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::ResourceUsageDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::ResourceUsageDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::ResourceUsageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->reports_v8_stats = Traits::reports_v8_stats(input);

      fragment->v8_bytes_allocated = Traits::v8_bytes_allocated(input);

      fragment->v8_bytes_used = Traits::v8_bytes_used(input);

      decltype(Traits::web_cache_stats(input)) in_web_cache_stats = Traits::web_cache_stats(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->web_cache_stats)::BaseType> web_cache_stats_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content::mojom::ResourceTypeStatsDataView, send_validation>(
        in_web_cache_stats,
        web_cache_stats_fragment);

      fragment->web_cache_stats.Set(
          web_cache_stats_fragment.is_null() ? nullptr : web_cache_stats_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_SEND_VALIDATION_H_