// content/public/common/resource_usage_reporter.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_DATA_VIEW_H_
#define CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "content/public/common/resource_usage_reporter.mojom-shared-internal.h"


namespace content::mojom {
class ResourceTypeStatDataView;

class ResourceTypeStatsDataView;

class ResourceUsageDataDataView;



}  // content::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::ResourceTypeStatDataView> {
  using Data = ::content::mojom::internal::ResourceTypeStat_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::ResourceTypeStatsDataView> {
  using Data = ::content::mojom::internal::ResourceTypeStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::ResourceUsageDataDataView> {
  using Data = ::content::mojom::internal::ResourceUsageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {
// Interface base classes. They are used for type safety check.
class ResourceUsageReporterInterfaceBase {};

using ResourceUsageReporterPtrDataView =
    mojo::InterfacePtrDataView<ResourceUsageReporterInterfaceBase>;
using ResourceUsageReporterRequestDataView =
    mojo::InterfaceRequestDataView<ResourceUsageReporterInterfaceBase>;
using ResourceUsageReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ResourceUsageReporterInterfaceBase>;
using ResourceUsageReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ResourceUsageReporterInterfaceBase>;


class ResourceTypeStatDataView {
 public:
  ResourceTypeStatDataView() = default;

  ResourceTypeStatDataView(
      internal::ResourceTypeStat_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t count() const {
    return data_->count;
  }
  uint64_t size() const {
    return data_->size;
  }
  uint64_t live_size() const {
    return data_->live_size;
  }
  uint64_t decoded_size() const {
    return data_->decoded_size;
  }
 private:
  internal::ResourceTypeStat_Data* data_ = nullptr;
};


class ResourceTypeStatsDataView {
 public:
  ResourceTypeStatsDataView() = default;

  ResourceTypeStatsDataView(
      internal::ResourceTypeStats_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImagesDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImages(UserType* output) {
    
    auto* pointer = data_->images.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetCssStyleSheetsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCssStyleSheets(UserType* output) {
    
    auto* pointer = data_->css_style_sheets.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetScriptsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScripts(UserType* output) {
    
    auto* pointer = data_->scripts.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetXslStyleSheetsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadXslStyleSheets(UserType* output) {
    
    auto* pointer = data_->xsl_style_sheets.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetFontsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFonts(UserType* output) {
    
    auto* pointer = data_->fonts.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetOtherDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOther(UserType* output) {
    
    auto* pointer = data_->other.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
 private:
  internal::ResourceTypeStats_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceUsageDataDataView {
 public:
  ResourceUsageDataDataView() = default;

  ResourceUsageDataDataView(
      internal::ResourceUsageData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool reports_v8_stats() const {
    return data_->reports_v8_stats;
  }
  uint64_t v8_bytes_allocated() const {
    return data_->v8_bytes_allocated;
  }
  uint64_t v8_bytes_used() const {
    return data_->v8_bytes_used;
  }
  inline void GetWebCacheStatsDataView(
      ResourceTypeStatsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebCacheStats(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::ResourceTypeStatsDataView, UserType>(),
    "Attempting to read the optional `web_cache_stats` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWebCacheStats` instead "
    "of `ReadWebCacheStats if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->web_cache_stats.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ResourceUsageData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // content::mojom

#endif  // CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_DATA_VIEW_H_