// content/public/common/extra_mojo_js_features.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_COMMON_EXTRA_MOJO_JS_FEATURES_MOJOM_H_
#define CONTENT_PUBLIC_COMMON_EXTRA_MOJO_JS_FEATURES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/public/common/extra_mojo_js_features.mojom-features.h"  // IWYU pragma: export
#include "content/public/common/extra_mojo_js_features.mojom-shared.h"  // IWYU pragma: export
#include "content/public/common/extra_mojo_js_features.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "content/common/content_export.h"




namespace content::mojom {





class CONTENT_EXPORT ExtraMojoJsFeatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtraMojoJsFeatures, T>::value>;
  using DataView = ExtraMojoJsFeaturesDataView;
  using Data_ = internal::ExtraMojoJsFeatures_Data;

  template <typename... Args>
  static ExtraMojoJsFeaturesPtr New(Args&&... args) {
    return ExtraMojoJsFeaturesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtraMojoJsFeaturesPtr From(const U& u) {
    return mojo::TypeConverter<ExtraMojoJsFeaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtraMojoJsFeatures>::Convert(*this);
  }


  ExtraMojoJsFeatures();

  explicit ExtraMojoJsFeatures(
      bool file_system_access);


  ~ExtraMojoJsFeatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtraMojoJsFeaturesPtr>
  ExtraMojoJsFeaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtraMojoJsFeatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtraMojoJsFeatures::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtraMojoJsFeatures::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtraMojoJsFeatures::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtraMojoJsFeatures::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtraMojoJsFeatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtraMojoJsFeatures_UnserializedMessageContext<
            UserType, ExtraMojoJsFeatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtraMojoJsFeatures::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtraMojoJsFeatures::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtraMojoJsFeatures_UnserializedMessageContext<
            UserType, ExtraMojoJsFeatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtraMojoJsFeatures::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool file_system_access;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtraMojoJsFeatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtraMojoJsFeatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtraMojoJsFeatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtraMojoJsFeatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ExtraMojoJsFeaturesPtr ExtraMojoJsFeatures::Clone() const {
  return New(
      mojo::Clone(file_system_access)
  );
}

template <typename T, ExtraMojoJsFeatures::EnableIfSame<T>*>
bool ExtraMojoJsFeatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file_system_access, other_struct.file_system_access))
    return false;
  return true;
}

template <typename T, ExtraMojoJsFeatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.file_system_access < rhs.file_system_access)
    return true;
  if (rhs.file_system_access < lhs.file_system_access)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::ExtraMojoJsFeatures::DataView,
                                         ::content::mojom::ExtraMojoJsFeaturesPtr> {
  static bool IsNull(const ::content::mojom::ExtraMojoJsFeaturesPtr& input) { return !input; }
  static void SetToNull(::content::mojom::ExtraMojoJsFeaturesPtr* output) { output->reset(); }

  static decltype(::content::mojom::ExtraMojoJsFeatures::file_system_access) file_system_access(
      const ::content::mojom::ExtraMojoJsFeaturesPtr& input) {
    return input->file_system_access;
  }

  static bool Read(::content::mojom::ExtraMojoJsFeatures::DataView input, ::content::mojom::ExtraMojoJsFeaturesPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_PUBLIC_COMMON_EXTRA_MOJO_JS_FEATURES_MOJOM_H_