// content/public/common/alternative_error_page_override_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_COMMON_ALTERNATIVE_ERROR_PAGE_OVERRIDE_INFO_MOJOM_H_
#define CONTENT_PUBLIC_COMMON_ALTERNATIVE_ERROR_PAGE_OVERRIDE_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/public/common/alternative_error_page_override_info.mojom-features.h"  // IWYU pragma: export
#include "content/public/common/alternative_error_page_override_info.mojom-shared.h"  // IWYU pragma: export
#include "content/public/common/alternative_error_page_override_info.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom.h"
#include <string>
#include <vector>




#include "content/common/content_export.h"




namespace content::mojom {








class CONTENT_EXPORT AlternativeErrorPageOverrideInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AlternativeErrorPageOverrideInfo, T>::value>;
  using DataView = AlternativeErrorPageOverrideInfoDataView;
  using Data_ = internal::AlternativeErrorPageOverrideInfo_Data;

  template <typename... Args>
  static AlternativeErrorPageOverrideInfoPtr New(Args&&... args) {
    return AlternativeErrorPageOverrideInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AlternativeErrorPageOverrideInfoPtr From(const U& u) {
    return mojo::TypeConverter<AlternativeErrorPageOverrideInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AlternativeErrorPageOverrideInfo>::Convert(*this);
  }


  AlternativeErrorPageOverrideInfo();

  AlternativeErrorPageOverrideInfo(
      uint32_t resource_id,
      ::base::Value::Dict alternative_error_page_params);

AlternativeErrorPageOverrideInfo(const AlternativeErrorPageOverrideInfo&) = delete;
AlternativeErrorPageOverrideInfo& operator=(const AlternativeErrorPageOverrideInfo&) = delete;

  ~AlternativeErrorPageOverrideInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AlternativeErrorPageOverrideInfoPtr>
  AlternativeErrorPageOverrideInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AlternativeErrorPageOverrideInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AlternativeErrorPageOverrideInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AlternativeErrorPageOverrideInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AlternativeErrorPageOverrideInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AlternativeErrorPageOverrideInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AlternativeErrorPageOverrideInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AlternativeErrorPageOverrideInfo_UnserializedMessageContext<
            UserType, AlternativeErrorPageOverrideInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AlternativeErrorPageOverrideInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AlternativeErrorPageOverrideInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AlternativeErrorPageOverrideInfo_UnserializedMessageContext<
            UserType, AlternativeErrorPageOverrideInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AlternativeErrorPageOverrideInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t resource_id;
  
  ::base::Value::Dict alternative_error_page_params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AlternativeErrorPageOverrideInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AlternativeErrorPageOverrideInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AlternativeErrorPageOverrideInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AlternativeErrorPageOverrideInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AlternativeErrorPageOverrideInfoPtr AlternativeErrorPageOverrideInfo::Clone() const {
  return New(
      mojo::Clone(resource_id),
      mojo::Clone(alternative_error_page_params)
  );
}

template <typename T, AlternativeErrorPageOverrideInfo::EnableIfSame<T>*>
bool AlternativeErrorPageOverrideInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource_id, other_struct.resource_id))
    return false;
  if (!mojo::Equals(this->alternative_error_page_params, other_struct.alternative_error_page_params))
    return false;
  return true;
}

template <typename T, AlternativeErrorPageOverrideInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resource_id < rhs.resource_id)
    return true;
  if (rhs.resource_id < lhs.resource_id)
    return false;
  if (lhs.alternative_error_page_params < rhs.alternative_error_page_params)
    return true;
  if (rhs.alternative_error_page_params < lhs.alternative_error_page_params)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::AlternativeErrorPageOverrideInfo::DataView,
                                         ::content::mojom::AlternativeErrorPageOverrideInfoPtr> {
  static bool IsNull(const ::content::mojom::AlternativeErrorPageOverrideInfoPtr& input) { return !input; }
  static void SetToNull(::content::mojom::AlternativeErrorPageOverrideInfoPtr* output) { output->reset(); }

  static decltype(::content::mojom::AlternativeErrorPageOverrideInfo::resource_id) resource_id(
      const ::content::mojom::AlternativeErrorPageOverrideInfoPtr& input) {
    return input->resource_id;
  }

  static const decltype(::content::mojom::AlternativeErrorPageOverrideInfo::alternative_error_page_params)& alternative_error_page_params(
      const ::content::mojom::AlternativeErrorPageOverrideInfoPtr& input) {
    return input->alternative_error_page_params;
  }

  static bool Read(::content::mojom::AlternativeErrorPageOverrideInfo::DataView input, ::content::mojom::AlternativeErrorPageOverrideInfoPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_PUBLIC_COMMON_ALTERNATIVE_ERROR_PAGE_OVERRIDE_INFO_MOJOM_H_