// content/common/web_contents_ns_view_bridge.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_H_
#define CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/web_contents_ns_view_bridge.mojom-features.h"  // IWYU pragma: export
#include "content/common/web_contents_ns_view_bridge.mojom-shared.h"  // IWYU pragma: export
#include "content/common/web_contents_ns_view_bridge.mojom-forward.h"  // IWYU pragma: export
#include "content/public/common/drop_data.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "ui/events/mojom/event.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace remote_cocoa::mojom {

class WebContentsNSViewProxy;

template <typename ImplRefTraits>
class WebContentsNSViewStub;

class WebContentsNSViewRequestValidator;


class CONTENT_EXPORT WebContentsNSView
    : public WebContentsNSViewInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.WebContentsNSView";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebContentsNSViewInterfaceBase;
  using Proxy_ = WebContentsNSViewProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebContentsNSViewStub<ImplRefTraits>;

  using RequestValidator_ = WebContentsNSViewRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetParentNSViewMinVersion = 0,
    kResetParentNSViewMinVersion = 0,
    kSetBoundsMinVersion = 0,
    kSetVisibleMinVersion = 0,
    kMakeFirstResponderMinVersion = 0,
    kTakeFocusMinVersion = 0,
    kStartDragMinVersion = 0,
    kDestroyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetParentNSView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetParentNSView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MakeFirstResponder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakeFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartDrag_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Destroy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebContentsNSView() = default;

  virtual void SetParentNSView(uint64_t parent_ns_view_id) = 0;

  virtual void ResetParentNSView() = 0;

  virtual void SetBounds(const ::gfx::Rect& bounds_in_superview) = 0;

  virtual void SetVisible(bool visible) = 0;

  virtual void MakeFirstResponder() = 0;

  virtual void TakeFocus(bool reverse) = 0;

  virtual void StartDrag(const ::content::DropData& drop_data, const ::url::Origin& source_origin, uint32_t operation_mask, const ::gfx::ImageSkia& image, const ::gfx::Vector2d& image_offset, bool is_privileged) = 0;

  virtual void Destroy() = 0;
};

class WebContentsNSViewHostProxy;

template <typename ImplRefTraits>
class WebContentsNSViewHostStub;

class WebContentsNSViewHostRequestValidator;
class WebContentsNSViewHostResponseValidator;


class CONTENT_EXPORT WebContentsNSViewHost
    : public WebContentsNSViewHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.WebContentsNSViewHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    4, 
    6, 
    7, 
    8
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebContentsNSViewHostInterfaceBase;
  using Proxy_ = WebContentsNSViewHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebContentsNSViewHostStub<ImplRefTraits>;

  using RequestValidator_ = WebContentsNSViewHostRequestValidator;
  using ResponseValidator_ = WebContentsNSViewHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnMouseEventMinVersion = 0,
    kOnBecameFirstResponderMinVersion = 0,
    kOnWindowVisibilityChangedMinVersion = 0,
    kSetDropDataMinVersion = 0,
    kDraggingEnteredMinVersion = 0,
    kDraggingExitedMinVersion = 0,
    kDraggingUpdatedMinVersion = 0,
    kPerformDragOperationMinVersion = 0,
    kDragPromisedFileToMinVersion = 0,
    kEndDragMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnMouseEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBecameFirstResponder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowVisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDropData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DraggingEntered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DraggingExited_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DraggingUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PerformDragOperation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DragPromisedFileTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EndDrag_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebContentsNSViewHost() = default;

  virtual void OnMouseEvent(::std::unique_ptr<::ui::Event> event) = 0;

  virtual void OnBecameFirstResponder(SelectionDirection direction) = 0;

  virtual void OnWindowVisibilityChanged(Visibility visibility) = 0;

  virtual void SetDropData(const ::content::DropData& drop_data) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DraggingEntered(DraggingInfoPtr dragging_info, uint32_t* out_result);
  using DraggingEnteredCallback = base::OnceCallback<void(uint32_t)>;
  using DraggingEnteredMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void DraggingEntered(DraggingInfoPtr dragging_info, DraggingEnteredCallback callback) = 0;

  virtual void DraggingExited() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DraggingUpdated(DraggingInfoPtr dragging_info, uint32_t* out_result);
  using DraggingUpdatedCallback = base::OnceCallback<void(uint32_t)>;
  using DraggingUpdatedMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void DraggingUpdated(DraggingInfoPtr dragging_info, DraggingUpdatedCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool PerformDragOperation(DraggingInfoPtr dragging_info, bool* out_result);
  using PerformDragOperationCallback = base::OnceCallback<void(bool)>;
  using PerformDragOperationMojoCallback = base::OnceCallback<void(bool)>;

  virtual void PerformDragOperation(DraggingInfoPtr dragging_info, PerformDragOperationCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DragPromisedFileTo(const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin, ::base::FilePath* out_file_path);
  using DragPromisedFileToCallback = base::OnceCallback<void(const ::base::FilePath&)>;
  using DragPromisedFileToMojoCallback = base::OnceCallback<void(const ::base::FilePath&)>;

  virtual void DragPromisedFileTo(const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin, DragPromisedFileToCallback callback) = 0;

  virtual void EndDrag(uint32_t drag_operation, const ::gfx::PointF& local_point, const ::gfx::PointF& screen_point) = 0;
};



class CONTENT_EXPORT WebContentsNSViewProxy
    : public WebContentsNSView {
 public:
  using InterfaceType = WebContentsNSView;

  explicit WebContentsNSViewProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetParentNSView(uint64_t parent_ns_view_id) final;
  
  void ResetParentNSView() final;
  
  void SetBounds(const ::gfx::Rect& bounds_in_superview) final;
  
  void SetVisible(bool visible) final;
  
  void MakeFirstResponder() final;
  
  void TakeFocus(bool reverse) final;
  
  void StartDrag(const ::content::DropData& drop_data, const ::url::Origin& source_origin, uint32_t operation_mask, const ::gfx::ImageSkia& image, const ::gfx::Vector2d& image_offset, bool is_privileged) final;
  
  void Destroy() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT WebContentsNSViewHostProxy
    : public WebContentsNSViewHost {
 public:
  using InterfaceType = WebContentsNSViewHost;

  explicit WebContentsNSViewHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnMouseEvent(::std::unique_ptr<::ui::Event> event) final;
  
  void OnBecameFirstResponder(SelectionDirection direction) final;
  
  void OnWindowVisibilityChanged(Visibility visibility) final;
  
  void SetDropData(const ::content::DropData& drop_data) final;
  
  bool DraggingEntered(DraggingInfoPtr dragging_info, uint32_t* out_result) final;
  
  void DraggingEntered(DraggingInfoPtr dragging_info, DraggingEnteredCallback callback) final;
  
  void DraggingExited() final;
  
  bool DraggingUpdated(DraggingInfoPtr dragging_info, uint32_t* out_result) final;
  
  void DraggingUpdated(DraggingInfoPtr dragging_info, DraggingUpdatedCallback callback) final;
  
  bool PerformDragOperation(DraggingInfoPtr dragging_info, bool* out_result) final;
  
  void PerformDragOperation(DraggingInfoPtr dragging_info, PerformDragOperationCallback callback) final;
  
  bool DragPromisedFileTo(const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin, ::base::FilePath* out_file_path) final;
  
  void DragPromisedFileTo(const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin, DragPromisedFileToCallback callback) final;
  
  void EndDrag(uint32_t drag_operation, const ::gfx::PointF& local_point, const ::gfx::PointF& screen_point) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT WebContentsNSViewStubDispatch {
 public:
  static bool Accept(WebContentsNSView* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebContentsNSView* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebContentsNSView>>
class WebContentsNSViewStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebContentsNSViewStub() = default;
  ~WebContentsNSViewStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentsNSViewStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentsNSViewStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT WebContentsNSViewHostStubDispatch {
 public:
  static bool Accept(WebContentsNSViewHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebContentsNSViewHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebContentsNSViewHost>>
class WebContentsNSViewHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebContentsNSViewHostStub() = default;
  ~WebContentsNSViewHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentsNSViewHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebContentsNSViewHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT WebContentsNSViewRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT WebContentsNSViewHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT WebContentsNSViewHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class CONTENT_EXPORT DraggingInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DraggingInfo, T>::value>;
  using DataView = DraggingInfoDataView;
  using Data_ = internal::DraggingInfo_Data;

  template <typename... Args>
  static DraggingInfoPtr New(Args&&... args) {
    return DraggingInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DraggingInfoPtr From(const U& u) {
    return mojo::TypeConverter<DraggingInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DraggingInfo>::Convert(*this);
  }


  DraggingInfo();

  DraggingInfo(
      const ::gfx::PointF& location_in_view,
      const ::gfx::PointF& location_in_screen,
      const std::optional<::GURL>& url,
      uint32_t operation_mask);


  ~DraggingInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DraggingInfoPtr>
  DraggingInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DraggingInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DraggingInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DraggingInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DraggingInfo_UnserializedMessageContext<
            UserType, DraggingInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DraggingInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DraggingInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DraggingInfo_UnserializedMessageContext<
            UserType, DraggingInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DraggingInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF location_in_view;
  
  ::gfx::PointF location_in_screen;
  
  std::optional<::GURL> url;
  
  uint32_t operation_mask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DraggingInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DraggingInfoPtr DraggingInfo::Clone() const {
  return New(
      mojo::Clone(location_in_view),
      mojo::Clone(location_in_screen),
      mojo::Clone(url),
      mojo::Clone(operation_mask)
  );
}

template <typename T, DraggingInfo::EnableIfSame<T>*>
bool DraggingInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->location_in_view, other_struct.location_in_view))
    return false;
  if (!mojo::Equals(this->location_in_screen, other_struct.location_in_screen))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->operation_mask, other_struct.operation_mask))
    return false;
  return true;
}

template <typename T, DraggingInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.location_in_view < rhs.location_in_view)
    return true;
  if (rhs.location_in_view < lhs.location_in_view)
    return false;
  if (lhs.location_in_screen < rhs.location_in_screen)
    return true;
  if (rhs.location_in_screen < lhs.location_in_screen)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.operation_mask < rhs.operation_mask)
    return true;
  if (rhs.operation_mask < lhs.operation_mask)
    return false;
  return false;
}


}  // remote_cocoa::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::remote_cocoa::mojom::DraggingInfo::DataView,
                                         ::remote_cocoa::mojom::DraggingInfoPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::DraggingInfoPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::DraggingInfoPtr* output) { output->reset(); }

  static const decltype(::remote_cocoa::mojom::DraggingInfo::location_in_view)& location_in_view(
      const ::remote_cocoa::mojom::DraggingInfoPtr& input) {
    return input->location_in_view;
  }

  static const decltype(::remote_cocoa::mojom::DraggingInfo::location_in_screen)& location_in_screen(
      const ::remote_cocoa::mojom::DraggingInfoPtr& input) {
    return input->location_in_screen;
  }

  static const decltype(::remote_cocoa::mojom::DraggingInfo::url)& url(
      const ::remote_cocoa::mojom::DraggingInfoPtr& input) {
    return input->url;
  }

  static decltype(::remote_cocoa::mojom::DraggingInfo::operation_mask) operation_mask(
      const ::remote_cocoa::mojom::DraggingInfoPtr& input) {
    return input->operation_mask;
  }

  static bool Read(::remote_cocoa::mojom::DraggingInfo::DataView input, ::remote_cocoa::mojom::DraggingInfoPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_H_