// content/common/web_contents_ns_view_bridge.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_TEST_UTILS_H_
#define CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_TEST_UTILS_H_

#include "content/common/web_contents_ns_view_bridge.mojom.h"
#include "content/common/content_export.h"


namespace remote_cocoa::mojom {


class CONTENT_EXPORT WebContentsNSViewInterceptorForTesting : public WebContentsNSView {
  virtual WebContentsNSView* GetForwardingInterface() = 0;
  void SetParentNSView(uint64_t parent_ns_view_id) override;
  void ResetParentNSView() override;
  void SetBounds(const ::gfx::Rect& bounds_in_superview) override;
  void SetVisible(bool visible) override;
  void MakeFirstResponder() override;
  void TakeFocus(bool reverse) override;
  void StartDrag(const ::content::DropData& drop_data, const ::url::Origin& source_origin, uint32_t operation_mask, const ::gfx::ImageSkia& image, const ::gfx::Vector2d& image_offset, bool is_privileged) override;
  void Destroy() override;
};
class CONTENT_EXPORT WebContentsNSViewAsyncWaiter {
 public:
  explicit WebContentsNSViewAsyncWaiter(WebContentsNSView* proxy);

  WebContentsNSViewAsyncWaiter(const WebContentsNSViewAsyncWaiter&) = delete;
  WebContentsNSViewAsyncWaiter& operator=(const WebContentsNSViewAsyncWaiter&) = delete;

  ~WebContentsNSViewAsyncWaiter();

 private:
  WebContentsNSView* const proxy_;
};


class CONTENT_EXPORT WebContentsNSViewHostInterceptorForTesting : public WebContentsNSViewHost {
  virtual WebContentsNSViewHost* GetForwardingInterface() = 0;
  void OnMouseEvent(::std::unique_ptr<::ui::Event> event) override;
  void OnBecameFirstResponder(SelectionDirection direction) override;
  void OnWindowVisibilityChanged(Visibility visibility) override;
  void SetDropData(const ::content::DropData& drop_data) override;
  void DraggingEntered(DraggingInfoPtr dragging_info, DraggingEnteredCallback callback) override;
  void DraggingExited() override;
  void DraggingUpdated(DraggingInfoPtr dragging_info, DraggingUpdatedCallback callback) override;
  void PerformDragOperation(DraggingInfoPtr dragging_info, PerformDragOperationCallback callback) override;
  void DragPromisedFileTo(const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin, DragPromisedFileToCallback callback) override;
  void EndDrag(uint32_t drag_operation, const ::gfx::PointF& local_point, const ::gfx::PointF& screen_point) override;
};
class CONTENT_EXPORT WebContentsNSViewHostAsyncWaiter {
 public:
  explicit WebContentsNSViewHostAsyncWaiter(WebContentsNSViewHost* proxy);

  WebContentsNSViewHostAsyncWaiter(const WebContentsNSViewHostAsyncWaiter&) = delete;
  WebContentsNSViewHostAsyncWaiter& operator=(const WebContentsNSViewHostAsyncWaiter&) = delete;

  ~WebContentsNSViewHostAsyncWaiter();
  void DraggingEntered(
      DraggingInfoPtr dragging_info, uint32_t* out_result);
  uint32_t DraggingEntered(DraggingInfoPtr dragging_info);
  void DraggingUpdated(
      DraggingInfoPtr dragging_info, uint32_t* out_result);
  uint32_t DraggingUpdated(DraggingInfoPtr dragging_info);
  void PerformDragOperation(
      DraggingInfoPtr dragging_info, bool* out_result);
  bool PerformDragOperation(DraggingInfoPtr dragging_info);
  void DragPromisedFileTo(
      const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin, ::base::FilePath* out_file_path);
  ::base::FilePath DragPromisedFileTo(const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin);

 private:
  WebContentsNSViewHost* const proxy_;
};




}  // remote_cocoa::mojom

#endif  // CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_TEST_UTILS_H_