// content/common/web_contents_ns_view_bridge.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_SHARED_H_
#define CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/web_contents_ns_view_bridge.mojom-shared-internal.h"
#include "content/public/common/drop_data.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "content/common/web_contents_ns_view_bridge.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::remote_cocoa::mojom::SelectionDirection>
    : public mojo::internal::EnumHashImpl<::remote_cocoa::mojom::SelectionDirection> {};

template <>
struct hash<::remote_cocoa::mojom::Visibility>
    : public mojo::internal::EnumHashImpl<::remote_cocoa::mojom::Visibility> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::SelectionDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::remote_cocoa::mojom::SelectionDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::remote_cocoa::mojom::SelectionDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::Visibility, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::remote_cocoa::mojom::Visibility, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::remote_cocoa::mojom::Visibility>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::DraggingInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::remote_cocoa::mojom::DraggingInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::remote_cocoa::mojom::internal::DraggingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::location_in_view(input)) in_location_in_view = Traits::location_in_view(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location_in_view)::BaseType> location_in_view_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_location_in_view,
      location_in_view_fragment);

    fragment->location_in_view.Set(
        location_in_view_fragment.is_null() ? nullptr : location_in_view_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->location_in_view.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location_in_view in DraggingInfo struct");

    decltype(Traits::location_in_screen(input)) in_location_in_screen = Traits::location_in_screen(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location_in_screen)::BaseType> location_in_screen_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_location_in_screen,
      location_in_screen_fragment);

    fragment->location_in_screen.Set(
        location_in_screen_fragment.is_null() ? nullptr : location_in_screen_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->location_in_screen.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location_in_screen in DraggingInfo struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    fragment->operation_mask = Traits::operation_mask(input);
  }

  static bool Deserialize(::remote_cocoa::mojom::internal::DraggingInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::remote_cocoa::mojom::DraggingInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace remote_cocoa::mojom {

inline void DraggingInfoDataView::GetLocationInViewDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->location_in_view.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void DraggingInfoDataView::GetLocationInScreenDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->location_in_screen.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void DraggingInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // remote_cocoa::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::remote_cocoa::mojom::SelectionDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::remote_cocoa::mojom::SelectionDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::remote_cocoa::mojom::Visibility> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::remote_cocoa::mojom::Visibility value);
};

} // namespace perfetto

#endif  // CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_SHARED_H_