// content/common/web_contents_ns_view_bridge.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/web_contents_ns_view_bridge.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/web_contents_ns_view_bridge.mojom-params-data.h"
namespace remote_cocoa {
namespace mojom {

NOINLINE static const char* SelectionDirectionToStringHelper(SelectionDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SelectionDirection::kDirect:
      return "kDirect";
    case SelectionDirection::kForward:
      return "kForward";
    case SelectionDirection::kReverse:
      return "kReverse";
    default:
      return nullptr;
  }
}

std::string SelectionDirectionToString(SelectionDirection value) {
  const char *str = SelectionDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SelectionDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SelectionDirection value) {
  return os << SelectionDirectionToString(value);
}

NOINLINE static const char* VisibilityToStringHelper(Visibility value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Visibility::kVisible:
      return "kVisible";
    case Visibility::kOccluded:
      return "kOccluded";
    case Visibility::kHidden:
      return "kHidden";
    default:
      return nullptr;
  }
}

std::string VisibilityToString(Visibility value) {
  const char *str = VisibilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Visibility value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Visibility value) {
  return os << VisibilityToString(value);
}

namespace internal {


// static
bool DraggingInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DraggingInfo_Data* object =
      static_cast<const DraggingInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location_in_view, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location_in_view, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location_in_screen, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location_in_screen, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

DraggingInfo_Data::DraggingInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSView_SetParentNSView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSView_SetParentNSView_Params_Data* object =
      static_cast<const WebContentsNSView_SetParentNSView_Params_Data*>(data);

  return true;
}

WebContentsNSView_SetParentNSView_Params_Data::WebContentsNSView_SetParentNSView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSView_ResetParentNSView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSView_ResetParentNSView_Params_Data* object =
      static_cast<const WebContentsNSView_ResetParentNSView_Params_Data*>(data);

  return true;
}

WebContentsNSView_ResetParentNSView_Params_Data::WebContentsNSView_ResetParentNSView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSView_SetBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSView_SetBounds_Params_Data* object =
      static_cast<const WebContentsNSView_SetBounds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds_in_superview, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds_in_superview, validation_context))
    return false;

  return true;
}

WebContentsNSView_SetBounds_Params_Data::WebContentsNSView_SetBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSView_SetVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSView_SetVisible_Params_Data* object =
      static_cast<const WebContentsNSView_SetVisible_Params_Data*>(data);

  return true;
}

WebContentsNSView_SetVisible_Params_Data::WebContentsNSView_SetVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSView_MakeFirstResponder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSView_MakeFirstResponder_Params_Data* object =
      static_cast<const WebContentsNSView_MakeFirstResponder_Params_Data*>(data);

  return true;
}

WebContentsNSView_MakeFirstResponder_Params_Data::WebContentsNSView_MakeFirstResponder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSView_TakeFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSView_TakeFocus_Params_Data* object =
      static_cast<const WebContentsNSView_TakeFocus_Params_Data*>(data);

  return true;
}

WebContentsNSView_TakeFocus_Params_Data::WebContentsNSView_TakeFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSView_StartDrag_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSView_StartDrag_Params_Data* object =
      static_cast<const WebContentsNSView_StartDrag_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drop_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drop_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_offset, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_offset, validation_context))
    return false;

  return true;
}

WebContentsNSView_StartDrag_Params_Data::WebContentsNSView_StartDrag_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSView_Destroy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSView_Destroy_Params_Data* object =
      static_cast<const WebContentsNSView_Destroy_Params_Data*>(data);

  return true;
}

WebContentsNSView_Destroy_Params_Data::WebContentsNSView_Destroy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_OnMouseEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_OnMouseEvent_Params_Data* object =
      static_cast<const WebContentsNSViewHost_OnMouseEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_OnMouseEvent_Params_Data::WebContentsNSViewHost_OnMouseEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_OnBecameFirstResponder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_OnBecameFirstResponder_Params_Data* object =
      static_cast<const WebContentsNSViewHost_OnBecameFirstResponder_Params_Data*>(data);


  if (!::remote_cocoa::mojom::internal::SelectionDirection_Data
        ::Validate(object->direction, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_OnBecameFirstResponder_Params_Data::WebContentsNSViewHost_OnBecameFirstResponder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_OnWindowVisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_OnWindowVisibilityChanged_Params_Data* object =
      static_cast<const WebContentsNSViewHost_OnWindowVisibilityChanged_Params_Data*>(data);


  if (!::remote_cocoa::mojom::internal::Visibility_Data
        ::Validate(object->visibility, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_OnWindowVisibilityChanged_Params_Data::WebContentsNSViewHost_OnWindowVisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_SetDropData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_SetDropData_Params_Data* object =
      static_cast<const WebContentsNSViewHost_SetDropData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drop_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drop_data, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_SetDropData_Params_Data::WebContentsNSViewHost_SetDropData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_DraggingEntered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_DraggingEntered_Params_Data* object =
      static_cast<const WebContentsNSViewHost_DraggingEntered_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dragging_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dragging_info, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_DraggingEntered_Params_Data::WebContentsNSViewHost_DraggingEntered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_DraggingEntered_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_DraggingEntered_ResponseParams_Data* object =
      static_cast<const WebContentsNSViewHost_DraggingEntered_ResponseParams_Data*>(data);

  return true;
}

WebContentsNSViewHost_DraggingEntered_ResponseParams_Data::WebContentsNSViewHost_DraggingEntered_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_DraggingExited_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_DraggingExited_Params_Data* object =
      static_cast<const WebContentsNSViewHost_DraggingExited_Params_Data*>(data);

  return true;
}

WebContentsNSViewHost_DraggingExited_Params_Data::WebContentsNSViewHost_DraggingExited_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_DraggingUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_DraggingUpdated_Params_Data* object =
      static_cast<const WebContentsNSViewHost_DraggingUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dragging_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dragging_info, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_DraggingUpdated_Params_Data::WebContentsNSViewHost_DraggingUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data* object =
      static_cast<const WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data*>(data);

  return true;
}

WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data::WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_PerformDragOperation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_PerformDragOperation_Params_Data* object =
      static_cast<const WebContentsNSViewHost_PerformDragOperation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dragging_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dragging_info, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_PerformDragOperation_Params_Data::WebContentsNSViewHost_PerformDragOperation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data* object =
      static_cast<const WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data*>(data);

  return true;
}

WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data::WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_DragPromisedFileTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_DragPromisedFileTo_Params_Data* object =
      static_cast<const WebContentsNSViewHost_DragPromisedFileTo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drop_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drop_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->download_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->download_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_DragPromisedFileTo_Params_Data::WebContentsNSViewHost_DragPromisedFileTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data* object =
      static_cast<const WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data::WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsNSViewHost_EndDrag_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentsNSViewHost_EndDrag_Params_Data* object =
      static_cast<const WebContentsNSViewHost_EndDrag_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_point, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local_point, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screen_point, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screen_point, validation_context))
    return false;

  return true;
}

WebContentsNSViewHost_EndDrag_Params_Data::WebContentsNSViewHost_EndDrag_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace remote_cocoa

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::SelectionDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::SelectionDirection value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::SelectionDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::Visibility>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::Visibility value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::VisibilityToString(value));
}

} // namespace perfetto