// content/common/web_contents_ns_view_bridge.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_DATA_VIEW_H_
#define CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "content/common/web_contents_ns_view_bridge.mojom-shared-internal.h"
#include "content/public/common/drop_data.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace remote_cocoa::mojom {
class DraggingInfoDataView;



}  // remote_cocoa::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::DraggingInfoDataView> {
  using Data = ::remote_cocoa::mojom::internal::DraggingInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace remote_cocoa::mojom {


enum class SelectionDirection : int32_t {
  
  kDirect = 0,
  
  kForward = 1,
  
  kReverse = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, SelectionDirection value);
inline bool IsKnownEnumValue(SelectionDirection value) {
  return internal::SelectionDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Visibility : int32_t {
  
  kVisible = 0,
  
  kOccluded = 1,
  
  kHidden = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, Visibility value);
inline bool IsKnownEnumValue(Visibility value) {
  return internal::Visibility_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebContentsNSViewInterfaceBase {};

using WebContentsNSViewPtrDataView =
    mojo::InterfacePtrDataView<WebContentsNSViewInterfaceBase>;
using WebContentsNSViewRequestDataView =
    mojo::InterfaceRequestDataView<WebContentsNSViewInterfaceBase>;
using WebContentsNSViewAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebContentsNSViewInterfaceBase>;
using WebContentsNSViewAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebContentsNSViewInterfaceBase>;
class WebContentsNSViewHostInterfaceBase {};

using WebContentsNSViewHostPtrDataView =
    mojo::InterfacePtrDataView<WebContentsNSViewHostInterfaceBase>;
using WebContentsNSViewHostRequestDataView =
    mojo::InterfaceRequestDataView<WebContentsNSViewHostInterfaceBase>;
using WebContentsNSViewHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebContentsNSViewHostInterfaceBase>;
using WebContentsNSViewHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebContentsNSViewHostInterfaceBase>;


class DraggingInfoDataView {
 public:
  DraggingInfoDataView() = default;

  DraggingInfoDataView(
      internal::DraggingInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationInViewDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocationInView(UserType* output) {
    
    auto* pointer = data_->location_in_view.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetLocationInScreenDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocationInScreen(UserType* output) {
    
    auto* pointer = data_->location_in_screen.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint32_t operation_mask() const {
    return data_->operation_mask;
  }
 private:
  internal::DraggingInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // remote_cocoa::mojom

#endif  // CONTENT_COMMON_WEB_CONTENTS_NS_VIEW_BRIDGE_MOJOM_DATA_VIEW_H_