// content/common/synthetic_trial_configuration.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_SYNTHETIC_TRIAL_CONFIGURATION_MOJOM_H_
#define CONTENT_COMMON_SYNTHETIC_TRIAL_CONFIGURATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/synthetic_trial_configuration.mojom-features.h"  // IWYU pragma: export
#include "content/common/synthetic_trial_configuration.mojom-shared.h"  // IWYU pragma: export
#include "content/common/synthetic_trial_configuration.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class SyntheticTrialConfigurationProxy;

template <typename ImplRefTraits>
class SyntheticTrialConfigurationStub;

class SyntheticTrialConfigurationRequestValidator;


class CONTENT_EXPORT SyntheticTrialConfiguration
    : public SyntheticTrialConfigurationInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.SyntheticTrialConfiguration";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SyntheticTrialConfigurationInterfaceBase;
  using Proxy_ = SyntheticTrialConfigurationProxy;

  template <typename ImplRefTraits>
  using Stub_ = SyntheticTrialConfigurationStub<ImplRefTraits>;

  using RequestValidator_ = SyntheticTrialConfigurationRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddOrUpdateSyntheticTrialGroupsMinVersion = 0,
    kRemoveSyntheticTrialGroupsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddOrUpdateSyntheticTrialGroups_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveSyntheticTrialGroups_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SyntheticTrialConfiguration() = default;

  virtual void AddOrUpdateSyntheticTrialGroups(std::vector<SyntheticTrialGroupPtr> groups) = 0;

  virtual void RemoveSyntheticTrialGroups(std::vector<SyntheticTrialGroupPtr> groups) = 0;
};



class CONTENT_EXPORT SyntheticTrialConfigurationProxy
    : public SyntheticTrialConfiguration {
 public:
  using InterfaceType = SyntheticTrialConfiguration;

  explicit SyntheticTrialConfigurationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddOrUpdateSyntheticTrialGroups(std::vector<SyntheticTrialGroupPtr> groups) final;
  
  void RemoveSyntheticTrialGroups(std::vector<SyntheticTrialGroupPtr> groups) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT SyntheticTrialConfigurationStubDispatch {
 public:
  static bool Accept(SyntheticTrialConfiguration* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SyntheticTrialConfiguration* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SyntheticTrialConfiguration>>
class SyntheticTrialConfigurationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SyntheticTrialConfigurationStub() = default;
  ~SyntheticTrialConfigurationStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SyntheticTrialConfigurationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SyntheticTrialConfigurationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT SyntheticTrialConfigurationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class CONTENT_EXPORT SyntheticTrialGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyntheticTrialGroup, T>::value>;
  using DataView = SyntheticTrialGroupDataView;
  using Data_ = internal::SyntheticTrialGroup_Data;

  template <typename... Args>
  static SyntheticTrialGroupPtr New(Args&&... args) {
    return SyntheticTrialGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyntheticTrialGroupPtr From(const U& u) {
    return mojo::TypeConverter<SyntheticTrialGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyntheticTrialGroup>::Convert(*this);
  }


  SyntheticTrialGroup();

  SyntheticTrialGroup(
      const std::string& trial_name,
      const std::string& group_name);


  ~SyntheticTrialGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyntheticTrialGroupPtr>
  SyntheticTrialGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyntheticTrialGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyntheticTrialGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyntheticTrialGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyntheticTrialGroup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyntheticTrialGroup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyntheticTrialGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyntheticTrialGroup_UnserializedMessageContext<
            UserType, SyntheticTrialGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyntheticTrialGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyntheticTrialGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyntheticTrialGroup_UnserializedMessageContext<
            UserType, SyntheticTrialGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyntheticTrialGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string trial_name;
  
  std::string group_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyntheticTrialGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyntheticTrialGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyntheticTrialGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyntheticTrialGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SyntheticTrialGroupPtr SyntheticTrialGroup::Clone() const {
  return New(
      mojo::Clone(trial_name),
      mojo::Clone(group_name)
  );
}

template <typename T, SyntheticTrialGroup::EnableIfSame<T>*>
bool SyntheticTrialGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->trial_name, other_struct.trial_name))
    return false;
  if (!mojo::Equals(this->group_name, other_struct.group_name))
    return false;
  return true;
}

template <typename T, SyntheticTrialGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.trial_name < rhs.trial_name)
    return true;
  if (rhs.trial_name < lhs.trial_name)
    return false;
  if (lhs.group_name < rhs.group_name)
    return true;
  if (rhs.group_name < lhs.group_name)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SyntheticTrialGroup::DataView,
                                         ::content::mojom::SyntheticTrialGroupPtr> {
  static bool IsNull(const ::content::mojom::SyntheticTrialGroupPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SyntheticTrialGroupPtr* output) { output->reset(); }

  static const decltype(::content::mojom::SyntheticTrialGroup::trial_name)& trial_name(
      const ::content::mojom::SyntheticTrialGroupPtr& input) {
    return input->trial_name;
  }

  static const decltype(::content::mojom::SyntheticTrialGroup::group_name)& group_name(
      const ::content::mojom::SyntheticTrialGroupPtr& input) {
    return input->group_name;
  }

  static bool Read(::content::mojom::SyntheticTrialGroup::DataView input, ::content::mojom::SyntheticTrialGroupPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_SYNTHETIC_TRIAL_CONFIGURATION_MOJOM_H_