// content/common/synthetic_trial_configuration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/synthetic_trial_configuration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/synthetic_trial_configuration.mojom-params-data.h"
#include "content/common/synthetic_trial_configuration.mojom-shared-message-ids.h"

#include "content/common/synthetic_trial_configuration.mojom-import-headers.h"
#include "content/common/synthetic_trial_configuration.mojom-test-utils.h"


namespace content::mojom {
SyntheticTrialGroup::SyntheticTrialGroup()
    : trial_name(),
      group_name() {}

SyntheticTrialGroup::SyntheticTrialGroup(
    const std::string& trial_name_in,
    const std::string& group_name_in)
    : trial_name(std::move(trial_name_in)),
      group_name(std::move(group_name_in)) {}

SyntheticTrialGroup::~SyntheticTrialGroup() = default;
size_t SyntheticTrialGroup::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->trial_name);
  seed = mojo::internal::Hash(seed, this->group_name);
  return seed;
}

void SyntheticTrialGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trial_name"), this->trial_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_name"), this->group_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SyntheticTrialGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SyntheticTrialConfiguration::IPCStableHashFunction SyntheticTrialConfiguration::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SyntheticTrialConfiguration>(message.name())) {
    case messages::SyntheticTrialConfiguration::kAddOrUpdateSyntheticTrialGroups: {
      return &SyntheticTrialConfiguration::AddOrUpdateSyntheticTrialGroups_Sym::IPCStableHash;
    }
    case messages::SyntheticTrialConfiguration::kRemoveSyntheticTrialGroups: {
      return &SyntheticTrialConfiguration::RemoveSyntheticTrialGroups_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SyntheticTrialConfiguration::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SyntheticTrialConfiguration>(message.name())) {
      case messages::SyntheticTrialConfiguration::kAddOrUpdateSyntheticTrialGroups:
            return "Receive content::mojom::SyntheticTrialConfiguration::AddOrUpdateSyntheticTrialGroups";
      case messages::SyntheticTrialConfiguration::kRemoveSyntheticTrialGroups:
            return "Receive content::mojom::SyntheticTrialConfiguration::RemoveSyntheticTrialGroups";
    }
  } else {
    switch (static_cast<messages::SyntheticTrialConfiguration>(message.name())) {
      case messages::SyntheticTrialConfiguration::kAddOrUpdateSyntheticTrialGroups:
            return "Receive reply content::mojom::SyntheticTrialConfiguration::AddOrUpdateSyntheticTrialGroups";
      case messages::SyntheticTrialConfiguration::kRemoveSyntheticTrialGroups:
            return "Receive reply content::mojom::SyntheticTrialConfiguration::RemoveSyntheticTrialGroups";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SyntheticTrialConfiguration::AddOrUpdateSyntheticTrialGroups_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43ffed7f;  // IPCStableHash for content::mojom::SyntheticTrialConfiguration::AddOrUpdateSyntheticTrialGroups
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SyntheticTrialConfiguration::RemoveSyntheticTrialGroups_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92ac229b;  // IPCStableHash for content::mojom::SyntheticTrialConfiguration::RemoveSyntheticTrialGroups
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SyntheticTrialConfigurationProxy::SyntheticTrialConfigurationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SyntheticTrialConfigurationProxy::AddOrUpdateSyntheticTrialGroups(
    std::vector<SyntheticTrialGroupPtr> in_groups) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::SyntheticTrialConfiguration::AddOrUpdateSyntheticTrialGroups", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("groups"), in_groups,
                        "<value of type std::vector<SyntheticTrialGroupPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SyntheticTrialConfiguration::kAddOrUpdateSyntheticTrialGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::SyntheticTrialConfiguration_AddOrUpdateSyntheticTrialGroups_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->groups)::BaseType>
      groups_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::content::mojom::SyntheticTrialGroupDataView>>(
    in_groups,
    groups_fragment,
    &groups_validate_params);

  params->groups.Set(
      groups_fragment.is_null() ? nullptr : groups_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->groups.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null groups in SyntheticTrialConfiguration.AddOrUpdateSyntheticTrialGroups request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SyntheticTrialConfiguration::Name_);
  message.set_method_name("AddOrUpdateSyntheticTrialGroups");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SyntheticTrialConfigurationProxy::RemoveSyntheticTrialGroups(
    std::vector<SyntheticTrialGroupPtr> in_groups) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::SyntheticTrialConfiguration::RemoveSyntheticTrialGroups", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("groups"), in_groups,
                        "<value of type std::vector<SyntheticTrialGroupPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SyntheticTrialConfiguration::kRemoveSyntheticTrialGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::SyntheticTrialConfiguration_RemoveSyntheticTrialGroups_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->groups)::BaseType>
      groups_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::content::mojom::SyntheticTrialGroupDataView>>(
    in_groups,
    groups_fragment,
    &groups_validate_params);

  params->groups.Set(
      groups_fragment.is_null() ? nullptr : groups_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->groups.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null groups in SyntheticTrialConfiguration.RemoveSyntheticTrialGroups request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SyntheticTrialConfiguration::Name_);
  message.set_method_name("RemoveSyntheticTrialGroups");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SyntheticTrialConfigurationStubDispatch::Accept(
    SyntheticTrialConfiguration* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SyntheticTrialConfiguration>(message->header()->name)) {
    case messages::SyntheticTrialConfiguration::kAddOrUpdateSyntheticTrialGroups: {
      DCHECK(message->is_serialized());
      internal::SyntheticTrialConfiguration_AddOrUpdateSyntheticTrialGroups_Params_Data* params =
          reinterpret_cast<internal::SyntheticTrialConfiguration_AddOrUpdateSyntheticTrialGroups_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SyntheticTrialConfiguration.0
      bool success = true;
      std::vector<SyntheticTrialGroupPtr> p_groups{};
      SyntheticTrialConfiguration_AddOrUpdateSyntheticTrialGroups_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroups(&p_groups))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SyntheticTrialConfiguration::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddOrUpdateSyntheticTrialGroups(        
        std::move(p_groups));
      return true;
    }
    case messages::SyntheticTrialConfiguration::kRemoveSyntheticTrialGroups: {
      DCHECK(message->is_serialized());
      internal::SyntheticTrialConfiguration_RemoveSyntheticTrialGroups_Params_Data* params =
          reinterpret_cast<internal::SyntheticTrialConfiguration_RemoveSyntheticTrialGroups_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SyntheticTrialConfiguration.1
      bool success = true;
      std::vector<SyntheticTrialGroupPtr> p_groups{};
      SyntheticTrialConfiguration_RemoveSyntheticTrialGroups_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroups(&p_groups))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SyntheticTrialConfiguration::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveSyntheticTrialGroups(        
        std::move(p_groups));
      return true;
    }
  }
  return false;
}

// static
bool SyntheticTrialConfigurationStubDispatch::AcceptWithResponder(
    SyntheticTrialConfiguration* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SyntheticTrialConfiguration>(message->header()->name)) {
    case messages::SyntheticTrialConfiguration::kAddOrUpdateSyntheticTrialGroups: {
      break;
    }
    case messages::SyntheticTrialConfiguration::kRemoveSyntheticTrialGroups: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSyntheticTrialConfigurationValidationInfo[] = {
    { &internal::SyntheticTrialConfiguration_AddOrUpdateSyntheticTrialGroups_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SyntheticTrialConfiguration_RemoveSyntheticTrialGroups_Params_Data::Validate,
     nullptr /* no response */},
};

bool SyntheticTrialConfigurationRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content::mojom::SyntheticTrialConfiguration::Name_,
    kSyntheticTrialConfigurationValidationInfo);
}



}  // content::mojom


namespace mojo {


// static
bool StructTraits<::content::mojom::SyntheticTrialGroup::DataView, ::content::mojom::SyntheticTrialGroupPtr>::Read(
    ::content::mojom::SyntheticTrialGroup::DataView input,
    ::content::mojom::SyntheticTrialGroupPtr* output) {
  bool success = true;
  ::content::mojom::SyntheticTrialGroupPtr result(::content::mojom::SyntheticTrialGroup::New());
  
      if (success && !input.ReadTrialName(&result->trial_name))
        success = false;
      if (success && !input.ReadGroupName(&result->group_name))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void SyntheticTrialConfigurationInterceptorForTesting::AddOrUpdateSyntheticTrialGroups(std::vector<SyntheticTrialGroupPtr> groups) {
  GetForwardingInterface()->AddOrUpdateSyntheticTrialGroups(
    std::move(groups)
    );
}
void SyntheticTrialConfigurationInterceptorForTesting::RemoveSyntheticTrialGroups(std::vector<SyntheticTrialGroupPtr> groups) {
  GetForwardingInterface()->RemoveSyntheticTrialGroups(
    std::move(groups)
    );
}
SyntheticTrialConfigurationAsyncWaiter::SyntheticTrialConfigurationAsyncWaiter(
    SyntheticTrialConfiguration* proxy) : proxy_(proxy) {}

SyntheticTrialConfigurationAsyncWaiter::~SyntheticTrialConfigurationAsyncWaiter() = default;







}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif