// content/common/renderer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_MOJOM_SHARED_H_
#define CONTENT_COMMON_RENDERER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/renderer.mojom-shared-internal.h"
#include "content/common/agent_scheduling_group.mojom-shared.h"
#include "content/common/native_types.mojom-shared.h"
#include "ipc/ipc.mojom-shared.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-shared.h"
#include "mojo/public/mojom/base/process_priority.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-shared.h"
#include "third_party/blink/public/mojom/cpu_performance.mojom-shared.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trials_settings.mojom-shared.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "content/common/renderer.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::content::mojom::RenderProcessVisibleState>
    : public mojo::internal::EnumHashImpl<::content::mojom::RenderProcessVisibleState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::RenderProcessVisibleState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::RenderProcessVisibleState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::RenderProcessVisibleState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::UpdateScrollbarThemeParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::UpdateScrollbarThemeParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::UpdateScrollbarThemeParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->has_initial_button_delay = Traits::has_initial_button_delay(input);

    fragment->initial_button_delay = Traits::initial_button_delay(input);

    fragment->has_autoscroll_button_delay = Traits::has_autoscroll_button_delay(input);

    fragment->autoscroll_button_delay = Traits::autoscroll_button_delay(input);

    fragment->jump_on_track_click = Traits::jump_on_track_click(input);

    
    mojo::internal::Serialize<::content::mojom::ScrollerStyle>(
      Traits::preferred_scroller_style(input),
      &fragment->preferred_scroller_style);

    fragment->redraw = Traits::redraw(input);

    fragment->scroll_view_rubber_banding = Traits::scroll_view_rubber_banding(input);
  }

  static bool Deserialize(::content::mojom::internal::UpdateScrollbarThemeParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::UpdateScrollbarThemeParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::UpdateSystemColorInfoParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::UpdateSystemColorInfoParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::UpdateSystemColorInfoParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->accent_color_$flag = Traits::accent_color(input).has_value();
    if (Traits::accent_color(input).has_value()) {
      fragment->accent_color_$value = Traits::accent_color(input).value();
    }
  }

  static bool Deserialize(::content::mojom::internal::UpdateSystemColorInfoParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::UpdateSystemColorInfoParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content::mojom {






}  // content::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::RenderProcessVisibleState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::RenderProcessVisibleState value);
};

} // namespace perfetto

#endif  // CONTENT_COMMON_RENDERER_MOJOM_SHARED_H_