// content/common/renderer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/renderer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/renderer.mojom-params-data.h"
namespace content {
namespace mojom {

NOINLINE static const char* RenderProcessVisibleStateToStringHelper(RenderProcessVisibleState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RenderProcessVisibleState::kVisible:
      return "kVisible";
    case RenderProcessVisibleState::kHidden:
      return "kHidden";
    default:
      return nullptr;
  }
}

std::string RenderProcessVisibleStateToString(RenderProcessVisibleState value) {
  const char *str = RenderProcessVisibleStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RenderProcessVisibleState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RenderProcessVisibleState value) {
  return os << RenderProcessVisibleStateToString(value);
}

namespace internal {


// static
bool UpdateScrollbarThemeParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateScrollbarThemeParams_Data* object =
      static_cast<const UpdateScrollbarThemeParams_Data*>(data);


  if (!::content::mojom::internal::ScrollerStyle_Data
        ::Validate(object->preferred_scroller_style, validation_context))
    return false;

  return true;
}

UpdateScrollbarThemeParams_Data::UpdateScrollbarThemeParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateSystemColorInfoParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateSystemColorInfoParams_Data* object =
      static_cast<const UpdateSystemColorInfoParams_Data*>(data);

  return true;
}

UpdateSystemColorInfoParams_Data::UpdateSystemColorInfoParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_CreateAgentSchedulingGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_CreateAgentSchedulingGroup_Params_Data* object =
      static_cast<const Renderer_CreateAgentSchedulingGroup_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->bootstrap, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->bootstrap,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Renderer_CreateAgentSchedulingGroup_Params_Data::Renderer_CreateAgentSchedulingGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data* object =
      static_cast<const Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent_scheduling_group, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent_scheduling_group,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_TransferSharedLastForegroundTime_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_TransferSharedLastForegroundTime_Params_Data* object =
      static_cast<const Renderer_TransferSharedLastForegroundTime_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_foreground_time_region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_foreground_time_region, validation_context))
    return false;

  return true;
}

Renderer_TransferSharedLastForegroundTime_Params_Data::Renderer_TransferSharedLastForegroundTime_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_OnNetworkConnectionChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_OnNetworkConnectionChanged_Params_Data* object =
      static_cast<const Renderer_OnNetworkConnectionChanged_Params_Data*>(data);


  if (!::content::mojom::internal::NetworkConnectionType_Data
        ::Validate(object->connection_type, validation_context))
    return false;

  return true;
}

Renderer_OnNetworkConnectionChanged_Params_Data::Renderer_OnNetworkConnectionChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_OnNetworkQualityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_OnNetworkQualityChanged_Params_Data* object =
      static_cast<const Renderer_OnNetworkQualityChanged_Params_Data*>(data);


  if (!::network::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->effective_connection_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_rtt, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->http_rtt, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transport_rtt, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transport_rtt, validation_context))
    return false;

  return true;
}

Renderer_OnNetworkQualityChanged_Params_Data::Renderer_OnNetworkQualityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetWebKitSharedTimersSuspended_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetWebKitSharedTimersSuspended_Params_Data* object =
      static_cast<const Renderer_SetWebKitSharedTimersSuspended_Params_Data*>(data);

  return true;
}

Renderer_SetWebKitSharedTimersSuspended_Params_Data::Renderer_SetWebKitSharedTimersSuspended_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UpdateScrollbarTheme_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_UpdateScrollbarTheme_Params_Data* object =
      static_cast<const Renderer_UpdateScrollbarTheme_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

Renderer_UpdateScrollbarTheme_Params_Data::Renderer_UpdateScrollbarTheme_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_OnSystemColorsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_OnSystemColorsChanged_Params_Data* object =
      static_cast<const Renderer_OnSystemColorsChanged_Params_Data*>(data);

  return true;
}

Renderer_OnSystemColorsChanged_Params_Data::Renderer_OnSystemColorsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UpdateSystemColorInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_UpdateSystemColorInfo_Params_Data* object =
      static_cast<const Renderer_UpdateSystemColorInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

Renderer_UpdateSystemColorInfo_Params_Data::Renderer_UpdateSystemColorInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_PurgePluginListCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_PurgePluginListCache_Params_Data* object =
      static_cast<const Renderer_PurgePluginListCache_Params_Data*>(data);

  return true;
}

Renderer_PurgePluginListCache_Params_Data::Renderer_PurgePluginListCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_PurgeResourceCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_PurgeResourceCache_Params_Data* object =
      static_cast<const Renderer_PurgeResourceCache_Params_Data*>(data);

  return true;
}

Renderer_PurgeResourceCache_Params_Data::Renderer_PurgeResourceCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_PurgeResourceCache_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_PurgeResourceCache_ResponseParams_Data* object =
      static_cast<const Renderer_PurgeResourceCache_ResponseParams_Data*>(data);

  return true;
}

Renderer_PurgeResourceCache_ResponseParams_Data::Renderer_PurgeResourceCache_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetProcessState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetProcessState_Params_Data* object =
      static_cast<const Renderer_SetProcessState_Params_Data*>(data);


  if (!::mojo_base::mojom::internal::ProcessPriority_Data
        ::Validate(object->process_priority, validation_context))
    return false;


  if (!::content::mojom::internal::RenderProcessVisibleState_Data
        ::Validate(object->visible_state, validation_context))
    return false;

  return true;
}

Renderer_SetProcessState_Params_Data::Renderer_SetProcessState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetIsLockedToSite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetIsLockedToSite_Params_Data* object =
      static_cast<const Renderer_SetIsLockedToSite_Params_Data*>(data);

  return true;
}

Renderer_SetIsLockedToSite_Params_Data::Renderer_SetIsLockedToSite_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetIsCrossOriginIsolated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetIsCrossOriginIsolated_Params_Data* object =
      static_cast<const Renderer_SetIsCrossOriginIsolated_Params_Data*>(data);

  return true;
}

Renderer_SetIsCrossOriginIsolated_Params_Data::Renderer_SetIsCrossOriginIsolated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetIsWebSecurityDisabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetIsWebSecurityDisabled_Params_Data* object =
      static_cast<const Renderer_SetIsWebSecurityDisabled_Params_Data*>(data);

  return true;
}

Renderer_SetIsWebSecurityDisabled_Params_Data::Renderer_SetIsWebSecurityDisabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetIsIsolatedContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetIsIsolatedContext_Params_Data* object =
      static_cast<const Renderer_SetIsIsolatedContext_Params_Data*>(data);

  return true;
}

Renderer_SetIsIsolatedContext_Params_Data::Renderer_SetIsIsolatedContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data* object =
      static_cast<const Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_map, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& resource_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->resource_map, validation_context,
                                         &resource_map_validate_params)) {
    return false;
  }

  return true;
}

Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data::Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_InitializeRenderer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_InitializeRenderer_Params_Data* object =
      static_cast<const Renderer_InitializeRenderer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_agent, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_agent_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_agent, validation_context,
                                         &user_agent_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cors_exempt_header_list, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cors_exempt_header_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->cors_exempt_header_list, validation_context,
                                         &cors_exempt_header_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->origin_trials_settings, validation_context))
    return false;


  if (!::blink::mojom::internal::PerformanceTier_Data
        ::Validate(object->cpu_performance_tier, validation_context))
    return false;

  return true;
}

Renderer_InitializeRenderer_Params_Data::Renderer_InitializeRenderer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetUserAgent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetUserAgent_Params_Data* object =
      static_cast<const Renderer_SetUserAgent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_agent, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_agent_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_agent, validation_context,
                                         &user_agent_validate_params)) {
    return false;
  }

  return true;
}

Renderer_SetUserAgent_Params_Data::Renderer_SetUserAgent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_Ping_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_Ping_Params_Data* object =
      static_cast<const Renderer_Ping_Params_Data*>(data);

  return true;
}

Renderer_Ping_Params_Data::Renderer_Ping_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_Ping_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_Ping_ResponseParams_Data* object =
      static_cast<const Renderer_Ping_ResponseParams_Data*>(data);

  return true;
}

Renderer_Ping_ResponseParams_Data::Renderer_Ping_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::RenderProcessVisibleState>::WriteIntoTrace(
   perfetto::TracedValue context, ::content::mojom::RenderProcessVisibleState value) {
  return std::move(context).WriteString(::content::mojom::RenderProcessVisibleStateToString(value));
}

} // namespace perfetto