// content/common/render_message_filter.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_DATA_VIEW_H_
#define CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "content/common/render_message_filter.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace content::mojom {
class FrameRoutingInfoDataView;



}  // content::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::FrameRoutingInfoDataView> {
  using Data = ::content::mojom::internal::FrameRoutingInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {
// Interface base classes. They are used for type safety check.
class RenderMessageFilterInterfaceBase {};

using RenderMessageFilterPtrDataView =
    mojo::InterfacePtrDataView<RenderMessageFilterInterfaceBase>;
using RenderMessageFilterRequestDataView =
    mojo::InterfaceRequestDataView<RenderMessageFilterInterfaceBase>;
using RenderMessageFilterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderMessageFilterInterfaceBase>;
using RenderMessageFilterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderMessageFilterInterfaceBase>;


class FrameRoutingInfoDataView {
 public:
  FrameRoutingInfoDataView() = default;

  FrameRoutingInfoDataView(
      internal::FrameRoutingInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  inline void GetFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameToken(UserType* output) {
    
    auto* pointer = data_->frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDocumentTokenDataView(
      ::blink::mojom::DocumentTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentToken(UserType* output) {
    
    auto* pointer = data_->document_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::DocumentTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::FrameRoutingInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // content::mojom

#endif  // CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_DATA_VIEW_H_