// content/common/navigation_client.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_SHARED_H_
#define CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/navigation_client.mojom-shared-internal.h"
#include "content/common/frame_messages.mojom-shared.h"
#include "content/public/common/alternative_error_page_override_info.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-shared.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/code_cache.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/fetch_later.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/same_document_navigation_type.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/document_policy_feature.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom-shared.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "content/common/navigation_client.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::content::mojom::NavigationClientDisconnectReason>
    : public mojo::internal::EnumHashImpl<::content::mojom::NavigationClientDisconnectReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::NavigationClientDisconnectReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::NavigationClientDisconnectReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::NavigationClientDisconnectReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::DidCommitProvisionalLoadParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::DidCommitProvisionalLoadParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::DidCommitProvisionalLoadParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->item_sequence_number = Traits::item_sequence_number(input);

    fragment->document_sequence_number = Traits::document_sequence_number(input);

    decltype(Traits::navigation_api_key(input)) in_navigation_api_key = Traits::navigation_api_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_api_key)::BaseType> navigation_api_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_navigation_api_key,
      navigation_api_key_fragment);

    fragment->navigation_api_key.Set(
        navigation_api_key_fragment.is_null() ? nullptr : navigation_api_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_api_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_api_key in DidCommitProvisionalLoadParams struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in DidCommitProvisionalLoadParams struct");

    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
      in_referrer,
      referrer_fragment);

    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->referrer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null referrer in DidCommitProvisionalLoadParams struct");

    
    mojo::internal::Serialize<::content::mojom::PageTransition>(
      Traits::transition(input),
      &fragment->transition);

    fragment->should_update_history = Traits::should_update_history(input);

    decltype(Traits::contents_mime_type(input)) in_contents_mime_type = Traits::contents_mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contents_mime_type)::BaseType> contents_mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_contents_mime_type,
      contents_mime_type_fragment);

    fragment->contents_mime_type.Set(
        contents_mime_type_fragment.is_null() ? nullptr : contents_mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->contents_mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contents_mime_type in DidCommitProvisionalLoadParams struct");

    fragment->did_create_new_entry = Traits::did_create_new_entry(input);

    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_method,
      method_fragment);

    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method in DidCommitProvisionalLoadParams struct");

    fragment->post_id = Traits::post_id(input);

    fragment->http_status_code = Traits::http_status_code(input);

    fragment->url_is_unreachable = Traits::url_is_unreachable(input);

    decltype(Traits::previous_page_state(input)) in_previous_page_state = Traits::previous_page_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->previous_page_state)::BaseType> previous_page_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::content::mojom::PageStateDataView>(
      in_previous_page_state,
      previous_page_state_fragment);

    fragment->previous_page_state.Set(
        previous_page_state_fragment.is_null() ? nullptr : previous_page_state_fragment.data());

    decltype(Traits::page_state(input)) in_page_state = Traits::page_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_state)::BaseType> page_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::content::mojom::PageStateDataView>(
      in_page_state,
      page_state_fragment);

    fragment->page_state.Set(
        page_state_fragment.is_null() ? nullptr : page_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->page_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_state in DidCommitProvisionalLoadParams struct");

    fragment->is_overriding_user_agent = Traits::is_overriding_user_agent(input);

    fragment->history_list_was_cleared = Traits::history_list_was_cleared(input);

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in DidCommitProvisionalLoadParams struct");

    decltype(Traits::initiator_base_url(input)) in_initiator_base_url = Traits::initiator_base_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_base_url)::BaseType> initiator_base_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_initiator_base_url,
      initiator_base_url_fragment);

    fragment->initiator_base_url.Set(
        initiator_base_url_fragment.is_null() ? nullptr : initiator_base_url_fragment.data());

    decltype(Traits::permissions_policy_header(input)) in_permissions_policy_header = Traits::permissions_policy_header(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permissions_policy_header)::BaseType>
        permissions_policy_header_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permissions_policy_header_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
      in_permissions_policy_header,
      permissions_policy_header_fragment,
      &permissions_policy_header_validate_params);

    fragment->permissions_policy_header.Set(
        permissions_policy_header_fragment.is_null() ? nullptr : permissions_policy_header_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permissions_policy_header.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permissions_policy_header in DidCommitProvisionalLoadParams struct");

    decltype(Traits::document_policy_header(input)) in_document_policy_header = Traits::document_policy_header(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_policy_header)::BaseType>
        document_policy_header_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& document_policy_header_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::DocumentPolicyFeature_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>>(
      in_document_policy_header,
      document_policy_header_fragment,
      &document_policy_header_validate_params);

    fragment->document_policy_header.Set(
        document_policy_header_fragment.is_null() ? nullptr : document_policy_header_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->document_policy_header.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_policy_header in DidCommitProvisionalLoadParams struct");

    
    mojo::internal::Serialize<::blink::mojom::InsecureRequestPolicy>(
      Traits::insecure_request_policy(input),
      &fragment->insecure_request_policy);

    decltype(Traits::insecure_navigations_set(input)) in_insecure_navigations_set = Traits::insecure_navigations_set(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->insecure_navigations_set)::BaseType>
        insecure_navigations_set_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& insecure_navigations_set_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_insecure_navigations_set,
      insecure_navigations_set_fragment,
      &insecure_navigations_set_validate_params);

    fragment->insecure_navigations_set.Set(
        insecure_navigations_set_fragment.is_null() ? nullptr : insecure_navigations_set_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->insecure_navigations_set.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null insecure_navigations_set in DidCommitProvisionalLoadParams struct");

    fragment->has_potentially_trustworthy_unique_origin = Traits::has_potentially_trustworthy_unique_origin(input);

    fragment->request_id = Traits::request_id(input);

    decltype(Traits::navigation_token(input)) in_navigation_token = Traits::navigation_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_token)::BaseType> navigation_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_navigation_token,
      navigation_token_fragment);

    fragment->navigation_token.Set(
        navigation_token_fragment.is_null() ? nullptr : navigation_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_token in DidCommitProvisionalLoadParams struct");

    decltype(Traits::embedding_token(input)) in_embedding_token = Traits::embedding_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->embedding_token)::BaseType> embedding_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_embedding_token,
      embedding_token_fragment);

    fragment->embedding_token.Set(
        embedding_token_fragment.is_null() ? nullptr : embedding_token_fragment.data());

    decltype(Traits::unload_start(input)) in_unload_start = Traits::unload_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unload_start)::BaseType> unload_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_unload_start,
      unload_start_fragment);

    fragment->unload_start.Set(
        unload_start_fragment.is_null() ? nullptr : unload_start_fragment.data());

    decltype(Traits::unload_end(input)) in_unload_end = Traits::unload_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unload_end)::BaseType> unload_end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_unload_end,
      unload_end_fragment);

    fragment->unload_end.Set(
        unload_end_fragment.is_null() ? nullptr : unload_end_fragment.data());

    decltype(Traits::commit_navigation_start(input)) in_commit_navigation_start = Traits::commit_navigation_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->commit_navigation_start)::BaseType> commit_navigation_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_commit_navigation_start,
      commit_navigation_start_fragment);

    fragment->commit_navigation_start.Set(
        commit_navigation_start_fragment.is_null() ? nullptr : commit_navigation_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->commit_navigation_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null commit_navigation_start in DidCommitProvisionalLoadParams struct");

    decltype(Traits::commit_navigation_end(input)) in_commit_navigation_end = Traits::commit_navigation_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->commit_navigation_end)::BaseType> commit_navigation_end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_commit_navigation_end,
      commit_navigation_end_fragment);

    fragment->commit_navigation_end.Set(
        commit_navigation_end_fragment.is_null() ? nullptr : commit_navigation_end_fragment.data());

    decltype(Traits::commit_reply_sent(input)) in_commit_reply_sent = Traits::commit_reply_sent(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->commit_reply_sent)::BaseType> commit_reply_sent_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_commit_reply_sent,
      commit_reply_sent_fragment);

    fragment->commit_reply_sent.Set(
        commit_reply_sent_fragment.is_null() ? nullptr : commit_reply_sent_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->commit_reply_sent.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null commit_reply_sent in DidCommitProvisionalLoadParams struct");
  }

  static bool Deserialize(::content::mojom::internal::DidCommitProvisionalLoadParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::DidCommitProvisionalLoadParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::DidCommitSameDocumentNavigationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::DidCommitSameDocumentNavigationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::DidCommitSameDocumentNavigationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::SameDocumentNavigationType>(
      Traits::same_document_navigation_type(input),
      &fragment->same_document_navigation_type);

    fragment->is_client_redirect = Traits::is_client_redirect(input);

    fragment->started_with_transient_activation = Traits::started_with_transient_activation(input);

    fragment->should_replace_current_entry = Traits::should_replace_current_entry(input);

    decltype(Traits::navigation_entry_screenshot_destination(input)) in_navigation_entry_screenshot_destination = Traits::navigation_entry_screenshot_destination(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_entry_screenshot_destination)::BaseType> navigation_entry_screenshot_destination_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView>(
      in_navigation_entry_screenshot_destination,
      navigation_entry_screenshot_destination_fragment);

    fragment->navigation_entry_screenshot_destination.Set(
        navigation_entry_screenshot_destination_fragment.is_null() ? nullptr : navigation_entry_screenshot_destination_fragment.data());

    decltype(Traits::same_document_metrics_token(input)) in_same_document_metrics_token = Traits::same_document_metrics_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->same_document_metrics_token)::BaseType> same_document_metrics_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_same_document_metrics_token,
      same_document_metrics_token_fragment);

    fragment->same_document_metrics_token.Set(
        same_document_metrics_token_fragment.is_null() ? nullptr : same_document_metrics_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->same_document_metrics_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null same_document_metrics_token in DidCommitSameDocumentNavigationParams struct");
  }

  static bool Deserialize(::content::mojom::internal::DidCommitSameDocumentNavigationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::DidCommitSameDocumentNavigationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CookieManagerInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CookieManagerInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CookieManagerInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in CookieManagerInfo struct");

    decltype(Traits::cookie_manager(input)) in_cookie_manager = Traits::cookie_manager(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::RestrictedCookieManagerInterfaceBase>>(
      in_cookie_manager,
      &fragment->cookie_manager,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->cookie_manager)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid cookie_manager in CookieManagerInfo struct");
  }

  static bool Deserialize(::content::mojom::internal::CookieManagerInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CookieManagerInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::StorageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::StorageInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::StorageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::local_storage_area(input)) in_local_storage_area = Traits::local_storage_area(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaInterfaceBase>>(
      in_local_storage_area,
      &fragment->local_storage_area,
      &fragment.message());

    decltype(Traits::session_storage_area(input)) in_session_storage_area = Traits::session_storage_area(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaInterfaceBase>>(
      in_session_storage_area,
      &fragment->session_storage_area,
      &fragment.message());
  }

  static bool Deserialize(::content::mojom::internal::StorageInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::StorageInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content::mojom {

inline void DidCommitProvisionalLoadParamsDataView::GetNavigationApiKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->navigation_api_key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetContentsMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->contents_mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetPreviousPageStateDataView(
    PageStateDataView* output) {
  auto pointer = data_->previous_page_state.Get();
  *output = PageStateDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetPageStateDataView(
    PageStateDataView* output) {
  auto pointer = data_->page_state.Get();
  *output = PageStateDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetInitiatorBaseUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->initiator_base_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetPermissionsPolicyHeaderDataView(
    mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output) {
  auto pointer = data_->permissions_policy_header.Get();
  *output = mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetDocumentPolicyHeaderDataView(
    mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>* output) {
  auto pointer = data_->document_policy_header.Get();
  *output = mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetInsecureNavigationsSetDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->insecure_navigations_set.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetNavigationTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->navigation_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetEmbeddingTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->embedding_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetUnloadStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->unload_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetUnloadEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->unload_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetCommitNavigationStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->commit_navigation_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetCommitNavigationEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->commit_navigation_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void DidCommitProvisionalLoadParamsDataView::GetCommitReplySentDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->commit_reply_sent.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void DidCommitSameDocumentNavigationParamsDataView::GetNavigationEntryScreenshotDestinationDataView(
    ::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView* output) {
  auto pointer = data_->navigation_entry_screenshot_destination.Get();
  *output = ::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView(pointer, message_);
}
inline void DidCommitSameDocumentNavigationParamsDataView::GetSameDocumentMetricsTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->same_document_metrics_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void CookieManagerInfoDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}





}  // content::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::NavigationClientDisconnectReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::NavigationClientDisconnectReason value);
};

} // namespace perfetto

#endif  // CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_SHARED_H_