// content/common/navigation_client.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_PARAMS_DATA_H_
#define CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace content::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) NavigationClient_CommitNavigation_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::CommonNavigationParams_Data> common_params;
  mojo::internal::Pointer<::blink::mojom::internal::CommitNavigationParams_Data> request_params;
  mojo::internal::Pointer<::network::mojom::internal::URLResponseHead_Data> response_head;
  mojo::internal::Handle_Data response_body;
  uint8_t pad3_[4];
  mojo::internal::Pointer<::network::mojom::internal::URLLoaderClientEndpoints_Data> url_loader_client_endpoints;
  mojo::internal::Pointer<::blink::mojom::internal::URLLoaderFactoryBundle_Data> subresource_loader_factories;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::blink::mojom::internal::TransferrableURLLoader_Data>>> subresource_overrides;
  mojo::internal::Pointer<::blink::mojom::internal::ControllerServiceWorkerInfo_Data> controller_service_worker_info;
  mojo::internal::Pointer<::blink::mojom::internal::ServiceWorkerContainerInfoForClient_Data> container_info;
  mojo::internal::Interface_Data subresource_proxying_loader_factory;
  mojo::internal::Interface_Data keep_alive_loader_factory;
  mojo::internal::AssociatedInterface_Data fetch_later_loader_factory;
  mojo::internal::Pointer<::blink::mojom::internal::DocumentToken_Data> document_token;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtools_navigation_token;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Uuid_Data> base_auction_nonce;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::ParsedPermissionsPolicyDeclaration_Data>>> permissions_policy;
  mojo::internal::Pointer<::blink::mojom::internal::PolicyContainer_Data> policy_container;
  mojo::internal::Interface_Data code_cache_host;
  mojo::internal::Interface_Data code_cache_host_for_background;
  mojo::internal::Pointer<internal::CookieManagerInfo_Data> cookie_manager_info;
  mojo::internal::Pointer<internal::StorageInfo_Data> storage_info;

 private:
  friend class mojo::internal::MessageFragment<NavigationClient_CommitNavigation_Params_Data>;

  NavigationClient_CommitNavigation_Params_Data();
  ~NavigationClient_CommitNavigation_Params_Data() = delete;
};
static_assert(sizeof(NavigationClient_CommitNavigation_Params_Data) == 176,
              "Bad sizeof(NavigationClient_CommitNavigation_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) NavigationClient_CommitNavigation_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::DidCommitProvisionalLoadParams_Data> params;
  mojo::internal::Pointer<::content::mojom::internal::DidCommitProvisionalLoadInterfaceParams_Data> interface_params;

 private:
  friend class mojo::internal::MessageFragment<NavigationClient_CommitNavigation_ResponseParams_Data>;

  NavigationClient_CommitNavigation_ResponseParams_Data();
  ~NavigationClient_CommitNavigation_ResponseParams_Data() = delete;
};
static_assert(sizeof(NavigationClient_CommitNavigation_ResponseParams_Data) == 24,
              "Bad sizeof(NavigationClient_CommitNavigation_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) NavigationClient_CommitFailedNavigation_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::CommonNavigationParams_Data> common_params;
  mojo::internal::Pointer<::blink::mojom::internal::CommitNavigationParams_Data> request_params;
  uint8_t has_stale_copy_in_cache : 1;
  uint8_t pad2_[3];
  int32_t error_code;
  int32_t extended_error_code;
  uint8_t pad4_[4];
  mojo::internal::Pointer<::network::mojom::internal::ResolveErrorInfo_Data> resolve_error_info;
  mojo::internal::Pointer<mojo::internal::String_Data> error_page_content;
  mojo::internal::Pointer<::blink::mojom::internal::URLLoaderFactoryBundle_Data> subresource_loader_factories;
  mojo::internal::Pointer<::blink::mojom::internal::DocumentToken_Data> document_token;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtools_navigation_token;
  mojo::internal::Pointer<::blink::mojom::internal::PolicyContainer_Data> policy_container;
  mojo::internal::Pointer<::content::mojom::internal::AlternativeErrorPageOverrideInfo_Data> alternative_error_page_info;

 private:
  friend class mojo::internal::MessageFragment<NavigationClient_CommitFailedNavigation_Params_Data>;

  NavigationClient_CommitFailedNavigation_Params_Data();
  ~NavigationClient_CommitFailedNavigation_Params_Data() = delete;
};
static_assert(sizeof(NavigationClient_CommitFailedNavigation_Params_Data) == 96,
              "Bad sizeof(NavigationClient_CommitFailedNavigation_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) NavigationClient_CommitFailedNavigation_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::DidCommitProvisionalLoadParams_Data> params;
  mojo::internal::Pointer<::content::mojom::internal::DidCommitProvisionalLoadInterfaceParams_Data> interface_params;

 private:
  friend class mojo::internal::MessageFragment<NavigationClient_CommitFailedNavigation_ResponseParams_Data>;

  NavigationClient_CommitFailedNavigation_ResponseParams_Data();
  ~NavigationClient_CommitFailedNavigation_ResponseParams_Data() = delete;
};
static_assert(sizeof(NavigationClient_CommitFailedNavigation_ResponseParams_Data) == 24,
              "Bad sizeof(NavigationClient_CommitFailedNavigation_ResponseParams_Data)");

}  // namespace internal


class NavigationClient_CommitNavigation_ParamsDataView {
 public:
  NavigationClient_CommitNavigation_ParamsDataView() = default;

  NavigationClient_CommitNavigation_ParamsDataView(
      internal::NavigationClient_CommitNavigation_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCommonParamsDataView(
      ::blink::mojom::CommonNavigationParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommonParams(UserType* output) {
    
    auto* pointer = data_->common_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommonNavigationParamsDataView>(
        pointer, output, message_);
  }
  inline void GetRequestParamsDataView(
      ::blink::mojom::CommitNavigationParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestParams(UserType* output) {
    
    auto* pointer = data_->request_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommitNavigationParamsDataView>(
        pointer, output, message_);
  }
  inline void GetResponseHeadDataView(
      ::network::mojom::URLResponseHeadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseHead(UserType* output) {
    
    auto* pointer = data_->response_head.Get();
    return mojo::internal::Deserialize<::network::mojom::URLResponseHeadDataView>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeConsumerHandle TakeResponseBody() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->response_body, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetUrlLoaderClientEndpointsDataView(
      ::network::mojom::URLLoaderClientEndpointsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlLoaderClientEndpoints(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLLoaderClientEndpointsDataView, UserType>(),
    "Attempting to read the optional `url_loader_client_endpoints` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrlLoaderClientEndpoints` instead "
    "of `ReadUrlLoaderClientEndpoints if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url_loader_client_endpoints.Get();
    return mojo::internal::Deserialize<::network::mojom::URLLoaderClientEndpointsDataView>(
        pointer, output, message_);
  }
  inline void GetSubresourceLoaderFactoriesDataView(
      ::blink::mojom::URLLoaderFactoryBundleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubresourceLoaderFactories(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::URLLoaderFactoryBundleDataView, UserType>(),
    "Attempting to read the optional `subresource_loader_factories` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubresourceLoaderFactories` instead "
    "of `ReadSubresourceLoaderFactories if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subresource_loader_factories.Get();
    return mojo::internal::Deserialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        pointer, output, message_);
  }
  inline void GetSubresourceOverridesDataView(
      mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubresourceOverrides(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>, UserType>(),
    "Attempting to read the optional `subresource_overrides` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubresourceOverrides` instead "
    "of `ReadSubresourceOverrides if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subresource_overrides.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>>(
        pointer, output, message_);
  }
  inline void GetControllerServiceWorkerInfoDataView(
      ::blink::mojom::ControllerServiceWorkerInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadControllerServiceWorkerInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ControllerServiceWorkerInfoDataView, UserType>(),
    "Attempting to read the optional `controller_service_worker_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadControllerServiceWorkerInfo` instead "
    "of `ReadControllerServiceWorkerInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->controller_service_worker_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
        pointer, output, message_);
  }
  inline void GetContainerInfoDataView(
      ::blink::mojom::ServiceWorkerContainerInfoForClientDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContainerInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerContainerInfoForClientDataView, UserType>(),
    "Attempting to read the optional `container_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContainerInfo` instead "
    "of `ReadContainerInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->container_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerContainerInfoForClientDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeSubresourceProxyingLoaderFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->subresource_proxying_loader_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeKeepAliveLoaderFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->keep_alive_loader_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFetchLaterLoaderFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FetchLaterLoaderFactoryAssociatedPtrInfoDataView>(
            &data_->fetch_later_loader_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetDocumentTokenDataView(
      ::blink::mojom::DocumentTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentToken(UserType* output) {
    
    auto* pointer = data_->document_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::DocumentTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsNavigationTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsNavigationToken(UserType* output) {
    
    auto* pointer = data_->devtools_navigation_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetBaseAuctionNonceDataView(
      ::mojo_base::mojom::UuidDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseAuctionNonce(UserType* output) {
    
    auto* pointer = data_->base_auction_nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UuidDataView>(
        pointer, output, message_);
  }
  inline void GetPermissionsPolicyDataView(
      mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissionsPolicy(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>, UserType>(),
    "Attempting to read the optional `permissions_policy` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPermissionsPolicy` instead "
    "of `ReadPermissionsPolicy if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->permissions_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  inline void GetPolicyContainerDataView(
      ::blink::mojom::PolicyContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainer(UserType* output) {
    
    auto* pointer = data_->policy_container.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCodeCacheHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::CodeCacheHostInterfaceBase>>(
            &data_->code_cache_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCodeCacheHostForBackground() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::CodeCacheHostInterfaceBase>>(
            &data_->code_cache_host_for_background, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetCookieManagerInfoDataView(
      CookieManagerInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieManagerInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::CookieManagerInfoDataView, UserType>(),
    "Attempting to read the optional `cookie_manager_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieManagerInfo` instead "
    "of `ReadCookieManagerInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_manager_info.Get();
    return mojo::internal::Deserialize<::content::mojom::CookieManagerInfoDataView>(
        pointer, output, message_);
  }
  inline void GetStorageInfoDataView(
      StorageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorageInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::StorageInfoDataView, UserType>(),
    "Attempting to read the optional `storage_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStorageInfo` instead "
    "of `ReadStorageInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->storage_info.Get();
    return mojo::internal::Deserialize<::content::mojom::StorageInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationClient_CommitNavigation_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NavigationClient_CommitNavigation_ResponseParamsDataView {
 public:
  NavigationClient_CommitNavigation_ResponseParamsDataView() = default;

  NavigationClient_CommitNavigation_ResponseParamsDataView(
      internal::NavigationClient_CommitNavigation_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      DidCommitProvisionalLoadParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
        pointer, output, message_);
  }
  inline void GetInterfaceParamsDataView(
      ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterfaceParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView, UserType>(),
    "Attempting to read the optional `interface_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterfaceParams` instead "
    "of `ReadInterfaceParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interface_params.Get();
    return mojo::internal::Deserialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationClient_CommitNavigation_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NavigationClient_CommitFailedNavigation_ParamsDataView {
 public:
  NavigationClient_CommitFailedNavigation_ParamsDataView() = default;

  NavigationClient_CommitFailedNavigation_ParamsDataView(
      internal::NavigationClient_CommitFailedNavigation_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCommonParamsDataView(
      ::blink::mojom::CommonNavigationParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommonParams(UserType* output) {
    
    auto* pointer = data_->common_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommonNavigationParamsDataView>(
        pointer, output, message_);
  }
  inline void GetRequestParamsDataView(
      ::blink::mojom::CommitNavigationParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestParams(UserType* output) {
    
    auto* pointer = data_->request_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommitNavigationParamsDataView>(
        pointer, output, message_);
  }
  bool has_stale_copy_in_cache() const {
    return data_->has_stale_copy_in_cache;
  }
  int32_t error_code() const {
    return data_->error_code;
  }
  int32_t extended_error_code() const {
    return data_->extended_error_code;
  }
  inline void GetResolveErrorInfoDataView(
      ::network::mojom::ResolveErrorInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResolveErrorInfo(UserType* output) {
    
    auto* pointer = data_->resolve_error_info.Get();
    return mojo::internal::Deserialize<::network::mojom::ResolveErrorInfoDataView>(
        pointer, output, message_);
  }
  inline void GetErrorPageContentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorPageContent(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `error_page_content` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadErrorPageContent` instead "
    "of `ReadErrorPageContent if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error_page_content.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSubresourceLoaderFactoriesDataView(
      ::blink::mojom::URLLoaderFactoryBundleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubresourceLoaderFactories(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::URLLoaderFactoryBundleDataView, UserType>(),
    "Attempting to read the optional `subresource_loader_factories` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubresourceLoaderFactories` instead "
    "of `ReadSubresourceLoaderFactories if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subresource_loader_factories.Get();
    return mojo::internal::Deserialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        pointer, output, message_);
  }
  inline void GetDocumentTokenDataView(
      ::blink::mojom::DocumentTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentToken(UserType* output) {
    
    auto* pointer = data_->document_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::DocumentTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsNavigationTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsNavigationToken(UserType* output) {
    
    auto* pointer = data_->devtools_navigation_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyContainerDataView(
      ::blink::mojom::PolicyContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainer(UserType* output) {
    
    auto* pointer = data_->policy_container.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerDataView>(
        pointer, output, message_);
  }
  inline void GetAlternativeErrorPageInfoDataView(
      ::content::mojom::AlternativeErrorPageOverrideInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlternativeErrorPageInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::AlternativeErrorPageOverrideInfoDataView, UserType>(),
    "Attempting to read the optional `alternative_error_page_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAlternativeErrorPageInfo` instead "
    "of `ReadAlternativeErrorPageInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->alternative_error_page_info.Get();
    return mojo::internal::Deserialize<::content::mojom::AlternativeErrorPageOverrideInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationClient_CommitFailedNavigation_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NavigationClient_CommitFailedNavigation_ResponseParamsDataView {
 public:
  NavigationClient_CommitFailedNavigation_ResponseParamsDataView() = default;

  NavigationClient_CommitFailedNavigation_ResponseParamsDataView(
      internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      DidCommitProvisionalLoadParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
        pointer, output, message_);
  }
  inline void GetInterfaceParamsDataView(
      ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterfaceParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView, UserType>(),
    "Attempting to read the optional `interface_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterfaceParams` instead "
    "of `ReadInterfaceParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interface_params.Get();
    return mojo::internal::Deserialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void NavigationClient_CommitNavigation_ParamsDataView::GetCommonParamsDataView(
    ::blink::mojom::CommonNavigationParamsDataView* output) {
  auto pointer = data_->common_params.Get();
  *output = ::blink::mojom::CommonNavigationParamsDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetRequestParamsDataView(
    ::blink::mojom::CommitNavigationParamsDataView* output) {
  auto pointer = data_->request_params.Get();
  *output = ::blink::mojom::CommitNavigationParamsDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetResponseHeadDataView(
    ::network::mojom::URLResponseHeadDataView* output) {
  auto pointer = data_->response_head.Get();
  *output = ::network::mojom::URLResponseHeadDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetUrlLoaderClientEndpointsDataView(
    ::network::mojom::URLLoaderClientEndpointsDataView* output) {
  auto pointer = data_->url_loader_client_endpoints.Get();
  *output = ::network::mojom::URLLoaderClientEndpointsDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetSubresourceLoaderFactoriesDataView(
    ::blink::mojom::URLLoaderFactoryBundleDataView* output) {
  auto pointer = data_->subresource_loader_factories.Get();
  *output = ::blink::mojom::URLLoaderFactoryBundleDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetSubresourceOverridesDataView(
    mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>* output) {
  auto pointer = data_->subresource_overrides.Get();
  *output = mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetControllerServiceWorkerInfoDataView(
    ::blink::mojom::ControllerServiceWorkerInfoDataView* output) {
  auto pointer = data_->controller_service_worker_info.Get();
  *output = ::blink::mojom::ControllerServiceWorkerInfoDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetContainerInfoDataView(
    ::blink::mojom::ServiceWorkerContainerInfoForClientDataView* output) {
  auto pointer = data_->container_info.Get();
  *output = ::blink::mojom::ServiceWorkerContainerInfoForClientDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetDocumentTokenDataView(
    ::blink::mojom::DocumentTokenDataView* output) {
  auto pointer = data_->document_token.Get();
  *output = ::blink::mojom::DocumentTokenDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetDevtoolsNavigationTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_navigation_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetBaseAuctionNonceDataView(
    ::mojo_base::mojom::UuidDataView* output) {
  auto pointer = data_->base_auction_nonce.Get();
  *output = ::mojo_base::mojom::UuidDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetPermissionsPolicyDataView(
    mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output) {
  auto pointer = data_->permissions_policy.Get();
  *output = mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetPolicyContainerDataView(
    ::blink::mojom::PolicyContainerDataView* output) {
  auto pointer = data_->policy_container.Get();
  *output = ::blink::mojom::PolicyContainerDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetCookieManagerInfoDataView(
    CookieManagerInfoDataView* output) {
  auto pointer = data_->cookie_manager_info.Get();
  *output = CookieManagerInfoDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetStorageInfoDataView(
    StorageInfoDataView* output) {
  auto pointer = data_->storage_info.Get();
  *output = StorageInfoDataView(pointer, message_);
}


inline void NavigationClient_CommitNavigation_ResponseParamsDataView::GetParamsDataView(
    DidCommitProvisionalLoadParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = DidCommitProvisionalLoadParamsDataView(pointer, message_);
}
inline void NavigationClient_CommitNavigation_ResponseParamsDataView::GetInterfaceParamsDataView(
    ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView* output) {
  auto pointer = data_->interface_params.Get();
  *output = ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView(pointer, message_);
}


inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetCommonParamsDataView(
    ::blink::mojom::CommonNavigationParamsDataView* output) {
  auto pointer = data_->common_params.Get();
  *output = ::blink::mojom::CommonNavigationParamsDataView(pointer, message_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetRequestParamsDataView(
    ::blink::mojom::CommitNavigationParamsDataView* output) {
  auto pointer = data_->request_params.Get();
  *output = ::blink::mojom::CommitNavigationParamsDataView(pointer, message_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetResolveErrorInfoDataView(
    ::network::mojom::ResolveErrorInfoDataView* output) {
  auto pointer = data_->resolve_error_info.Get();
  *output = ::network::mojom::ResolveErrorInfoDataView(pointer, message_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetErrorPageContentDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_page_content.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetSubresourceLoaderFactoriesDataView(
    ::blink::mojom::URLLoaderFactoryBundleDataView* output) {
  auto pointer = data_->subresource_loader_factories.Get();
  *output = ::blink::mojom::URLLoaderFactoryBundleDataView(pointer, message_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetDocumentTokenDataView(
    ::blink::mojom::DocumentTokenDataView* output) {
  auto pointer = data_->document_token.Get();
  *output = ::blink::mojom::DocumentTokenDataView(pointer, message_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetDevtoolsNavigationTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_navigation_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetPolicyContainerDataView(
    ::blink::mojom::PolicyContainerDataView* output) {
  auto pointer = data_->policy_container.Get();
  *output = ::blink::mojom::PolicyContainerDataView(pointer, message_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetAlternativeErrorPageInfoDataView(
    ::content::mojom::AlternativeErrorPageOverrideInfoDataView* output) {
  auto pointer = data_->alternative_error_page_info.Get();
  *output = ::content::mojom::AlternativeErrorPageOverrideInfoDataView(pointer, message_);
}


inline void NavigationClient_CommitFailedNavigation_ResponseParamsDataView::GetParamsDataView(
    DidCommitProvisionalLoadParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = DidCommitProvisionalLoadParamsDataView(pointer, message_);
}
inline void NavigationClient_CommitFailedNavigation_ResponseParamsDataView::GetInterfaceParamsDataView(
    ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView* output) {
  auto pointer = data_->interface_params.Get();
  *output = ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView(pointer, message_);
}



}  // content::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_PARAMS_DATA_H_