// content/common/memory_coordinator/mojom/memory_coordinator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-params-data.h"
#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-shared-message-ids.h"

#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-import-headers.h"
#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-test-utils.h"


namespace content::mojom {
MemoryConsumerTraits::MemoryConsumerTraits()
    : supports_memory_limit(),
      in_process(),
      estimated_memory_usage(),
      release_memory_cost(),
      recreate_memory_cost(),
      information_retention(),
      memory_release_behavior(),
      execution_type(),
      release_gc_references(),
      garbage_collects_v8_heap() {}

MemoryConsumerTraits::MemoryConsumerTraits(
    uint8_t supports_memory_limit_in,
    uint8_t in_process_in,
    uint8_t estimated_memory_usage_in,
    uint8_t release_memory_cost_in,
    uint8_t recreate_memory_cost_in,
    uint8_t information_retention_in,
    uint8_t memory_release_behavior_in,
    uint8_t execution_type_in,
    uint8_t release_gc_references_in,
    uint8_t garbage_collects_v8_heap_in)
    : supports_memory_limit(std::move(supports_memory_limit_in)),
      in_process(std::move(in_process_in)),
      estimated_memory_usage(std::move(estimated_memory_usage_in)),
      release_memory_cost(std::move(release_memory_cost_in)),
      recreate_memory_cost(std::move(recreate_memory_cost_in)),
      information_retention(std::move(information_retention_in)),
      memory_release_behavior(std::move(memory_release_behavior_in)),
      execution_type(std::move(execution_type_in)),
      release_gc_references(std::move(release_gc_references_in)),
      garbage_collects_v8_heap(std::move(garbage_collects_v8_heap_in)) {}

MemoryConsumerTraits::~MemoryConsumerTraits() = default;

void MemoryConsumerTraits::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_memory_limit"), this->supports_memory_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_process"), this->in_process,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "estimated_memory_usage"), this->estimated_memory_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_memory_cost"), this->release_memory_cost,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recreate_memory_cost"), this->recreate_memory_cost,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "information_retention"), this->information_retention,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "memory_release_behavior"), this->memory_release_behavior,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "execution_type"), this->execution_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_gc_references"), this->release_gc_references,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "garbage_collects_v8_heap"), this->garbage_collects_v8_heap,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MemoryConsumerTraits::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ChildMemoryConsumer::IPCStableHashFunction ChildMemoryConsumer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChildMemoryConsumer>(message.name())) {
    case messages::ChildMemoryConsumer::kNotifyReleaseMemory: {
      return &ChildMemoryConsumer::NotifyReleaseMemory_Sym::IPCStableHash;
    }
    case messages::ChildMemoryConsumer::kNotifyUpdateMemoryLimit: {
      return &ChildMemoryConsumer::NotifyUpdateMemoryLimit_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChildMemoryConsumer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChildMemoryConsumer>(message.name())) {
      case messages::ChildMemoryConsumer::kNotifyReleaseMemory:
            return "Receive content::mojom::ChildMemoryConsumer::NotifyReleaseMemory";
      case messages::ChildMemoryConsumer::kNotifyUpdateMemoryLimit:
            return "Receive content::mojom::ChildMemoryConsumer::NotifyUpdateMemoryLimit";
    }
  } else {
    switch (static_cast<messages::ChildMemoryConsumer>(message.name())) {
      case messages::ChildMemoryConsumer::kNotifyReleaseMemory:
            return "Receive reply content::mojom::ChildMemoryConsumer::NotifyReleaseMemory";
      case messages::ChildMemoryConsumer::kNotifyUpdateMemoryLimit:
            return "Receive reply content::mojom::ChildMemoryConsumer::NotifyUpdateMemoryLimit";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChildMemoryConsumer::NotifyReleaseMemory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7504fdea;  // IPCStableHash for content::mojom::ChildMemoryConsumer::NotifyReleaseMemory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildMemoryConsumer::NotifyUpdateMemoryLimit_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64f5772f;  // IPCStableHash for content::mojom::ChildMemoryConsumer::NotifyUpdateMemoryLimit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ChildMemoryConsumerProxy::ChildMemoryConsumerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildMemoryConsumerProxy::NotifyReleaseMemory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::ChildMemoryConsumer::NotifyReleaseMemory");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildMemoryConsumer::kNotifyReleaseMemory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildMemoryConsumer_NotifyReleaseMemory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildMemoryConsumer::Name_);
  message.set_method_name("NotifyReleaseMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChildMemoryConsumerProxy::NotifyUpdateMemoryLimit(
    int32_t in_percentage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::ChildMemoryConsumer::NotifyUpdateMemoryLimit", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("percentage"), in_percentage,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildMemoryConsumer::kNotifyUpdateMemoryLimit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildMemoryConsumer_NotifyUpdateMemoryLimit_Params_Data> params(
          message);
  params.Allocate();

  params->percentage = in_percentage;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildMemoryConsumer::Name_);
  message.set_method_name("NotifyUpdateMemoryLimit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ChildMemoryConsumerStubDispatch::Accept(
    ChildMemoryConsumer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChildMemoryConsumer>(message->header()->name)) {
    case messages::ChildMemoryConsumer::kNotifyReleaseMemory: {
      DCHECK(message->is_serialized());
      internal::ChildMemoryConsumer_NotifyReleaseMemory_Params_Data* params =
          reinterpret_cast<internal::ChildMemoryConsumer_NotifyReleaseMemory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChildMemoryConsumer.0
      bool success = true;
      ChildMemoryConsumer_NotifyReleaseMemory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildMemoryConsumer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyReleaseMemory(        );
      return true;
    }
    case messages::ChildMemoryConsumer::kNotifyUpdateMemoryLimit: {
      DCHECK(message->is_serialized());
      internal::ChildMemoryConsumer_NotifyUpdateMemoryLimit_Params_Data* params =
          reinterpret_cast<internal::ChildMemoryConsumer_NotifyUpdateMemoryLimit_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChildMemoryConsumer.1
      bool success = true;
      int32_t p_percentage{};
      ChildMemoryConsumer_NotifyUpdateMemoryLimit_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_percentage = input_data_view.percentage();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildMemoryConsumer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyUpdateMemoryLimit(        
        std::move(p_percentage));
      return true;
    }
  }
  return false;
}

// static
bool ChildMemoryConsumerStubDispatch::AcceptWithResponder(
    ChildMemoryConsumer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChildMemoryConsumer>(message->header()->name)) {
    case messages::ChildMemoryConsumer::kNotifyReleaseMemory: {
      break;
    }
    case messages::ChildMemoryConsumer::kNotifyUpdateMemoryLimit: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kChildMemoryConsumerValidationInfo[] = {
    { &internal::ChildMemoryConsumer_NotifyReleaseMemory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChildMemoryConsumer_NotifyUpdateMemoryLimit_Params_Data::Validate,
     nullptr /* no response */},
};

bool ChildMemoryConsumerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content::mojom::ChildMemoryConsumer::Name_,
    kChildMemoryConsumerValidationInfo);
}

// The declaration includes the definition on other builds.

BrowserMemoryConsumerRegistry::IPCStableHashFunction BrowserMemoryConsumerRegistry::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BrowserMemoryConsumerRegistry>(message.name())) {
    case messages::BrowserMemoryConsumerRegistry::kRegisterChildMemoryConsumer: {
      return &BrowserMemoryConsumerRegistry::RegisterChildMemoryConsumer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BrowserMemoryConsumerRegistry::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BrowserMemoryConsumerRegistry>(message.name())) {
      case messages::BrowserMemoryConsumerRegistry::kRegisterChildMemoryConsumer:
            return "Receive content::mojom::BrowserMemoryConsumerRegistry::RegisterChildMemoryConsumer";
    }
  } else {
    switch (static_cast<messages::BrowserMemoryConsumerRegistry>(message.name())) {
      case messages::BrowserMemoryConsumerRegistry::kRegisterChildMemoryConsumer:
            return "Receive reply content::mojom::BrowserMemoryConsumerRegistry::RegisterChildMemoryConsumer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BrowserMemoryConsumerRegistry::RegisterChildMemoryConsumer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24a72dcf;  // IPCStableHash for content::mojom::BrowserMemoryConsumerRegistry::RegisterChildMemoryConsumer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BrowserMemoryConsumerRegistryProxy::BrowserMemoryConsumerRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BrowserMemoryConsumerRegistryProxy::RegisterChildMemoryConsumer(
    const std::string& in_consumer_id, ::base::MemoryConsumerTraits in_traits, ::mojo::PendingRemote<ChildMemoryConsumer> in_child_consumer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::BrowserMemoryConsumerRegistry::RegisterChildMemoryConsumer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("consumer_id"), in_consumer_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traits"), in_traits,
                        "<value of type ::base::MemoryConsumerTraits>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_consumer"), in_child_consumer,
                        "<value of type ::mojo::PendingRemote<ChildMemoryConsumer>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BrowserMemoryConsumerRegistry::kRegisterChildMemoryConsumer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->consumer_id)::BaseType> consumer_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_consumer_id,
    consumer_id_fragment);

  params->consumer_id.Set(
      consumer_id_fragment.is_null() ? nullptr : consumer_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->consumer_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null consumer_id in BrowserMemoryConsumerRegistry.RegisterChildMemoryConsumer request");
  mojo::internal::MessageFragment<
      typename decltype(params->traits)::BaseType> traits_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::MemoryConsumerTraitsDataView>(
    in_traits,
    traits_fragment);

  params->traits.Set(
      traits_fragment.is_null() ? nullptr : traits_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traits.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traits in BrowserMemoryConsumerRegistry.RegisterChildMemoryConsumer request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::content::mojom::ChildMemoryConsumerInterfaceBase>>(
    in_child_consumer,
    &params->child_consumer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->child_consumer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid child_consumer in BrowserMemoryConsumerRegistry.RegisterChildMemoryConsumer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BrowserMemoryConsumerRegistry::Name_);
  message.set_method_name("RegisterChildMemoryConsumer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BrowserMemoryConsumerRegistryStubDispatch::Accept(
    BrowserMemoryConsumerRegistry* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BrowserMemoryConsumerRegistry>(message->header()->name)) {
    case messages::BrowserMemoryConsumerRegistry::kRegisterChildMemoryConsumer: {
      DCHECK(message->is_serialized());
      internal::BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_Params_Data* params =
          reinterpret_cast<internal::BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BrowserMemoryConsumerRegistry.0
      bool success = true;
      std::string p_consumer_id{};
      ::base::MemoryConsumerTraits p_traits{};
      ::mojo::PendingRemote<ChildMemoryConsumer> p_child_consumer{};
      BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConsumerId(&p_consumer_id))
        success = false;
      if (success && !input_data_view.ReadTraits(&p_traits))
        success = false;
      if (success) {
        p_child_consumer =
            input_data_view.TakeChildConsumer<decltype(p_child_consumer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BrowserMemoryConsumerRegistry::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterChildMemoryConsumer(        
        std::move(p_consumer_id), 
        std::move(p_traits), 
        std::move(p_child_consumer));
      return true;
    }
  }
  return false;
}

// static
bool BrowserMemoryConsumerRegistryStubDispatch::AcceptWithResponder(
    BrowserMemoryConsumerRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BrowserMemoryConsumerRegistry>(message->header()->name)) {
    case messages::BrowserMemoryConsumerRegistry::kRegisterChildMemoryConsumer: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBrowserMemoryConsumerRegistryValidationInfo[] = {
    { &internal::BrowserMemoryConsumerRegistry_RegisterChildMemoryConsumer_Params_Data::Validate,
     nullptr /* no response */},
};

bool BrowserMemoryConsumerRegistryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content::mojom::BrowserMemoryConsumerRegistry::Name_,
    kBrowserMemoryConsumerRegistryValidationInfo);
}



}  // content::mojom


namespace mojo {


// static
bool StructTraits<::content::mojom::MemoryConsumerTraits::DataView, ::content::mojom::MemoryConsumerTraitsPtr>::Read(
    ::content::mojom::MemoryConsumerTraits::DataView input,
    ::content::mojom::MemoryConsumerTraitsPtr* output) {
  bool success = true;
  ::content::mojom::MemoryConsumerTraitsPtr result(::content::mojom::MemoryConsumerTraits::New());
  
      if (success)
        result->supports_memory_limit = input.supports_memory_limit();
      if (success)
        result->in_process = input.in_process();
      if (success)
        result->estimated_memory_usage = input.estimated_memory_usage();
      if (success)
        result->release_memory_cost = input.release_memory_cost();
      if (success)
        result->recreate_memory_cost = input.recreate_memory_cost();
      if (success)
        result->information_retention = input.information_retention();
      if (success)
        result->memory_release_behavior = input.memory_release_behavior();
      if (success)
        result->execution_type = input.execution_type();
      if (success)
        result->release_gc_references = input.release_gc_references();
      if (success)
        result->garbage_collects_v8_heap = input.garbage_collects_v8_heap();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void ChildMemoryConsumerInterceptorForTesting::NotifyReleaseMemory() {
  GetForwardingInterface()->NotifyReleaseMemory();
}
void ChildMemoryConsumerInterceptorForTesting::NotifyUpdateMemoryLimit(int32_t percentage) {
  GetForwardingInterface()->NotifyUpdateMemoryLimit(
    std::move(percentage)
    );
}
ChildMemoryConsumerAsyncWaiter::ChildMemoryConsumerAsyncWaiter(
    ChildMemoryConsumer* proxy) : proxy_(proxy) {}

ChildMemoryConsumerAsyncWaiter::~ChildMemoryConsumerAsyncWaiter() = default;





void BrowserMemoryConsumerRegistryInterceptorForTesting::RegisterChildMemoryConsumer(const std::string& consumer_id, ::base::MemoryConsumerTraits traits, ::mojo::PendingRemote<ChildMemoryConsumer> child_consumer) {
  GetForwardingInterface()->RegisterChildMemoryConsumer(
    std::move(consumer_id)
    , 
    std::move(traits)
    , 
    std::move(child_consumer)
    );
}
BrowserMemoryConsumerRegistryAsyncWaiter::BrowserMemoryConsumerRegistryAsyncWaiter(
    BrowserMemoryConsumerRegistry* proxy) : proxy_(proxy) {}

BrowserMemoryConsumerRegistryAsyncWaiter::~BrowserMemoryConsumerRegistryAsyncWaiter() = default;







}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif