// content/common/input/input_injector.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_SHARED_H_
#define CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/input/input_injector.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "content/common/input/input_injector.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::content::mojom::GestureSourceType>
    : public mojo::internal::EnumHashImpl<::content::mojom::GestureSourceType> {};

template <>
struct hash<::content::mojom::PointerActionType>
    : public mojo::internal::EnumHashImpl<::content::mojom::PointerActionType> {};

template <>
struct hash<::content::mojom::SyntheticButton>
    : public mojo::internal::EnumHashImpl<::content::mojom::SyntheticButton> {};

template <>
struct hash<::content::mojom::InputEventPattern>
    : public mojo::internal::EnumHashImpl<::content::mojom::InputEventPattern> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::GestureSourceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::GestureSourceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::GestureSourceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::PointerActionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::PointerActionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::PointerActionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SyntheticButton, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::SyntheticButton, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::SyntheticButton>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::InputEventPattern, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::InputEventPattern, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::InputEventPattern>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SyntheticSmoothDragDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticSmoothDragDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticSmoothDrag_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::content::mojom::GestureSourceType>(
      Traits::gesture_source_type(input),
      &fragment->gesture_source_type);

    decltype(Traits::start_point(input)) in_start_point = Traits::start_point(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_point)::BaseType> start_point_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_start_point,
      start_point_fragment);

    fragment->start_point.Set(
        start_point_fragment.is_null() ? nullptr : start_point_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start_point.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_point in SyntheticSmoothDrag struct");

    decltype(Traits::distances(input)) in_distances = Traits::distances(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->distances)::BaseType>
        distances_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& distances_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>>(
      in_distances,
      distances_fragment,
      &distances_validate_params);

    fragment->distances.Set(
        distances_fragment.is_null() ? nullptr : distances_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->distances.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null distances in SyntheticSmoothDrag struct");

    fragment->speed_in_pixels_s = Traits::speed_in_pixels_s(input);

    fragment->vsync_offset_ms = Traits::vsync_offset_ms(input);

    
    mojo::internal::Serialize<::content::mojom::InputEventPattern>(
      Traits::input_event_pattern(input),
      &fragment->input_event_pattern);
  }

  static bool Deserialize(::content::mojom::internal::SyntheticSmoothDrag_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SyntheticSmoothDragDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SyntheticSmoothScrollDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticSmoothScrollDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticSmoothScroll_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::content::mojom::GestureSourceType>(
      Traits::gesture_source_type(input),
      &fragment->gesture_source_type);

    decltype(Traits::anchor(input)) in_anchor = Traits::anchor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->anchor)::BaseType> anchor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_anchor,
      anchor_fragment);

    fragment->anchor.Set(
        anchor_fragment.is_null() ? nullptr : anchor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->anchor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null anchor in SyntheticSmoothScroll struct");

    decltype(Traits::distances(input)) in_distances = Traits::distances(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->distances)::BaseType>
        distances_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& distances_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>>(
      in_distances,
      distances_fragment,
      &distances_validate_params);

    fragment->distances.Set(
        distances_fragment.is_null() ? nullptr : distances_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->distances.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null distances in SyntheticSmoothScroll struct");

    fragment->prevent_fling = Traits::prevent_fling(input);

    fragment->speed_in_pixels_s = Traits::speed_in_pixels_s(input);

    fragment->fling_velocity_x = Traits::fling_velocity_x(input);

    fragment->fling_velocity_y = Traits::fling_velocity_y(input);

    
    mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
      Traits::granularity(input),
      &fragment->granularity);

    fragment->modifiers = Traits::modifiers(input);

    fragment->vsync_offset_ms = Traits::vsync_offset_ms(input);

    
    mojo::internal::Serialize<::content::mojom::InputEventPattern>(
      Traits::input_event_pattern(input),
      &fragment->input_event_pattern);
  }

  static bool Deserialize(::content::mojom::internal::SyntheticSmoothScroll_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SyntheticSmoothScrollDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SyntheticPinchDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticPinchDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticPinch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->scale_factor = Traits::scale_factor(input);

    decltype(Traits::anchor(input)) in_anchor = Traits::anchor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->anchor)::BaseType> anchor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_anchor,
      anchor_fragment);

    fragment->anchor.Set(
        anchor_fragment.is_null() ? nullptr : anchor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->anchor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null anchor in SyntheticPinch struct");

    fragment->relative_pointer_speed_in_pixels_s = Traits::relative_pointer_speed_in_pixels_s(input);

    fragment->vsync_offset_ms = Traits::vsync_offset_ms(input);

    
    mojo::internal::Serialize<::content::mojom::InputEventPattern>(
      Traits::input_event_pattern(input),
      &fragment->input_event_pattern);
  }

  static bool Deserialize(::content::mojom::internal::SyntheticPinch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SyntheticPinchDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SyntheticTapDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticTapDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticTap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::content::mojom::GestureSourceType>(
      Traits::gesture_source_type(input),
      &fragment->gesture_source_type);

    decltype(Traits::position(input)) in_position = Traits::position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position)::BaseType> position_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_position,
      position_fragment);

    fragment->position.Set(
        position_fragment.is_null() ? nullptr : position_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->position.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null position in SyntheticTap struct");

    fragment->duration_ms = Traits::duration_ms(input);
  }

  static bool Deserialize(::content::mojom::internal::SyntheticTap_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SyntheticTapDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SyntheticPointerActionParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticPointerActionParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticPointerActionParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::content::mojom::PointerActionType>(
      Traits::pointer_action_type(input),
      &fragment->pointer_action_type);

    decltype(Traits::position(input)) in_position = Traits::position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position)::BaseType> position_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_position,
      position_fragment);

    fragment->position.Set(
        position_fragment.is_null() ? nullptr : position_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->position.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null position in SyntheticPointerActionParams struct");

    fragment->pointer_id = Traits::pointer_id(input);

    
    mojo::internal::Serialize<::content::mojom::SyntheticButton>(
      Traits::button(input),
      &fragment->button);

    fragment->key_modifiers = Traits::key_modifiers(input);

    fragment->width = Traits::width(input);

    fragment->height = Traits::height(input);

    fragment->rotation_angle = Traits::rotation_angle(input);

    fragment->force = Traits::force(input);

    fragment->tangential_pressure = Traits::tangential_pressure(input);

    fragment->tilt_x = Traits::tilt_x(input);

    fragment->tilt_y = Traits::tilt_y(input);

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in SyntheticPointerActionParams struct");

    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration,
      duration_fragment);

    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->duration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in SyntheticPointerActionParams struct");
  }

  static bool Deserialize(::content::mojom::internal::SyntheticPointerActionParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SyntheticPointerActionParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SyntheticPointerActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticPointerActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticPointerAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::content::mojom::GestureSourceType>(
      Traits::gesture_source_type(input),
      &fragment->gesture_source_type);

    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType>
        params_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<::content::mojom::SyntheticPointerActionParamsDataView>>>(
      in_params,
      params_fragment,
      &params_validate_params);

    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in SyntheticPointerAction struct");
  }

  static bool Deserialize(::content::mojom::internal::SyntheticPointerAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SyntheticPointerActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content::mojom {

inline void SyntheticSmoothDragDataView::GetStartPointDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->start_point.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void SyntheticSmoothDragDataView::GetDistancesDataView(
    mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>* output) {
  auto pointer = data_->distances.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>(pointer, message_);
}


inline void SyntheticSmoothScrollDataView::GetAnchorDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->anchor.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void SyntheticSmoothScrollDataView::GetDistancesDataView(
    mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>* output) {
  auto pointer = data_->distances.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>(pointer, message_);
}


inline void SyntheticPinchDataView::GetAnchorDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->anchor.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}


inline void SyntheticTapDataView::GetPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}


inline void SyntheticPointerActionParamsDataView::GetPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void SyntheticPointerActionParamsDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void SyntheticPointerActionParamsDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void SyntheticPointerActionDataView::GetParamsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<SyntheticPointerActionParamsDataView>>* output) {
  auto pointer = data_->params.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<SyntheticPointerActionParamsDataView>>(pointer, message_);
}



}  // content::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::GestureSourceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::GestureSourceType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::PointerActionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::PointerActionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::SyntheticButton> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::SyntheticButton value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::InputEventPattern> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::InputEventPattern value);
};

} // namespace perfetto

#endif  // CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_SHARED_H_