// content/common/frame.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_MOJOM_TEST_UTILS_H_
#define CONTENT_COMMON_FRAME_MOJOM_TEST_UTILS_H_

#include "content/common/frame.mojom.h"
#include "content/common/content_export.h"


namespace content::mojom {


class CONTENT_EXPORT FrameHTMLSerializerHandlerInterceptorForTesting : public FrameHTMLSerializerHandler {
  virtual FrameHTMLSerializerHandler* GetForwardingInterface() = 0;
  void DidReceiveData(const std::string& data_buffer) override;
  void Done() override;
};
class CONTENT_EXPORT FrameHTMLSerializerHandlerAsyncWaiter {
 public:
  explicit FrameHTMLSerializerHandlerAsyncWaiter(FrameHTMLSerializerHandler* proxy);

  FrameHTMLSerializerHandlerAsyncWaiter(const FrameHTMLSerializerHandlerAsyncWaiter&) = delete;
  FrameHTMLSerializerHandlerAsyncWaiter& operator=(const FrameHTMLSerializerHandlerAsyncWaiter&) = delete;

  ~FrameHTMLSerializerHandlerAsyncWaiter();

 private:
  FrameHTMLSerializerHandler* const proxy_;
};


class CONTENT_EXPORT FrameInterceptorForTesting : public Frame {
  virtual Frame* GetForwardingInterface() = 0;
  void CommitSameDocumentNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, CommitSameDocumentNavigationCallback callback) override;
  void UpdateSubresourceLoaderFactories(::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories) override;
  void SetWantErrorMessageStackTrace() override;
  void Unload(bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces, const std::optional<::base::UnguessableToken>& devtools_frame_token) override;
  void Delete(FrameDeleteIntention intention) override;
  void UndoCommitNavigation(bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces) override;
  void GetInterfaceProvider(::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> interfaces) override;
  void SnapshotAccessibilityTree(SnapshotAccessibilityTreeParamsPtr params, SnapshotAccessibilityTreeCallback callback) override;
  void GetSerializedHtmlWithLocalLinks(const base::flat_map<::GURL, ::base::FilePath>& url_map, const base::flat_map<::blink::FrameToken, ::base::FilePath>& frame_token_map, bool save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> handler_remote) override;
};
class CONTENT_EXPORT FrameAsyncWaiter {
 public:
  explicit FrameAsyncWaiter(Frame* proxy);

  FrameAsyncWaiter(const FrameAsyncWaiter&) = delete;
  FrameAsyncWaiter& operator=(const FrameAsyncWaiter&) = delete;

  ~FrameAsyncWaiter();
  void CommitSameDocumentNavigation(
      ::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, ::blink::mojom::CommitResult* out_commit_result);
  ::blink::mojom::CommitResult CommitSameDocumentNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params);
  void SnapshotAccessibilityTree(
      SnapshotAccessibilityTreeParamsPtr params, ::ui::AXTreeUpdate* out_snapshot);
  ::ui::AXTreeUpdate SnapshotAccessibilityTree(SnapshotAccessibilityTreeParamsPtr params);

 private:
  Frame* const proxy_;
};


class CONTENT_EXPORT FrameBindingsControlInterceptorForTesting : public FrameBindingsControl {
  virtual FrameBindingsControl* GetForwardingInterface() = 0;
  void AllowBindings(int64_t enabled_bindings_flags) override;
  void EnableMojoJsBindings(::content::mojom::ExtraMojoJsFeaturesPtr features) override;
  void EnableMojoJsBindingsWithBroker(::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> broker) override;
  void BindWebUI(::mojo::PendingAssociatedReceiver<::content::mojom::WebUI> receiver, ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost> remote) override;
};
class CONTENT_EXPORT FrameBindingsControlAsyncWaiter {
 public:
  explicit FrameBindingsControlAsyncWaiter(FrameBindingsControl* proxy);

  FrameBindingsControlAsyncWaiter(const FrameBindingsControlAsyncWaiter&) = delete;
  FrameBindingsControlAsyncWaiter& operator=(const FrameBindingsControlAsyncWaiter&) = delete;

  ~FrameBindingsControlAsyncWaiter();

 private:
  FrameBindingsControl* const proxy_;
};


class CONTENT_EXPORT NavigationRendererCancellationListenerInterceptorForTesting : public NavigationRendererCancellationListener {
  virtual NavigationRendererCancellationListener* GetForwardingInterface() = 0;
  void RendererCancellationWindowEnded() override;
};
class CONTENT_EXPORT NavigationRendererCancellationListenerAsyncWaiter {
 public:
  explicit NavigationRendererCancellationListenerAsyncWaiter(NavigationRendererCancellationListener* proxy);

  NavigationRendererCancellationListenerAsyncWaiter(const NavigationRendererCancellationListenerAsyncWaiter&) = delete;
  NavigationRendererCancellationListenerAsyncWaiter& operator=(const NavigationRendererCancellationListenerAsyncWaiter&) = delete;

  ~NavigationRendererCancellationListenerAsyncWaiter();

 private:
  NavigationRendererCancellationListener* const proxy_;
};


class CONTENT_EXPORT FrameHostInterceptorForTesting : public FrameHost {
  virtual FrameHost* GetForwardingInterface() = 0;
  void CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowCallback callback) override;
  void CreateChildFrame(const ::blink::LocalFrameToken& child_frame_token, ::mojo::PendingAssociatedRemote<Frame> frame, ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker, ::blink::mojom::PolicyContainerBindParamsPtr policy_container_bind_params, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider, ::blink::mojom::TreeScopeType scope, const std::string& frame_name, const std::string& frame_unique_name, bool is_created_by_script, const ::blink::FramePolicy& frame_policy, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties, ::blink::FrameOwnerElementType child_frame_owner_element_type, int64_t document_ukm_source_id) override;
  void DidCommitProvisionalLoad(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr interface_params) override;
  void DidCommitSameDocumentNavigation(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr same_document_params) override;
  void DidOpenDocumentInputStream(const ::GURL& url) override;
  void BeginNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::BeginNavigationParamsPtr begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> navigation_client, ::mojo::PendingRemote<::blink::mojom::NavigationStateKeepAliveHandle> initiator_navigation_state_keep_alive_handle, ::mojo::PendingReceiver<NavigationRendererCancellationListener> renderer_cancellation_listener) override;
  void SubresourceResponseStarted(const ::url::SchemeHostPort& final_response_url, uint32_t cert_status) override;
  void ResourceLoadComplete(::blink::mojom::ResourceLoadInfoPtr url_load_info) override;
  void DidChangeName(const std::string& name, const std::string& unique_name) override;
  void CancelInitialHistoryLoad() override;
  void UpdateEncoding(const std::string& encoding_name) override;
  void UpdateState(const ::blink::PageState& state) override;
  void OpenURL(::blink::mojom::OpenURLParamsPtr params) override;
  void DidStopLoading() override;
};
class CONTENT_EXPORT FrameHostAsyncWaiter {
 public:
  explicit FrameHostAsyncWaiter(FrameHost* proxy);

  FrameHostAsyncWaiter(const FrameHostAsyncWaiter&) = delete;
  FrameHostAsyncWaiter& operator=(const FrameHostAsyncWaiter&) = delete;

  ~FrameHostAsyncWaiter();
  void CreateNewWindow(
      CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply);
  

 private:
  FrameHost* const proxy_;
};




}  // content::mojom

#endif  // CONTENT_COMMON_FRAME_MOJOM_TEST_UTILS_H_