// content/common/frame.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_MOJOM_SHARED_H_
#define CONTENT_COMMON_FRAME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/frame.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_state.mojom-shared.h"
#include "content/common/frame_messages.mojom-shared.h"
#include "content/common/navigation_client.mojom-shared.h"
#include "content/common/web_ui.mojom-shared.h"
#include "content/public/common/extra_mojo_js_features.mojom-shared.h"
#include "content/public/common/window_container_type.mojom-shared.h"
#include "ipc/constants.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "third_party/blink/public/mojom/associated_interfaces/associated_interfaces.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-shared.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-shared.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"
#include "third_party/blink/public/mojom/page/prerender_page_param.mojom-shared.h"
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "content/common/frame.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::content::mojom::ViewWidgetType>
    : public mojo::internal::EnumHashImpl<::content::mojom::ViewWidgetType> {};

template <>
struct hash<::content::mojom::ChildFrameOwnerElementType>
    : public mojo::internal::EnumHashImpl<::content::mojom::ChildFrameOwnerElementType> {};

template <>
struct hash<::content::mojom::FrameDeleteIntention>
    : public mojo::internal::EnumHashImpl<::content::mojom::FrameDeleteIntention> {};

template <>
struct hash<::content::mojom::CreateNewWindowStatus>
    : public mojo::internal::EnumHashImpl<::content::mojom::CreateNewWindowStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ViewWidgetType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::ViewWidgetType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::ViewWidgetType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ChildFrameOwnerElementType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::ChildFrameOwnerElementType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::ChildFrameOwnerElementType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::FrameDeleteIntention, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::FrameDeleteIntention, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::FrameDeleteIntention>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateNewWindowStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::CreateNewWindowStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::CreateNewWindowStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateViewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateViewParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateViewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::renderer_preferences(input)) in_renderer_preferences = Traits::renderer_preferences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->renderer_preferences)::BaseType> renderer_preferences_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::RendererPreferencesDataView>(
      in_renderer_preferences,
      renderer_preferences_fragment);

    fragment->renderer_preferences.Set(
        renderer_preferences_fragment.is_null() ? nullptr : renderer_preferences_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->renderer_preferences.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null renderer_preferences in CreateViewParams struct");

    decltype(Traits::web_preferences(input)) in_web_preferences = Traits::web_preferences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->web_preferences)::BaseType> web_preferences_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebPreferencesDataView>(
      in_web_preferences,
      web_preferences_fragment);

    fragment->web_preferences.Set(
        web_preferences_fragment.is_null() ? nullptr : web_preferences_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->web_preferences.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null web_preferences in CreateViewParams struct");

    decltype(Traits::session_storage_namespace_id(input)) in_session_storage_namespace_id = Traits::session_storage_namespace_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_storage_namespace_id)::BaseType> session_storage_namespace_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_session_storage_namespace_id,
      session_storage_namespace_id_fragment);

    fragment->session_storage_namespace_id.Set(
        session_storage_namespace_id_fragment.is_null() ? nullptr : session_storage_namespace_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session_storage_namespace_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_storage_namespace_id in CreateViewParams struct");

    decltype(Traits::opener_frame_token(input)) in_opener_frame_token = Traits::opener_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->opener_frame_token)>
        opener_frame_token_fragment(fragment.message());
    opener_frame_token_fragment.Claim(&fragment->opener_frame_token);
    
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_opener_frame_token,
      opener_frame_token_fragment,
      true);

    decltype(Traits::replication_state(input)) in_replication_state = Traits::replication_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replication_state)::BaseType> replication_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
      in_replication_state,
      replication_state_fragment);

    fragment->replication_state.Set(
        replication_state_fragment.is_null() ? nullptr : replication_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->replication_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replication_state in CreateViewParams struct");

    decltype(Traits::devtools_main_frame_token(input)) in_devtools_main_frame_token = Traits::devtools_main_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_main_frame_token)::BaseType> devtools_main_frame_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_main_frame_token,
      devtools_main_frame_token_fragment);

    fragment->devtools_main_frame_token.Set(
        devtools_main_frame_token_fragment.is_null() ? nullptr : devtools_main_frame_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->devtools_main_frame_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_main_frame_token in CreateViewParams struct");

    decltype(Traits::main_frame(input)) in_main_frame = Traits::main_frame(input);
    mojo::internal::MessageFragment<decltype(fragment->main_frame)>
        main_frame_fragment(fragment.message());
    main_frame_fragment.Claim(&fragment->main_frame);
    
    mojo::internal::Serialize<::content::mojom::CreateMainFrameUnionDataView>(
      in_main_frame,
      main_frame_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->main_frame.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame in CreateViewParams struct");

    fragment->hidden = Traits::hidden(input);

    decltype(Traits::prerender_param(input)) in_prerender_param = Traits::prerender_param(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prerender_param)::BaseType> prerender_param_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PrerenderParamDataView>(
      in_prerender_param,
      prerender_param_fragment);

    fragment->prerender_param.Set(
        prerender_param_fragment.is_null() ? nullptr : prerender_param_fragment.data());

    fragment->never_composited = Traits::never_composited(input);

    fragment->window_was_opened_by_another_window = Traits::window_was_opened_by_another_window(input);

    
    mojo::internal::Serialize<::content::mojom::ViewWidgetType>(
      Traits::type(input),
      &fragment->type);

    
    mojo::internal::Serialize<::blink::mojom::DeprecatedFencedFrameMode>(
      Traits::fenced_frame_mode(input),
      &fragment->fenced_frame_mode);

    decltype(Traits::outermost_origin(input)) in_outermost_origin = Traits::outermost_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->outermost_origin)::BaseType> outermost_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_outermost_origin,
      outermost_origin_fragment);

    fragment->outermost_origin.Set(
        outermost_origin_fragment.is_null() ? nullptr : outermost_origin_fragment.data());

    decltype(Traits::blink_page_broadcast(input)) in_blink_page_broadcast = Traits::blink_page_broadcast(input);

    
    mojo::internal::Serialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
      in_blink_page_broadcast,
      &fragment->blink_page_broadcast,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->blink_page_broadcast)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid blink_page_broadcast in CreateViewParams struct");

    decltype(Traits::base_background_color(input)) in_base_background_color = Traits::base_background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->base_background_color)::BaseType> base_background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_base_background_color,
      base_background_color_fragment);

    fragment->base_background_color.Set(
        base_background_color_fragment.is_null() ? nullptr : base_background_color_fragment.data());

    decltype(Traits::color_provider_colors(input)) in_color_provider_colors = Traits::color_provider_colors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_provider_colors)::BaseType> color_provider_colors_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ColorProviderColorMapsDataView>(
      in_color_provider_colors,
      color_provider_colors_fragment);

    fragment->color_provider_colors.Set(
        color_provider_colors_fragment.is_null() ? nullptr : color_provider_colors_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color_provider_colors.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_provider_colors in CreateViewParams struct");

    decltype(Traits::browsing_context_group_token(input)) in_browsing_context_group_token = Traits::browsing_context_group_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browsing_context_group_token)::BaseType> browsing_context_group_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_browsing_context_group_token,
      browsing_context_group_token_fragment);

    fragment->browsing_context_group_token.Set(
        browsing_context_group_token_fragment.is_null() ? nullptr : browsing_context_group_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->browsing_context_group_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browsing_context_group_token in CreateViewParams struct");

    
    mojo::internal::Serialize<::network::mojom::AttributionSupport>(
      Traits::attribution_support(input),
      &fragment->attribution_support);

    decltype(Traits::navigation_metrics_token(input)) in_navigation_metrics_token = Traits::navigation_metrics_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_metrics_token)::BaseType> navigation_metrics_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_navigation_metrics_token,
      navigation_metrics_token_fragment);

    fragment->navigation_metrics_token.Set(
        navigation_metrics_token_fragment.is_null() ? nullptr : navigation_metrics_token_fragment.data());

    fragment->history_index = Traits::history_index(input);

    fragment->history_length = Traits::history_length(input);
  }

  static bool Deserialize(::content::mojom::internal::CreateViewParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateViewParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateLocalMainFrameParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateLocalMainFrameParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateLocalMainFrameParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::frame_token(input)) in_frame_token = Traits::frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_token)::BaseType> frame_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_frame_token,
      frame_token_fragment);

    fragment->frame_token.Set(
        frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token in CreateLocalMainFrameParams struct");

    fragment->routing_id = Traits::routing_id(input);

    decltype(Traits::frame(input)) in_frame = Traits::frame(input);

    
    mojo::internal::Serialize<::content::mojom::FrameAssociatedRequestDataView>(
      in_frame,
      &fragment->frame,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid frame in CreateLocalMainFrameParams struct");

    decltype(Traits::interface_broker(input)) in_interface_broker = Traits::interface_broker(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_interface_broker,
      &fragment->interface_broker,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->interface_broker)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid interface_broker in CreateLocalMainFrameParams struct");

    decltype(Traits::associated_interface_provider_remote(input)) in_associated_interface_provider_remote = Traits::associated_interface_provider_remote(input);

    
    mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
      in_associated_interface_provider_remote,
      &fragment->associated_interface_provider_remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->associated_interface_provider_remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid associated_interface_provider_remote in CreateLocalMainFrameParams struct");

    fragment->is_on_initial_empty_document = Traits::is_on_initial_empty_document(input);

    decltype(Traits::document_token(input)) in_document_token = Traits::document_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_token)::BaseType> document_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView>(
      in_document_token,
      document_token_fragment);

    fragment->document_token.Set(
        document_token_fragment.is_null() ? nullptr : document_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->document_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_token in CreateLocalMainFrameParams struct");

    decltype(Traits::policy_container(input)) in_policy_container = Traits::policy_container(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_container)::BaseType> policy_container_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
      in_policy_container,
      policy_container_fragment);

    fragment->policy_container.Set(
        policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());

    decltype(Traits::widget_params(input)) in_widget_params = Traits::widget_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->widget_params)::BaseType> widget_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::content::mojom::CreateFrameWidgetParamsDataView>(
      in_widget_params,
      widget_params_fragment);

    fragment->widget_params.Set(
        widget_params_fragment.is_null() ? nullptr : widget_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->widget_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null widget_params in CreateLocalMainFrameParams struct");

    decltype(Traits::subresource_loader_factories(input)) in_subresource_loader_factories = Traits::subresource_loader_factories(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories,
      subresource_loader_factories_fragment);

    fragment->subresource_loader_factories.Set(
        subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subresource_loader_factories.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subresource_loader_factories in CreateLocalMainFrameParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CreateLocalMainFrameParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateLocalMainFrameParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateProvisionalLocalMainFrameParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::local_params(input)) in_local_params = Traits::local_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_params)::BaseType> local_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::content::mojom::CreateLocalMainFrameParamsDataView>(
      in_local_params,
      local_params_fragment);

    fragment->local_params.Set(
        local_params_fragment.is_null() ? nullptr : local_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->local_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_params in CreateProvisionalLocalMainFrameParams struct");

    decltype(Traits::previous_frame_token(input)) in_previous_frame_token = Traits::previous_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->previous_frame_token)>
        previous_frame_token_fragment(fragment.message());
    previous_frame_token_fragment.Claim(&fragment->previous_frame_token);
    
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_previous_frame_token,
      previous_frame_token_fragment,
      true);
  }

  static bool Deserialize(::content::mojom::internal::CreateProvisionalLocalMainFrameParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateProvisionalLocalMainFrameParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateRemoteMainFrameParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateRemoteMainFrameParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateRemoteMainFrameParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
      in_token,
      token_fragment);

    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in CreateRemoteMainFrameParams struct");

    decltype(Traits::frame_interfaces(input)) in_frame_interfaces = Traits::frame_interfaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_interfaces)::BaseType> frame_interfaces_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
      in_frame_interfaces,
      frame_interfaces_fragment);

    fragment->frame_interfaces.Set(
        frame_interfaces_fragment.is_null() ? nullptr : frame_interfaces_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_interfaces.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_interfaces in CreateRemoteMainFrameParams struct");

    decltype(Traits::main_frame_interfaces(input)) in_main_frame_interfaces = Traits::main_frame_interfaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_frame_interfaces)::BaseType> main_frame_interfaces_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::RemoteMainFrameInterfacesDataView>(
      in_main_frame_interfaces,
      main_frame_interfaces_fragment);

    fragment->main_frame_interfaces.Set(
        main_frame_interfaces_fragment.is_null() ? nullptr : main_frame_interfaces_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->main_frame_interfaces.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame_interfaces in CreateRemoteMainFrameParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CreateRemoteMainFrameParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateRemoteMainFrameParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateFrameWidgetParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateFrameWidgetParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateFrameWidgetParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->routing_id = Traits::routing_id(input);

    decltype(Traits::frame_widget_host(input)) in_frame_widget_host = Traits::frame_widget_host(input);

    
    mojo::internal::Serialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
      in_frame_widget_host,
      &fragment->frame_widget_host,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame_widget_host)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid frame_widget_host in CreateFrameWidgetParams struct");

    decltype(Traits::frame_widget(input)) in_frame_widget = Traits::frame_widget(input);

    
    mojo::internal::Serialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
      in_frame_widget,
      &fragment->frame_widget,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame_widget)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid frame_widget in CreateFrameWidgetParams struct");

    decltype(Traits::widget_host(input)) in_widget_host = Traits::widget_host(input);

    
    mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
      in_widget_host,
      &fragment->widget_host,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->widget_host)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid widget_host in CreateFrameWidgetParams struct");

    decltype(Traits::widget(input)) in_widget = Traits::widget(input);

    
    mojo::internal::Serialize<::blink::mojom::WidgetAssociatedRequestDataView>(
      in_widget,
      &fragment->widget,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->widget)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid widget in CreateFrameWidgetParams struct");

    decltype(Traits::visual_properties(input)) in_visual_properties = Traits::visual_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visual_properties)::BaseType> visual_properties_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::VisualPropertiesDataView>(
      in_visual_properties,
      visual_properties_fragment);

    fragment->visual_properties.Set(
        visual_properties_fragment.is_null() ? nullptr : visual_properties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visual_properties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visual_properties in CreateFrameWidgetParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CreateFrameWidgetParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateFrameWidgetParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateFrameParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateFrameParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateFrameParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::frame_token(input)) in_frame_token = Traits::frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_token)::BaseType> frame_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_frame_token,
      frame_token_fragment);

    fragment->frame_token.Set(
        frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token in CreateFrameParams struct");

    fragment->routing_id = Traits::routing_id(input);

    decltype(Traits::previous_frame_token(input)) in_previous_frame_token = Traits::previous_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->previous_frame_token)>
        previous_frame_token_fragment(fragment.message());
    previous_frame_token_fragment.Claim(&fragment->previous_frame_token);
    
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_previous_frame_token,
      previous_frame_token_fragment,
      true);

    decltype(Traits::opener_frame_token(input)) in_opener_frame_token = Traits::opener_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->opener_frame_token)>
        opener_frame_token_fragment(fragment.message());
    opener_frame_token_fragment.Claim(&fragment->opener_frame_token);
    
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_opener_frame_token,
      opener_frame_token_fragment,
      true);

    decltype(Traits::parent_frame_token(input)) in_parent_frame_token = Traits::parent_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->parent_frame_token)>
        parent_frame_token_fragment(fragment.message());
    parent_frame_token_fragment.Claim(&fragment->parent_frame_token);
    
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_parent_frame_token,
      parent_frame_token_fragment,
      true);

    decltype(Traits::previous_sibling_frame_token(input)) in_previous_sibling_frame_token = Traits::previous_sibling_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->previous_sibling_frame_token)>
        previous_sibling_frame_token_fragment(fragment.message());
    previous_sibling_frame_token_fragment.Claim(&fragment->previous_sibling_frame_token);
    
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_previous_sibling_frame_token,
      previous_sibling_frame_token_fragment,
      true);

    decltype(Traits::interface_broker(input)) in_interface_broker = Traits::interface_broker(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_interface_broker,
      &fragment->interface_broker,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->interface_broker)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid interface_broker in CreateFrameParams struct");

    
    mojo::internal::Serialize<::blink::mojom::TreeScopeType>(
      Traits::tree_scope_type(input),
      &fragment->tree_scope_type);

    decltype(Traits::replication_state(input)) in_replication_state = Traits::replication_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replication_state)::BaseType> replication_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
      in_replication_state,
      replication_state_fragment);

    fragment->replication_state.Set(
        replication_state_fragment.is_null() ? nullptr : replication_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->replication_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replication_state in CreateFrameParams struct");

    decltype(Traits::devtools_frame_token(input)) in_devtools_frame_token = Traits::devtools_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_frame_token,
      devtools_frame_token_fragment);

    fragment->devtools_frame_token.Set(
        devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->devtools_frame_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_frame_token in CreateFrameParams struct");

    decltype(Traits::frame_owner_properties(input)) in_frame_owner_properties = Traits::frame_owner_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_owner_properties)::BaseType> frame_owner_properties_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
      in_frame_owner_properties,
      frame_owner_properties_fragment);

    fragment->frame_owner_properties.Set(
        frame_owner_properties_fragment.is_null() ? nullptr : frame_owner_properties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_owner_properties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_owner_properties in CreateFrameParams struct");

    decltype(Traits::widget_params(input)) in_widget_params = Traits::widget_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->widget_params)::BaseType> widget_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::content::mojom::CreateFrameWidgetParamsDataView>(
      in_widget_params,
      widget_params_fragment);

    fragment->widget_params.Set(
        widget_params_fragment.is_null() ? nullptr : widget_params_fragment.data());

    fragment->is_on_initial_empty_document = Traits::is_on_initial_empty_document(input);

    decltype(Traits::document_token(input)) in_document_token = Traits::document_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_token)::BaseType> document_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView>(
      in_document_token,
      document_token_fragment);

    fragment->document_token.Set(
        document_token_fragment.is_null() ? nullptr : document_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->document_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_token in CreateFrameParams struct");

    decltype(Traits::policy_container(input)) in_policy_container = Traits::policy_container(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_container)::BaseType> policy_container_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
      in_policy_container,
      policy_container_fragment);

    fragment->policy_container.Set(
        policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());

    decltype(Traits::frame(input)) in_frame = Traits::frame(input);

    
    mojo::internal::Serialize<::content::mojom::FrameAssociatedRequestDataView>(
      in_frame,
      &fragment->frame,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid frame in CreateFrameParams struct");

    decltype(Traits::associated_interface_provider_remote(input)) in_associated_interface_provider_remote = Traits::associated_interface_provider_remote(input);

    
    mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
      in_associated_interface_provider_remote,
      &fragment->associated_interface_provider_remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->associated_interface_provider_remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid associated_interface_provider_remote in CreateFrameParams struct");

    fragment->is_for_nested_main_frame = Traits::is_for_nested_main_frame(input);

    decltype(Traits::navigation_metrics_token(input)) in_navigation_metrics_token = Traits::navigation_metrics_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_metrics_token)::BaseType> navigation_metrics_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_navigation_metrics_token,
      navigation_metrics_token_fragment);

    fragment->navigation_metrics_token.Set(
        navigation_metrics_token_fragment.is_null() ? nullptr : navigation_metrics_token_fragment.data());
  }

  static bool Deserialize(::content::mojom::internal::CreateFrameParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateFrameParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SnapshotAccessibilityTreeParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SnapshotAccessibilityTreeParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SnapshotAccessibilityTreeParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->ax_mode = Traits::ax_mode(input);

    fragment->max_nodes = Traits::max_nodes(input);

    decltype(Traits::timeout(input)) in_timeout = Traits::timeout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timeout)::BaseType> timeout_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timeout,
      timeout_fragment);

    fragment->timeout.Set(
        timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timeout.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timeout in SnapshotAccessibilityTreeParams struct");
  }

  static bool Deserialize(::content::mojom::internal::SnapshotAccessibilityTreeParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SnapshotAccessibilityTreeParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateNewWindowParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateNewWindowParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateNewWindowParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->allow_popup = Traits::allow_popup(input);

    
    mojo::internal::Serialize<::content::mojom::WindowContainerType>(
      Traits::window_container_type(input),
      &fragment->window_container_type);

    decltype(Traits::session_storage_namespace_id(input)) in_session_storage_namespace_id = Traits::session_storage_namespace_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_storage_namespace_id)::BaseType> session_storage_namespace_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_session_storage_namespace_id,
      session_storage_namespace_id_fragment);

    fragment->session_storage_namespace_id.Set(
        session_storage_namespace_id_fragment.is_null() ? nullptr : session_storage_namespace_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session_storage_namespace_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_storage_namespace_id in CreateNewWindowParams struct");

    decltype(Traits::clone_from_session_storage_namespace_id(input)) in_clone_from_session_storage_namespace_id = Traits::clone_from_session_storage_namespace_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clone_from_session_storage_namespace_id)::BaseType> clone_from_session_storage_namespace_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_clone_from_session_storage_namespace_id,
      clone_from_session_storage_namespace_id_fragment);

    fragment->clone_from_session_storage_namespace_id.Set(
        clone_from_session_storage_namespace_id_fragment.is_null() ? nullptr : clone_from_session_storage_namespace_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->clone_from_session_storage_namespace_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clone_from_session_storage_namespace_id in CreateNewWindowParams struct");

    decltype(Traits::frame_name(input)) in_frame_name = Traits::frame_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_name)::BaseType> frame_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_frame_name,
      frame_name_fragment);

    fragment->frame_name.Set(
        frame_name_fragment.is_null() ? nullptr : frame_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_name in CreateNewWindowParams struct");

    fragment->opener_suppressed = Traits::opener_suppressed(input);

    fragment->is_form_submission = Traits::is_form_submission(input);

    fragment->consumes_user_activation = Traits::consumes_user_activation(input);

    decltype(Traits::form_submission_post_data(input)) in_form_submission_post_data = Traits::form_submission_post_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_submission_post_data)::BaseType> form_submission_post_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::URLRequestBodyDataView>(
      in_form_submission_post_data,
      form_submission_post_data_fragment);

    fragment->form_submission_post_data.Set(
        form_submission_post_data_fragment.is_null() ? nullptr : form_submission_post_data_fragment.data());

    decltype(Traits::form_submission_post_content_type(input)) in_form_submission_post_content_type = Traits::form_submission_post_content_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_submission_post_content_type)::BaseType> form_submission_post_content_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_form_submission_post_content_type,
      form_submission_post_content_type_fragment);

    fragment->form_submission_post_content_type.Set(
        form_submission_post_content_type_fragment.is_null() ? nullptr : form_submission_post_content_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->form_submission_post_content_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_submission_post_content_type in CreateNewWindowParams struct");

    
    mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
      Traits::disposition(input),
      &fragment->disposition);

    decltype(Traits::target_url(input)) in_target_url = Traits::target_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_url)::BaseType> target_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_target_url,
      target_url_fragment);

    fragment->target_url.Set(
        target_url_fragment.is_null() ? nullptr : target_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->target_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_url in CreateNewWindowParams struct");

    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
      in_referrer,
      referrer_fragment);

    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->referrer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null referrer in CreateNewWindowParams struct");

    decltype(Traits::features(input)) in_features = Traits::features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->features)::BaseType> features_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WindowFeaturesDataView>(
      in_features,
      features_fragment);

    fragment->features.Set(
        features_fragment.is_null() ? nullptr : features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in CreateNewWindowParams struct");

    decltype(Traits::impression(input)) in_impression = Traits::impression(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->impression)::BaseType> impression_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ImpressionDataView>(
      in_impression,
      impression_fragment);

    fragment->impression.Set(
        impression_fragment.is_null() ? nullptr : impression_fragment.data());

    decltype(Traits::download_policy(input)) in_download_policy = Traits::download_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->download_policy)::BaseType> download_policy_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::NavigationDownloadPolicyDataView>(
      in_download_policy,
      download_policy_fragment);

    fragment->download_policy.Set(
        download_policy_fragment.is_null() ? nullptr : download_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->download_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null download_policy in CreateNewWindowParams struct");

    decltype(Traits::pip_options(input)) in_pip_options = Traits::pip_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pip_options)::BaseType> pip_options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PictureInPictureWindowOptionsDataView>(
      in_pip_options,
      pip_options_fragment);

    fragment->pip_options.Set(
        pip_options_fragment.is_null() ? nullptr : pip_options_fragment.data());

    
    mojo::internal::Serialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
      Traits::initiator_activation_and_ad_status(input),
      &fragment->initiator_activation_and_ad_status);

    decltype(Traits::frame_remote(input)) in_frame_remote = Traits::frame_remote(input);

    
    mojo::internal::Serialize<::content::mojom::FrameAssociatedPtrInfoDataView>(
      in_frame_remote,
      &fragment->frame_remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame_remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid frame_remote in CreateNewWindowParams struct");

    decltype(Traits::page_broadcast_remote(input)) in_page_broadcast_remote = Traits::page_broadcast_remote(input);

    
    mojo::internal::Serialize<::blink::mojom::PageBroadcastAssociatedPtrInfoDataView>(
      in_page_broadcast_remote,
      &fragment->page_broadcast_remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->page_broadcast_remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid page_broadcast_remote in CreateNewWindowParams struct");

    decltype(Traits::main_frame_interface_broker(input)) in_main_frame_interface_broker = Traits::main_frame_interface_broker(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_main_frame_interface_broker,
      &fragment->main_frame_interface_broker,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->main_frame_interface_broker)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid main_frame_interface_broker in CreateNewWindowParams struct");

    decltype(Traits::associated_interface_provider(input)) in_associated_interface_provider = Traits::associated_interface_provider(input);

    
    mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedRequestDataView>(
      in_associated_interface_provider,
      &fragment->associated_interface_provider,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->associated_interface_provider)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid associated_interface_provider in CreateNewWindowParams struct");

    decltype(Traits::widget_host(input)) in_widget_host = Traits::widget_host(input);

    
    mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedRequestDataView>(
      in_widget_host,
      &fragment->widget_host,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->widget_host)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid widget_host in CreateNewWindowParams struct");

    decltype(Traits::widget(input)) in_widget = Traits::widget(input);

    
    mojo::internal::Serialize<::blink::mojom::WidgetAssociatedPtrInfoDataView>(
      in_widget,
      &fragment->widget,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->widget)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid widget in CreateNewWindowParams struct");

    decltype(Traits::frame_widget_host(input)) in_frame_widget_host = Traits::frame_widget_host(input);

    
    mojo::internal::Serialize<::blink::mojom::FrameWidgetHostAssociatedRequestDataView>(
      in_frame_widget_host,
      &fragment->frame_widget_host,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame_widget_host)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid frame_widget_host in CreateNewWindowParams struct");

    decltype(Traits::frame_widget(input)) in_frame_widget = Traits::frame_widget(input);

    
    mojo::internal::Serialize<::blink::mojom::FrameWidgetAssociatedPtrInfoDataView>(
      in_frame_widget,
      &fragment->frame_widget,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame_widget)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid frame_widget in CreateNewWindowParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CreateNewWindowParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateNewWindowParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateNewWindowReplyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateNewWindowReplyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateNewWindowReply_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::main_frame_token(input)) in_main_frame_token = Traits::main_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_frame_token)::BaseType> main_frame_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_main_frame_token,
      main_frame_token_fragment);

    fragment->main_frame_token.Set(
        main_frame_token_fragment.is_null() ? nullptr : main_frame_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->main_frame_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame_token in CreateNewWindowReply struct");

    fragment->main_frame_route_id = Traits::main_frame_route_id(input);

    fragment->widget_routing_id = Traits::widget_routing_id(input);

    decltype(Traits::visual_properties(input)) in_visual_properties = Traits::visual_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visual_properties)::BaseType> visual_properties_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::VisualPropertiesDataView>(
      in_visual_properties,
      visual_properties_fragment);

    fragment->visual_properties.Set(
        visual_properties_fragment.is_null() ? nullptr : visual_properties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visual_properties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visual_properties in CreateNewWindowReply struct");

    decltype(Traits::cloned_session_storage_namespace_id(input)) in_cloned_session_storage_namespace_id = Traits::cloned_session_storage_namespace_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cloned_session_storage_namespace_id)::BaseType> cloned_session_storage_namespace_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_cloned_session_storage_namespace_id,
      cloned_session_storage_namespace_id_fragment);

    fragment->cloned_session_storage_namespace_id.Set(
        cloned_session_storage_namespace_id_fragment.is_null() ? nullptr : cloned_session_storage_namespace_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cloned_session_storage_namespace_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cloned_session_storage_namespace_id in CreateNewWindowReply struct");

    decltype(Traits::devtools_main_frame_token(input)) in_devtools_main_frame_token = Traits::devtools_main_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_main_frame_token)::BaseType> devtools_main_frame_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_main_frame_token,
      devtools_main_frame_token_fragment);

    fragment->devtools_main_frame_token.Set(
        devtools_main_frame_token_fragment.is_null() ? nullptr : devtools_main_frame_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->devtools_main_frame_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_main_frame_token in CreateNewWindowReply struct");

    fragment->wait_for_debugger = Traits::wait_for_debugger(input);

    decltype(Traits::document_token(input)) in_document_token = Traits::document_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_token)::BaseType> document_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView>(
      in_document_token,
      document_token_fragment);

    fragment->document_token.Set(
        document_token_fragment.is_null() ? nullptr : document_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->document_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_token in CreateNewWindowReply struct");

    decltype(Traits::policy_container(input)) in_policy_container = Traits::policy_container(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_container)::BaseType> policy_container_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
      in_policy_container,
      policy_container_fragment);

    fragment->policy_container.Set(
        policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->policy_container.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_container in CreateNewWindowReply struct");

    decltype(Traits::browsing_context_group_token(input)) in_browsing_context_group_token = Traits::browsing_context_group_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browsing_context_group_token)::BaseType> browsing_context_group_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_browsing_context_group_token,
      browsing_context_group_token_fragment);

    fragment->browsing_context_group_token.Set(
        browsing_context_group_token_fragment.is_null() ? nullptr : browsing_context_group_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->browsing_context_group_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browsing_context_group_token in CreateNewWindowReply struct");

    decltype(Traits::color_provider_colors(input)) in_color_provider_colors = Traits::color_provider_colors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_provider_colors)::BaseType> color_provider_colors_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ColorProviderColorMapsDataView>(
      in_color_provider_colors,
      color_provider_colors_fragment);

    fragment->color_provider_colors.Set(
        color_provider_colors_fragment.is_null() ? nullptr : color_provider_colors_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color_provider_colors.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_provider_colors in CreateNewWindowReply struct");

    decltype(Traits::widget_screen_rect(input)) in_widget_screen_rect = Traits::widget_screen_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->widget_screen_rect)::BaseType> widget_screen_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_widget_screen_rect,
      widget_screen_rect_fragment);

    fragment->widget_screen_rect.Set(
        widget_screen_rect_fragment.is_null() ? nullptr : widget_screen_rect_fragment.data());

    decltype(Traits::window_screen_rect(input)) in_window_screen_rect = Traits::window_screen_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->window_screen_rect)::BaseType> window_screen_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_window_screen_rect,
      window_screen_rect_fragment);

    fragment->window_screen_rect.Set(
        window_screen_rect_fragment.is_null() ? nullptr : window_screen_rect_fragment.data());
  }

  static bool Deserialize(::content::mojom::internal::CreateNewWindowReply_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateNewWindowReplyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateMainFrameUnionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::content::mojom::CreateMainFrameUnionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::content::mojom::internal::CreateMainFrameUnion_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::content::mojom::CreateMainFrameUnionDataView::Tag::kLocalParams: {
    decltype(Traits::local_params(input))
    in_local_params = Traits::local_params(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_local_params)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::content::mojom::CreateLocalMainFrameParamsDataView>(
  in_local_params,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null local_params in CreateMainFrameUnion union");
    fragment->data.f_local_params.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::content::mojom::CreateMainFrameUnionDataView::Tag::kProvisionalLocalParams: {
    decltype(Traits::provisional_local_params(input))
    in_provisional_local_params = Traits::provisional_local_params(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_provisional_local_params)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView>(
  in_provisional_local_params,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null provisional_local_params in CreateMainFrameUnion union");
    fragment->data.f_provisional_local_params.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::content::mojom::CreateMainFrameUnionDataView::Tag::kRemoteParams: {
    decltype(Traits::remote_params(input))
    in_remote_params = Traits::remote_params(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_remote_params)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::content::mojom::CreateRemoteMainFrameParamsDataView>(
  in_remote_params,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null remote_params in CreateMainFrameUnion union");
    fragment->data.f_remote_params.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::content::mojom::internal::CreateMainFrameUnion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateMainFrameUnionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content::mojom {

inline void CreateViewParamsDataView::GetRendererPreferencesDataView(
    ::blink::mojom::RendererPreferencesDataView* output) {
  auto pointer = data_->renderer_preferences.Get();
  *output = ::blink::mojom::RendererPreferencesDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetWebPreferencesDataView(
    ::blink::mojom::WebPreferencesDataView* output) {
  auto pointer = data_->web_preferences.Get();
  *output = ::blink::mojom::WebPreferencesDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetOpenerFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->opener_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetReplicationStateDataView(
    ::blink::mojom::FrameReplicationStateDataView* output) {
  auto pointer = data_->replication_state.Get();
  *output = ::blink::mojom::FrameReplicationStateDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetDevtoolsMainFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_main_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetMainFrameDataView(
    CreateMainFrameUnionDataView* output) {
  auto pointer = &data_->main_frame;
  *output = CreateMainFrameUnionDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetPrerenderParamDataView(
    ::blink::mojom::PrerenderParamDataView* output) {
  auto pointer = data_->prerender_param.Get();
  *output = ::blink::mojom::PrerenderParamDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetOutermostOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->outermost_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetBaseBackgroundColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->base_background_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetColorProviderColorsDataView(
    ::blink::mojom::ColorProviderColorMapsDataView* output) {
  auto pointer = data_->color_provider_colors.Get();
  *output = ::blink::mojom::ColorProviderColorMapsDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetBrowsingContextGroupTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->browsing_context_group_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetNavigationMetricsTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->navigation_metrics_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void CreateLocalMainFrameParamsDataView::GetFrameTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->frame_token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void CreateLocalMainFrameParamsDataView::GetDocumentTokenDataView(
    ::blink::mojom::DocumentTokenDataView* output) {
  auto pointer = data_->document_token.Get();
  *output = ::blink::mojom::DocumentTokenDataView(pointer, message_);
}
inline void CreateLocalMainFrameParamsDataView::GetPolicyContainerDataView(
    ::blink::mojom::PolicyContainerDataView* output) {
  auto pointer = data_->policy_container.Get();
  *output = ::blink::mojom::PolicyContainerDataView(pointer, message_);
}
inline void CreateLocalMainFrameParamsDataView::GetWidgetParamsDataView(
    CreateFrameWidgetParamsDataView* output) {
  auto pointer = data_->widget_params.Get();
  *output = CreateFrameWidgetParamsDataView(pointer, message_);
}
inline void CreateLocalMainFrameParamsDataView::GetSubresourceLoaderFactoriesDataView(
    ::blink::mojom::URLLoaderFactoryBundleDataView* output) {
  auto pointer = data_->subresource_loader_factories.Get();
  *output = ::blink::mojom::URLLoaderFactoryBundleDataView(pointer, message_);
}


inline void CreateProvisionalLocalMainFrameParamsDataView::GetLocalParamsDataView(
    CreateLocalMainFrameParamsDataView* output) {
  auto pointer = data_->local_params.Get();
  *output = CreateLocalMainFrameParamsDataView(pointer, message_);
}
inline void CreateProvisionalLocalMainFrameParamsDataView::GetPreviousFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->previous_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}


inline void CreateRemoteMainFrameParamsDataView::GetTokenDataView(
    ::blink::mojom::RemoteFrameTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::blink::mojom::RemoteFrameTokenDataView(pointer, message_);
}
inline void CreateRemoteMainFrameParamsDataView::GetFrameInterfacesDataView(
    ::blink::mojom::RemoteFrameInterfacesFromBrowserDataView* output) {
  auto pointer = data_->frame_interfaces.Get();
  *output = ::blink::mojom::RemoteFrameInterfacesFromBrowserDataView(pointer, message_);
}
inline void CreateRemoteMainFrameParamsDataView::GetMainFrameInterfacesDataView(
    ::blink::mojom::RemoteMainFrameInterfacesDataView* output) {
  auto pointer = data_->main_frame_interfaces.Get();
  *output = ::blink::mojom::RemoteMainFrameInterfacesDataView(pointer, message_);
}


inline void CreateFrameWidgetParamsDataView::GetVisualPropertiesDataView(
    ::blink::mojom::VisualPropertiesDataView* output) {
  auto pointer = data_->visual_properties.Get();
  *output = ::blink::mojom::VisualPropertiesDataView(pointer, message_);
}


inline void CreateFrameParamsDataView::GetFrameTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->frame_token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetPreviousFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->previous_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetOpenerFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->opener_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetParentFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->parent_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetPreviousSiblingFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->previous_sibling_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetReplicationStateDataView(
    ::blink::mojom::FrameReplicationStateDataView* output) {
  auto pointer = data_->replication_state.Get();
  *output = ::blink::mojom::FrameReplicationStateDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetDevtoolsFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetFrameOwnerPropertiesDataView(
    ::blink::mojom::FrameOwnerPropertiesDataView* output) {
  auto pointer = data_->frame_owner_properties.Get();
  *output = ::blink::mojom::FrameOwnerPropertiesDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetWidgetParamsDataView(
    CreateFrameWidgetParamsDataView* output) {
  auto pointer = data_->widget_params.Get();
  *output = CreateFrameWidgetParamsDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetDocumentTokenDataView(
    ::blink::mojom::DocumentTokenDataView* output) {
  auto pointer = data_->document_token.Get();
  *output = ::blink::mojom::DocumentTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetPolicyContainerDataView(
    ::blink::mojom::PolicyContainerDataView* output) {
  auto pointer = data_->policy_container.Get();
  *output = ::blink::mojom::PolicyContainerDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetNavigationMetricsTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->navigation_metrics_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void SnapshotAccessibilityTreeParamsDataView::GetTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void CreateNewWindowParamsDataView::GetSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetCloneFromSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->clone_from_session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetFrameNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->frame_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetFormSubmissionPostDataDataView(
    ::network::mojom::URLRequestBodyDataView* output) {
  auto pointer = data_->form_submission_post_data.Get();
  *output = ::network::mojom::URLRequestBodyDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetFormSubmissionPostContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->form_submission_post_content_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetTargetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->target_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetFeaturesDataView(
    ::blink::mojom::WindowFeaturesDataView* output) {
  auto pointer = data_->features.Get();
  *output = ::blink::mojom::WindowFeaturesDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetImpressionDataView(
    ::blink::mojom::ImpressionDataView* output) {
  auto pointer = data_->impression.Get();
  *output = ::blink::mojom::ImpressionDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetDownloadPolicyDataView(
    ::blink::mojom::NavigationDownloadPolicyDataView* output) {
  auto pointer = data_->download_policy.Get();
  *output = ::blink::mojom::NavigationDownloadPolicyDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetPipOptionsDataView(
    ::blink::mojom::PictureInPictureWindowOptionsDataView* output) {
  auto pointer = data_->pip_options.Get();
  *output = ::blink::mojom::PictureInPictureWindowOptionsDataView(pointer, message_);
}


inline void CreateNewWindowReplyDataView::GetMainFrameTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->main_frame_token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetVisualPropertiesDataView(
    ::blink::mojom::VisualPropertiesDataView* output) {
  auto pointer = data_->visual_properties.Get();
  *output = ::blink::mojom::VisualPropertiesDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetClonedSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cloned_session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetDevtoolsMainFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_main_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetDocumentTokenDataView(
    ::blink::mojom::DocumentTokenDataView* output) {
  auto pointer = data_->document_token.Get();
  *output = ::blink::mojom::DocumentTokenDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetPolicyContainerDataView(
    ::blink::mojom::PolicyContainerDataView* output) {
  auto pointer = data_->policy_container.Get();
  *output = ::blink::mojom::PolicyContainerDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetBrowsingContextGroupTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->browsing_context_group_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetColorProviderColorsDataView(
    ::blink::mojom::ColorProviderColorMapsDataView* output) {
  auto pointer = data_->color_provider_colors.Get();
  *output = ::blink::mojom::ColorProviderColorMapsDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetWidgetScreenRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->widget_screen_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetWindowScreenRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->window_screen_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}


inline void CreateMainFrameUnionDataView::GetLocalParamsDataView(
    CreateLocalMainFrameParamsDataView* output) const {
  CHECK(is_local_params());
  *output = CreateLocalMainFrameParamsDataView(data_->data.f_local_params.Get(), message_);
}
inline void CreateMainFrameUnionDataView::GetProvisionalLocalParamsDataView(
    CreateProvisionalLocalMainFrameParamsDataView* output) const {
  CHECK(is_provisional_local_params());
  *output = CreateProvisionalLocalMainFrameParamsDataView(data_->data.f_provisional_local_params.Get(), message_);
}
inline void CreateMainFrameUnionDataView::GetRemoteParamsDataView(
    CreateRemoteMainFrameParamsDataView* output) const {
  CHECK(is_remote_params());
  *output = CreateRemoteMainFrameParamsDataView(data_->data.f_remote_params.Get(), message_);
}


}  // content::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::ViewWidgetType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::ViewWidgetType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::ChildFrameOwnerElementType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::ChildFrameOwnerElementType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::FrameDeleteIntention> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::FrameDeleteIntention value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::CreateNewWindowStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::CreateNewWindowStatus value);
};

} // namespace perfetto

#endif  // CONTENT_COMMON_FRAME_MOJOM_SHARED_H_