// content/common/download/mhtml_file_writer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SEND_VALIDATION_H_
#define CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SEND_VALIDATION_H_

#include "content/common/download/mhtml_file_writer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "content/common/download/mhtml_file_writer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::content::mojom::MhtmlSaveStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::SerializeAsMHTMLParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SerializeAsMHTMLParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SerializeAsMHTMLParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mhtml_boundary_marker(input)) in_mhtml_boundary_marker = Traits::mhtml_boundary_marker(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mhtml_boundary_marker)::BaseType> mhtml_boundary_marker_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mhtml_boundary_marker,
        mhtml_boundary_marker_fragment);

      fragment->mhtml_boundary_marker.Set(
          mhtml_boundary_marker_fragment.is_null() ? nullptr : mhtml_boundary_marker_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mhtml_boundary_marker.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mhtml_boundary_marker in SerializeAsMHTMLParams struct");

      fragment->mhtml_binary_encoding = Traits::mhtml_binary_encoding(input);

      fragment->mhtml_popup_overlay_removal = Traits::mhtml_popup_overlay_removal(input);

      decltype(Traits::digests_of_uris_to_skip(input)) in_digests_of_uris_to_skip = Traits::digests_of_uris_to_skip(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->digests_of_uris_to_skip)::BaseType>
          digests_of_uris_to_skip_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& digests_of_uris_to_skip_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>, send_validation>(
        in_digests_of_uris_to_skip,
        digests_of_uris_to_skip_fragment,
        &digests_of_uris_to_skip_validate_params);

      fragment->digests_of_uris_to_skip.Set(
          digests_of_uris_to_skip_fragment.is_null() ? nullptr : digests_of_uris_to_skip_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->digests_of_uris_to_skip.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null digests_of_uris_to_skip in SerializeAsMHTMLParams struct");

      decltype(Traits::salt(input)) in_salt = Traits::salt(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->salt)::BaseType> salt_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_salt,
        salt_fragment);

      fragment->salt.Set(
          salt_fragment.is_null() ? nullptr : salt_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->salt.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null salt in SerializeAsMHTMLParams struct");

      decltype(Traits::output_handle(input)) in_output_handle = Traits::output_handle(input);
      mojo::internal::MessageFragment<decltype(fragment->output_handle)>
          output_handle_fragment(fragment.message());
      output_handle_fragment.Claim(&fragment->output_handle);
      
      mojo::internal::Serialize<::content::mojom::MhtmlOutputHandleDataView, send_validation>(
        in_output_handle,
        output_handle_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->output_handle.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null output_handle in SerializeAsMHTMLParams struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::MhtmlOutputHandleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::content::mojom::MhtmlOutputHandleDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::content::mojom::internal::MhtmlOutputHandle_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::content::mojom::MhtmlOutputHandleDataView::Tag::kFileHandle: {
    decltype(Traits::file_handle(input))
    in_file_handle = Traits::file_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::FileDataView, send_validation>(
  in_file_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file_handle in MhtmlOutputHandle union");
    fragment->data.f_file_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::content::mojom::MhtmlOutputHandleDataView::Tag::kProducerHandle: {
    decltype(Traits::producer_handle(input))
    in_producer_handle = Traits::producer_handle(input);
        
mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle, send_validation>(
  in_producer_handle,
  &fragment->data.f_producer_handle,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_producer_handle)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null producer_handle in MhtmlOutputHandle union");
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SEND_VALIDATION_H_