// content/common/download/mhtml_file_writer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_DATA_VIEW_H_
#define CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "content/common/download/mhtml_file_writer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace content::mojom {
class SerializeAsMHTMLParamsDataView;

class MhtmlOutputHandleDataView;


}  // content::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::SerializeAsMHTMLParamsDataView> {
  using Data = ::content::mojom::internal::SerializeAsMHTMLParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::MhtmlOutputHandleDataView> {
  using Data = ::content::mojom::internal::MhtmlOutputHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {


enum class MhtmlSaveStatus : int32_t {
  
  kSuccess = 0,
  
  kFileClosingError = 1,
  
  kFileCreationError = 2,
  
  kFileWritingError = 3,
  
  kFrameNoLongerExists = 4,
  
  kDeprecatedFrameSerializationForbidden = 5,
  
  kRenderProcessExited = 6,
  
  kStreamingError = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, MhtmlSaveStatus value);
inline bool IsKnownEnumValue(MhtmlSaveStatus value) {
  return internal::MhtmlSaveStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MhtmlFileWriterInterfaceBase {};

using MhtmlFileWriterPtrDataView =
    mojo::InterfacePtrDataView<MhtmlFileWriterInterfaceBase>;
using MhtmlFileWriterRequestDataView =
    mojo::InterfaceRequestDataView<MhtmlFileWriterInterfaceBase>;
using MhtmlFileWriterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MhtmlFileWriterInterfaceBase>;
using MhtmlFileWriterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MhtmlFileWriterInterfaceBase>;


class SerializeAsMHTMLParamsDataView {
 public:
  SerializeAsMHTMLParamsDataView() = default;

  SerializeAsMHTMLParamsDataView(
      internal::SerializeAsMHTMLParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMhtmlBoundaryMarkerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMhtmlBoundaryMarker(UserType* output) {
    
    auto* pointer = data_->mhtml_boundary_marker.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool mhtml_binary_encoding() const {
    return data_->mhtml_binary_encoding;
  }
  bool mhtml_popup_overlay_removal() const {
    return data_->mhtml_popup_overlay_removal;
  }
  inline void GetDigestsOfUrisToSkipDataView(
      mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDigestsOfUrisToSkip(UserType* output) {
    
    auto* pointer = data_->digests_of_uris_to_skip.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
        pointer, output, message_);
  }
  inline void GetSaltDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSalt(UserType* output) {
    
    auto* pointer = data_->salt.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetOutputHandleDataView(
      MhtmlOutputHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputHandle(UserType* output) {
    
    auto* pointer = !data_->output_handle.is_null() ? &data_->output_handle : nullptr;
    return mojo::internal::Deserialize<::content::mojom::MhtmlOutputHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::SerializeAsMHTMLParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MhtmlOutputHandleDataView {
 public:
  using Tag = internal::MhtmlOutputHandle_Data::MhtmlOutputHandle_Tag;

  MhtmlOutputHandleDataView() = default;

  MhtmlOutputHandleDataView(
      internal::MhtmlOutputHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_file_handle() const { return data_->tag == Tag::kFileHandle; }
  inline void GetFileHandleDataView(
      ::mojo_base::mojom::FileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFileHandle(UserType* output) const {
    
    CHECK(is_file_handle());
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        data_->data.f_file_handle.Get(), output, message_);
  }
  bool is_producer_handle() const { return data_->tag == Tag::kProducerHandle; }
  mojo::ScopedDataPipeProducerHandle TakeProducerHandle() {
    CHECK(is_producer_handle());
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->data.f_producer_handle, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::MhtmlOutputHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // content::mojom

#endif  // CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_DATA_VIEW_H_