// content/common/dom_automation_controller.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOM_AUTOMATION_CONTROLLER_MOJOM_H_
#define CONTENT_COMMON_DOM_AUTOMATION_CONTROLLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/dom_automation_controller.mojom-features.h"  // IWYU pragma: export
#include "content/common/dom_automation_controller.mojom-shared.h"  // IWYU pragma: export
#include "content/common/dom_automation_controller.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class DomAutomationControllerHostProxy;

template <typename ImplRefTraits>
class DomAutomationControllerHostStub;

class DomAutomationControllerHostRequestValidator;


class CONTENT_EXPORT DomAutomationControllerHost
    : public DomAutomationControllerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.DomAutomationControllerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DomAutomationControllerHostInterfaceBase;
  using Proxy_ = DomAutomationControllerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = DomAutomationControllerHostStub<ImplRefTraits>;

  using RequestValidator_ = DomAutomationControllerHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDomOperationResponseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DomOperationResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DomAutomationControllerHost() = default;

  virtual void DomOperationResponse(const std::string& json_string) = 0;
};



class CONTENT_EXPORT DomAutomationControllerHostProxy
    : public DomAutomationControllerHost {
 public:
  using InterfaceType = DomAutomationControllerHost;

  explicit DomAutomationControllerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DomOperationResponse(const std::string& json_string) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT DomAutomationControllerHostStubDispatch {
 public:
  static bool Accept(DomAutomationControllerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DomAutomationControllerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DomAutomationControllerHost>>
class DomAutomationControllerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DomAutomationControllerHostStub() = default;
  ~DomAutomationControllerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomAutomationControllerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomAutomationControllerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT DomAutomationControllerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_DOM_AUTOMATION_CONTROLLER_MOJOM_H_