// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const kNtpToUnixTimeOffsetMs=-22089888e5;const CalculatorModifier=Object.freeze({kNone:Object.freeze({postfix:"",multiplier:1}),kMillisecondsFromSeconds:Object.freeze({postfix:"_in_ms",multiplier:1e3}),kBytesToBits:Object.freeze({bitrate:true,multiplier:8})});class Metric{constructor(name,value){this.name=name;this.value=value}toString(){return'{"'+this.name+'":"'+this.value+'"}'}}class CalculatedStats{constructor(id){this.id=id;this.calculatedMetricsByOriginalName=new Map}addCalculatedMetric(originalName,metric){let calculatedMetrics=this.calculatedMetricsByOriginalName.get(originalName);if(!calculatedMetrics){calculatedMetrics=[];this.calculatedMetricsByOriginalName.set(originalName,calculatedMetrics)}calculatedMetrics.push(metric)}getCalculatedMetrics(originalName){const calculatedMetrics=this.calculatedMetricsByOriginalName.get(originalName);if(!calculatedMetrics){return[]}return calculatedMetrics}toString(){let str='{id:"'+this.id+'"';for(const originalName of this.calculatedMetricsByOriginalName.keys()){const calculatedMetrics=this.calculatedMetricsByOriginalName.get(originalName);str+=","+originalName+":[";for(let i=0;i<calculatedMetrics.length;i++){str+=calculatedMetrics[i].toString();if(i+1<calculatedMetrics.length){str+=","}str+="]"}}str+="}";return str}}class DateCalculator{constructor(metric,timestampOffsetMs=0){this.metric=metric;this.timestampOffsetMs=timestampOffsetMs}getCalculatedMetricName(){return"["+this.metric+"]"}calculate(id,previousReport,currentReport){const timestamp=currentReport.get(id)[this.metric];const date=new Date(timestamp+this.timestampOffsetMs);return date.toLocaleString()}}class RateCalculator{constructor(accumulativeMetric,samplesMetric,modifier=CalculatorModifier.kNone){this.accumulativeMetric=accumulativeMetric;this.samplesMetric=samplesMetric;this.modifier=modifier}getCalculatedMetricName(){const accumulativeMetric=this.modifier.bitrate?this.accumulativeMetric+"_in_bits":this.accumulativeMetric;if(this.samplesMetric==="timestamp"){return"["+accumulativeMetric+"/s]"}return"["+accumulativeMetric+"/"+this.samplesMetric+this.modifier.postfix+"]"}calculate(id,previousReport,currentReport){return RateCalculator.calculateRate(id,previousReport,currentReport,this.accumulativeMetric,this.samplesMetric)*this.modifier.multiplier}static calculateRate(id,previousReport,currentReport,accumulativeMetric,samplesMetric){if(!previousReport||!currentReport){return undefined}const previousStats=previousReport.get(id);const currentStats=currentReport.get(id);if(!previousStats||!currentStats){return undefined}const deltaTime=currentStats.timestamp-previousStats.timestamp;if(deltaTime<=0){return undefined}const previousValue=Number(previousStats[accumulativeMetric]);const currentValue=Number(currentStats[accumulativeMetric]);if(typeof previousValue!=="number"||typeof currentValue!=="number"){return undefined}const previousSamples=Number(previousStats[samplesMetric]);const currentSamples=Number(currentStats[samplesMetric]);if(typeof previousSamples!=="number"||typeof currentSamples!=="number"){return undefined}const deltaValue=currentValue-previousValue;const deltaSamples=currentSamples-previousSamples;if(samplesMetric==="timestamp"){return 1e3*deltaValue/deltaSamples}return deltaValue/deltaSamples}}class CodecCalculator{getCalculatedMetricName(){return"[codec]"}calculate(id,previousReport,currentReport){const targetStats=currentReport.get(id);const codecStats=currentReport.get(targetStats.codecId);if(!codecStats){return undefined}const codec=codecStats.mimeType.substr(codecStats.mimeType.indexOf("/")+1);let fmtpLine="";if(codecStats.sdpFmtpLine){fmtpLine=", "+codecStats.sdpFmtpLine}return codec+" ("+codecStats.payloadType+fmtpLine+")"}}class AudioLevelRmsCalculator{getCalculatedMetricName(){return"[Audio_Level_in_RMS]"}calculate(id,previousReport,currentReport){const averageAudioLevelSquared=RateCalculator.calculateRate(id,previousReport,currentReport,"totalAudioEnergy","totalSamplesDuration");return Math.sqrt(averageAudioLevelSquared)}}class DifferenceCalculator{constructor(metricA,...otherMetrics){this.metricA=metricA;this.otherMetrics=otherMetrics}getCalculatedMetricName(){return"["+this.metricA+"-"+this.otherMetrics.join("-")+"]"}calculate(id,previousReport,currentReport){const currentStats=currentReport.get(id);return currentStats[this.metricA]-this.otherMetrics.map((metric=>currentStats[metric])).reduce(((a,b)=>a+b),0)}}class StandardDeviationCalculator{constructor(totalSquaredSumMetric,totalSumMetric,totalCount,label){this.totalSquaredSumMetric=totalSquaredSumMetric;this.totalSumMetric=totalSumMetric;this.totalCount=totalCount;this.label=label}getCalculatedMetricName(){return"["+this.label+"StDev_in_ms]"}calculate(id,previousReport,currentReport){return StandardDeviationCalculator.calculateStandardDeviation(id,previousReport,currentReport,this.totalSquaredSumMetric,this.totalSumMetric,this.totalCount)}static calculateStandardDeviation(id,previousReport,currentReport,totalSquaredSumMetric,totalSumMetric,totalCount){if(!previousReport||!currentReport){return undefined}const previousStats=previousReport.get(id);const currentStats=currentReport.get(id);if(!previousStats||!currentStats){return undefined}const deltaCount=Number(currentStats[totalCount])-Number(previousStats[totalCount]);if(deltaCount<=0){return undefined}const previousSquaredSumValue=Number(previousStats[totalSquaredSumMetric]);const currentSquaredSumValue=Number(currentStats[totalSquaredSumMetric]);if(typeof previousSquaredSumValue!=="number"||typeof currentSquaredSumValue!=="number"){return undefined}const previousSumValue=Number(previousStats[totalSumMetric]);const currentSumValue=Number(currentStats[totalSumMetric]);if(typeof previousSumValue!=="number"||typeof currentSumValue!=="number"){return undefined}const deltaSquaredSum=currentSquaredSumValue-previousSquaredSumValue;const deltaSum=currentSumValue-previousSumValue;const variance=(deltaSquaredSum-Math.pow(deltaSum,2)/deltaCount)/deltaCount;if(variance<0){return undefined}return 1e3*Math.sqrt(variance)}}class PsnrRateCalculator{constructor(component){this.component_=component}getCalculatedMetricName(){return"[PSNR_"+this.component_+"]"}calculate(id,previousReport,currentReport){if(!previousReport||!currentReport){return undefined}const previousStats=previousReport.get(id);const currentStats=currentReport.get(id);if(!previousStats||!currentStats){return undefined}const deltaTime=currentStats.timestamp-previousStats.timestamp;if(deltaTime<=0){return undefined}const previousSamples=Number(previousStats["psnrMeasurements"]);const currentSamples=Number(currentStats["psnrMeasurements"]);if(typeof previousSamples!=="number"||typeof currentSamples!=="number"){return undefined}if(previousSamples==currentSamples){return undefined}let previousValue=previousStats["psnrSum"];let currentValue=currentStats["psnrSum"];if(typeof previousValue!=="string"||typeof currentValue!=="string"){return undefined}try{previousValue=JSON.parse(previousValue);currentValue=JSON.parse(currentValue)}catch(e){return undefined}return(currentValue[this.component_]-previousValue[this.component_])/(currentSamples-previousSamples)}}export class StatsRatesCalculator{constructor(){this.previousReport=null;this.currentReport=null;this.statsCalculators={"data-channel":{messagesSent:new RateCalculator("messagesSent","timestamp"),messagesReceived:new RateCalculator("messagesReceived","timestamp"),bytesSent:new RateCalculator("bytesSent","timestamp",CalculatorModifier.kBytesToBits),bytesReceived:new RateCalculator("bytesReceived","timestamp",CalculatorModifier.kBytesToBits)},"media-source":{totalAudioEnergy:new AudioLevelRmsCalculator},"media-playout":{totalPlayoutDelay:new RateCalculator("totalPlayoutDelay","totalSamplesCount")},"outbound-rtp":{bytesSent:new RateCalculator("bytesSent","timestamp",CalculatorModifier.kBytesToBits),headerBytesSent:new RateCalculator("headerBytesSent","timestamp",CalculatorModifier.kBytesToBits),retransmittedBytesSent:new RateCalculator("retransmittedBytesSent","timestamp",CalculatorModifier.kBytesToBits),packetsSent:new RateCalculator("packetsSent","timestamp"),packetsSentWithEct1:new RateCalculator("packetsSentWithEct1","timestamp"),retransmittedPacketsSent:new RateCalculator("retransmittedPacketsSent","timestamp"),totalPacketSendDelay:new RateCalculator("totalPacketSendDelay","packetsSent",CalculatorModifier.kMillisecondsFromSeconds),framesEncoded:new RateCalculator("framesEncoded","timestamp"),framesSent:new RateCalculator("framesSent","timestamp"),totalEncodedBytesTarget:new RateCalculator("totalEncodedBytesTarget","timestamp",CalculatorModifier.kBytesToBits),totalEncodeTime:new RateCalculator("totalEncodeTime","framesEncoded",CalculatorModifier.kMillisecondsFromSeconds),qpSum:new RateCalculator("qpSum","framesEncoded"),psnrSum:[new PsnrRateCalculator("y"),new PsnrRateCalculator("u"),new PsnrRateCalculator("v")],codecId:new CodecCalculator},"inbound-rtp":{bytesReceived:new RateCalculator("bytesReceived","timestamp",CalculatorModifier.kBytesToBits),headerBytesReceived:new RateCalculator("headerBytesReceived","timestamp",CalculatorModifier.kBytesToBits),retransmittedBytesReceived:new RateCalculator("retransmittedBytesReceived","timestamp",CalculatorModifier.kBytesToBits),fecBytesReceived:new RateCalculator("fecBytesReceived","timestamp",CalculatorModifier.kBytesToBits),packetsReceived:new RateCalculator("packetsReceived","timestamp"),packetsReceivedWithEct1:new RateCalculator("packetsReceivedWithEct1","timestamp"),packetsReceivedWithCe:new RateCalculator("packetsReceivedWithCe","timestamp"),packetsReportedAsLost:new RateCalculator("packetsReportedAsLost","timestamp"),packetsReportedAsLostButRecovered:new RateCalculator("packetsReportedAsLostButRecovered","timestamp"),packetsDiscarded:new RateCalculator("packetsDiscarded","timestamp"),retransmittedPacketsReceived:new RateCalculator("retransmittedPacketsReceived","timestamp"),fecPacketsReceived:new RateCalculator("fecPacketsReceived","timestamp"),fecPacketsDiscarded:new RateCalculator("fecPacketsDiscarded","timestamp"),framesReceived:[new RateCalculator("framesReceived","timestamp"),new DifferenceCalculator("framesReceived","framesDecoded","framesDropped")],framesDecoded:new RateCalculator("framesDecoded","timestamp"),keyFramesDecoded:new RateCalculator("keyFramesDecoded","timestamp"),totalDecodeTime:new RateCalculator("totalDecodeTime","framesDecoded",CalculatorModifier.kMillisecondsFromSeconds),totalInterFrameDelay:new RateCalculator("totalInterFrameDelay","framesDecoded",CalculatorModifier.kMillisecondsFromSeconds),totalSquaredInterFrameDelay:new StandardDeviationCalculator("totalSquaredInterFrameDelay","totalInterFrameDelay","framesDecoded","interFrameDelay"),totalSamplesReceived:new RateCalculator("totalSamplesReceived","timestamp"),concealedSamples:[new RateCalculator("concealedSamples","timestamp"),new RateCalculator("concealedSamples","totalSamplesReceived")],silentConcealedSamples:new RateCalculator("silentConcealedSamples","timestamp"),insertedSamplesForDeceleration:new RateCalculator("insertedSamplesForDeceleration","timestamp"),removedSamplesForAcceleration:new RateCalculator("removedSamplesForAcceleration","timestamp"),qpSum:new RateCalculator("qpSum","framesDecoded"),totalCorruptionProbability:new RateCalculator("totalCorruptionProbability","corruptionMeasurements"),codecId:new CodecCalculator,totalAudioEnergy:new AudioLevelRmsCalculator,jitterBufferDelay:new RateCalculator("jitterBufferDelay","jitterBufferEmittedCount",CalculatorModifier.kMillisecondsFromSeconds),jitterBufferTargetDelay:new RateCalculator("jitterBufferTargetDelay","jitterBufferEmittedCount",CalculatorModifier.kMillisecondsFromSeconds),jitterBufferMinimumDelay:new RateCalculator("jitterBufferMinimumDelay","jitterBufferEmittedCount",CalculatorModifier.kMillisecondsFromSeconds),lastPacketReceivedTimestamp:new DateCalculator("lastPacketReceivedTimestamp"),estimatedPlayoutTimestamp:new DateCalculator("estimatedPlayoutTimestamp",kNtpToUnixTimeOffsetMs),totalProcessingDelay:new RateCalculator("totalProcessingDelay","jitterBufferEmittedCount",CalculatorModifier.kMillisecondsFromSeconds),totalAssemblyTime:new RateCalculator("totalAssemblyTime","framesAssembledFromMultiplePackets",CalculatorModifier.kMillisecondsFromSeconds)},"remote-inbound-rtp":{totalRoundTripTime:new RateCalculator("totalRoundTripTime","roundTripTimeMeasurements"),packetsReceivedWithEct1:new RateCalculator("packetsReceivedWithEct1","timestamp"),packetsReceivedWithCe:new RateCalculator("packetsReceivedWithCe","timestamp"),packetsReportedAsLost:new RateCalculator("packetsReportedAsLost","timestamp"),packetsReportedAsLostButRecovered:new RateCalculator("packetsReportedAsLostButRecovered","timestamp"),packetsWithBleachedEct1Marking:new RateCalculator("packetsWithBleachedEct1Marking","timestamp")},"remote-outbound-rtp":{remoteTimestamp:new DateCalculator("remoteTimestamp"),totalRoundTripTime:new RateCalculator("totalRoundTripTime","roundTripTimeMeasurements")},transport:{bytesSent:new RateCalculator("bytesSent","timestamp",CalculatorModifier.kBytesToBits),bytesReceived:new RateCalculator("bytesReceived","timestamp",CalculatorModifier.kBytesToBits),packetsSent:new RateCalculator("packetsSent","timestamp"),packetsReceived:new RateCalculator("packetsReceived","timestamp"),ccfbMessagesSent:new RateCalculator("ccfbMessagesSent","timestamp"),ccfbMessagesReceived:new RateCalculator("ccfbMessagesReceived","timestamp")},"candidate-pair":{bytesSent:new RateCalculator("bytesSent","timestamp",CalculatorModifier.kBytesToBits),bytesReceived:new RateCalculator("bytesReceived","timestamp",CalculatorModifier.kBytesToBits),packetsSent:new RateCalculator("packetsSent","timestamp"),packetsReceived:new RateCalculator("packetsReceived","timestamp"),totalRoundTripTime:new RateCalculator("totalRoundTripTime","responsesReceived"),lastPacketReceivedTimestamp:new DateCalculator("lastPacketReceivedTimestamp"),lastPacketSentTimestamp:new DateCalculator("lastPacketSentTimestamp")}}}addStatsReport(report){this.previousReport=this.currentReport;this.currentReport=report;this.updateCalculatedMetrics_()}updateCalculatedMetrics_(){Object.keys(this.statsCalculators).forEach((statsType=>{this.currentReport.forEach((stats=>{if(stats.type!==statsType)return;Object.keys(this.statsCalculators[statsType]).forEach((originalMetric=>{let metricCalculators=this.statsCalculators[statsType][originalMetric];if(!Array.isArray(metricCalculators)){metricCalculators=[metricCalculators]}metricCalculators.forEach((metricCalculator=>{const name=metricCalculator.getCalculatedMetricName();const result=metricCalculator.calculate(stats.id,this.previousReport,this.currentReport);if(result!==undefined&&(typeof result!=="number"||!isNaN(result))){this.currentReport.get(stats.id)[name]=result}}))}))}))}))}}