// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";function appendChildWithText(parent,tag,text){const child=document.createElement(tag);child.textContent=text;parent.appendChild(child);return child}export function createIceCandidateGrid(peerConnectionElement){const container=document.createElement("details");appendChildWithText(container,"summary","ICE candidate grid");const table=document.createElement("table");table.id="grid-"+peerConnectionElement.id;table.className="candidategrid";container.appendChild(table);const tableHeader=document.createElement("tr");table.append(tableHeader);appendChildWithText(tableHeader,"th","Candidate (pair) id");appendChildWithText(tableHeader,"th","State / Candidate type");appendChildWithText(tableHeader,"th","Network type / address");appendChildWithText(tableHeader,"th","Port");appendChildWithText(tableHeader,"th","Protocol / candidate type");appendChildWithText(tableHeader,"th","(Pair) Priority");appendChildWithText(tableHeader,"th","Bytes sent / received");appendChildWithText(tableHeader,"th","STUN requests sent / responses received");appendChildWithText(tableHeader,"th","STUN requests received / responses sent");appendChildWithText(tableHeader,"th","RTT");appendChildWithText(tableHeader,"th","Last data sent / received");appendChildWithText(tableHeader,"th","Last update");peerConnectionElement.appendChild(container)}function findOrCreateGridRow(peerConnectionElementId,statId,type){const elementId="grid-"+peerConnectionElementId+"-"+statId+"-"+type;let row=document.getElementById(elementId);if(!row){row=document.createElement("tr");row.id=elementId;for(let i=0;i<12;i++){row.appendChild(document.createElement("td"))}$("grid-"+peerConnectionElementId).appendChild(row)}return row}function appendRow(peerConnectionElement,active,candidatePair,stats){const pairRow=findOrCreateGridRow(peerConnectionElement.id,candidatePair.id,"candidatepair");pairRow.classList.add("candidategrid-candidatepair");if(active){pairRow.classList.add("candidategrid-active")}pairRow.children[0].innerText=candidatePair.id;pairRow.children[1].innerText=candidatePair.state;pairRow.children[5].innerText="0x"+parseInt(candidatePair.priority,10).toString(16);pairRow.children[6].innerText=candidatePair.bytesSent+" / "+candidatePair.bytesReceived;pairRow.children[7].innerText=candidatePair.requestsSent+" / "+candidatePair.responsesReceived;pairRow.children[8].innerText=candidatePair.requestsReceived+" / "+candidatePair.responsesSent;pairRow.children[9].innerText=candidatePair.currentRoundTripTime!==undefined?candidatePair.currentRoundTripTime+"s":"";if(candidatePair.lastPacketSentTimestamp){pairRow.children[10].innerText=new Date(candidatePair.lastPacketSentTimestamp).toLocaleTimeString()+" / "+new Date(candidatePair.lastPacketReceivedTimestamp).toLocaleTimeString()}pairRow.children[11].innerText=(new Date).toLocaleTimeString();const localRow=findOrCreateGridRow(peerConnectionElement.id,candidatePair.id,"local");localRow.className="candidategrid-candidate";const localCandidate=stats.get(candidatePair.localCandidateId);["id","type","address","port","candidateType","priority"].forEach(((stat,index)=>{if(stat=="candidateType"&&localCandidate.relayProtocol){localRow.children[index].innerText=localCandidate[stat]+"("+localCandidate.relayProtocol+")";if(localCandidate.url){localRow.children[index].innerText+="\n"+localCandidate.url}}else if(stat==="priority"){const priority=parseInt(localCandidate[stat],10)&4294967295;localRow.children[index].innerText="0x"+priority.toString(16)+"\n"+(priority>>24)+" | "+(priority>>8&65535)+" | "+(priority&255)}else if(stat==="address"){localRow.children[index].innerText=localCandidate[stat]||"(not set)"}else{localRow.children[index].innerText=localCandidate[stat]}}));pairRow.children[2].innerText=localCandidate.networkType;if(localCandidate["vpn"]===true){pairRow.children[2].innerText+=" (VPN)"}pairRow.children[4].innerText=localCandidate.protocol;if(localCandidate.tcpType){pairRow.children[4].innerText+=" "+localCandidate.tcpType}const remoteRow=findOrCreateGridRow(peerConnectionElement.id,candidatePair.id,"remote");remoteRow.className="candidategrid-candidate";const remoteCandidate=stats.get(candidatePair.remoteCandidateId);["id","type","address","port","candidateType","priority"].forEach(((stat,index)=>{if(stat==="priority"){remoteRow.children[index].innerText="0x"+parseInt(remoteCandidate[stat],10).toString(16)}else if(stat==="address"){remoteRow.children[index].innerText=remoteCandidate[stat]||"(not set)"}else{remoteRow.children[index].innerText=remoteCandidate[stat]}}));return pairRow}export function updateIceCandidateGrid(peerConnectionElement,stats){const container=$("grid-"+peerConnectionElement.id);container.childNodes.forEach((row=>{row.classList.remove("candidategrid-active")}));let activePairIds=[];stats.forEach((transportReport=>{if(transportReport.type!=="transport"){return}if(!transportReport.selectedCandidatePairId){return}activePairIds.push(transportReport.selectedCandidatePairId);appendRow(peerConnectionElement,true,stats.get(transportReport.selectedCandidatePairId),stats)}));stats.forEach((report=>{if(report.type!=="candidate-pair"||activePairIds.includes(report.id)){return}appendRow(peerConnectionElement,false,report,stats)}))}