// content/browser/tracing/traces_internals/traces_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/browser/tracing/traces_internals/traces_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/tracing/traces_internals/traces_internals.mojom-params-data.h"
#include "content/browser/tracing/traces_internals/traces_internals.mojom-shared-message-ids.h"

#include "content/browser/tracing/traces_internals/traces_internals.mojom-import-headers.h"
#include "content/browser/tracing/traces_internals/traces_internals.mojom-test-utils.h"


namespace traces_internals::mojom {
ClientTraceReport::ClientTraceReport()
    : uuid(),
      creation_time(),
      scenario_name(),
      upload_rule_name(),
      upload_rule_value(),
      total_size(),
      upload_state(),
      upload_time(),
      skip_reason(),
      has_trace_content() {}

ClientTraceReport::ClientTraceReport(
    const ::base::Token& uuid_in,
    ::base::Time creation_time_in,
    const std::string& scenario_name_in,
    const std::string& upload_rule_name_in,
    std::optional<int32_t> upload_rule_value_in,
    int64_t total_size_in,
    ::content::ReportUploadState upload_state_in,
    ::base::Time upload_time_in,
    ::content::SkipUploadReason skip_reason_in,
    bool has_trace_content_in)
    : uuid(std::move(uuid_in)),
      creation_time(std::move(creation_time_in)),
      scenario_name(std::move(scenario_name_in)),
      upload_rule_name(std::move(upload_rule_name_in)),
      upload_rule_value(std::move(upload_rule_value_in)),
      total_size(std::move(total_size_in)),
      upload_state(std::move(upload_state_in)),
      upload_time(std::move(upload_time_in)),
      skip_reason(std::move(skip_reason_in)),
      has_trace_content(std::move(has_trace_content_in)) {}

ClientTraceReport::~ClientTraceReport() = default;

void ClientTraceReport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation_time"), this->creation_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scenario_name"), this->scenario_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_rule_name"), this->upload_rule_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_rule_value"), this->upload_rule_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_size"), this->total_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_state"), this->upload_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::content::ReportUploadState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_time"), this->upload_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_reason"), this->skip_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::content::SkipUploadReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_trace_content"), this->has_trace_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClientTraceReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Scenario::Scenario()
    : scenario_name(),
      description(),
      is_local_scenario(),
      is_enabled(),
      current_state() {}

Scenario::Scenario(
    const std::string& scenario_name_in,
    const std::string& description_in,
    bool is_local_scenario_in,
    bool is_enabled_in,
    ::content::TracingScenario::State current_state_in)
    : scenario_name(std::move(scenario_name_in)),
      description(std::move(description_in)),
      is_local_scenario(std::move(is_local_scenario_in)),
      is_enabled(std::move(is_enabled_in)),
      current_state(std::move(current_state_in)) {}

Scenario::~Scenario() = default;

void Scenario::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scenario_name"), this->scenario_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_local_scenario"), this->is_local_scenario,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_enabled"), this->is_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_state"), this->current_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::content::TracingScenario::State>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Scenario::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TraceCategory::TraceCategory()
    : name(),
      is_group(),
      description(),
      tags() {}

TraceCategory::TraceCategory(
    const std::string& name_in,
    bool is_group_in,
    const std::string& description_in,
    std::vector<std::string> tags_in)
    : name(std::move(name_in)),
      is_group(std::move(is_group_in)),
      description(std::move(description_in)),
      tags(std::move(tags_in)) {}

TraceCategory::~TraceCategory() = default;

void TraceCategory::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_group"), this->is_group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tags"), this->tags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TraceCategory::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

TracesInternalsHandlerFactory::IPCStableHashFunction TracesInternalsHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TracesInternalsHandlerFactory>(message.name())) {
    case messages::TracesInternalsHandlerFactory::kCreatePageHandler: {
      return &TracesInternalsHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TracesInternalsHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TracesInternalsHandlerFactory>(message.name())) {
      case messages::TracesInternalsHandlerFactory::kCreatePageHandler:
            return "Receive traces_internals::mojom::TracesInternalsHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::TracesInternalsHandlerFactory>(message.name())) {
      case messages::TracesInternalsHandlerFactory::kCreatePageHandler:
            return "Receive reply traces_internals::mojom::TracesInternalsHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TracesInternalsHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x393c1104;  // IPCStableHash for traces_internals::mojom::TracesInternalsHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TracesInternalsHandlerFactoryProxy::TracesInternalsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TracesInternalsHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::TracesInternalsHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TracesInternalsHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::TracesInternalsHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::traces_internals::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in TracesInternalsHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::traces_internals::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in TracesInternalsHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracesInternalsHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TracesInternalsHandlerFactoryStubDispatch::Accept(
    TracesInternalsHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TracesInternalsHandlerFactory>(message->header()->name)) {
    case messages::TracesInternalsHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::TracesInternalsHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::TracesInternalsHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TracesInternalsHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      TracesInternalsHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracesInternalsHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool TracesInternalsHandlerFactoryStubDispatch::AcceptWithResponder(
    TracesInternalsHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TracesInternalsHandlerFactory>(message->header()->name)) {
    case messages::TracesInternalsHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTracesInternalsHandlerFactoryValidationInfo[] = {
    { &internal::TracesInternalsHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool TracesInternalsHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::traces_internals::mojom::TracesInternalsHandlerFactory::Name_,
    kTracesInternalsHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kStartTraceSession: {
      return &PageHandler::StartTraceSession_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCloneTraceSession: {
      return &PageHandler::CloneTraceSession_Sym::IPCStableHash;
    }
    case messages::PageHandler::kStopTraceSession: {
      return &PageHandler::StopTraceSession_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTrackEventCategories: {
      return &PageHandler::GetTrackEventCategories_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetBufferUsage: {
      return &PageHandler::GetBufferUsage_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetAllTraceReports: {
      return &PageHandler::GetAllTraceReports_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeleteSingleTrace: {
      return &PageHandler::DeleteSingleTrace_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeleteAllTraces: {
      return &PageHandler::DeleteAllTraces_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUserUploadSingleTrace: {
      return &PageHandler::UserUploadSingleTrace_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDownloadTrace: {
      return &PageHandler::DownloadTrace_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetAllScenarios: {
      return &PageHandler::GetAllScenarios_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetEnabledScenarios: {
      return &PageHandler::SetEnabledScenarios_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetScenariosConfigFromString: {
      return &PageHandler::SetScenariosConfigFromString_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetScenariosConfigFromBuffer: {
      return &PageHandler::SetScenariosConfigFromBuffer_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetPrivacyFilterEnabled: {
      return &PageHandler::GetPrivacyFilterEnabled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetPrivacyFilterEnabled: {
      return &PageHandler::SetPrivacyFilterEnabled_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kStartTraceSession:
            return "Receive traces_internals::mojom::PageHandler::StartTraceSession";
      case messages::PageHandler::kCloneTraceSession:
            return "Receive traces_internals::mojom::PageHandler::CloneTraceSession";
      case messages::PageHandler::kStopTraceSession:
            return "Receive traces_internals::mojom::PageHandler::StopTraceSession";
      case messages::PageHandler::kGetTrackEventCategories:
            return "Receive traces_internals::mojom::PageHandler::GetTrackEventCategories";
      case messages::PageHandler::kGetBufferUsage:
            return "Receive traces_internals::mojom::PageHandler::GetBufferUsage";
      case messages::PageHandler::kGetAllTraceReports:
            return "Receive traces_internals::mojom::PageHandler::GetAllTraceReports";
      case messages::PageHandler::kDeleteSingleTrace:
            return "Receive traces_internals::mojom::PageHandler::DeleteSingleTrace";
      case messages::PageHandler::kDeleteAllTraces:
            return "Receive traces_internals::mojom::PageHandler::DeleteAllTraces";
      case messages::PageHandler::kUserUploadSingleTrace:
            return "Receive traces_internals::mojom::PageHandler::UserUploadSingleTrace";
      case messages::PageHandler::kDownloadTrace:
            return "Receive traces_internals::mojom::PageHandler::DownloadTrace";
      case messages::PageHandler::kGetAllScenarios:
            return "Receive traces_internals::mojom::PageHandler::GetAllScenarios";
      case messages::PageHandler::kSetEnabledScenarios:
            return "Receive traces_internals::mojom::PageHandler::SetEnabledScenarios";
      case messages::PageHandler::kSetScenariosConfigFromString:
            return "Receive traces_internals::mojom::PageHandler::SetScenariosConfigFromString";
      case messages::PageHandler::kSetScenariosConfigFromBuffer:
            return "Receive traces_internals::mojom::PageHandler::SetScenariosConfigFromBuffer";
      case messages::PageHandler::kGetPrivacyFilterEnabled:
            return "Receive traces_internals::mojom::PageHandler::GetPrivacyFilterEnabled";
      case messages::PageHandler::kSetPrivacyFilterEnabled:
            return "Receive traces_internals::mojom::PageHandler::SetPrivacyFilterEnabled";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kStartTraceSession:
            return "Receive reply traces_internals::mojom::PageHandler::StartTraceSession";
      case messages::PageHandler::kCloneTraceSession:
            return "Receive reply traces_internals::mojom::PageHandler::CloneTraceSession";
      case messages::PageHandler::kStopTraceSession:
            return "Receive reply traces_internals::mojom::PageHandler::StopTraceSession";
      case messages::PageHandler::kGetTrackEventCategories:
            return "Receive reply traces_internals::mojom::PageHandler::GetTrackEventCategories";
      case messages::PageHandler::kGetBufferUsage:
            return "Receive reply traces_internals::mojom::PageHandler::GetBufferUsage";
      case messages::PageHandler::kGetAllTraceReports:
            return "Receive reply traces_internals::mojom::PageHandler::GetAllTraceReports";
      case messages::PageHandler::kDeleteSingleTrace:
            return "Receive reply traces_internals::mojom::PageHandler::DeleteSingleTrace";
      case messages::PageHandler::kDeleteAllTraces:
            return "Receive reply traces_internals::mojom::PageHandler::DeleteAllTraces";
      case messages::PageHandler::kUserUploadSingleTrace:
            return "Receive reply traces_internals::mojom::PageHandler::UserUploadSingleTrace";
      case messages::PageHandler::kDownloadTrace:
            return "Receive reply traces_internals::mojom::PageHandler::DownloadTrace";
      case messages::PageHandler::kGetAllScenarios:
            return "Receive reply traces_internals::mojom::PageHandler::GetAllScenarios";
      case messages::PageHandler::kSetEnabledScenarios:
            return "Receive reply traces_internals::mojom::PageHandler::SetEnabledScenarios";
      case messages::PageHandler::kSetScenariosConfigFromString:
            return "Receive reply traces_internals::mojom::PageHandler::SetScenariosConfigFromString";
      case messages::PageHandler::kSetScenariosConfigFromBuffer:
            return "Receive reply traces_internals::mojom::PageHandler::SetScenariosConfigFromBuffer";
      case messages::PageHandler::kGetPrivacyFilterEnabled:
            return "Receive reply traces_internals::mojom::PageHandler::GetPrivacyFilterEnabled";
      case messages::PageHandler::kSetPrivacyFilterEnabled:
            return "Receive reply traces_internals::mojom::PageHandler::SetPrivacyFilterEnabled";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::StartTraceSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe4e37543;  // IPCStableHash for traces_internals::mojom::PageHandler::StartTraceSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::CloneTraceSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x37a56f56;  // IPCStableHash for traces_internals::mojom::PageHandler::CloneTraceSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::StopTraceSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5736b8f;  // IPCStableHash for traces_internals::mojom::PageHandler::StopTraceSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTrackEventCategories_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x184fb842;  // IPCStableHash for traces_internals::mojom::PageHandler::GetTrackEventCategories
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetBufferUsage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x314dd513;  // IPCStableHash for traces_internals::mojom::PageHandler::GetBufferUsage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetAllTraceReports_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd104cecb;  // IPCStableHash for traces_internals::mojom::PageHandler::GetAllTraceReports
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeleteSingleTrace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x994d1c25;  // IPCStableHash for traces_internals::mojom::PageHandler::DeleteSingleTrace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeleteAllTraces_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7708fca4;  // IPCStableHash for traces_internals::mojom::PageHandler::DeleteAllTraces
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UserUploadSingleTrace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb798d05c;  // IPCStableHash for traces_internals::mojom::PageHandler::UserUploadSingleTrace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DownloadTrace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41783c02;  // IPCStableHash for traces_internals::mojom::PageHandler::DownloadTrace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetAllScenarios_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7c224b67;  // IPCStableHash for traces_internals::mojom::PageHandler::GetAllScenarios
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetEnabledScenarios_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13889d73;  // IPCStableHash for traces_internals::mojom::PageHandler::SetEnabledScenarios
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetScenariosConfigFromString_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a5b4235;  // IPCStableHash for traces_internals::mojom::PageHandler::SetScenariosConfigFromString
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetScenariosConfigFromBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x55922ae5;  // IPCStableHash for traces_internals::mojom::PageHandler::SetScenariosConfigFromBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetPrivacyFilterEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee0371f5;  // IPCStableHash for traces_internals::mojom::PageHandler::GetPrivacyFilterEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetPrivacyFilterEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9822dabf;  // IPCStableHash for traces_internals::mojom::PageHandler::SetPrivacyFilterEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_StartTraceSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_StartTraceSession_ForwardToCallback(
      PageHandler::StartTraceSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_StartTraceSession_ForwardToCallback(const PageHandler_StartTraceSession_ForwardToCallback&) = delete;
  PageHandler_StartTraceSession_ForwardToCallback& operator=(const PageHandler_StartTraceSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::StartTraceSessionCallback callback_;
};

class PageHandler_CloneTraceSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_CloneTraceSession_ForwardToCallback(
      PageHandler::CloneTraceSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_CloneTraceSession_ForwardToCallback(const PageHandler_CloneTraceSession_ForwardToCallback&) = delete;
  PageHandler_CloneTraceSession_ForwardToCallback& operator=(const PageHandler_CloneTraceSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::CloneTraceSessionCallback callback_;
};

class PageHandler_StopTraceSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_StopTraceSession_ForwardToCallback(
      PageHandler::StopTraceSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_StopTraceSession_ForwardToCallback(const PageHandler_StopTraceSession_ForwardToCallback&) = delete;
  PageHandler_StopTraceSession_ForwardToCallback& operator=(const PageHandler_StopTraceSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::StopTraceSessionCallback callback_;
};

class PageHandler_GetTrackEventCategories_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTrackEventCategories_ForwardToCallback(
      PageHandler::GetTrackEventCategoriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTrackEventCategories_ForwardToCallback(const PageHandler_GetTrackEventCategories_ForwardToCallback&) = delete;
  PageHandler_GetTrackEventCategories_ForwardToCallback& operator=(const PageHandler_GetTrackEventCategories_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTrackEventCategoriesCallback callback_;
};

class PageHandler_GetBufferUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetBufferUsage_ForwardToCallback(
      PageHandler::GetBufferUsageCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetBufferUsage_ForwardToCallback(const PageHandler_GetBufferUsage_ForwardToCallback&) = delete;
  PageHandler_GetBufferUsage_ForwardToCallback& operator=(const PageHandler_GetBufferUsage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetBufferUsageCallback callback_;
};

class PageHandler_GetAllTraceReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetAllTraceReports_ForwardToCallback(
      PageHandler::GetAllTraceReportsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetAllTraceReports_ForwardToCallback(const PageHandler_GetAllTraceReports_ForwardToCallback&) = delete;
  PageHandler_GetAllTraceReports_ForwardToCallback& operator=(const PageHandler_GetAllTraceReports_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAllTraceReportsCallback callback_;
};

class PageHandler_DeleteSingleTrace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_DeleteSingleTrace_ForwardToCallback(
      PageHandler::DeleteSingleTraceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_DeleteSingleTrace_ForwardToCallback(const PageHandler_DeleteSingleTrace_ForwardToCallback&) = delete;
  PageHandler_DeleteSingleTrace_ForwardToCallback& operator=(const PageHandler_DeleteSingleTrace_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::DeleteSingleTraceCallback callback_;
};

class PageHandler_DeleteAllTraces_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_DeleteAllTraces_ForwardToCallback(
      PageHandler::DeleteAllTracesCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_DeleteAllTraces_ForwardToCallback(const PageHandler_DeleteAllTraces_ForwardToCallback&) = delete;
  PageHandler_DeleteAllTraces_ForwardToCallback& operator=(const PageHandler_DeleteAllTraces_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::DeleteAllTracesCallback callback_;
};

class PageHandler_UserUploadSingleTrace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_UserUploadSingleTrace_ForwardToCallback(
      PageHandler::UserUploadSingleTraceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_UserUploadSingleTrace_ForwardToCallback(const PageHandler_UserUploadSingleTrace_ForwardToCallback&) = delete;
  PageHandler_UserUploadSingleTrace_ForwardToCallback& operator=(const PageHandler_UserUploadSingleTrace_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::UserUploadSingleTraceCallback callback_;
};

class PageHandler_DownloadTrace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_DownloadTrace_ForwardToCallback(
      PageHandler::DownloadTraceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_DownloadTrace_ForwardToCallback(const PageHandler_DownloadTrace_ForwardToCallback&) = delete;
  PageHandler_DownloadTrace_ForwardToCallback& operator=(const PageHandler_DownloadTrace_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::DownloadTraceCallback callback_;
};

class PageHandler_GetAllScenarios_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetAllScenarios_ForwardToCallback(
      PageHandler::GetAllScenariosCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetAllScenarios_ForwardToCallback(const PageHandler_GetAllScenarios_ForwardToCallback&) = delete;
  PageHandler_GetAllScenarios_ForwardToCallback& operator=(const PageHandler_GetAllScenarios_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAllScenariosCallback callback_;
};

class PageHandler_SetEnabledScenarios_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_SetEnabledScenarios_ForwardToCallback(
      PageHandler::SetEnabledScenariosCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_SetEnabledScenarios_ForwardToCallback(const PageHandler_SetEnabledScenarios_ForwardToCallback&) = delete;
  PageHandler_SetEnabledScenarios_ForwardToCallback& operator=(const PageHandler_SetEnabledScenarios_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::SetEnabledScenariosCallback callback_;
};

class PageHandler_SetScenariosConfigFromString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_SetScenariosConfigFromString_ForwardToCallback(
      PageHandler::SetScenariosConfigFromStringCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_SetScenariosConfigFromString_ForwardToCallback(const PageHandler_SetScenariosConfigFromString_ForwardToCallback&) = delete;
  PageHandler_SetScenariosConfigFromString_ForwardToCallback& operator=(const PageHandler_SetScenariosConfigFromString_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::SetScenariosConfigFromStringCallback callback_;
};

class PageHandler_SetScenariosConfigFromBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_SetScenariosConfigFromBuffer_ForwardToCallback(
      PageHandler::SetScenariosConfigFromBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_SetScenariosConfigFromBuffer_ForwardToCallback(const PageHandler_SetScenariosConfigFromBuffer_ForwardToCallback&) = delete;
  PageHandler_SetScenariosConfigFromBuffer_ForwardToCallback& operator=(const PageHandler_SetScenariosConfigFromBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::SetScenariosConfigFromBufferCallback callback_;
};

class PageHandler_GetPrivacyFilterEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetPrivacyFilterEnabled_ForwardToCallback(
      PageHandler::GetPrivacyFilterEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetPrivacyFilterEnabled_ForwardToCallback(const PageHandler_GetPrivacyFilterEnabled_ForwardToCallback&) = delete;
  PageHandler_GetPrivacyFilterEnabled_ForwardToCallback& operator=(const PageHandler_GetPrivacyFilterEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetPrivacyFilterEnabledCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::StartTraceSession(
    ::mojo_base::BigBuffer in_config_pb, bool in_enable_privacy_filters, StartTraceSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::PageHandler::StartTraceSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_pb"), in_config_pb,
                        "<value of type ::mojo_base::BigBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable_privacy_filters"), in_enable_privacy_filters,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kStartTraceSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_StartTraceSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->config_pb)>
      config_pb_fragment(params.message());
  config_pb_fragment.Claim(&params->config_pb);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_config_pb,
    config_pb_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config_pb.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config_pb in PageHandler.StartTraceSession request");

  params->enable_privacy_filters = in_enable_privacy_filters;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("StartTraceSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_StartTraceSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::CloneTraceSession(
    CloneTraceSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send traces_internals::mojom::PageHandler::CloneTraceSession");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCloneTraceSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_CloneTraceSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CloneTraceSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_CloneTraceSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::StopTraceSession(
    StopTraceSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send traces_internals::mojom::PageHandler::StopTraceSession");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kStopTraceSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_StopTraceSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("StopTraceSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_StopTraceSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetTrackEventCategories(
    GetTrackEventCategoriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send traces_internals::mojom::PageHandler::GetTrackEventCategories");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTrackEventCategories), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetTrackEventCategories_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTrackEventCategories");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTrackEventCategories_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetBufferUsage(
    GetBufferUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send traces_internals::mojom::PageHandler::GetBufferUsage");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetBufferUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetBufferUsage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetBufferUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetBufferUsage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetAllTraceReports(
    GetAllTraceReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send traces_internals::mojom::PageHandler::GetAllTraceReports");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllTraceReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetAllTraceReports_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllTraceReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetAllTraceReports_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::DeleteSingleTrace(
    const ::base::Token& in_uuid, DeleteSingleTraceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::PageHandler::DeleteSingleTrace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Token&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteSingleTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_DeleteSingleTrace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in PageHandler.DeleteSingleTrace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteSingleTrace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_DeleteSingleTrace_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::DeleteAllTraces(
    DeleteAllTracesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send traces_internals::mojom::PageHandler::DeleteAllTraces");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteAllTraces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_DeleteAllTraces_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteAllTraces");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_DeleteAllTraces_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::UserUploadSingleTrace(
    const ::base::Token& in_uuid, UserUploadSingleTraceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::PageHandler::UserUploadSingleTrace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Token&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUserUploadSingleTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_UserUploadSingleTrace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in PageHandler.UserUploadSingleTrace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UserUploadSingleTrace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_UserUploadSingleTrace_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::DownloadTrace(
    const ::base::Token& in_uuid, DownloadTraceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::PageHandler::DownloadTrace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Token&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDownloadTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_DownloadTrace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in PageHandler.DownloadTrace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DownloadTrace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_DownloadTrace_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetAllScenarios(
    GetAllScenariosCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send traces_internals::mojom::PageHandler::GetAllScenarios");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetAllScenarios_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllScenarios");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetAllScenarios_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetEnabledScenarios(
    const std::vector<std::string>& in_new_config, SetEnabledScenariosCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::PageHandler::SetEnabledScenarios", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_config"), in_new_config,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetEnabledScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_SetEnabledScenarios_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_config)::BaseType>
      new_config_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& new_config_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_new_config,
    new_config_fragment,
    &new_config_validate_params);

  params->new_config.Set(
      new_config_fragment.is_null() ? nullptr : new_config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_config in PageHandler.SetEnabledScenarios request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetEnabledScenarios");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_SetEnabledScenarios_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetScenariosConfigFromString(
    const std::string& in_config_string, SetScenariosConfigFromStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::PageHandler::SetScenariosConfigFromString", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_string"), in_config_string,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetScenariosConfigFromString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_SetScenariosConfigFromString_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config_string)::BaseType> config_string_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_config_string,
    config_string_fragment);

  params->config_string.Set(
      config_string_fragment.is_null() ? nullptr : config_string_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config_string.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config_string in PageHandler.SetScenariosConfigFromString request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetScenariosConfigFromString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_SetScenariosConfigFromString_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetScenariosConfigFromBuffer(
    ::mojo_base::BigBuffer in_config_pb, SetScenariosConfigFromBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::PageHandler::SetScenariosConfigFromBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_pb"), in_config_pb,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetScenariosConfigFromBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_SetScenariosConfigFromBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->config_pb)>
      config_pb_fragment(params.message());
  config_pb_fragment.Claim(&params->config_pb);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_config_pb,
    config_pb_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config_pb.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config_pb in PageHandler.SetScenariosConfigFromBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetScenariosConfigFromBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_SetScenariosConfigFromBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetPrivacyFilterEnabled(
    GetPrivacyFilterEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send traces_internals::mojom::PageHandler::GetPrivacyFilterEnabled");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetPrivacyFilterEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetPrivacyFilterEnabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetPrivacyFilterEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetPrivacyFilterEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetPrivacyFilterEnabled(
    bool in_enable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::PageHandler::SetPrivacyFilterEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetPrivacyFilterEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_SetPrivacyFilterEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetPrivacyFilterEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_StartTraceSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::StartTraceSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_StartTraceSession_ProxyToResponder> proxy(
        new PageHandler_StartTraceSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_StartTraceSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_StartTraceSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_StartTraceSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::StartTraceSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_StartTraceSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_StartTraceSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_StartTraceSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  bool p_success{};
  PageHandler_StartTraceSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_StartTraceSession_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::StartTraceSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kStartTraceSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_StartTraceSession_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("StartTraceSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_CloneTraceSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::CloneTraceSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_CloneTraceSession_ProxyToResponder> proxy(
        new PageHandler_CloneTraceSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_CloneTraceSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_CloneTraceSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_CloneTraceSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::CloneTraceSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::mojo_base::BigBuffer> in_trace, const std::optional<::base::Token>& in_uuid);
};

bool PageHandler_CloneTraceSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_CloneTraceSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_CloneTraceSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_trace{};
  std::optional<::base::Token> p_uuid{};
  PageHandler_CloneTraceSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTrace(&p_trace))
    success = false;
  if (success && !input_data_view.ReadUuid(&p_uuid))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_trace), 
std::move(p_uuid));
  }
  return true;
}

void PageHandler_CloneTraceSession_ProxyToResponder::Run(
    std::optional<::mojo_base::BigBuffer> in_trace, const std::optional<::base::Token>& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::CloneTraceSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace"), in_trace,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::optional<::base::Token>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCloneTraceSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_CloneTraceSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->trace)>
      trace_fragment(params.message());
  trace_fragment.Claim(&params->trace);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_trace,
    trace_fragment,
    true);
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CloneTraceSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_StopTraceSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::StopTraceSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_StopTraceSession_ProxyToResponder> proxy(
        new PageHandler_StopTraceSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_StopTraceSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_StopTraceSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_StopTraceSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::StopTraceSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_StopTraceSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_StopTraceSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_StopTraceSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  bool p_success{};
  PageHandler_StopTraceSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_StopTraceSession_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::StopTraceSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kStopTraceSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_StopTraceSession_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("StopTraceSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetTrackEventCategories_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTrackEventCategoriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTrackEventCategories_ProxyToResponder> proxy(
        new PageHandler_GetTrackEventCategories_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTrackEventCategories_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTrackEventCategories_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTrackEventCategories_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTrackEventCategoriesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<TraceCategoryPtr> in_categories);
};

bool PageHandler_GetTrackEventCategories_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTrackEventCategories_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTrackEventCategories_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  std::vector<TraceCategoryPtr> p_categories{};
  PageHandler_GetTrackEventCategories_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCategories(&p_categories))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_categories));
  }
  return true;
}

void PageHandler_GetTrackEventCategories_ProxyToResponder::Run(
    std::vector<TraceCategoryPtr> in_categories) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::GetTrackEventCategories", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("categories"), in_categories,
                        "<value of type std::vector<TraceCategoryPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTrackEventCategories), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetTrackEventCategories_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->categories)::BaseType>
      categories_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& categories_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::traces_internals::mojom::TraceCategoryDataView>>(
    in_categories,
    categories_fragment,
    &categories_validate_params);

  params->categories.Set(
      categories_fragment.is_null() ? nullptr : categories_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->categories.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null categories in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTrackEventCategories");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetBufferUsage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetBufferUsageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetBufferUsage_ProxyToResponder> proxy(
        new PageHandler_GetBufferUsage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetBufferUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetBufferUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetBufferUsage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetBufferUsageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, float in_percent_full, bool in_data_loss);
};

bool PageHandler_GetBufferUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetBufferUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetBufferUsage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.4
  bool success = true;
  bool p_success{};
  float p_percent_full{};
  bool p_data_loss{};
  PageHandler_GetBufferUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_percent_full = input_data_view.percent_full();
  if (success)
    p_data_loss = input_data_view.data_loss();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_percent_full), 
std::move(p_data_loss));
  }
  return true;
}

void PageHandler_GetBufferUsage_ProxyToResponder::Run(
    bool in_success, float in_percent_full, bool in_data_loss) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::GetBufferUsage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("percent_full"), in_percent_full,
                        "<value of type float>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_loss"), in_data_loss,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetBufferUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetBufferUsage_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

  params->percent_full = in_percent_full;

  params->data_loss = in_data_loss;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetBufferUsage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetAllTraceReports_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAllTraceReportsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetAllTraceReports_ProxyToResponder> proxy(
        new PageHandler_GetAllTraceReports_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetAllTraceReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetAllTraceReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetAllTraceReports_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetAllTraceReportsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ClientTraceReportPtr> in_reports);
};

bool PageHandler_GetAllTraceReports_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetAllTraceReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetAllTraceReports_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.5
  bool success = true;
  std::vector<ClientTraceReportPtr> p_reports{};
  PageHandler_GetAllTraceReports_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReports(&p_reports))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_reports));
  }
  return true;
}

void PageHandler_GetAllTraceReports_ProxyToResponder::Run(
    std::vector<ClientTraceReportPtr> in_reports) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::GetAllTraceReports", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reports"), in_reports,
                        "<value of type std::vector<ClientTraceReportPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllTraceReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetAllTraceReports_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reports)::BaseType>
      reports_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& reports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::traces_internals::mojom::ClientTraceReportDataView>>(
    in_reports,
    reports_fragment,
    &reports_validate_params);

  params->reports.Set(
      reports_fragment.is_null() ? nullptr : reports_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reports.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reports in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllTraceReports");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_DeleteSingleTrace_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::DeleteSingleTraceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_DeleteSingleTrace_ProxyToResponder> proxy(
        new PageHandler_DeleteSingleTrace_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_DeleteSingleTrace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_DeleteSingleTrace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_DeleteSingleTrace_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::DeleteSingleTraceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_DeleteSingleTrace_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_DeleteSingleTrace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_DeleteSingleTrace_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.6
  bool success = true;
  bool p_success{};
  PageHandler_DeleteSingleTrace_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_DeleteSingleTrace_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::DeleteSingleTrace", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteSingleTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_DeleteSingleTrace_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteSingleTrace");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_DeleteAllTraces_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::DeleteAllTracesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_DeleteAllTraces_ProxyToResponder> proxy(
        new PageHandler_DeleteAllTraces_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_DeleteAllTraces_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_DeleteAllTraces_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_DeleteAllTraces_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::DeleteAllTracesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_DeleteAllTraces_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_DeleteAllTraces_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_DeleteAllTraces_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.7
  bool success = true;
  bool p_success{};
  PageHandler_DeleteAllTraces_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_DeleteAllTraces_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::DeleteAllTraces", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteAllTraces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_DeleteAllTraces_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteAllTraces");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_UserUploadSingleTrace_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::UserUploadSingleTraceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_UserUploadSingleTrace_ProxyToResponder> proxy(
        new PageHandler_UserUploadSingleTrace_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_UserUploadSingleTrace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_UserUploadSingleTrace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_UserUploadSingleTrace_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::UserUploadSingleTraceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_UserUploadSingleTrace_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_UserUploadSingleTrace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_UserUploadSingleTrace_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.8
  bool success = true;
  bool p_success{};
  PageHandler_UserUploadSingleTrace_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_UserUploadSingleTrace_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::UserUploadSingleTrace", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUserUploadSingleTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_UserUploadSingleTrace_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UserUploadSingleTrace");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_DownloadTrace_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::DownloadTraceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_DownloadTrace_ProxyToResponder> proxy(
        new PageHandler_DownloadTrace_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_DownloadTrace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_DownloadTrace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_DownloadTrace_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::DownloadTraceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::mojo_base::BigBuffer> in_trace);
};

bool PageHandler_DownloadTrace_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_DownloadTrace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_DownloadTrace_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.9
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_trace{};
  PageHandler_DownloadTrace_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTrace(&p_trace))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_trace));
  }
  return true;
}

void PageHandler_DownloadTrace_ProxyToResponder::Run(
    std::optional<::mojo_base::BigBuffer> in_trace) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::DownloadTrace", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace"), in_trace,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDownloadTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_DownloadTrace_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->trace)>
      trace_fragment(params.message());
  trace_fragment.Claim(&params->trace);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_trace,
    trace_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DownloadTrace");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetAllScenarios_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAllScenariosCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetAllScenarios_ProxyToResponder> proxy(
        new PageHandler_GetAllScenarios_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetAllScenarios_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetAllScenarios_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetAllScenarios_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetAllScenariosCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ScenarioPtr> in_config);
};

bool PageHandler_GetAllScenarios_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetAllScenarios_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetAllScenarios_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.10
  bool success = true;
  std::vector<ScenarioPtr> p_config{};
  PageHandler_GetAllScenarios_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_config));
  }
  return true;
}

void PageHandler_GetAllScenarios_ProxyToResponder::Run(
    std::vector<ScenarioPtr> in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::GetAllScenarios", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type std::vector<ScenarioPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetAllScenarios_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType>
      config_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& config_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::traces_internals::mojom::ScenarioDataView>>(
    in_config,
    config_fragment,
    &config_validate_params);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllScenarios");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_SetEnabledScenarios_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::SetEnabledScenariosCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_SetEnabledScenarios_ProxyToResponder> proxy(
        new PageHandler_SetEnabledScenarios_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_SetEnabledScenarios_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_SetEnabledScenarios_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_SetEnabledScenarios_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::SetEnabledScenariosCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_SetEnabledScenarios_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_SetEnabledScenarios_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_SetEnabledScenarios_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.11
  bool success = true;
  bool p_success{};
  PageHandler_SetEnabledScenarios_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_SetEnabledScenarios_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::SetEnabledScenarios", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetEnabledScenarios), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_SetEnabledScenarios_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetEnabledScenarios");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_SetScenariosConfigFromString_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::SetScenariosConfigFromStringCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_SetScenariosConfigFromString_ProxyToResponder> proxy(
        new PageHandler_SetScenariosConfigFromString_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_SetScenariosConfigFromString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_SetScenariosConfigFromString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_SetScenariosConfigFromString_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::SetScenariosConfigFromStringCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_SetScenariosConfigFromString_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_SetScenariosConfigFromString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_SetScenariosConfigFromString_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.12
  bool success = true;
  bool p_success{};
  PageHandler_SetScenariosConfigFromString_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_SetScenariosConfigFromString_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::SetScenariosConfigFromString", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetScenariosConfigFromString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_SetScenariosConfigFromString_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetScenariosConfigFromString");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_SetScenariosConfigFromBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::SetScenariosConfigFromBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_SetScenariosConfigFromBuffer_ProxyToResponder> proxy(
        new PageHandler_SetScenariosConfigFromBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_SetScenariosConfigFromBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_SetScenariosConfigFromBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_SetScenariosConfigFromBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::SetScenariosConfigFromBufferCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_SetScenariosConfigFromBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_SetScenariosConfigFromBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_SetScenariosConfigFromBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.13
  bool success = true;
  bool p_success{};
  PageHandler_SetScenariosConfigFromBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_SetScenariosConfigFromBuffer_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::SetScenariosConfigFromBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetScenariosConfigFromBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_SetScenariosConfigFromBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetScenariosConfigFromBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetPrivacyFilterEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetPrivacyFilterEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetPrivacyFilterEnabled_ProxyToResponder> proxy(
        new PageHandler_GetPrivacyFilterEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetPrivacyFilterEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetPrivacyFilterEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetPrivacyFilterEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetPrivacyFilterEnabledCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);
};

bool PageHandler_GetPrivacyFilterEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.14
  bool success = true;
  bool p_enabled{};
  PageHandler_GetPrivacyFilterEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_enabled));
  }
  return true;
}

void PageHandler_GetPrivacyFilterEnabled_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply traces_internals::mojom::PageHandler::GetPrivacyFilterEnabled", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetPrivacyFilterEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetPrivacyFilterEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kStartTraceSession: {
      break;
    }
    case messages::PageHandler::kCloneTraceSession: {
      break;
    }
    case messages::PageHandler::kStopTraceSession: {
      break;
    }
    case messages::PageHandler::kGetTrackEventCategories: {
      break;
    }
    case messages::PageHandler::kGetBufferUsage: {
      break;
    }
    case messages::PageHandler::kGetAllTraceReports: {
      break;
    }
    case messages::PageHandler::kDeleteSingleTrace: {
      break;
    }
    case messages::PageHandler::kDeleteAllTraces: {
      break;
    }
    case messages::PageHandler::kUserUploadSingleTrace: {
      break;
    }
    case messages::PageHandler::kDownloadTrace: {
      break;
    }
    case messages::PageHandler::kGetAllScenarios: {
      break;
    }
    case messages::PageHandler::kSetEnabledScenarios: {
      break;
    }
    case messages::PageHandler::kSetScenariosConfigFromString: {
      break;
    }
    case messages::PageHandler::kSetScenariosConfigFromBuffer: {
      break;
    }
    case messages::PageHandler::kGetPrivacyFilterEnabled: {
      break;
    }
    case messages::PageHandler::kSetPrivacyFilterEnabled: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetPrivacyFilterEnabled_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetPrivacyFilterEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      bool p_enable{};
      PageHandler_SetPrivacyFilterEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPrivacyFilterEnabled(        
        std::move(p_enable));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kStartTraceSession: {
      internal::PageHandler_StartTraceSession_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_StartTraceSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      ::mojo_base::BigBuffer p_config_pb{};
      bool p_enable_privacy_filters{};
      PageHandler_StartTraceSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfigPb(&p_config_pb))
        success = false;
      if (success)
        p_enable_privacy_filters = input_data_view.enable_privacy_filters();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_StartTraceSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartTraceSession(        
        std::move(p_config_pb), 
        std::move(p_enable_privacy_filters), std::move(callback));
      return true;
    }
    case messages::PageHandler::kCloneTraceSession: {
      internal::PageHandler_CloneTraceSession_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_CloneTraceSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_CloneTraceSession_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_CloneTraceSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloneTraceSession(std::move(callback));
      return true;
    }
    case messages::PageHandler::kStopTraceSession: {
      internal::PageHandler_StopTraceSession_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_StopTraceSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_StopTraceSession_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_StopTraceSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopTraceSession(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetTrackEventCategories: {
      internal::PageHandler_GetTrackEventCategories_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTrackEventCategories_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      PageHandler_GetTrackEventCategories_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_GetTrackEventCategories_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTrackEventCategories(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetBufferUsage: {
      internal::PageHandler_GetBufferUsage_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetBufferUsage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      PageHandler_GetBufferUsage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          PageHandler_GetBufferUsage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBufferUsage(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetAllTraceReports: {
      internal::PageHandler_GetAllTraceReports_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetAllTraceReports_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      PageHandler_GetAllTraceReports_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          PageHandler_GetAllTraceReports_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllTraceReports(std::move(callback));
      return true;
    }
    case messages::PageHandler::kDeleteSingleTrace: {
      internal::PageHandler_DeleteSingleTrace_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_DeleteSingleTrace_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      ::base::Token p_uuid{};
      PageHandler_DeleteSingleTrace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          PageHandler_DeleteSingleTrace_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteSingleTrace(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
    case messages::PageHandler::kDeleteAllTraces: {
      internal::PageHandler_DeleteAllTraces_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_DeleteAllTraces_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      PageHandler_DeleteAllTraces_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      auto callback =
          PageHandler_DeleteAllTraces_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteAllTraces(std::move(callback));
      return true;
    }
    case messages::PageHandler::kUserUploadSingleTrace: {
      internal::PageHandler_UserUploadSingleTrace_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_UserUploadSingleTrace_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      ::base::Token p_uuid{};
      PageHandler_UserUploadSingleTrace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          PageHandler_UserUploadSingleTrace_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UserUploadSingleTrace(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
    case messages::PageHandler::kDownloadTrace: {
      internal::PageHandler_DownloadTrace_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_DownloadTrace_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      ::base::Token p_uuid{};
      PageHandler_DownloadTrace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      auto callback =
          PageHandler_DownloadTrace_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadTrace(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetAllScenarios: {
      internal::PageHandler_GetAllScenarios_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetAllScenarios_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      PageHandler_GetAllScenarios_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      auto callback =
          PageHandler_GetAllScenarios_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllScenarios(std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetEnabledScenarios: {
      internal::PageHandler_SetEnabledScenarios_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_SetEnabledScenarios_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      std::vector<std::string> p_new_config{};
      PageHandler_SetEnabledScenarios_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewConfig(&p_new_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      auto callback =
          PageHandler_SetEnabledScenarios_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnabledScenarios(        
        std::move(p_new_config), std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetScenariosConfigFromString: {
      internal::PageHandler_SetScenariosConfigFromString_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_SetScenariosConfigFromString_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      std::string p_config_string{};
      PageHandler_SetScenariosConfigFromString_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfigString(&p_config_string))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      auto callback =
          PageHandler_SetScenariosConfigFromString_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScenariosConfigFromString(        
        std::move(p_config_string), std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetScenariosConfigFromBuffer: {
      internal::PageHandler_SetScenariosConfigFromBuffer_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_SetScenariosConfigFromBuffer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      ::mojo_base::BigBuffer p_config_pb{};
      PageHandler_SetScenariosConfigFromBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfigPb(&p_config_pb))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      auto callback =
          PageHandler_SetScenariosConfigFromBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScenariosConfigFromBuffer(        
        std::move(p_config_pb), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetPrivacyFilterEnabled: {
      internal::PageHandler_GetPrivacyFilterEnabled_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetPrivacyFilterEnabled_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      PageHandler_GetPrivacyFilterEnabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      auto callback =
          PageHandler_GetPrivacyFilterEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPrivacyFilterEnabled(std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetPrivacyFilterEnabled: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_StartTraceSession_Params_Data::Validate,
     &internal::PageHandler_StartTraceSession_ResponseParams_Data::Validate},
    { &internal::PageHandler_CloneTraceSession_Params_Data::Validate,
     &internal::PageHandler_CloneTraceSession_ResponseParams_Data::Validate},
    { &internal::PageHandler_StopTraceSession_Params_Data::Validate,
     &internal::PageHandler_StopTraceSession_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetTrackEventCategories_Params_Data::Validate,
     &internal::PageHandler_GetTrackEventCategories_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetBufferUsage_Params_Data::Validate,
     &internal::PageHandler_GetBufferUsage_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetAllTraceReports_Params_Data::Validate,
     &internal::PageHandler_GetAllTraceReports_ResponseParams_Data::Validate},
    { &internal::PageHandler_DeleteSingleTrace_Params_Data::Validate,
     &internal::PageHandler_DeleteSingleTrace_ResponseParams_Data::Validate},
    { &internal::PageHandler_DeleteAllTraces_Params_Data::Validate,
     &internal::PageHandler_DeleteAllTraces_ResponseParams_Data::Validate},
    { &internal::PageHandler_UserUploadSingleTrace_Params_Data::Validate,
     &internal::PageHandler_UserUploadSingleTrace_ResponseParams_Data::Validate},
    { &internal::PageHandler_DownloadTrace_Params_Data::Validate,
     &internal::PageHandler_DownloadTrace_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetAllScenarios_Params_Data::Validate,
     &internal::PageHandler_GetAllScenarios_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetEnabledScenarios_Params_Data::Validate,
     &internal::PageHandler_SetEnabledScenarios_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetScenariosConfigFromString_Params_Data::Validate,
     &internal::PageHandler_SetScenariosConfigFromString_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetScenariosConfigFromBuffer_Params_Data::Validate,
     &internal::PageHandler_SetScenariosConfigFromBuffer_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetPrivacyFilterEnabled_Params_Data::Validate,
     &internal::PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetPrivacyFilterEnabled_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::traces_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::traces_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnTraceComplete: {
      return &Page::OnTraceComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnTraceComplete:
            return "Receive traces_internals::mojom::Page::OnTraceComplete";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnTraceComplete:
            return "Receive reply traces_internals::mojom::Page::OnTraceComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnTraceComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca519e06;  // IPCStableHash for traces_internals::mojom::Page::OnTraceComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnTraceComplete(
    std::optional<::mojo_base::BigBuffer> in_trace, const std::optional<::base::Token>& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send traces_internals::mojom::Page::OnTraceComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace"), in_trace,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::optional<::base::Token>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnTraceComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::traces_internals::mojom::internal::Page_OnTraceComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->trace)>
      trace_fragment(params.message());
  trace_fragment.Claim(&params->trace);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_trace,
    trace_fragment,
    true);
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnTraceComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnTraceComplete: {
      DCHECK(message->is_serialized());
      internal::Page_OnTraceComplete_Params_Data* params =
          reinterpret_cast<internal::Page_OnTraceComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      std::optional<::mojo_base::BigBuffer> p_trace{};
      std::optional<::base::Token> p_uuid{};
      Page_OnTraceComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTrace(&p_trace))
        success = false;
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTraceComplete(        
        std::move(p_trace), 
        std::move(p_uuid));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnTraceComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnTraceComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::traces_internals::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // traces_internals::mojom


namespace mojo {


// static
bool StructTraits<::traces_internals::mojom::ClientTraceReport::DataView, ::traces_internals::mojom::ClientTraceReportPtr>::Read(
    ::traces_internals::mojom::ClientTraceReport::DataView input,
    ::traces_internals::mojom::ClientTraceReportPtr* output) {
  bool success = true;
  ::traces_internals::mojom::ClientTraceReportPtr result(::traces_internals::mojom::ClientTraceReport::New());
  
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success && !input.ReadCreationTime(&result->creation_time))
        success = false;
      if (success && !input.ReadScenarioName(&result->scenario_name))
        success = false;
      if (success && !input.ReadUploadRuleName(&result->upload_rule_name))
        success = false;
      if (success) {
        result->upload_rule_value = input.upload_rule_value();
      }
      if (success)
        result->total_size = input.total_size();
      if (success && !input.ReadUploadState(&result->upload_state))
        success = false;
      if (success && !input.ReadUploadTime(&result->upload_time))
        success = false;
      if (success && !input.ReadSkipReason(&result->skip_reason))
        success = false;
      if (success)
        result->has_trace_content = input.has_trace_content();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::traces_internals::mojom::Scenario::DataView, ::traces_internals::mojom::ScenarioPtr>::Read(
    ::traces_internals::mojom::Scenario::DataView input,
    ::traces_internals::mojom::ScenarioPtr* output) {
  bool success = true;
  ::traces_internals::mojom::ScenarioPtr result(::traces_internals::mojom::Scenario::New());
  
      if (success && !input.ReadScenarioName(&result->scenario_name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success)
        result->is_local_scenario = input.is_local_scenario();
      if (success)
        result->is_enabled = input.is_enabled();
      if (success && !input.ReadCurrentState(&result->current_state))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::traces_internals::mojom::TraceCategory::DataView, ::traces_internals::mojom::TraceCategoryPtr>::Read(
    ::traces_internals::mojom::TraceCategory::DataView input,
    ::traces_internals::mojom::TraceCategoryPtr* output) {
  bool success = true;
  ::traces_internals::mojom::TraceCategoryPtr result(::traces_internals::mojom::TraceCategory::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->is_group = input.is_group();
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadTags(&result->tags))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace traces_internals::mojom {


void TracesInternalsHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
TracesInternalsHandlerFactoryAsyncWaiter::TracesInternalsHandlerFactoryAsyncWaiter(
    TracesInternalsHandlerFactory* proxy) : proxy_(proxy) {}

TracesInternalsHandlerFactoryAsyncWaiter::~TracesInternalsHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::StartTraceSession(::mojo_base::BigBuffer config_pb, bool enable_privacy_filters, StartTraceSessionCallback callback) {
  GetForwardingInterface()->StartTraceSession(
    std::move(config_pb)
    , 
    std::move(enable_privacy_filters)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::CloneTraceSession(CloneTraceSessionCallback callback) {
  GetForwardingInterface()->CloneTraceSession(std::move(callback));
}
void PageHandlerInterceptorForTesting::StopTraceSession(StopTraceSessionCallback callback) {
  GetForwardingInterface()->StopTraceSession(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetTrackEventCategories(GetTrackEventCategoriesCallback callback) {
  GetForwardingInterface()->GetTrackEventCategories(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetBufferUsage(GetBufferUsageCallback callback) {
  GetForwardingInterface()->GetBufferUsage(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetAllTraceReports(GetAllTraceReportsCallback callback) {
  GetForwardingInterface()->GetAllTraceReports(std::move(callback));
}
void PageHandlerInterceptorForTesting::DeleteSingleTrace(const ::base::Token& uuid, DeleteSingleTraceCallback callback) {
  GetForwardingInterface()->DeleteSingleTrace(
    std::move(uuid)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::DeleteAllTraces(DeleteAllTracesCallback callback) {
  GetForwardingInterface()->DeleteAllTraces(std::move(callback));
}
void PageHandlerInterceptorForTesting::UserUploadSingleTrace(const ::base::Token& uuid, UserUploadSingleTraceCallback callback) {
  GetForwardingInterface()->UserUploadSingleTrace(
    std::move(uuid)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::DownloadTrace(const ::base::Token& uuid, DownloadTraceCallback callback) {
  GetForwardingInterface()->DownloadTrace(
    std::move(uuid)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetAllScenarios(GetAllScenariosCallback callback) {
  GetForwardingInterface()->GetAllScenarios(std::move(callback));
}
void PageHandlerInterceptorForTesting::SetEnabledScenarios(const std::vector<std::string>& new_config, SetEnabledScenariosCallback callback) {
  GetForwardingInterface()->SetEnabledScenarios(
    std::move(new_config)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::SetScenariosConfigFromString(const std::string& config_string, SetScenariosConfigFromStringCallback callback) {
  GetForwardingInterface()->SetScenariosConfigFromString(
    std::move(config_string)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::SetScenariosConfigFromBuffer(::mojo_base::BigBuffer config_pb, SetScenariosConfigFromBufferCallback callback) {
  GetForwardingInterface()->SetScenariosConfigFromBuffer(
    std::move(config_pb)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetPrivacyFilterEnabled(GetPrivacyFilterEnabledCallback callback) {
  GetForwardingInterface()->GetPrivacyFilterEnabled(std::move(callback));
}
void PageHandlerInterceptorForTesting::SetPrivacyFilterEnabled(bool enable) {
  GetForwardingInterface()->SetPrivacyFilterEnabled(
    std::move(enable)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::StartTraceSession(
    ::mojo_base::BigBuffer config_pb, bool enable_privacy_filters, bool* out_success) {
  base::RunLoop loop;
  proxy_->StartTraceSession(
      std::move(config_pb),
      std::move(enable_privacy_filters),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::StartTraceSession(
    ::mojo_base::BigBuffer config_pb, bool enable_privacy_filters) {
  bool async_wait_result;
  StartTraceSession(std::move(config_pb),std::move(enable_privacy_filters),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::CloneTraceSession(
    std::optional<::mojo_base::BigBuffer>* out_trace, std::optional<::base::Token>* out_uuid) {
  base::RunLoop loop;
  proxy_->CloneTraceSession(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::mojo_base::BigBuffer>* out_trace
,
             std::optional<::base::Token>* out_uuid
,
             std::optional<::mojo_base::BigBuffer> trace,
             const std::optional<::base::Token>& uuid) {*out_trace = std::move(trace);*out_uuid = std::move(uuid);
            loop->Quit();
          },
          &loop,
          out_trace,
          out_uuid));
  loop.Run();
}



void PageHandlerAsyncWaiter::StopTraceSession(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->StopTraceSession(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::StopTraceSession(
    ) {
  bool async_wait_result;
  StopTraceSession(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetTrackEventCategories(
    std::vector<TraceCategoryPtr>* out_categories) {
  base::RunLoop loop;
  proxy_->GetTrackEventCategories(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<TraceCategoryPtr>* out_categories
,
             std::vector<TraceCategoryPtr> categories) {*out_categories = std::move(categories);
            loop->Quit();
          },
          &loop,
          out_categories));
  loop.Run();
}

std::vector<TraceCategoryPtr> PageHandlerAsyncWaiter::GetTrackEventCategories(
    ) {
  std::vector<TraceCategoryPtr> async_wait_result;
  GetTrackEventCategories(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetBufferUsage(
    bool* out_success, float* out_percent_full, bool* out_data_loss) {
  base::RunLoop loop;
  proxy_->GetBufferUsage(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             float* out_percent_full
,
             bool* out_data_loss
,
             bool success,
             float percent_full,
             bool data_loss) {*out_success = std::move(success);*out_percent_full = std::move(percent_full);*out_data_loss = std::move(data_loss);
            loop->Quit();
          },
          &loop,
          out_success,
          out_percent_full,
          out_data_loss));
  loop.Run();
}



void PageHandlerAsyncWaiter::GetAllTraceReports(
    std::vector<ClientTraceReportPtr>* out_reports) {
  base::RunLoop loop;
  proxy_->GetAllTraceReports(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ClientTraceReportPtr>* out_reports
,
             std::vector<ClientTraceReportPtr> reports) {*out_reports = std::move(reports);
            loop->Quit();
          },
          &loop,
          out_reports));
  loop.Run();
}

std::vector<ClientTraceReportPtr> PageHandlerAsyncWaiter::GetAllTraceReports(
    ) {
  std::vector<ClientTraceReportPtr> async_wait_result;
  GetAllTraceReports(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::DeleteSingleTrace(
    const ::base::Token& uuid, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteSingleTrace(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::DeleteSingleTrace(
    const ::base::Token& uuid) {
  bool async_wait_result;
  DeleteSingleTrace(std::move(uuid),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::DeleteAllTraces(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteAllTraces(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::DeleteAllTraces(
    ) {
  bool async_wait_result;
  DeleteAllTraces(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::UserUploadSingleTrace(
    const ::base::Token& uuid, bool* out_success) {
  base::RunLoop loop;
  proxy_->UserUploadSingleTrace(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::UserUploadSingleTrace(
    const ::base::Token& uuid) {
  bool async_wait_result;
  UserUploadSingleTrace(std::move(uuid),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::DownloadTrace(
    const ::base::Token& uuid, std::optional<::mojo_base::BigBuffer>* out_trace) {
  base::RunLoop loop;
  proxy_->DownloadTrace(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::mojo_base::BigBuffer>* out_trace
,
             std::optional<::mojo_base::BigBuffer> trace) {*out_trace = std::move(trace);
            loop->Quit();
          },
          &loop,
          out_trace));
  loop.Run();
}

std::optional<::mojo_base::BigBuffer> PageHandlerAsyncWaiter::DownloadTrace(
    const ::base::Token& uuid) {
  std::optional<::mojo_base::BigBuffer> async_wait_result;
  DownloadTrace(std::move(uuid),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetAllScenarios(
    std::vector<ScenarioPtr>* out_config) {
  base::RunLoop loop;
  proxy_->GetAllScenarios(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ScenarioPtr>* out_config
,
             std::vector<ScenarioPtr> config) {*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_config));
  loop.Run();
}

std::vector<ScenarioPtr> PageHandlerAsyncWaiter::GetAllScenarios(
    ) {
  std::vector<ScenarioPtr> async_wait_result;
  GetAllScenarios(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::SetEnabledScenarios(
    const std::vector<std::string>& new_config, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetEnabledScenarios(
      std::move(new_config),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::SetEnabledScenarios(
    const std::vector<std::string>& new_config) {
  bool async_wait_result;
  SetEnabledScenarios(std::move(new_config),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::SetScenariosConfigFromString(
    const std::string& config_string, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetScenariosConfigFromString(
      std::move(config_string),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::SetScenariosConfigFromString(
    const std::string& config_string) {
  bool async_wait_result;
  SetScenariosConfigFromString(std::move(config_string),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::SetScenariosConfigFromBuffer(
    ::mojo_base::BigBuffer config_pb, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetScenariosConfigFromBuffer(
      std::move(config_pb),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::SetScenariosConfigFromBuffer(
    ::mojo_base::BigBuffer config_pb) {
  bool async_wait_result;
  SetScenariosConfigFromBuffer(std::move(config_pb),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetPrivacyFilterEnabled(
    bool* out_enabled) {
  base::RunLoop loop;
  proxy_->GetPrivacyFilterEnabled(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool enabled) {*out_enabled = std::move(enabled);
            loop->Quit();
          },
          &loop,
          out_enabled));
  loop.Run();
}

bool PageHandlerAsyncWaiter::GetPrivacyFilterEnabled(
    ) {
  bool async_wait_result;
  GetPrivacyFilterEnabled(&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::OnTraceComplete(std::optional<::mojo_base::BigBuffer> trace, const std::optional<::base::Token>& uuid) {
  GetForwardingInterface()->OnTraceComplete(
    std::move(trace)
    , 
    std::move(uuid)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // traces_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif