// content/browser/tracing/traces_internals/traces_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/tracing/traces_internals/traces_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/tracing/traces_internals/traces_internals.mojom-params-data.h"
namespace traces_internals {
namespace mojom {

NOINLINE static const char* ReportUploadStateToStringHelper(ReportUploadState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ReportUploadState::kNotUploaded:
      return "kNotUploaded";
    case ReportUploadState::kPending:
      return "kPending";
    case ReportUploadState::kPending_UserRequested:
      return "kPending_UserRequested";
    case ReportUploadState::kUploaded:
      return "kUploaded";
    default:
      return nullptr;
  }
}

std::string ReportUploadStateToString(ReportUploadState value) {
  const char *str = ReportUploadStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ReportUploadState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ReportUploadState value) {
  return os << ReportUploadStateToString(value);
}

NOINLINE static const char* SkipUploadReasonToStringHelper(SkipUploadReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SkipUploadReason::kNoSkip:
      return "kNoSkip";
    case SkipUploadReason::kSizeLimitExceeded:
      return "kSizeLimitExceeded";
    case SkipUploadReason::kNotAnonymized:
      return "kNotAnonymized";
    case SkipUploadReason::kScenarioQuotaExceeded:
      return "kScenarioQuotaExceeded";
    case SkipUploadReason::kUploadTimedOut:
      return "kUploadTimedOut";
    case SkipUploadReason::kLocalScenario:
      return "kLocalScenario";
    default:
      return nullptr;
  }
}

std::string SkipUploadReasonToString(SkipUploadReason value) {
  const char *str = SkipUploadReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SkipUploadReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SkipUploadReason value) {
  return os << SkipUploadReasonToString(value);
}

NOINLINE static const char* TracingScenarioStateToStringHelper(TracingScenarioState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TracingScenarioState::kDisabled:
      return "kDisabled";
    case TracingScenarioState::kEnabled:
      return "kEnabled";
    case TracingScenarioState::kSetup:
      return "kSetup";
    case TracingScenarioState::kStarting:
      return "kStarting";
    case TracingScenarioState::kRecording:
      return "kRecording";
    case TracingScenarioState::kStopping:
      return "kStopping";
    case TracingScenarioState::kFinalizing:
      return "kFinalizing";
    case TracingScenarioState::kCloning:
      return "kCloning";
    default:
      return nullptr;
  }
}

std::string TracingScenarioStateToString(TracingScenarioState value) {
  const char *str = TracingScenarioStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TracingScenarioState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TracingScenarioState value) {
  return os << TracingScenarioStateToString(value);
}

namespace internal {


// static
bool ClientTraceReport_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientTraceReport_Data* object =
      static_cast<const ClientTraceReport_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->creation_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->creation_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scenario_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scenario_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scenario_name, validation_context,
                                         &scenario_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->upload_rule_name, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& upload_rule_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->upload_rule_name, validation_context,
                                         &upload_rule_name_validate_params)) {
    return false;
  }


  if (!::traces_internals::mojom::internal::ReportUploadState_Data
        ::Validate(object->upload_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->upload_time, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->upload_time, validation_context))
    return false;


  if (!::traces_internals::mojom::internal::SkipUploadReason_Data
        ::Validate(object->skip_reason, validation_context))
    return false;

  return true;
}

ClientTraceReport_Data::ClientTraceReport_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Scenario_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Scenario_Data* object =
      static_cast<const Scenario_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scenario_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scenario_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scenario_name, validation_context,
                                         &scenario_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }


  if (!::traces_internals::mojom::internal::TracingScenarioState_Data
        ::Validate(object->current_state, validation_context))
    return false;

  return true;
}

Scenario_Data::Scenario_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TraceCategory_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TraceCategory_Data* object =
      static_cast<const TraceCategory_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tags, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tags_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->tags, validation_context,
                                         &tags_validate_params)) {
    return false;
  }

  return true;
}

TraceCategory_Data::TraceCategory_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TracesInternalsHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TracesInternalsHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const TracesInternalsHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TracesInternalsHandlerFactory_CreatePageHandler_Params_Data::TracesInternalsHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StartTraceSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StartTraceSession_Params_Data* object =
      static_cast<const PageHandler_StartTraceSession_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->config_pb, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->config_pb, validation_context))
    return false;

  return true;
}

PageHandler_StartTraceSession_Params_Data::PageHandler_StartTraceSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StartTraceSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StartTraceSession_ResponseParams_Data* object =
      static_cast<const PageHandler_StartTraceSession_ResponseParams_Data*>(data);

  return true;
}

PageHandler_StartTraceSession_ResponseParams_Data::PageHandler_StartTraceSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CloneTraceSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CloneTraceSession_Params_Data* object =
      static_cast<const PageHandler_CloneTraceSession_Params_Data*>(data);

  return true;
}

PageHandler_CloneTraceSession_Params_Data::PageHandler_CloneTraceSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CloneTraceSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CloneTraceSession_ResponseParams_Data* object =
      static_cast<const PageHandler_CloneTraceSession_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->trace, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

PageHandler_CloneTraceSession_ResponseParams_Data::PageHandler_CloneTraceSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StopTraceSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StopTraceSession_Params_Data* object =
      static_cast<const PageHandler_StopTraceSession_Params_Data*>(data);

  return true;
}

PageHandler_StopTraceSession_Params_Data::PageHandler_StopTraceSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StopTraceSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StopTraceSession_ResponseParams_Data* object =
      static_cast<const PageHandler_StopTraceSession_ResponseParams_Data*>(data);

  return true;
}

PageHandler_StopTraceSession_ResponseParams_Data::PageHandler_StopTraceSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTrackEventCategories_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTrackEventCategories_Params_Data* object =
      static_cast<const PageHandler_GetTrackEventCategories_Params_Data*>(data);

  return true;
}

PageHandler_GetTrackEventCategories_Params_Data::PageHandler_GetTrackEventCategories_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTrackEventCategories_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTrackEventCategories_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTrackEventCategories_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->categories, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& categories_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->categories, validation_context,
                                         &categories_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetTrackEventCategories_ResponseParams_Data::PageHandler_GetTrackEventCategories_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetBufferUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetBufferUsage_Params_Data* object =
      static_cast<const PageHandler_GetBufferUsage_Params_Data*>(data);

  return true;
}

PageHandler_GetBufferUsage_Params_Data::PageHandler_GetBufferUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetBufferUsage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetBufferUsage_ResponseParams_Data* object =
      static_cast<const PageHandler_GetBufferUsage_ResponseParams_Data*>(data);

  return true;
}

PageHandler_GetBufferUsage_ResponseParams_Data::PageHandler_GetBufferUsage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetAllTraceReports_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetAllTraceReports_Params_Data* object =
      static_cast<const PageHandler_GetAllTraceReports_Params_Data*>(data);

  return true;
}

PageHandler_GetAllTraceReports_Params_Data::PageHandler_GetAllTraceReports_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetAllTraceReports_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetAllTraceReports_ResponseParams_Data* object =
      static_cast<const PageHandler_GetAllTraceReports_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reports, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reports, validation_context,
                                         &reports_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetAllTraceReports_ResponseParams_Data::PageHandler_GetAllTraceReports_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeleteSingleTrace_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeleteSingleTrace_Params_Data* object =
      static_cast<const PageHandler_DeleteSingleTrace_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

PageHandler_DeleteSingleTrace_Params_Data::PageHandler_DeleteSingleTrace_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeleteSingleTrace_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeleteSingleTrace_ResponseParams_Data* object =
      static_cast<const PageHandler_DeleteSingleTrace_ResponseParams_Data*>(data);

  return true;
}

PageHandler_DeleteSingleTrace_ResponseParams_Data::PageHandler_DeleteSingleTrace_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeleteAllTraces_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeleteAllTraces_Params_Data* object =
      static_cast<const PageHandler_DeleteAllTraces_Params_Data*>(data);

  return true;
}

PageHandler_DeleteAllTraces_Params_Data::PageHandler_DeleteAllTraces_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeleteAllTraces_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeleteAllTraces_ResponseParams_Data* object =
      static_cast<const PageHandler_DeleteAllTraces_ResponseParams_Data*>(data);

  return true;
}

PageHandler_DeleteAllTraces_ResponseParams_Data::PageHandler_DeleteAllTraces_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UserUploadSingleTrace_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UserUploadSingleTrace_Params_Data* object =
      static_cast<const PageHandler_UserUploadSingleTrace_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

PageHandler_UserUploadSingleTrace_Params_Data::PageHandler_UserUploadSingleTrace_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UserUploadSingleTrace_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UserUploadSingleTrace_ResponseParams_Data* object =
      static_cast<const PageHandler_UserUploadSingleTrace_ResponseParams_Data*>(data);

  return true;
}

PageHandler_UserUploadSingleTrace_ResponseParams_Data::PageHandler_UserUploadSingleTrace_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DownloadTrace_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DownloadTrace_Params_Data* object =
      static_cast<const PageHandler_DownloadTrace_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

PageHandler_DownloadTrace_Params_Data::PageHandler_DownloadTrace_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DownloadTrace_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DownloadTrace_ResponseParams_Data* object =
      static_cast<const PageHandler_DownloadTrace_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->trace, validation_context))
    return false;

  return true;
}

PageHandler_DownloadTrace_ResponseParams_Data::PageHandler_DownloadTrace_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetAllScenarios_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetAllScenarios_Params_Data* object =
      static_cast<const PageHandler_GetAllScenarios_Params_Data*>(data);

  return true;
}

PageHandler_GetAllScenarios_Params_Data::PageHandler_GetAllScenarios_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetAllScenarios_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetAllScenarios_ResponseParams_Data* object =
      static_cast<const PageHandler_GetAllScenarios_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& config_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->config, validation_context,
                                         &config_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetAllScenarios_ResponseParams_Data::PageHandler_GetAllScenarios_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetEnabledScenarios_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetEnabledScenarios_Params_Data* object =
      static_cast<const PageHandler_SetEnabledScenarios_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_config, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_config_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->new_config, validation_context,
                                         &new_config_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetEnabledScenarios_Params_Data::PageHandler_SetEnabledScenarios_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetEnabledScenarios_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetEnabledScenarios_ResponseParams_Data* object =
      static_cast<const PageHandler_SetEnabledScenarios_ResponseParams_Data*>(data);

  return true;
}

PageHandler_SetEnabledScenarios_ResponseParams_Data::PageHandler_SetEnabledScenarios_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetScenariosConfigFromString_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetScenariosConfigFromString_Params_Data* object =
      static_cast<const PageHandler_SetScenariosConfigFromString_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config_string, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& config_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->config_string, validation_context,
                                         &config_string_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetScenariosConfigFromString_Params_Data::PageHandler_SetScenariosConfigFromString_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetScenariosConfigFromString_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetScenariosConfigFromString_ResponseParams_Data* object =
      static_cast<const PageHandler_SetScenariosConfigFromString_ResponseParams_Data*>(data);

  return true;
}

PageHandler_SetScenariosConfigFromString_ResponseParams_Data::PageHandler_SetScenariosConfigFromString_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetScenariosConfigFromBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetScenariosConfigFromBuffer_Params_Data* object =
      static_cast<const PageHandler_SetScenariosConfigFromBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->config_pb, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->config_pb, validation_context))
    return false;

  return true;
}

PageHandler_SetScenariosConfigFromBuffer_Params_Data::PageHandler_SetScenariosConfigFromBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetScenariosConfigFromBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetScenariosConfigFromBuffer_ResponseParams_Data* object =
      static_cast<const PageHandler_SetScenariosConfigFromBuffer_ResponseParams_Data*>(data);

  return true;
}

PageHandler_SetScenariosConfigFromBuffer_ResponseParams_Data::PageHandler_SetScenariosConfigFromBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetPrivacyFilterEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetPrivacyFilterEnabled_Params_Data* object =
      static_cast<const PageHandler_GetPrivacyFilterEnabled_Params_Data*>(data);

  return true;
}

PageHandler_GetPrivacyFilterEnabled_Params_Data::PageHandler_GetPrivacyFilterEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data* object =
      static_cast<const PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data*>(data);

  return true;
}

PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data::PageHandler_GetPrivacyFilterEnabled_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetPrivacyFilterEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetPrivacyFilterEnabled_Params_Data* object =
      static_cast<const PageHandler_SetPrivacyFilterEnabled_Params_Data*>(data);

  return true;
}

PageHandler_SetPrivacyFilterEnabled_Params_Data::PageHandler_SetPrivacyFilterEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnTraceComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnTraceComplete_Params_Data* object =
      static_cast<const Page_OnTraceComplete_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->trace, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

Page_OnTraceComplete_Params_Data::Page_OnTraceComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace traces_internals

namespace perfetto {

// static
void TraceFormatTraits<::traces_internals::mojom::ReportUploadState>::WriteIntoTrace(
   perfetto::TracedValue context, ::traces_internals::mojom::ReportUploadState value) {
  return std::move(context).WriteString(::traces_internals::mojom::ReportUploadStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::traces_internals::mojom::SkipUploadReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::traces_internals::mojom::SkipUploadReason value) {
  return std::move(context).WriteString(::traces_internals::mojom::SkipUploadReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::traces_internals::mojom::TracingScenarioState>::WriteIntoTrace(
   perfetto::TracedValue context, ::traces_internals::mojom::TracingScenarioState value) {
  return std::move(context).WriteString(::traces_internals::mojom::TracingScenarioStateToString(value));
}

} // namespace perfetto