// content/browser/tracing/traces_internals/traces_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  BigBufferSpec as mojoBase_mojom_BigBufferSpec,
  BigBuffer as mojoBase_mojom_BigBuffer
} from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  TokenSpec as mojoBase_mojom_TokenSpec,
  Token as mojoBase_mojom_Token
} from '//resources/mojo/mojo/public/mojom/base/token.mojom-webui.js';





export const ReportUploadStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ReportUploadState {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kNotUploaded = 0,
  kPending = 1,
  kPending_UserRequested = 2,
  kUploaded = 3,
}

export const SkipUploadReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SkipUploadReason {

  MIN_VALUE = 0,
  MAX_VALUE = 5,
  kNoSkip = 0,
  kSizeLimitExceeded = 1,
  kNotAnonymized = 2,
  kScenarioQuotaExceeded = 3,
  kUploadTimedOut = 4,
  kLocalScenario = 5,
}

export const TracingScenarioStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TracingScenarioState {

  MIN_VALUE = 0,
  MAX_VALUE = 7,
  kDisabled = 0,
  kEnabled = 1,
  kSetup = 2,
  kStarting = 3,
  kRecording = 4,
  kStopping = 5,
  kFinalizing = 6,
  kCloning = 7,
}



export type TracesInternalsHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<TracesInternalsHandlerFactoryPendingReceiver>;

export class TracesInternalsHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<TracesInternalsHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<TracesInternalsHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|TracesInternalsHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'traces_internals.mojom.TracesInternalsHandlerFactory',
        scope);
  }
}

export interface TracesInternalsHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class TracesInternalsHandlerFactoryRemote implements TracesInternalsHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<TracesInternalsHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<TracesInternalsHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|TracesInternalsHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TracesInternalsHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TracesInternalsHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TracesInternalsHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TracesInternalsHandlerFactoryRemote, TracesInternalsHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TracesInternalsHandlerFactoryRemote, TracesInternalsHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: TracesInternalsHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TracesInternalsHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TracesInternalsHandlerFactory {
  static get $interfaceName(): string {
    return "traces_internals.mojom.TracesInternalsHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): TracesInternalsHandlerFactoryRemote {
    let remote = new TracesInternalsHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the TracesInternalsHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TracesInternalsHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TracesInternalsHandlerFactoryRemote, TracesInternalsHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TracesInternalsHandlerFactoryRemote, TracesInternalsHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TracesInternalsHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'traces_internals.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  startTraceSession(configPb: mojoBase_mojom_BigBuffer, enablePrivacyFilters: boolean): Promise<{
        success: boolean, }>;
  cloneTraceSession(): Promise<{
        trace: (mojoBase_mojom_BigBuffer | null),
        uuid: (mojoBase_mojom_Token | null), }>;
  stopTraceSession(): Promise<{
        success: boolean, }>;
  getTrackEventCategories(): Promise<{
        categories: TraceCategory[], }>;
  getBufferUsage(): Promise<{
        success: boolean,
        percentFull: number,
        dataLoss: boolean, }>;
  getAllTraceReports(): Promise<{
        reports: ClientTraceReport[], }>;
  deleteSingleTrace(uuid: mojoBase_mojom_Token): Promise<{
        success: boolean, }>;
  deleteAllTraces(): Promise<{
        success: boolean, }>;
  userUploadSingleTrace(uuid: mojoBase_mojom_Token): Promise<{
        success: boolean, }>;
  downloadTrace(uuid: mojoBase_mojom_Token): Promise<{
        trace: (mojoBase_mojom_BigBuffer | null), }>;
  getAllScenarios(): Promise<{
        config: Scenario[], }>;
  setEnabledScenarios(newConfig: string[]): Promise<{
        success: boolean, }>;
  setScenariosConfigFromString(configString: string): Promise<{
        success: boolean, }>;
  setScenariosConfigFromBuffer(configPb: mojoBase_mojom_BigBuffer): Promise<{
        success: boolean, }>;
  getPrivacyFilterEnabled(): Promise<{
        enabled: boolean, }>;
  setPrivacyFilterEnabled(enable: boolean): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  startTraceSession(
      configPb: mojoBase_mojom_BigBuffer,
      enablePrivacyFilters: boolean): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_StartTraceSession_ParamsSpec.$,
        PageHandler_StartTraceSession_ResponseParamsSpec.$,
        [
          configPb,
          enablePrivacyFilters
        ],
        false);
  }

  cloneTraceSession(): Promise<{
        trace: (mojoBase_mojom_BigBuffer | null),
        uuid: (mojoBase_mojom_Token | null), }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_CloneTraceSession_ParamsSpec.$,
        PageHandler_CloneTraceSession_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  stopTraceSession(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_StopTraceSession_ParamsSpec.$,
        PageHandler_StopTraceSession_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getTrackEventCategories(): Promise<{
        categories: TraceCategory[], }> {
    return this.proxy.sendMessage(
        3,
        PageHandler_GetTrackEventCategories_ParamsSpec.$,
        PageHandler_GetTrackEventCategories_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getBufferUsage(): Promise<{
        success: boolean,
        percentFull: number,
        dataLoss: boolean, }> {
    return this.proxy.sendMessage(
        4,
        PageHandler_GetBufferUsage_ParamsSpec.$,
        PageHandler_GetBufferUsage_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getAllTraceReports(): Promise<{
        reports: ClientTraceReport[], }> {
    return this.proxy.sendMessage(
        5,
        PageHandler_GetAllTraceReports_ParamsSpec.$,
        PageHandler_GetAllTraceReports_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  deleteSingleTrace(
      uuid: mojoBase_mojom_Token): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        6,
        PageHandler_DeleteSingleTrace_ParamsSpec.$,
        PageHandler_DeleteSingleTrace_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }

  deleteAllTraces(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        7,
        PageHandler_DeleteAllTraces_ParamsSpec.$,
        PageHandler_DeleteAllTraces_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  userUploadSingleTrace(
      uuid: mojoBase_mojom_Token): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        8,
        PageHandler_UserUploadSingleTrace_ParamsSpec.$,
        PageHandler_UserUploadSingleTrace_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }

  downloadTrace(
      uuid: mojoBase_mojom_Token): Promise<{
        trace: (mojoBase_mojom_BigBuffer | null), }> {
    return this.proxy.sendMessage(
        9,
        PageHandler_DownloadTrace_ParamsSpec.$,
        PageHandler_DownloadTrace_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }

  getAllScenarios(): Promise<{
        config: Scenario[], }> {
    return this.proxy.sendMessage(
        10,
        PageHandler_GetAllScenarios_ParamsSpec.$,
        PageHandler_GetAllScenarios_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setEnabledScenarios(
      newConfig: string[]): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        11,
        PageHandler_SetEnabledScenarios_ParamsSpec.$,
        PageHandler_SetEnabledScenarios_ResponseParamsSpec.$,
        [
          newConfig
        ],
        false);
  }

  setScenariosConfigFromString(
      configString: string): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        12,
        PageHandler_SetScenariosConfigFromString_ParamsSpec.$,
        PageHandler_SetScenariosConfigFromString_ResponseParamsSpec.$,
        [
          configString
        ],
        false);
  }

  setScenariosConfigFromBuffer(
      configPb: mojoBase_mojom_BigBuffer): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        13,
        PageHandler_SetScenariosConfigFromBuffer_ParamsSpec.$,
        PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec.$,
        [
          configPb
        ],
        false);
  }

  getPrivacyFilterEnabled(): Promise<{
        enabled: boolean, }> {
    return this.proxy.sendMessage(
        14,
        PageHandler_GetPrivacyFilterEnabled_ParamsSpec.$,
        PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setPrivacyFilterEnabled(
      enable: boolean): void {
    this.proxy.sendMessage(
        15,
        PageHandler_SetPrivacyFilterEnabled_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_StartTraceSession_ParamsSpec.$,
        PageHandler_StartTraceSession_ResponseParamsSpec.$,
        impl.startTraceSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_CloneTraceSession_ParamsSpec.$,
        PageHandler_CloneTraceSession_ResponseParamsSpec.$,
        impl.cloneTraceSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_StopTraceSession_ParamsSpec.$,
        PageHandler_StopTraceSession_ResponseParamsSpec.$,
        impl.stopTraceSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_GetTrackEventCategories_ParamsSpec.$,
        PageHandler_GetTrackEventCategories_ResponseParamsSpec.$,
        impl.getTrackEventCategories.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_GetBufferUsage_ParamsSpec.$,
        PageHandler_GetBufferUsage_ResponseParamsSpec.$,
        impl.getBufferUsage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_GetAllTraceReports_ParamsSpec.$,
        PageHandler_GetAllTraceReports_ResponseParamsSpec.$,
        impl.getAllTraceReports.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_DeleteSingleTrace_ParamsSpec.$,
        PageHandler_DeleteSingleTrace_ResponseParamsSpec.$,
        impl.deleteSingleTrace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_DeleteAllTraces_ParamsSpec.$,
        PageHandler_DeleteAllTraces_ResponseParamsSpec.$,
        impl.deleteAllTraces.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_UserUploadSingleTrace_ParamsSpec.$,
        PageHandler_UserUploadSingleTrace_ResponseParamsSpec.$,
        impl.userUploadSingleTrace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_DownloadTrace_ParamsSpec.$,
        PageHandler_DownloadTrace_ResponseParamsSpec.$,
        impl.downloadTrace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetAllScenarios_ParamsSpec.$,
        PageHandler_GetAllScenarios_ResponseParamsSpec.$,
        impl.getAllScenarios.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_SetEnabledScenarios_ParamsSpec.$,
        PageHandler_SetEnabledScenarios_ResponseParamsSpec.$,
        impl.setEnabledScenarios.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_SetScenariosConfigFromString_ParamsSpec.$,
        PageHandler_SetScenariosConfigFromString_ResponseParamsSpec.$,
        impl.setScenariosConfigFromString.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        PageHandler_SetScenariosConfigFromBuffer_ParamsSpec.$,
        PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec.$,
        impl.setScenariosConfigFromBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        PageHandler_GetPrivacyFilterEnabled_ParamsSpec.$,
        PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec.$,
        impl.getPrivacyFilterEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        PageHandler_SetPrivacyFilterEnabled_ParamsSpec.$,
        null,
        impl.setPrivacyFilterEnabled.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "traces_internals.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  startTraceSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  cloneTraceSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stopTraceSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTrackEventCategories: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getBufferUsage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getAllTraceReports: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteSingleTrace: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteAllTraces: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  userUploadSingleTrace: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  downloadTrace: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getAllScenarios: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setEnabledScenarios: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setScenariosConfigFromString: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setScenariosConfigFromBuffer: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getPrivacyFilterEnabled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPrivacyFilterEnabled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.startTraceSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_StartTraceSession_ParamsSpec.$,
        PageHandler_StartTraceSession_ResponseParamsSpec.$,
        this.startTraceSession.createReceiverHandler(true /* expectsResponse */),
        false);
    this.cloneTraceSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_CloneTraceSession_ParamsSpec.$,
        PageHandler_CloneTraceSession_ResponseParamsSpec.$,
        this.cloneTraceSession.createReceiverHandler(true /* expectsResponse */),
        false);
    this.stopTraceSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_StopTraceSession_ParamsSpec.$,
        PageHandler_StopTraceSession_ResponseParamsSpec.$,
        this.stopTraceSession.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getTrackEventCategories =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_GetTrackEventCategories_ParamsSpec.$,
        PageHandler_GetTrackEventCategories_ResponseParamsSpec.$,
        this.getTrackEventCategories.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getBufferUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_GetBufferUsage_ParamsSpec.$,
        PageHandler_GetBufferUsage_ResponseParamsSpec.$,
        this.getBufferUsage.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getAllTraceReports =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_GetAllTraceReports_ParamsSpec.$,
        PageHandler_GetAllTraceReports_ResponseParamsSpec.$,
        this.getAllTraceReports.createReceiverHandler(true /* expectsResponse */),
        false);
    this.deleteSingleTrace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_DeleteSingleTrace_ParamsSpec.$,
        PageHandler_DeleteSingleTrace_ResponseParamsSpec.$,
        this.deleteSingleTrace.createReceiverHandler(true /* expectsResponse */),
        false);
    this.deleteAllTraces =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_DeleteAllTraces_ParamsSpec.$,
        PageHandler_DeleteAllTraces_ResponseParamsSpec.$,
        this.deleteAllTraces.createReceiverHandler(true /* expectsResponse */),
        false);
    this.userUploadSingleTrace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_UserUploadSingleTrace_ParamsSpec.$,
        PageHandler_UserUploadSingleTrace_ResponseParamsSpec.$,
        this.userUploadSingleTrace.createReceiverHandler(true /* expectsResponse */),
        false);
    this.downloadTrace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_DownloadTrace_ParamsSpec.$,
        PageHandler_DownloadTrace_ResponseParamsSpec.$,
        this.downloadTrace.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getAllScenarios =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetAllScenarios_ParamsSpec.$,
        PageHandler_GetAllScenarios_ResponseParamsSpec.$,
        this.getAllScenarios.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setEnabledScenarios =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_SetEnabledScenarios_ParamsSpec.$,
        PageHandler_SetEnabledScenarios_ResponseParamsSpec.$,
        this.setEnabledScenarios.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setScenariosConfigFromString =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_SetScenariosConfigFromString_ParamsSpec.$,
        PageHandler_SetScenariosConfigFromString_ResponseParamsSpec.$,
        this.setScenariosConfigFromString.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setScenariosConfigFromBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        PageHandler_SetScenariosConfigFromBuffer_ParamsSpec.$,
        PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec.$,
        this.setScenariosConfigFromBuffer.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getPrivacyFilterEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        PageHandler_GetPrivacyFilterEnabled_ParamsSpec.$,
        PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec.$,
        this.getPrivacyFilterEnabled.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setPrivacyFilterEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        PageHandler_SetPrivacyFilterEnabled_ParamsSpec.$,
        null,
        this.setPrivacyFilterEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'traces_internals.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onTraceComplete(trace: (mojoBase_mojom_BigBuffer | null), uuid: (mojoBase_mojom_Token | null)): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onTraceComplete(
      trace: (mojoBase_mojom_BigBuffer | null),
      uuid: (mojoBase_mojom_Token | null)): void {
    this.proxy.sendMessage(
        0,
        Page_OnTraceComplete_ParamsSpec.$,
        null,
        [
          trace,
          uuid
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnTraceComplete_ParamsSpec.$,
        null,
        impl.onTraceComplete.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "traces_internals.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onTraceComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onTraceComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnTraceComplete_ParamsSpec.$,
        null,
        this.onTraceComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ClientTraceReportSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ScenarioSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TraceCategorySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_StartTraceSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_StartTraceSession_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CloneTraceSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CloneTraceSession_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_StopTraceSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_StopTraceSession_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTrackEventCategories_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTrackEventCategories_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetBufferUsage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetBufferUsage_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetAllTraceReports_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetAllTraceReports_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteSingleTrace_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteSingleTrace_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteAllTraces_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteAllTraces_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UserUploadSingleTrace_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UserUploadSingleTrace_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DownloadTrace_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DownloadTrace_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetAllScenarios_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetAllScenarios_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetEnabledScenarios_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetEnabledScenarios_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetScenariosConfigFromString_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetScenariosConfigFromString_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetScenariosConfigFromBuffer_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetPrivacyFilterEnabled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetPrivacyFilterEnabled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnTraceComplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ClientTraceReportMojoType {
  uuid: mojoBase_mojom_Token;
  creationTime: mojoBase_mojom_Time;
  scenarioName: string;
  uploadRuleName: string;
  uploadRuleValue: (number | null);
  hasTraceContent: boolean;
  totalSize: bigint;
  uploadState: ReportUploadState;
  skipReason: SkipUploadReason;
  uploadTime: mojoBase_mojom_Time;
}


export type ClientTraceReport = ClientTraceReportMojoType;
mojo.internal.Struct<ClientTraceReportMojoType>(
    ClientTraceReportSpec.$,
    'ClientTraceReport',
    [
      mojo.internal.StructField<ClientTraceReportMojoType, mojoBase_mojom_Token>(
        'uuid', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, mojoBase_mojom_Time>(
        'creationTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, string>(
        'scenarioName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, string>(
        'uploadRuleName', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, boolean>(
        'upload_rule_value_$flag', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "upload_rule_value_$value",
          originalFieldName: "uploadRuleValue",
        },
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, number>(
        'upload_rule_value_$value', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "uploadRuleValue",
        },
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, bigint>(
        'totalSize', 40,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, ReportUploadState>(
        'uploadState', 48,
        0,
        ReportUploadStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, mojoBase_mojom_Time>(
        'uploadTime', 56,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, SkipUploadReason>(
        'skipReason', 52,
        0,
        SkipUploadReasonSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientTraceReportMojoType, boolean>(
        'hasTraceContent', 32,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 72],]);





export interface ScenarioMojoType {
  scenarioName: string;
  description: string;
  isLocalScenario: boolean;
  isEnabled: boolean;
  currentState: TracingScenarioState;
}


export type Scenario = ScenarioMojoType;
mojo.internal.Struct<ScenarioMojoType>(
    ScenarioSpec.$,
    'Scenario',
    [
      mojo.internal.StructField<ScenarioMojoType, string>(
        'scenarioName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScenarioMojoType, string>(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScenarioMojoType, boolean>(
        'isLocalScenario', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScenarioMojoType, boolean>(
        'isEnabled', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScenarioMojoType, TracingScenarioState>(
        'currentState', 20,
        0,
        TracingScenarioStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface TraceCategoryMojoType {
  name: string;
  isGroup: boolean;
  description: string;
  tags: string[];
}


export type TraceCategory = TraceCategoryMojoType;
mojo.internal.Struct<TraceCategoryMojoType>(
    TraceCategorySpec.$,
    'TraceCategory',
    [
      mojo.internal.StructField<TraceCategoryMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TraceCategoryMojoType, boolean>(
        'isGroup', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TraceCategoryMojoType, string>(
        'description', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TraceCategoryMojoType, string[]>(
        'tags', 24,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface TracesInternalsHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type TracesInternalsHandlerFactory_CreatePageHandler_Params = TracesInternalsHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<TracesInternalsHandlerFactory_CreatePageHandler_ParamsMojoType>(
    TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'TracesInternalsHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<TracesInternalsHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TracesInternalsHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_StartTraceSession_ParamsMojoType {
  configPb: mojoBase_mojom_BigBuffer;
  enablePrivacyFilters: boolean;
}


export type PageHandler_StartTraceSession_Params = PageHandler_StartTraceSession_ParamsMojoType;
mojo.internal.Struct<PageHandler_StartTraceSession_ParamsMojoType>(
    PageHandler_StartTraceSession_ParamsSpec.$,
    'PageHandler_StartTraceSession_Params',
    [
      mojo.internal.StructField<PageHandler_StartTraceSession_ParamsMojoType, mojoBase_mojom_BigBuffer>(
        'configPb', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_StartTraceSession_ParamsMojoType, boolean>(
        'enablePrivacyFilters', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_StartTraceSession_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_StartTraceSession_ResponseParams = PageHandler_StartTraceSession_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_StartTraceSession_ResponseParamsMojoType>(
    PageHandler_StartTraceSession_ResponseParamsSpec.$,
    'PageHandler_StartTraceSession_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_StartTraceSession_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_CloneTraceSession_ParamsMojoType {
}


export type PageHandler_CloneTraceSession_Params = PageHandler_CloneTraceSession_ParamsMojoType;
mojo.internal.Struct<PageHandler_CloneTraceSession_ParamsMojoType>(
    PageHandler_CloneTraceSession_ParamsSpec.$,
    'PageHandler_CloneTraceSession_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_CloneTraceSession_ResponseParamsMojoType {
  trace: (mojoBase_mojom_BigBuffer | null);
  uuid: (mojoBase_mojom_Token | null);
}


export type PageHandler_CloneTraceSession_ResponseParams = PageHandler_CloneTraceSession_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_CloneTraceSession_ResponseParamsMojoType>(
    PageHandler_CloneTraceSession_ResponseParamsSpec.$,
    'PageHandler_CloneTraceSession_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_CloneTraceSession_ResponseParamsMojoType, mojoBase_mojom_BigBuffer>(
        'trace', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_CloneTraceSession_ResponseParamsMojoType, mojoBase_mojom_Token>(
        'uuid', 16,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_StopTraceSession_ParamsMojoType {
}


export type PageHandler_StopTraceSession_Params = PageHandler_StopTraceSession_ParamsMojoType;
mojo.internal.Struct<PageHandler_StopTraceSession_ParamsMojoType>(
    PageHandler_StopTraceSession_ParamsSpec.$,
    'PageHandler_StopTraceSession_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_StopTraceSession_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_StopTraceSession_ResponseParams = PageHandler_StopTraceSession_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_StopTraceSession_ResponseParamsMojoType>(
    PageHandler_StopTraceSession_ResponseParamsSpec.$,
    'PageHandler_StopTraceSession_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_StopTraceSession_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetTrackEventCategories_ParamsMojoType {
}


export type PageHandler_GetTrackEventCategories_Params = PageHandler_GetTrackEventCategories_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTrackEventCategories_ParamsMojoType>(
    PageHandler_GetTrackEventCategories_ParamsSpec.$,
    'PageHandler_GetTrackEventCategories_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetTrackEventCategories_ResponseParamsMojoType {
  categories: TraceCategory[];
}


export type PageHandler_GetTrackEventCategories_ResponseParams = PageHandler_GetTrackEventCategories_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTrackEventCategories_ResponseParamsMojoType>(
    PageHandler_GetTrackEventCategories_ResponseParamsSpec.$,
    'PageHandler_GetTrackEventCategories_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTrackEventCategories_ResponseParamsMojoType, TraceCategory[]>(
        'categories', 0,
        0,
        mojo.internal.Array(TraceCategorySpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetBufferUsage_ParamsMojoType {
}


export type PageHandler_GetBufferUsage_Params = PageHandler_GetBufferUsage_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetBufferUsage_ParamsMojoType>(
    PageHandler_GetBufferUsage_ParamsSpec.$,
    'PageHandler_GetBufferUsage_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetBufferUsage_ResponseParamsMojoType {
  success: boolean;
  dataLoss: boolean;
  percentFull: number;
}


export type PageHandler_GetBufferUsage_ResponseParams = PageHandler_GetBufferUsage_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetBufferUsage_ResponseParamsMojoType>(
    PageHandler_GetBufferUsage_ResponseParamsSpec.$,
    'PageHandler_GetBufferUsage_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetBufferUsage_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_GetBufferUsage_ResponseParamsMojoType, number>(
        'percentFull', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_GetBufferUsage_ResponseParamsMojoType, boolean>(
        'dataLoss', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetAllTraceReports_ParamsMojoType {
}


export type PageHandler_GetAllTraceReports_Params = PageHandler_GetAllTraceReports_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetAllTraceReports_ParamsMojoType>(
    PageHandler_GetAllTraceReports_ParamsSpec.$,
    'PageHandler_GetAllTraceReports_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetAllTraceReports_ResponseParamsMojoType {
  reports: ClientTraceReport[];
}


export type PageHandler_GetAllTraceReports_ResponseParams = PageHandler_GetAllTraceReports_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetAllTraceReports_ResponseParamsMojoType>(
    PageHandler_GetAllTraceReports_ResponseParamsSpec.$,
    'PageHandler_GetAllTraceReports_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetAllTraceReports_ResponseParamsMojoType, ClientTraceReport[]>(
        'reports', 0,
        0,
        mojo.internal.Array(ClientTraceReportSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DeleteSingleTrace_ParamsMojoType {
  uuid: mojoBase_mojom_Token;
}


export type PageHandler_DeleteSingleTrace_Params = PageHandler_DeleteSingleTrace_ParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteSingleTrace_ParamsMojoType>(
    PageHandler_DeleteSingleTrace_ParamsSpec.$,
    'PageHandler_DeleteSingleTrace_Params',
    [
      mojo.internal.StructField<PageHandler_DeleteSingleTrace_ParamsMojoType, mojoBase_mojom_Token>(
        'uuid', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DeleteSingleTrace_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_DeleteSingleTrace_ResponseParams = PageHandler_DeleteSingleTrace_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteSingleTrace_ResponseParamsMojoType>(
    PageHandler_DeleteSingleTrace_ResponseParamsSpec.$,
    'PageHandler_DeleteSingleTrace_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_DeleteSingleTrace_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DeleteAllTraces_ParamsMojoType {
}


export type PageHandler_DeleteAllTraces_Params = PageHandler_DeleteAllTraces_ParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteAllTraces_ParamsMojoType>(
    PageHandler_DeleteAllTraces_ParamsSpec.$,
    'PageHandler_DeleteAllTraces_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_DeleteAllTraces_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_DeleteAllTraces_ResponseParams = PageHandler_DeleteAllTraces_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteAllTraces_ResponseParamsMojoType>(
    PageHandler_DeleteAllTraces_ResponseParamsSpec.$,
    'PageHandler_DeleteAllTraces_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_DeleteAllTraces_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_UserUploadSingleTrace_ParamsMojoType {
  uuid: mojoBase_mojom_Token;
}


export type PageHandler_UserUploadSingleTrace_Params = PageHandler_UserUploadSingleTrace_ParamsMojoType;
mojo.internal.Struct<PageHandler_UserUploadSingleTrace_ParamsMojoType>(
    PageHandler_UserUploadSingleTrace_ParamsSpec.$,
    'PageHandler_UserUploadSingleTrace_Params',
    [
      mojo.internal.StructField<PageHandler_UserUploadSingleTrace_ParamsMojoType, mojoBase_mojom_Token>(
        'uuid', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_UserUploadSingleTrace_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_UserUploadSingleTrace_ResponseParams = PageHandler_UserUploadSingleTrace_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_UserUploadSingleTrace_ResponseParamsMojoType>(
    PageHandler_UserUploadSingleTrace_ResponseParamsSpec.$,
    'PageHandler_UserUploadSingleTrace_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_UserUploadSingleTrace_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DownloadTrace_ParamsMojoType {
  uuid: mojoBase_mojom_Token;
}


export type PageHandler_DownloadTrace_Params = PageHandler_DownloadTrace_ParamsMojoType;
mojo.internal.Struct<PageHandler_DownloadTrace_ParamsMojoType>(
    PageHandler_DownloadTrace_ParamsSpec.$,
    'PageHandler_DownloadTrace_Params',
    [
      mojo.internal.StructField<PageHandler_DownloadTrace_ParamsMojoType, mojoBase_mojom_Token>(
        'uuid', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DownloadTrace_ResponseParamsMojoType {
  trace: (mojoBase_mojom_BigBuffer | null);
}


export type PageHandler_DownloadTrace_ResponseParams = PageHandler_DownloadTrace_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_DownloadTrace_ResponseParamsMojoType>(
    PageHandler_DownloadTrace_ResponseParamsSpec.$,
    'PageHandler_DownloadTrace_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_DownloadTrace_ResponseParamsMojoType, mojoBase_mojom_BigBuffer>(
        'trace', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetAllScenarios_ParamsMojoType {
}


export type PageHandler_GetAllScenarios_Params = PageHandler_GetAllScenarios_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetAllScenarios_ParamsMojoType>(
    PageHandler_GetAllScenarios_ParamsSpec.$,
    'PageHandler_GetAllScenarios_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetAllScenarios_ResponseParamsMojoType {
  config: Scenario[];
}


export type PageHandler_GetAllScenarios_ResponseParams = PageHandler_GetAllScenarios_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetAllScenarios_ResponseParamsMojoType>(
    PageHandler_GetAllScenarios_ResponseParamsSpec.$,
    'PageHandler_GetAllScenarios_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetAllScenarios_ResponseParamsMojoType, Scenario[]>(
        'config', 0,
        0,
        mojo.internal.Array(ScenarioSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetEnabledScenarios_ParamsMojoType {
  newConfig: string[];
}


export type PageHandler_SetEnabledScenarios_Params = PageHandler_SetEnabledScenarios_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetEnabledScenarios_ParamsMojoType>(
    PageHandler_SetEnabledScenarios_ParamsSpec.$,
    'PageHandler_SetEnabledScenarios_Params',
    [
      mojo.internal.StructField<PageHandler_SetEnabledScenarios_ParamsMojoType, string[]>(
        'newConfig', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetEnabledScenarios_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_SetEnabledScenarios_ResponseParams = PageHandler_SetEnabledScenarios_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_SetEnabledScenarios_ResponseParamsMojoType>(
    PageHandler_SetEnabledScenarios_ResponseParamsSpec.$,
    'PageHandler_SetEnabledScenarios_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_SetEnabledScenarios_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetScenariosConfigFromString_ParamsMojoType {
  configString: string;
}


export type PageHandler_SetScenariosConfigFromString_Params = PageHandler_SetScenariosConfigFromString_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetScenariosConfigFromString_ParamsMojoType>(
    PageHandler_SetScenariosConfigFromString_ParamsSpec.$,
    'PageHandler_SetScenariosConfigFromString_Params',
    [
      mojo.internal.StructField<PageHandler_SetScenariosConfigFromString_ParamsMojoType, string>(
        'configString', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetScenariosConfigFromString_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_SetScenariosConfigFromString_ResponseParams = PageHandler_SetScenariosConfigFromString_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_SetScenariosConfigFromString_ResponseParamsMojoType>(
    PageHandler_SetScenariosConfigFromString_ResponseParamsSpec.$,
    'PageHandler_SetScenariosConfigFromString_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_SetScenariosConfigFromString_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetScenariosConfigFromBuffer_ParamsMojoType {
  configPb: mojoBase_mojom_BigBuffer;
}


export type PageHandler_SetScenariosConfigFromBuffer_Params = PageHandler_SetScenariosConfigFromBuffer_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetScenariosConfigFromBuffer_ParamsMojoType>(
    PageHandler_SetScenariosConfigFromBuffer_ParamsSpec.$,
    'PageHandler_SetScenariosConfigFromBuffer_Params',
    [
      mojo.internal.StructField<PageHandler_SetScenariosConfigFromBuffer_ParamsMojoType, mojoBase_mojom_BigBuffer>(
        'configPb', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_SetScenariosConfigFromBuffer_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_SetScenariosConfigFromBuffer_ResponseParams = PageHandler_SetScenariosConfigFromBuffer_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_SetScenariosConfigFromBuffer_ResponseParamsMojoType>(
    PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec.$,
    'PageHandler_SetScenariosConfigFromBuffer_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_SetScenariosConfigFromBuffer_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetPrivacyFilterEnabled_ParamsMojoType {
}


export type PageHandler_GetPrivacyFilterEnabled_Params = PageHandler_GetPrivacyFilterEnabled_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetPrivacyFilterEnabled_ParamsMojoType>(
    PageHandler_GetPrivacyFilterEnabled_ParamsSpec.$,
    'PageHandler_GetPrivacyFilterEnabled_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetPrivacyFilterEnabled_ResponseParamsMojoType {
  enabled: boolean;
}


export type PageHandler_GetPrivacyFilterEnabled_ResponseParams = PageHandler_GetPrivacyFilterEnabled_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetPrivacyFilterEnabled_ResponseParamsMojoType>(
    PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec.$,
    'PageHandler_GetPrivacyFilterEnabled_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetPrivacyFilterEnabled_ResponseParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetPrivacyFilterEnabled_ParamsMojoType {
  enable: boolean;
}


export type PageHandler_SetPrivacyFilterEnabled_Params = PageHandler_SetPrivacyFilterEnabled_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetPrivacyFilterEnabled_ParamsMojoType>(
    PageHandler_SetPrivacyFilterEnabled_ParamsSpec.$,
    'PageHandler_SetPrivacyFilterEnabled_Params',
    [
      mojo.internal.StructField<PageHandler_SetPrivacyFilterEnabled_ParamsMojoType, boolean>(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnTraceComplete_ParamsMojoType {
  trace: (mojoBase_mojom_BigBuffer | null);
  uuid: (mojoBase_mojom_Token | null);
}


export type Page_OnTraceComplete_Params = Page_OnTraceComplete_ParamsMojoType;
mojo.internal.Struct<Page_OnTraceComplete_ParamsMojoType>(
    Page_OnTraceComplete_ParamsSpec.$,
    'Page_OnTraceComplete_Params',
    [
      mojo.internal.StructField<Page_OnTraceComplete_ParamsMojoType, mojoBase_mojom_BigBuffer>(
        'trace', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnTraceComplete_ParamsMojoType, mojoBase_mojom_Token>(
        'uuid', 16,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);



