// content/browser/process_internals/process_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type ProcessInternalsHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ProcessInternalsHandlerPendingReceiver>;

export class ProcessInternalsHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ProcessInternalsHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<ProcessInternalsHandlerPendingReceiver>;
  constructor(handle: MojoHandle|ProcessInternalsHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'mojom.ProcessInternalsHandler',
        scope);
  }
}

export interface ProcessInternalsHandlerInterface {
  getProcessCountInfo(): Promise<{
        info: ProcessCountInfo, }>;
  getIsolationMode(): Promise<{
        mode: string, }>;
  getProcessPerSiteMode(): Promise<{
        mode: string, }>;
  getUserTriggeredIsolatedOrigins(): Promise<{
        isolatedOrigins: string[], }>;
  getWebTriggeredIsolatedOrigins(): Promise<{
        isolatedOrigins: string[], }>;
  getGloballyIsolatedOrigins(): Promise<{
        isolatedOrigins: IsolatedOriginInfo[], }>;
  getAllWebContentsInfo(): Promise<{
        infos: WebContentsInfo[], }>;
}

export class ProcessInternalsHandlerRemote implements ProcessInternalsHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ProcessInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ProcessInternalsHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ProcessInternalsHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProcessInternalsHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getProcessCountInfo(): Promise<{
        info: ProcessCountInfo, }> {
    return this.proxy.sendMessage(
        0,
        ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec.$,
        ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getIsolationMode(): Promise<{
        mode: string, }> {
    return this.proxy.sendMessage(
        1,
        ProcessInternalsHandler_GetIsolationMode_ParamsSpec.$,
        ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getProcessPerSiteMode(): Promise<{
        mode: string, }> {
    return this.proxy.sendMessage(
        2,
        ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec.$,
        ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getUserTriggeredIsolatedOrigins(): Promise<{
        isolatedOrigins: string[], }> {
    return this.proxy.sendMessage(
        3,
        ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec.$,
        ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getWebTriggeredIsolatedOrigins(): Promise<{
        isolatedOrigins: string[], }> {
    return this.proxy.sendMessage(
        4,
        ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec.$,
        ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getGloballyIsolatedOrigins(): Promise<{
        isolatedOrigins: IsolatedOriginInfo[], }> {
    return this.proxy.sendMessage(
        5,
        ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec.$,
        ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getAllWebContentsInfo(): Promise<{
        infos: WebContentsInfo[], }> {
    return this.proxy.sendMessage(
        6,
        ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec.$,
        ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProcessInternalsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProcessInternalsHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ProcessInternalsHandlerRemote, ProcessInternalsHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ProcessInternalsHandlerRemote, ProcessInternalsHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ProcessInternalsHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProcessInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec.$,
        ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec.$,
        impl.getProcessCountInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ProcessInternalsHandler_GetIsolationMode_ParamsSpec.$,
        ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec.$,
        impl.getIsolationMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec.$,
        ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec.$,
        impl.getProcessPerSiteMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec.$,
        ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec.$,
        impl.getUserTriggeredIsolatedOrigins.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec.$,
        ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec.$,
        impl.getWebTriggeredIsolatedOrigins.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec.$,
        ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec.$,
        impl.getGloballyIsolatedOrigins.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec.$,
        ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec.$,
        impl.getAllWebContentsInfo.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProcessInternalsHandler {
  static get $interfaceName(): string {
    return "mojom.ProcessInternalsHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ProcessInternalsHandlerRemote {
    let remote = new ProcessInternalsHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ProcessInternalsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProcessInternalsHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ProcessInternalsHandlerRemote, ProcessInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ProcessInternalsHandlerRemote, ProcessInternalsHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getProcessCountInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getIsolationMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProcessPerSiteMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getUserTriggeredIsolatedOrigins: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getWebTriggeredIsolatedOrigins: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getGloballyIsolatedOrigins: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getAllWebContentsInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProcessInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getProcessCountInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec.$,
        ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec.$,
        this.getProcessCountInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getIsolationMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ProcessInternalsHandler_GetIsolationMode_ParamsSpec.$,
        ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec.$,
        this.getIsolationMode.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getProcessPerSiteMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec.$,
        ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec.$,
        this.getProcessPerSiteMode.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getUserTriggeredIsolatedOrigins =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec.$,
        ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec.$,
        this.getUserTriggeredIsolatedOrigins.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getWebTriggeredIsolatedOrigins =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec.$,
        ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec.$,
        this.getWebTriggeredIsolatedOrigins.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getGloballyIsolatedOrigins =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec.$,
        ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec.$,
        this.getGloballyIsolatedOrigins.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getAllWebContentsInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec.$,
        ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec.$,
        this.getAllWebContentsInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ProcessCountInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SiteInstanceInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrameInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebContentsInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IsolatedOriginInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetIsolationMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ProcessCountInfoMojoType {
  rendererProcessLimit: bigint;
  rendererProcessCountTotal: bigint;
  liveRendererProcessesCountTotal: bigint;
  rendererProcessCountForLimit: bigint;
}


export type ProcessCountInfo = ProcessCountInfoMojoType;
mojo.internal.Struct<ProcessCountInfoMojoType>(
    ProcessCountInfoSpec.$,
    'ProcessCountInfo',
    [
      mojo.internal.StructField<ProcessCountInfoMojoType, bigint>(
        'rendererProcessLimit', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProcessCountInfoMojoType, bigint>(
        'rendererProcessCountTotal', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProcessCountInfoMojoType, bigint>(
        'liveRendererProcessesCountTotal', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProcessCountInfoMojoType, bigint>(
        'rendererProcessCountForLimit', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface SiteInstanceInfoMojoType {
  id: number;
  siteInstanceGroupId: number;
  browsingInstanceId: number;
  locked: boolean;
  requiresOriginKeyedProcess: boolean;
  isSandboxForIframes: boolean;
  isGuest: boolean;
  isPdf: boolean;
  areJavascriptOptimizersEnabled: boolean;
  siteUrl: (url_mojom_Url | null);
  processLockUrl: (url_mojom_Url | null);
  storagePartition: (string | null);
}


export type SiteInstanceInfo = SiteInstanceInfoMojoType;
mojo.internal.Struct<SiteInstanceInfoMojoType>(
    SiteInstanceInfoSpec.$,
    'SiteInstanceInfo',
    [
      mojo.internal.StructField<SiteInstanceInfoMojoType, number>(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, number>(
        'siteInstanceGroupId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, number>(
        'browsingInstanceId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, boolean>(
        'locked', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, url_mojom_Url>(
        'siteUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, url_mojom_Url>(
        'processLockUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, boolean>(
        'requiresOriginKeyedProcess', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, boolean>(
        'isSandboxForIframes', 12,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, boolean>(
        'isGuest', 12,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, boolean>(
        'isPdf', 12,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, boolean>(
        'areJavascriptOptimizersEnabled', 12,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SiteInstanceInfoMojoType, string>(
        'storagePartition', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);




export const FrameInfo_TypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum FrameInfo_Type {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kActive = 0,
  kBackForwardCache = 1,
  kPrerender = 2,
}


export interface FrameInfoMojoType {
  routingId: number;
  agentSchedulingGroupId: number;
  processId: number;
  type: FrameInfo_Type;
  siteInstance: SiteInstanceInfo;
  lastCommittedUrl: (url_mojom_Url | null);
  subframes: FrameInfo[];
}


export type FrameInfo = FrameInfoMojoType;
mojo.internal.Struct<FrameInfoMojoType>(
    FrameInfoSpec.$,
    'FrameInfo',
    [
      mojo.internal.StructField<FrameInfoMojoType, number>(
        'routingId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, number>(
        'agentSchedulingGroupId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, number>(
        'processId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, SiteInstanceInfo>(
        'siteInstance', 16,
        0,
        SiteInstanceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, url_mojom_Url>(
        'lastCommittedUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, FrameInfo[]>(
        'subframes', 32,
        0,
        mojo.internal.Array(FrameInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, FrameInfo_Type>(
        'type', 12,
        0,
        FrameInfo_TypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface WebContentsInfoMojoType {
  title: string;
  rootFrame: FrameInfo;
  bfcachedRootFrames: FrameInfo[];
  prerenderRootFrames: FrameInfo[];
}


export type WebContentsInfo = WebContentsInfoMojoType;
mojo.internal.Struct<WebContentsInfoMojoType>(
    WebContentsInfoSpec.$,
    'WebContentsInfo',
    [
      mojo.internal.StructField<WebContentsInfoMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebContentsInfoMojoType, FrameInfo>(
        'rootFrame', 8,
        0,
        FrameInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebContentsInfoMojoType, FrameInfo[]>(
        'bfcachedRootFrames', 16,
        0,
        mojo.internal.Array(FrameInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebContentsInfoMojoType, FrameInfo[]>(
        'prerenderRootFrames', 24,
        0,
        mojo.internal.Array(FrameInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface IsolatedOriginInfoMojoType {
  origin: string;
  source: string;
}


export type IsolatedOriginInfo = IsolatedOriginInfoMojoType;
mojo.internal.Struct<IsolatedOriginInfoMojoType>(
    IsolatedOriginInfoSpec.$,
    'IsolatedOriginInfo',
    [
      mojo.internal.StructField<IsolatedOriginInfoMojoType, string>(
        'origin', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<IsolatedOriginInfoMojoType, string>(
        'source', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ProcessInternalsHandler_GetProcessCountInfo_ParamsMojoType {
}


export type ProcessInternalsHandler_GetProcessCountInfo_Params = ProcessInternalsHandler_GetProcessCountInfo_ParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetProcessCountInfo_ParamsMojoType>(
    ProcessInternalsHandler_GetProcessCountInfo_ParamsSpec.$,
    'ProcessInternalsHandler_GetProcessCountInfo_Params',
    [
    ],
    [[0, 8],]);





export interface ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsMojoType {
  info: ProcessCountInfo;
}


export type ProcessInternalsHandler_GetProcessCountInfo_ResponseParams = ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsMojoType>(
    ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsSpec.$,
    'ProcessInternalsHandler_GetProcessCountInfo_ResponseParams',
    [
      mojo.internal.StructField<ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsMojoType, ProcessCountInfo>(
        'info', 0,
        0,
        ProcessCountInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProcessInternalsHandler_GetIsolationMode_ParamsMojoType {
}


export type ProcessInternalsHandler_GetIsolationMode_Params = ProcessInternalsHandler_GetIsolationMode_ParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetIsolationMode_ParamsMojoType>(
    ProcessInternalsHandler_GetIsolationMode_ParamsSpec.$,
    'ProcessInternalsHandler_GetIsolationMode_Params',
    [
    ],
    [[0, 8],]);





export interface ProcessInternalsHandler_GetIsolationMode_ResponseParamsMojoType {
  mode: string;
}


export type ProcessInternalsHandler_GetIsolationMode_ResponseParams = ProcessInternalsHandler_GetIsolationMode_ResponseParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetIsolationMode_ResponseParamsMojoType>(
    ProcessInternalsHandler_GetIsolationMode_ResponseParamsSpec.$,
    'ProcessInternalsHandler_GetIsolationMode_ResponseParams',
    [
      mojo.internal.StructField<ProcessInternalsHandler_GetIsolationMode_ResponseParamsMojoType, string>(
        'mode', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProcessInternalsHandler_GetProcessPerSiteMode_ParamsMojoType {
}


export type ProcessInternalsHandler_GetProcessPerSiteMode_Params = ProcessInternalsHandler_GetProcessPerSiteMode_ParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetProcessPerSiteMode_ParamsMojoType>(
    ProcessInternalsHandler_GetProcessPerSiteMode_ParamsSpec.$,
    'ProcessInternalsHandler_GetProcessPerSiteMode_Params',
    [
    ],
    [[0, 8],]);





export interface ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsMojoType {
  mode: string;
}


export type ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParams = ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsMojoType>(
    ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsSpec.$,
    'ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParams',
    [
      mojo.internal.StructField<ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsMojoType, string>(
        'mode', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsMojoType {
}


export type ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params = ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsMojoType>(
    ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsSpec.$,
    'ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params',
    [
    ],
    [[0, 8],]);





export interface ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsMojoType {
  isolatedOrigins: string[];
}


export type ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams = ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsMojoType>(
    ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsSpec.$,
    'ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams',
    [
      mojo.internal.StructField<ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsMojoType, string[]>(
        'isolatedOrigins', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsMojoType {
}


export type ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params = ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsMojoType>(
    ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsSpec.$,
    'ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params',
    [
    ],
    [[0, 8],]);





export interface ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsMojoType {
  isolatedOrigins: string[];
}


export type ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams = ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsMojoType>(
    ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsSpec.$,
    'ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams',
    [
      mojo.internal.StructField<ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsMojoType, string[]>(
        'isolatedOrigins', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsMojoType {
}


export type ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params = ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsMojoType>(
    ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsSpec.$,
    'ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params',
    [
    ],
    [[0, 8],]);





export interface ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsMojoType {
  isolatedOrigins: IsolatedOriginInfo[];
}


export type ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams = ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsMojoType>(
    ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsSpec.$,
    'ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams',
    [
      mojo.internal.StructField<ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsMojoType, IsolatedOriginInfo[]>(
        'isolatedOrigins', 0,
        0,
        mojo.internal.Array(IsolatedOriginInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProcessInternalsHandler_GetAllWebContentsInfo_ParamsMojoType {
}


export type ProcessInternalsHandler_GetAllWebContentsInfo_Params = ProcessInternalsHandler_GetAllWebContentsInfo_ParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetAllWebContentsInfo_ParamsMojoType>(
    ProcessInternalsHandler_GetAllWebContentsInfo_ParamsSpec.$,
    'ProcessInternalsHandler_GetAllWebContentsInfo_Params',
    [
    ],
    [[0, 8],]);





export interface ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsMojoType {
  infos: WebContentsInfo[];
}


export type ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams = ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsMojoType;
mojo.internal.Struct<ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsMojoType>(
    ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsSpec.$,
    'ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams',
    [
      mojo.internal.StructField<ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsMojoType, WebContentsInfo[]>(
        'infos', 0,
        0,
        mojo.internal.Array(WebContentsInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



